/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.print;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Properties;
import org.compiere.print.PrintData;
import org.compiere.print.PrintDataElement;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PrintDataHandler
extends DefaultHandler {
    private Properties m_ctx = null;
    private PrintData m_pd = null;
    private String m_curPDEname = null;
    private StringBuffer m_curPDEvalue = null;
    private PrintData m_curPD = null;
    private ArrayList<PrintData> m_stack = new ArrayList();

    public PrintDataHandler(Properties ctx) {
        this.m_ctx = ctx;
    }

    public PrintData getPrintData() {
        return this.m_pd;
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        if (qName.equals("adempiereData")) {
            String name = attributes.getValue("name");
            if (this.m_pd == null) {
                this.m_pd = new PrintData(this.m_ctx, name);
                this.push(this.m_pd);
            } else {
                PrintData temp = new PrintData(this.m_ctx, name);
                this.m_curPD.addNode(temp);
                this.push(temp);
            }
        } else if (qName.equals("row")) {
            this.m_curPD.addRow(false, 0);
        } else if (qName.equals("element")) {
            this.m_curPDEname = attributes.getValue("name");
            this.m_curPDEvalue = new StringBuffer();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.m_curPDEvalue.append(ch, start, length);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        if (qName.equals("adempiereData")) {
            this.pop();
        } else if (qName.equals("element")) {
            this.m_curPD.addNode(new PrintDataElement(this.m_curPDEname, (Serializable)((Object)this.m_curPDEvalue.toString()), 0, null));
        }
    }

    private void push(PrintData newPD) {
        this.m_stack.add(newPD);
        this.m_curPD = newPD;
    }

    private void pop() {
        if (this.m_stack.size() > 0) {
            this.m_stack.remove(this.m_stack.size() - 1);
        }
        if (this.m_stack.size() > 0) {
            this.m_curPD = this.m_stack.get(this.m_stack.size() - 1);
        }
    }
}

