/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.Serializable;
import java.math.RoundingMode;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_C_Currency;
import org.compiere.model.MPaymentValidate;
import org.compiere.model.PaymentProcessor;
import org.compiere.util.Util;
import paypal.payflow.ClientInfo;
import paypal.payflow.PayflowAPI;
import paypal.payflow.SDKProperties;

public final class PP_PayFlowPro4
extends PaymentProcessor
implements Serializable {
    private static final long serialVersionUID = -3904174878402449633L;
    private PayflowAPI m_pp = null;
    private boolean m_ok = false;
    protected static final String RESULT_OK = "0";
    protected static final String RESULT_DECLINED = "12";
    protected static final String RESULT_INVALID_NO = "23";
    protected static final String RESULT_INVALID_EXP = "24";
    protected static final String RESULT_INSUFFICIENT_FUNDS = "50";
    protected static final String RESULT_TIMEOUT_PROCESSOR = "104";
    protected static final String RESULT_TIMEOUT_HOST = "109";

    public String getVersion() {
        return "PayFlowPro " + this.m_pp.getVersion();
    }

    @Override
    public boolean processCC() throws IllegalArgumentException {
        String year;
        this.log.fine(this.p_mpp.getHostAddress() + " " + this.p_mpp.getHostPort() + ", Timeout=" + this.getTimeout() + "; Proxy=" + this.p_mpp.getProxyAddress() + " " + this.p_mpp.getProxyPort() + " " + this.p_mpp.getProxyLogon() + " " + this.p_mpp.getProxyPassword());
        if (this.p_mpp.getC_Currency_ID() != 0 && this.p_mpp.getC_Currency_ID() != this.p_mp.getC_Currency_ID()) {
            throw new IllegalArgumentException("Payment currency not supported by processor.");
        }
        if (this.p_mpp.getMinimumAmt().compareTo(this.p_mp.getPayAmt()) > 0) {
            throw new IllegalArgumentException("Payment amount is less than minimum accepted.");
        }
        if (this.p_mpp.isRequireVV() && Util.isEmpty(this.p_mp.getCreditCardVV(), true)) {
            throw new IllegalArgumentException("Credit card verification code required.");
        }
        StringBuffer param = new StringBuffer();
        if (!this.p_mp.getTrxType().equals("S")) {
            throw new IllegalArgumentException("PP_PayFlowPro TrxType not supported - " + this.p_mp.getTrxType());
        }
        param.append("TRXTYPE=").append(this.p_mp.getTrxType());
        param.append("&TENDER=C").append("&ACCT=").append(MPaymentValidate.checkNumeric(this.p_mp.getCreditCardNumber()));
        param.append("&EXPDATE=");
        String month = String.valueOf(this.p_mp.getCreditCardExpMM());
        if (month.length() == 1) {
            param.append(RESULT_OK);
        }
        param.append(month);
        int expYY = this.p_mp.getCreditCardExpYY();
        if (expYY > 2000) {
            expYY -= 2000;
        }
        if ((year = String.valueOf(expYY)).length() == 1) {
            param.append(RESULT_OK);
        }
        param.append(year);
        int precision = 2;
        I_C_Currency currency = null;
        currency = this.p_mp.getC_Currency();
        if (currency != null) {
            precision = currency.getStdPrecision();
            param.append(this.createPair("&CURRENCY", currency.getISO_Code(), 3));
        }
        param.append("&AMT=").append(this.p_mp.getPayAmt().setScale(precision, RoundingMode.HALF_UP));
        param.append(this.createPair("&AUTHCODE", this.p_mp.getVoiceAuthCode(), 6));
        param.append(this.createPair("&ORIGID", this.p_mp.getOrig_TrxID(), 12));
        param.append(this.createPair("&CVV2", this.p_mp.getCreditCardVV(), 4));
        param.append(this.createPair("&NAME", this.p_mp.getA_Name(), 30));
        param.append(this.createPair("&STREET", this.p_mp.getA_Street(), 30));
        param.append(this.createPair("&ZIP", this.p_mp.getA_Zip(), 9));
        param.append(this.createPair("&EMAIL", this.p_mp.getA_EMail(), 64));
        param.append(this.createPair("&SHIPTOZIP", this.p_mp.getA_Zip(), 6));
        param.append(this.createPair("&TAXAMT", this.p_mp.getTaxAmt(), 10));
        param.append(this.createPair("&INVNUM", this.p_mp.getC_Invoice_ID(), 9));
        param.append(this.createPair("&COMMENT1", this.p_mp.getC_Payment_ID(), 128));
        param.append(this.createPair("&COMMENT2", this.p_mp.getC_BPartner_ID(), 128));
        return this.process(param.toString());
    }

    public boolean process(String parameter) {
        long start = System.currentTimeMillis();
        StringBuffer param = new StringBuffer(parameter);
        param.append("&PARTNER=").append(this.p_mpp.getPartnerID()).append("&VENDOR=").append(this.p_mpp.getVendorID()).append("&USER=").append(this.p_mpp.getUserID()).append("&PWD=").append(this.p_mpp.getPassword());
        SDKProperties.setHostAddress((String)this.p_mpp.getHostAddress());
        SDKProperties.setHostPort((int)this.p_mpp.getHostPort());
        SDKProperties.setTimeOut((int)this.getTimeout());
        SDKProperties.setProxyAddress((String)this.p_mpp.getProxyAddress());
        SDKProperties.setProxyPort((int)this.p_mpp.getProxyPort());
        SDKProperties.setProxyLogin((String)this.p_mpp.getProxyLogon());
        SDKProperties.setProxyPassword((String)this.p_mpp.getProxyPassword());
        this.m_pp = new PayflowAPI();
        String requestId = this.m_pp.generateRequestId();
        String response = this.m_pp.submitTransaction(param.toString(), requestId);
        ClientInfo clInfo = new ClientInfo();
        this.m_pp.setClientInfo(clInfo);
        String transErrors = this.m_pp.getTransactionContext().toString();
        if (transErrors != null && transErrors.length() > 0) {
            this.log.log(Level.SEVERE, "Transaction Errors from SDK = \n" + transErrors);
        }
        this.p_mp.setR_Result("");
        this.p_mp.setR_Info(response);
        StringTokenizer st = new StringTokenizer(response, "&", false);
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int pos = token.indexOf(61);
            String name = token.substring(0, pos);
            String value = token.substring(pos + 1);
            if (name.equals("RESULT")) {
                this.p_mp.setR_Result(value);
                this.m_ok = RESULT_OK.equals(value);
                continue;
            }
            if (name.equals("PNREF")) {
                this.p_mp.setR_PnRef(value);
                continue;
            }
            if (name.equals("RESPMSG")) {
                this.p_mp.setR_RespMsg(value);
                continue;
            }
            if (name.equals("AUTHCODE")) {
                this.p_mp.setR_AuthCode(value);
                continue;
            }
            if (name.equals("AVSADDR")) {
                this.p_mp.setR_AvsAddr(value);
                continue;
            }
            if (name.equals("AVSZIP")) {
                this.p_mp.setR_AvsZip(value);
                continue;
            }
            if (name.equals("IAVS") || name.equals("CVV2MATCH")) continue;
            this.log.log(Level.SEVERE, "Response unknown = " + token);
        }
        return this.m_ok;
    }

    @Override
    public boolean isProcessedOK() {
        return this.m_ok;
    }
}

