/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.core.domains.models.X_S_TimeExpenseLine;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MConversionRate;
import org.compiere.model.MResourceAssignment;
import org.compiere.model.MTimeExpense;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class MTimeExpenseLine
extends X_S_TimeExpenseLine {
    private static final long serialVersionUID = -815975460880303779L;
    private MTimeExpense m_parent = null;
    private int m_C_Currency_Report_ID = 0;

    public MTimeExpenseLine(Properties ctx, int S_TimeExpenseLine_ID, String trxName) {
        super(ctx, S_TimeExpenseLine_ID, trxName);
        if (S_TimeExpenseLine_ID == 0) {
            this.setQty(Env.ONE);
            this.setQtyInvoiced(Env.ZERO);
            this.setQtyReimbursed(Env.ZERO);
            this.setExpenseAmt(Env.ZERO);
            this.setConvertedAmt(Env.ZERO);
            this.setPriceReimbursed(Env.ZERO);
            this.setInvoicePrice(Env.ZERO);
            this.setPriceInvoiced(Env.ZERO);
            this.setDateExpense(new Timestamp(System.currentTimeMillis()));
            this.setIsInvoiced(false);
            this.setIsTimeReport(false);
            this.setLine(10);
            this.setProcessed(false);
        }
    }

    public MTimeExpenseLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MTimeExpense getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MTimeExpense(this.getCtx(), this.getS_TimeExpense_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    @Override
    public BigDecimal getQtyInvoiced() {
        BigDecimal bd = super.getQtyInvoiced();
        if (Env.ZERO.compareTo(bd) == 0) {
            return this.getQty();
        }
        return bd;
    }

    @Override
    public BigDecimal getQtyReimbursed() {
        BigDecimal bd = super.getQtyReimbursed();
        if (Env.ZERO.compareTo(bd) == 0) {
            return this.getQty();
        }
        return bd;
    }

    @Override
    public BigDecimal getPriceInvoiced() {
        BigDecimal bd = super.getPriceInvoiced();
        if (Env.ZERO.compareTo(bd) == 0) {
            return this.getInvoicePrice();
        }
        return bd;
    }

    @Override
    public BigDecimal getPriceReimbursed() {
        BigDecimal bd = super.getPriceReimbursed();
        if (Env.ZERO.compareTo(bd) == 0) {
            return this.getConvertedAmt();
        }
        return bd;
    }

    public BigDecimal getApprovalAmt() {
        return this.getQty().multiply(this.getConvertedAmt());
    }

    public int getC_Currency_Report_ID() {
        if (this.m_C_Currency_Report_ID != 0) {
            return this.m_C_Currency_Report_ID;
        }
        MTimeExpense te = new MTimeExpense(this.getCtx(), this.getS_TimeExpense_ID(), this.get_TrxName());
        this.m_C_Currency_Report_ID = te.getC_Currency_ID();
        return this.m_C_Currency_Report_ID;
    }

    protected void setC_Currency_Report_ID(int C_Currency_ID) {
        this.m_C_Currency_Report_ID = C_Currency_ID;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (newRecord && this.getParent().isComplete()) {
            throw new AdempiereException("Parent was Completed" + Msg.translate(this.getCtx(), "S_TimeExpenseLine"));
        }
        if (newRecord || this.is_ValueChanged("ExpenseAmt") || this.is_ValueChanged("C_Currency_ID")) {
            if (this.getC_Currency_ID() == this.getC_Currency_Report_ID()) {
                this.setConvertedAmt(this.getExpenseAmt());
            } else {
                this.setConvertedAmt(MConversionRate.convert(this.getCtx(), this.getExpenseAmt(), this.getC_Currency_ID(), this.getC_Currency_Report_ID(), this.getDateExpense(), 0, this.getAD_Client_ID(), this.getAD_Org_ID()));
            }
        }
        if (this.isTimeReport()) {
            this.setExpenseAmt(Env.ZERO);
            this.setConvertedAmt(Env.ZERO);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (success) {
            this.updateHeader();
            if (newRecord || this.is_ValueChanged("S_ResourceAssignment_ID")) {
                Object ii;
                int S_ResourceAssignment_ID = this.getS_ResourceAssignment_ID();
                int old_S_ResourceAssignment_ID = 0;
                if (!newRecord && (ii = this.get_ValueOld("S_ResourceAssignment_ID")) instanceof Integer && (old_S_ResourceAssignment_ID = ((Integer)ii).intValue()) != S_ResourceAssignment_ID && old_S_ResourceAssignment_ID != 0) {
                    MResourceAssignment ra = new MResourceAssignment(this.getCtx(), old_S_ResourceAssignment_ID, this.get_TrxName());
                    ra.delete(false);
                }
                if (S_ResourceAssignment_ID != 0) {
                    MResourceAssignment ra = new MResourceAssignment(this.getCtx(), S_ResourceAssignment_ID, this.get_TrxName());
                    if (this.getQty().compareTo(ra.getQty()) != 0) {
                        ra.setQty(this.getQty());
                        if (this.getDescription() != null && this.getDescription().length() > 0) {
                            ra.setDescription(this.getDescription());
                        }
                        ra.saveEx();
                    }
                }
            }
        }
        return success;
    }

    @Override
    protected boolean afterDelete(boolean success) {
        if (success) {
            int old_S_ResourceAssignment_ID;
            this.updateHeader();
            Object ii = this.get_ValueOld("S_ResourceAssignment_ID");
            if (ii instanceof Integer && (old_S_ResourceAssignment_ID = ((Integer)ii).intValue()) != 0) {
                MResourceAssignment ra = new MResourceAssignment(this.getCtx(), old_S_ResourceAssignment_ID, this.get_TrxName());
                ra.delete(false);
            }
        }
        return success;
    }

    private void updateHeader() {
        String sql = "UPDATE S_TimeExpense te SET ApprovalAmt = (SELECT SUM(Qty*ConvertedAmt) FROM S_TimeExpenseLine tel WHERE te.S_TimeExpense_ID=tel.S_TimeExpense_ID) WHERE S_TimeExpense_ID=" + this.getS_TimeExpense_ID();
        int no = DB.executeUpdate(sql, this.get_TrxName());
    }
}

