/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.core.domains.models.X_R_StandardRequestType;
import org.compiere.model.MRequest;
import org.compiere.model.MStandardRequest;
import org.compiere.model.MTable;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class MStandardRequestType
extends X_R_StandardRequestType {
    private static final long serialVersionUID = 1032692474434985197L;
    private List<MStandardRequest> standardRequests = new ArrayList<MStandardRequest>();
    private HashMap<String, Boolean> columns = new HashMap();

    public MStandardRequestType(Properties ctx, int R_StandardRequestType_ID, String trxName) {
        super(ctx, R_StandardRequestType_ID, trxName);
    }

    public MStandardRequestType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static List<MStandardRequestType> getByTable(PO model) {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("AD_Table_ID").append("=? ");
        return new Query(model.getCtx(), "R_StandardRequestType", whereClause.toString(), model.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setParameters(model.get_Table_ID()).setOrderBy("AD_Table_ID,C_DocType_ID").list();
    }

    public List<MStandardRequest> getStandardRequest(boolean reset) {
        if (this.standardRequests.size() > 0 && !reset) {
            return this.standardRequests;
        }
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("R_StandardRequestType_ID").append("=?");
        this.standardRequests = new Query(this.getCtx(), "R_StandardRequest", whereClause.toString(), this.get_TrxName()).setClient_ID().setOnlyActiveRecords(true).setParameters(this.getR_StandardRequestType_ID()).list();
        return this.standardRequests;
    }

    public List<MRequest> createStandardRequest(PO entity) {
        HashMap relatedRequests = new HashMap();
        if (this.columns.size() <= 0) {
            MTable requestTableInfo = MTable.get(entity.getCtx(), MRequest.Table_ID);
            Arrays.stream(requestTableInfo.getColumns(true)).forEach(column -> this.columns.put(column.getColumnName(), column.isUpdateable()));
        }
        Timestamp today = new Timestamp(System.currentTimeMillis());
        ArrayList<MRequest> requests = new ArrayList<MRequest>();
        List<MStandardRequest> standardRequests = this.getStandardRequest(true);
        standardRequests.forEach(standardRequest -> {
            Timestamp dateNextAction;
            int salesRepId;
            Optional<Timestamp> startPlanOptinal;
            MRequest request = new MRequest(entity.getCtx(), 0, entity.get_TrxName());
            this.columns.keySet().stream().filter(columnName -> this.columns.get(columnName) != false && !columnName.equals("DocumentNo")).forEach(columnName -> {
                if (!DisplayType.isID(entity.get_ColumnDisplayType(entity.get_ColumnIndex((String)columnName))) && entity.get_ColumnIndex((String)columnName) > 0 && entity.get_Value((String)columnName) != null) {
                    request.set_Value((String)columnName, entity.get_Value((String)columnName));
                } else if (DisplayType.isID(entity.get_ColumnDisplayType(entity.get_ColumnIndex((String)columnName))) && entity.get_ValueAsInt((String)columnName) > 0) {
                    request.set_Value((String)columnName, (Object)entity.get_ValueAsInt((String)columnName));
                }
            });
            request.setR_RequestType_ID(standardRequest.getR_RequestType_ID());
            request.setAD_Table_ID(entity.get_Table_ID());
            request.setRecord_ID(entity.get_ID());
            request.setResult(Msg.parseTranslation(entity.getCtx(), "@Generate@ @From@ " + this.getName()));
            request.setR_Group_ID(standardRequest.getR_Group_ID());
            request.setR_Category_ID(standardRequest.getR_Category_ID());
            request.setDueType(standardRequest.getDueType());
            request.setR_Status_ID(standardRequest.getR_Status_ID());
            request.setTaskStatus(standardRequest.getTaskStatus());
            request.setAD_Role_ID(standardRequest.getAD_Role_ID());
            request.setSummary(standardRequest.getSummary());
            Optional.ofNullable(standardRequest.getSubject()).ifPresent(subject -> request.setSubject(standardRequest.getSubject()));
            request.setPriority(standardRequest.getPriority());
            request.setDateStartPlan(today);
            if (entity.get_ColumnIndex("DateOrdered") > 0) {
                startPlanOptinal = Optional.ofNullable((Timestamp)entity.get_Value("DateOrdered"));
                startPlanOptinal.ifPresent(startPlan -> request.setDateStartPlan((Timestamp)startPlan));
            } else if (entity.get_ColumnIndex("MovementDate") > 0) {
                startPlanOptinal = Optional.ofNullable((Timestamp)entity.get_Value("MovementDate"));
                startPlanOptinal.ifPresent(startPlan -> request.setDateStartPlan((Timestamp)startPlan));
            } else if (entity.get_ColumnIndex("DateTrx") > 0) {
                startPlanOptinal = Optional.ofNullable((Timestamp)entity.get_Value("DateTrx"));
                startPlanOptinal.ifPresent(startPlan -> request.setDateStartPlan((Timestamp)startPlan));
            } else if (entity.get_ColumnIndex("StatementDate") > 0) {
                startPlanOptinal = Optional.ofNullable((Timestamp)entity.get_Value("StatementDate"));
                startPlanOptinal.ifPresent(startPlan -> request.setDateStartPlan((Timestamp)startPlan));
            } else if (entity.get_ColumnIndex("DateStart") > 0) {
                startPlanOptinal = Optional.ofNullable((Timestamp)entity.get_Value("DateStart"));
                startPlanOptinal.ifPresent(startPlan -> request.setDateStartPlan((Timestamp)startPlan));
            } else if (entity.get_ColumnIndex("DateDoc") > 0) {
                startPlanOptinal = Optional.ofNullable((Timestamp)entity.get_Value("DateDoc"));
                startPlanOptinal.ifPresent(startPlan -> request.setDateStartPlan((Timestamp)startPlan));
            }
            if (request.get_ColumnIndex(entity.get_TableName() + "_ID") > 0 && entity.get_ID() > 0) {
                request.set_Value(entity.get_TableName() + "_ID", (Object)entity.get_ID());
            }
            if ((salesRepId = standardRequest.getSalesRep_ID()) == 0 && entity.get_ColumnIndex("SalesRep_ID") > -1) {
                salesRepId = entity.get_ValueAsInt("SalesRep_ID");
            }
            if (salesRepId == 0) {
                salesRepId = Env.getAD_User_ID(Env.getCtx());
            }
            if (salesRepId > 0) {
                request.setSalesRep_ID(salesRepId);
            }
            if ((dateNextAction = TimeUtil.addDuration(request.getDateStartPlan() != null ? request.getDateStartPlan() : today, standardRequest.getDurationUnit(), standardRequest.getDuration())) != null) {
                request.setDateNextAction(dateNextAction);
                request.setDateCompletePlan(dateNextAction);
            }
            if (standardRequest.getConfidentialTypeEntry() != null) {
                request.setConfidentialTypeEntry(standardRequest.getConfidentialTypeEntry());
            }
            request.saveEx();
            relatedRequests.put(standardRequest.getR_StandardRequest_ID(), request);
            requests.add(request);
        });
        standardRequests.stream().filter(standardRequest -> standardRequest.getR_RequestRelated_ID() > 0).forEach(standardRequest -> {
            MRequest relatedRequest = (MRequest)relatedRequests.get(standardRequest.getR_RequestRelated_ID());
            MRequest request = (MRequest)relatedRequests.get(standardRequest.getR_StandardRequest_ID());
            request.setR_RequestRelated_ID(relatedRequest.getR_Request_ID());
            request.saveEx();
        });
        return requests;
    }

    public boolean isValid(PO entity) {
        if (entity.getAD_Client_ID() != this.getAD_Client_ID()) {
            return false;
        }
        return this.isValidFromTo() != false && this.isValidSOTrx(entity, this.getIsSOTrx()) != false && this.isValidWhereCondition(entity, this.getWhereClause());
    }

    public boolean isValidDocument(PO entity, int documentTypeId, String documentStatus) {
        return !(!this.isValid(entity) || this.getAD_Table_ID() != entity.get_Table_ID() || this.getC_DocType_ID() > 0 && this.getC_DocType_ID() != documentTypeId || this.getDocStatus() != null && !Util.isEmpty(documentStatus) && !this.getDocStatus().equals(documentStatus));
    }

    private Boolean isValidSOTrx(PO entity, String standardRequestIsSOTrx) {
        if (standardRequestIsSOTrx == null) {
            return true;
        }
        Boolean isSoTrx = entity.get_ColumnIndex("IsSOTrx") > 0 ? Boolean.valueOf(entity.get_ValueAsBoolean("IsSOTrx")) : Boolean.valueOf(Env.isSOTrx(Env.getCtx()));
        if (isSoTrx.booleanValue() == "Y".equals(standardRequestIsSOTrx)) {
            return true;
        }
        if (isSoTrx.booleanValue() == "N".equals(standardRequestIsSOTrx)) {
            return false;
        }
        return false;
    }

    public Boolean isValidFromTo() {
        Timestamp currentDate = new Timestamp(System.currentTimeMillis());
        if (this.getValidFrom() != null && currentDate.before(this.getValidFrom())) {
            return false;
        }
        if (this.getValidTo() != null && currentDate.after(this.getValidTo())) {
            return false;
        }
        return true;
    }

    private boolean isValidWhereCondition(PO entity, String whereClause) {
        if (whereClause == null || whereClause.isEmpty()) {
            return true;
        }
        if (!this.validateQueryObject(entity, whereClause)) {
            this.log.severe("SQL logic evaluated to false (" + whereClause + ")");
            return false;
        }
        return true;
    }

    private boolean validateQueryObject(PO entity, String whereClause) {
        String tableName = entity.get_TableName();
        String[] keyColumns = entity.get_KeyColumns();
        String whereConditions = "";
        if (keyColumns.length != 1) {
            this.log.severe("Tables with more then one key column not supported - " + tableName + " = " + keyColumns.length);
            return false;
        }
        if (whereClause.indexOf(64) > -1) {
            whereConditions = Env.parseVariable(whereClause, entity, entity.get_TrxName(), false);
        }
        Object instance = new Query(entity.getCtx(), tableName, (String)(whereConditions.isEmpty() ? whereClause : whereConditions + " AND " + keyColumns[0] + "=" + entity.get_ID()), entity.get_TrxName()).first();
        return instance != null && ((PO)instance).get_ID() > 0;
    }
}

