/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_PA_SLA_Goal;
import org.compiere.model.MSLAMeasure;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class MSLAGoal
extends X_PA_SLA_Goal {
    private static final long serialVersionUID = -5165579804502911120L;

    public MSLAGoal(Properties ctx, int PA_SLA_Goal_ID, String trxName) {
        super(ctx, PA_SLA_Goal_ID, trxName);
        if (PA_SLA_Goal_ID == 0) {
            this.setMeasureActual(Env.ZERO);
            this.setMeasureTarget(Env.ZERO);
            this.setProcessed(false);
        }
    }

    public MSLAGoal(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MSLAMeasure[] getAllMeasures() {
        String sql = "SELECT * FROM PA_SLA_Measure WHERE PA_SLA_Goal_ID=? ORDER BY DateTrx";
        return this.getMeasures(sql);
    }

    public MSLAMeasure[] getNewMeasures() {
        String sql = "SELECT * FROM PA_SLA_Measure WHERE PA_SLA_Goal_ID=? AND Processed='N' ORDER BY DateTrx";
        return this.getMeasures(sql);
    }

    private MSLAMeasure[] getMeasures(String sql) {
        ArrayList<MSLAMeasure> list = new ArrayList<MSLAMeasure>();
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getPA_SLA_Goal_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MSLAMeasure(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MSLAMeasure[] retValue = new MSLAMeasure[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public boolean isDateValid(Timestamp date) {
        if (date == null) {
            return false;
        }
        if (this.getValidFrom() != null && date.before(this.getValidFrom())) {
            return false;
        }
        return this.getValidTo() == null || !date.after(this.getValidTo());
    }
}

