/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_RfQLine;
import org.compiere.model.MProduct;
import org.compiere.model.MRfQ;
import org.compiere.model.MRfQLineQty;
import org.compiere.util.CCache;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.TimeUtil;

public class MRfQLine
extends X_C_RfQLine {
    private static final long serialVersionUID = 5090299865266992874L;
    private static CCache<Integer, MRfQLine> s_cache = new CCache("C_RfQLine", 20);
    private MRfQLineQty[] m_qtys = null;

    public static MRfQLine get(Properties ctx, int C_RfQLine_ID, String trxName) {
        Integer key = C_RfQLine_ID;
        MRfQLine retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MRfQLine(ctx, C_RfQLine_ID, trxName);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MRfQLine(Properties ctx, int C_RfQLine_ID, String trxName) {
        super(ctx, C_RfQLine_ID, trxName);
        if (C_RfQLine_ID == 0) {
            this.setLine(0);
        }
    }

    public MRfQLine(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
        if (this.get_ID() > 0) {
            s_cache.put(this.get_ID(), this);
        }
    }

    public MRfQLine(MRfQ rfq) {
        this(rfq.getCtx(), 0, rfq.get_TrxName());
        this.setClientOrg(rfq);
        this.setC_RfQ_ID(rfq.getC_RfQ_ID());
    }

    public MRfQLineQty[] getQtys() {
        return this.getQtys(false);
    }

    public MRfQLineQty[] getQtys(boolean requery) {
        if (this.m_qtys != null && !requery) {
            return this.m_qtys;
        }
        ArrayList<MRfQLineQty> list = new ArrayList<MRfQLineQty>();
        String sql = "SELECT * FROM C_RfQLineQty WHERE C_RfQLine_ID=? AND IsActive='Y' ORDER BY Qty";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_RfQLine_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MRfQLineQty(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (list.size() == 0) {
            MRfQLineQty qty = new MRfQLineQty(this);
            qty.saveEx();
            list.add(qty);
        }
        this.m_qtys = new MRfQLineQty[list.size()];
        list.toArray(this.m_qtys);
        return this.m_qtys;
    }

    public String getProductDetailHTML() {
        if (this.getM_Product_ID() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        MProduct product = MProduct.get(this.getCtx(), this.getM_Product_ID());
        sb.append(product.getName());
        if (product.getDescription() != null && product.getDescription().length() > 0) {
            sb.append("<br><i>").append(product.getDescription()).append("</i>");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MRfQLine[");
        sb.append(this.get_ID()).append(",").append(this.getLine()).append("]");
        return sb.toString();
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getDateWorkStart() != null && this.getDeliveryDays() != 0) {
            this.setDateWorkComplete(TimeUtil.addDays(this.getDateWorkStart(), this.getDeliveryDays()));
        } else if (this.getDateWorkStart() != null && this.getDeliveryDays() == 0 && this.getDateWorkComplete() != null) {
            this.setDeliveryDays(TimeUtil.getDaysBetween(this.getDateWorkStart(), this.getDateWorkComplete(), new int[0]));
        } else if (this.getDateWorkStart() == null && this.getDeliveryDays() != 0 && this.getDateWorkComplete() != null) {
            this.setDateWorkStart(TimeUtil.addDays(this.getDateWorkComplete(), this.getDeliveryDays() * -1));
        }
        return true;
    }
}

