/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_C_RevenueRecognition_Plan;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MRevenueRecognition;
import org.compiere.model.MRevenueRecognitionRun;
import org.compiere.model.Query;
import org.compiere.util.Env;

public class MRevenueRecognitionPlan
extends X_C_RevenueRecognition_Plan {
    private static final long serialVersionUID = -6748195415080148091L;

    public MRevenueRecognitionPlan(Properties ctx, int C_RevenueRecognition_Plan_ID, String trxName) {
        super(ctx, C_RevenueRecognition_Plan_ID, trxName);
        if (C_RevenueRecognition_Plan_ID == 0) {
            this.setTotalAmt(Env.ZERO);
            this.setRecognizedAmt(Env.ZERO);
        }
    }

    public MRevenueRecognitionPlan(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        MRevenueRecognition rr;
        if (!newRecord || (rr = new MRevenueRecognition(this.getCtx(), this.getC_RevenueRecognition_ID(), this.get_TrxName())).isTimeBased()) {
            // empty if block
        }
        return success;
    }

    public void updateRecognizedAmount() {
        BigDecimal recognizedAmt = new Query(this.getCtx(), "C_RevenueRecognition_Run", "C_RevenueRecognition_Plan_ID = ?", this.get_TrxName()).setParameters(this.getC_RevenueRecognition_Plan_ID()).sum("RecognizedAmt");
        if (recognizedAmt == null) {
            recognizedAmt = Env.ZERO;
        }
        this.setRecognizedAmt(recognizedAmt);
        BigDecimal recognizedAmtAcct = new Query(this.getCtx(), "C_RevenueRecognition_Run", "C_RevenueRecognition_Plan_ID = ?", this.get_TrxName()).setParameters(this.getC_RevenueRecognition_Plan_ID()).sum("RecognizedAmtAcct");
        if (recognizedAmtAcct == null) {
            recognizedAmtAcct = Env.ZERO;
        }
        this.set_ValueOfColumn("RecognizedAmtAcct", (Object)recognizedAmtAcct);
        BigDecimal totalAmt = this.getTotalAmt();
        if (totalAmt != null) {
            boolean isRecognized = totalAmt.compareTo(recognizedAmt) == 0;
            this.set_ValueOfColumn("IsRecognized", (Object)isRecognized);
        }
        MOrder mOrder = null;
        try {
            MOrderLine mOrderLine = new MOrderLine(this.getCtx(), this.get_ValueAsInt("C_OrderLine_ID"), this.get_TrxName());
            mOrder = (MOrder)mOrderLine.getC_Order();
            org.openup.core.utils.model.MOrder.updateFullyRecognized(mOrder);
            mOrder.saveEx();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.saveEx();
    }

    public List<MRevenueRecognitionRun> getMRevenueRecognitionRuns() {
        List<MRevenueRecognitionRun> ret = new Query(this.getCtx(), "C_RevenueRecognition_Run", "C_RevenueRecognition_Plan_ID=?", this.get_TrxName()).setParameters(this.get_ID()).list();
        this.log.fine("" + ret.size());
        return ret;
    }
}

