/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.List;
import java.util.Properties;
import org.adempiere.core.domains.models.X_C_ProjectTask;
import org.compiere.model.MOrder;
import org.compiere.model.MProjectLine;
import org.compiere.model.MProjectPhase;
import org.compiere.model.MProjectTypeTask;
import org.compiere.model.MRequest;
import org.compiere.model.MStandardRequestType;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MProjectTask
extends X_C_ProjectTask {
    private static final long serialVersionUID = 6714520156233475723L;
    private int C_Project_ID = 0;

    public MProjectTask(Properties ctx, int C_ProjectTask_ID, String trxName) {
        super(ctx, C_ProjectTask_ID, trxName);
        if (C_ProjectTask_ID == 0) {
            this.setSeqNo(0);
            this.setQty(Env.ZERO);
        }
    }

    public MProjectTask(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MProjectTask(MProjectPhase phase) {
        this(phase.getCtx(), 0, phase.get_TrxName());
        this.setClientOrg(phase);
        this.setC_ProjectPhase_ID(phase.getC_ProjectPhase_ID());
    }

    public MProjectTask(MProjectPhase phase, MProjectTypeTask task) {
        this(phase);
        this.setC_Task_ID(task.getC_Task_ID());
        this.setSeqNo(task.getSeqNo());
        this.setName(task.getName());
        this.setDescription(task.getDescription());
        this.setHelp(task.getHelp());
        if (task.getM_Product_ID() > 0) {
            this.setM_Product_ID(task.getM_Product_ID());
        }
        if (task.getPP_Product_BOM_ID() > 0) {
            this.setPP_Product_BOM_ID(task.getPP_Product_BOM_ID());
        }
        if (task.getAD_Workflow_ID() > 0) {
            this.setAD_Workflow_ID(task.getAD_Workflow_ID());
        }
        if (phase.getC_Campaign_ID() > 0) {
            this.setC_Campaign_ID(phase.getC_Campaign_ID());
        }
        if (phase.getC_Activity_ID() > 0) {
            this.setC_Activity_ID(phase.getC_Activity_ID());
        }
        if (phase.getC_SalesRegion_ID() > 0) {
            this.setC_SalesRegion_ID(phase.getC_SalesRegion_ID());
        }
        if (phase.getAD_OrgTrx_ID() > 0) {
            this.setAD_OrgTrx_ID(phase.getAD_OrgTrx_ID());
        }
        if (phase.getUser1_ID() > 0) {
            this.setUser1_ID(phase.getUser1_ID());
        }
        if (phase.getUser2_ID() > 0) {
            this.setUser2_ID(phase.getUser2_ID());
        }
        if (phase.getUser3_ID() > 0) {
            this.setUser3_ID(phase.getUser3_ID());
        }
        if (phase.getUser4_ID() > 0) {
            this.setUser4_ID(phase.getUser4_ID());
        }
        this.setPriorityRule(task.getPriorityRule());
        this.setIsMilestone(task.isMilestone());
        this.setIsIndefinite(task.isIndefinite());
        this.setIsRecurrent(task.isRecurrent());
        this.setFrequencyType(task.getFrequencyType());
        this.setFrequency(task.getFrequency());
        this.setRunsMax(task.getRunsMax());
        this.setDurationUnit(task.getDurationUnit());
        this.setDurationEstimated(task.getDurationEstimated());
        this.setQty(task.getStandardQty());
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        Timestamp phaseStartDate;
        if (this.getDateDeadline() == null && (phaseStartDate = this.getC_ProjectPhase().getStartDate()) != null && this.getDurationUnit() != null) {
            Timestamp deadLine = TimeUtil.addDuration(phaseStartDate, this.getDurationUnit(), this.getDurationEstimated());
            this.setDateDeadline(deadLine);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (newRecord) {
            this.createRequest();
        }
        return true;
    }

    public void createRequest() {
        if (this.getC_Task_ID() > 0 && this.getC_Task().getR_StandardRequestType_ID() > 0) {
            MStandardRequestType standardRequestType = (MStandardRequestType)this.getC_Task().getR_StandardRequestType();
            List<MRequest> requests = standardRequestType.createStandardRequest(this);
            requests.stream().forEach(request -> {
                request.setC_Project_ID(this.getC_Project_ID(false));
                request.setC_ProjectPhase_ID(this.getC_ProjectPhase_ID());
                request.setC_ProjectTask_ID(this.getC_ProjectTask_ID());
                request.setDateStartPlan(this.getDateStartSchedule());
                request.setDateCompletePlan(this.getDateFinishSchedule());
                request.saveEx();
            });
        }
    }

    public MProjectLine[] getLines() {
        String whereClause = "C_ProjectPhase_ID=? and C_ProjectTask_ID=? ";
        List<MProjectLine> list = new Query(this.getCtx(), "C_ProjectLine", "C_ProjectPhase_ID=? and C_ProjectTask_ID=? ", this.get_TrxName()).setParameters(this.getC_ProjectPhase_ID(), this.getC_ProjectTask_ID()).setOrderBy("Line").list();
        MProjectLine[] retValue = new MProjectLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public int copyLinesFrom(MProjectTask fromTask) {
        if (fromTask == null) {
            return 0;
        }
        int count = 0;
        MProjectLine[] fromLines = fromTask.getLines();
        for (int i2 = 0; i2 < fromLines.length; ++i2) {
            MProjectLine toLine = new MProjectLine(this.getCtx(), 0, this.get_TrxName());
            PO.copyValues(fromLines[i2], toLine, this.getAD_Client_ID(), this.getAD_Org_ID());
            toLine.setC_Project_ID(this.getC_Project_ID(false));
            toLine.setC_ProjectPhase_ID(this.getC_ProjectPhase_ID());
            toLine.setC_ProjectTask_ID(this.getC_ProjectTask_ID());
            if (!toLine.save()) continue;
            ++count;
        }
        if (fromLines.length != count) {
            this.log.warning("Count difference - ProjectLine=" + fromLines.length + " <> Saved=" + count);
        }
        return count;
    }

    private int getC_Project_ID(boolean reQuery) {
        if (this.C_Project_ID == 0 || reQuery) {
            this.C_Project_ID = this.getC_ProjectPhase().getC_Project_ID();
        }
        return this.C_Project_ID;
    }

    public List<MOrder> getOrders() {
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("EXISTS (SELECT 1 FROM C_OrderLine ol WHERE ol.C_Order_ID = C_Order.C_Order_ID AND ol.C_ProjectTask_ID=?)");
        return new Query(this.getCtx(), "C_Order", whereClause.toString(), this.get_TrxName()).setClient_ID().setParameters(this.getC_ProjectTask_ID()).list();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MProjectTask[");
        sb.append(this.get_ID()).append("-").append(this.getSeqNo()).append("-").append(this.getName()).append("]");
        return sb.toString();
    }
}

