/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_C_PaySelection;
import org.adempiere.core.domains.models.X_C_PaySelectionCheck;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBPBankAccount;
import org.compiere.model.MDocType;
import org.compiere.model.MPaySelection;
import org.compiere.model.MPaySelectionLine;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentAllocate;
import org.compiere.model.MPaymentBatch;
import org.compiere.model.PO;
import org.compiere.model.Query;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public final class MPaySelectionCheck
extends X_C_PaySelectionCheck {
    private static final long serialVersionUID = -5890511999934551763L;
    private static CLogger logger = CLogger.getCLogger(MPaySelectionCheck.class);
    private MPaySelection m_parent = null;
    private List<MPaySelectionLine> paySelectionLines = null;

    public static MPaySelectionCheck getOfPayment(Properties ctx, int paymentId, String trxName) {
        MPaySelectionCheck retValue = null;
        List paySelectionChecks = new Query(ctx, "C_PaySelectionCheck", "C_Payment_ID=?", trxName).setClient_ID().setParameters(paymentId).list();
        int count = 0;
        for (MPaySelectionCheck paySelectionCheck : paySelectionChecks) {
            if (retValue == null) {
                retValue = paySelectionCheck;
            } else if (!retValue.isProcessed() && paySelectionCheck.isProcessed()) {
                retValue = paySelectionCheck;
            }
            ++count;
        }
        if (count > 1) {
            logger.warning("More then one for C_Payment_ID=" + paymentId);
        }
        return retValue;
    }

    public static MPaySelectionCheck createForPayment(Properties ctx, int paymentId, String trxName) {
        if (paymentId == 0) {
            return null;
        }
        MPayment payment = new MPayment(ctx, paymentId, null);
        String paymentRule = "S";
        if (payment.getTenderType().equals("C")) {
            paymentRule = "K";
        } else if (payment.getTenderType().equals("D")) {
            paymentRule = "D";
        } else if (payment.getTenderType().equals("A")) {
            paymentRule = "T";
        }
        MPaySelection paySelection = new MPaySelection(ctx, 0, trxName);
        paySelection.setC_DocType_ID();
        paySelection.setAD_Org_ID(payment.getAD_Org_ID());
        paySelection.setC_BankAccount_ID(payment.getC_BankAccount_ID());
        paySelection.setDescription(Msg.parseTranslation(ctx, "@CreateFrom@ @C_Payment_ID@ " + payment.getDocumentNo()));
        paySelection.setDescription(payment.getDescription());
        paySelection.setPayDate(payment.getDateTrx());
        paySelection.setTotalAmt(payment.getPayAmt());
        paySelection.setIsApproved(true);
        paySelection.saveEx();
        MPaySelectionCheck paySelectionCheck = new MPaySelectionCheck(paySelection, paymentRule);
        paySelectionCheck.setC_BPartner_ID(payment.getC_BPartner_ID());
        paySelectionCheck.setC_Payment_ID(payment.getC_Payment_ID());
        paySelectionCheck.setIsReceipt(payment.isReceipt());
        paySelectionCheck.setPayAmt(payment.getPayAmt());
        paySelectionCheck.setDiscountAmt(payment.getDiscountAmt());
        paySelectionCheck.setQty(1);
        paySelectionCheck.setDocumentNo(payment.getDocumentNo());
        paySelectionCheck.setProcessed(true);
        paySelectionCheck.setIsGeneratedDraft(!payment.isProcessed());
        paySelectionCheck.saveEx();
        MPaySelectionLine paySelectionLine = null;
        if (payment.getC_Invoice_ID() != 0) {
            paySelectionLine = new MPaySelectionLine(paySelection, 10, paymentRule);
            if (payment.getC_Order_ID() != 0) {
                paySelectionLine.setC_Order_ID(payment.getC_Order_ID());
            }
            if (payment.getC_Charge_ID() != 0) {
                paySelectionLine.setC_Charge_ID(payment.getC_Charge_ID());
            }
            if (payment.getC_ConversionType_ID() != 0) {
                paySelectionLine.setC_ConversionType_ID(payment.getC_ConversionType_ID());
            }
            if (payment.getC_Invoice_ID() != 0) {
                paySelectionLine.setC_Invoice_ID(payment.getC_Invoice_ID());
            }
            paySelectionLine.setIsPrepayment(payment.isPrepayment());
            BigDecimal openAmount = Env.ZERO;
            if (payment.isOverUnderPayment()) {
                openAmount = payment.getPayAmt().add(payment.getDiscountAmt()).add(payment.getOverUnderAmt());
            }
            paySelectionLine.setC_BPartner_ID(payment.getC_BPartner_ID());
            paySelectionLine.setIsSOTrx(payment.isReceipt());
            paySelectionLine.setAmtSource(payment.getPayAmt());
            paySelectionLine.setOpenAmt(openAmount);
            paySelectionLine.setPayAmt(payment.getPayAmt());
            paySelectionLine.setDiscountAmt(payment.getDiscountAmt());
            paySelectionLine.setDifferenceAmt(Env.ZERO);
            paySelectionLine.setC_PaySelectionCheck_ID(paySelectionCheck.getC_PaySelectionCheck_ID());
            paySelectionLine.setProcessed(true);
            paySelectionLine.saveEx();
        } else {
            String paymentRuleFinal = paymentRule;
            MPaymentAllocate[] paymentAllocates = MPaymentAllocate.get(payment);
            if (paymentAllocates.length != 0) {
                AtomicInteger numInv = new AtomicInteger();
                Arrays.stream(paymentAllocates).filter(paymentAllocate -> paymentAllocate != null && paymentAllocate.getC_Invoice_ID() != 0).forEach(paymentAllocate -> {
                    MPaySelectionLine newPaySelectionLine = null;
                    newPaySelectionLine = new MPaySelectionLine(paySelection, 10 * (numInv.get() + 1), paymentRuleFinal);
                    if (payment.getC_Order_ID() != 0) {
                        newPaySelectionLine.setC_Order_ID(payment.getC_Order_ID());
                    }
                    if (payment.getC_Charge_ID() != 0) {
                        newPaySelectionLine.setC_Charge_ID(payment.getC_Charge_ID());
                    }
                    if (payment.getC_ConversionType_ID() != 0) {
                        newPaySelectionLine.setC_ConversionType_ID(payment.getC_ConversionType_ID());
                    }
                    if (payment.getC_Invoice_ID() != 0) {
                        newPaySelectionLine.setC_Invoice_ID(payment.getC_Invoice_ID());
                    }
                    newPaySelectionLine.setIsPrepayment(payment.isPrepayment());
                    newPaySelectionLine.setIsSOTrx(payment.isReceipt());
                    newPaySelectionLine.setOpenAmt(paymentAllocate.getAmount().add(paymentAllocate.getDiscountAmt()));
                    newPaySelectionLine.setPayAmt(paymentAllocate.getAmount());
                    newPaySelectionLine.setDiscountAmt(paymentAllocate.getDiscountAmt());
                    newPaySelectionLine.setDifferenceAmt(Env.ZERO);
                    newPaySelectionLine.setC_PaySelectionCheck_ID(paySelectionCheck.getC_PaySelectionCheck_ID());
                    newPaySelectionLine.setProcessed(true);
                    newPaySelectionLine.saveEx();
                    numInv.updateAndGet(line -> line++);
                });
                if (numInv.get() > 0) {
                    paySelectionCheck.setQty(numInv.get());
                    paySelectionCheck.saveEx();
                }
            }
        }
        paySelection.processIt("CO");
        paySelection.saveEx();
        return paySelectionCheck;
    }

    public static List<MPaySelectionCheck> get(int paySelectionId, String paymentRule, int startDocumentNo, String trxName) {
        logger.fine("C_PaySelection_ID=" + paySelectionId + ", PaymentRule=" + paymentRule + ", startDocumentNo=" + startDocumentNo);
        ArrayList<MPaySelectionCheck> paySelectionChecks = new ArrayList<MPaySelectionCheck>();
        AtomicInteger docNo = new AtomicInteger(startDocumentNo);
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("C_PaySelection_ID").append("=? AND ").append("PaymentRule").append("=? ").append("AND (C_PaySelectionCheck.C_Payment_ID IS NULL \t\t\tOR \t\tEXISTS(SELECT 1 FROM C_Payment p \t\t\t\tWHERE p.C_Payment_ID = C_PaySelectionCheck.C_Payment_ID \t\t\t\tAND p.DocStatus NOT IN('CO', 'CL')))");
        List draftPaySelectionChecks = new Query(Env.getCtx(), "C_PaySelectionCheck", whereClause.toString(), trxName).setClient_ID().setParameters(paySelectionId, paymentRule).list();
        draftPaySelectionChecks.stream().filter(paySelectionCheck -> paySelectionCheck != null).forEach(paySelectionCheck -> {
            paySelectionCheck.setDocumentNo(String.valueOf(docNo.get()));
            docNo.updateAndGet(no -> no + 1);
            paySelectionCheck.saveEx();
            paySelectionChecks.add((MPaySelectionCheck)paySelectionCheck);
        });
        return paySelectionChecks;
    }

    public static List<MPaySelectionCheck> get(Properties ctx, int paySelectionId, String trxName) {
        logger.fine("C_PaySelection_ID=" + paySelectionId);
        return new Query(ctx, "C_PaySelectionCheck", "C_PaySelection_ID = ?", trxName).setParameters(paySelectionId).list();
    }

    public static int confirmPrint(List<MPaySelectionCheck> paySelectionChecks, MPaymentBatch batch) {
        AtomicInteger lastDocumentNo = new AtomicInteger();
        paySelectionChecks.stream().filter(psc -> psc != null).forEach(paySelectionCheck -> {
            MPayment payment = new MPayment(paySelectionCheck.getCtx(), paySelectionCheck.getC_Payment_ID(), paySelectionCheck.get_TrxName());
            if (paySelectionCheck.getC_Payment_ID() != 0 && (payment.getDocStatus().equals("CO") || payment.getDocStatus().equals("CL"))) {
                if (paySelectionCheck.getPaymentRule().equals("S")) {
                    payment.setCheckNo(paySelectionCheck.getDocumentNo());
                } else {
                    payment.setDocumentNo(paySelectionCheck.getDocumentNo());
                }
                payment.saveEx();
            } else {
                List<MPaySelectionLine> paySelectionLines;
                I_C_PaySelection paySelection = paySelectionCheck.getC_PaySelection();
                MDocType documentType = MDocType.get(paySelectionCheck.getCtx(), paySelection.getC_DocType_ID());
                int docTypeId = documentType.getC_DocTypePayment_ID();
                payment = new MPayment(paySelectionCheck.getCtx(), 0, paySelectionCheck.get_TrxName());
                payment.setAD_Org_ID(paySelectionCheck.getAD_Org_ID());
                if (paySelectionCheck.getPaymentRule().equals("S")) {
                    payment.setBankCheck(paySelectionCheck.getParent().getC_BankAccount_ID(), false, paySelectionCheck.getDocumentNo());
                } else if (paySelectionCheck.getPaymentRule().equals("K")) {
                    payment.setTenderType("C");
                } else if (paySelectionCheck.getPaymentRule().equals("T") || paySelectionCheck.getPaymentRule().equals("D") || paySelectionCheck.getPaymentRule().equals("B")) {
                    payment.setBankACH((MPaySelectionCheck)paySelectionCheck);
                } else {
                    logger.log(Level.SEVERE, "Unsupported Payment Rule=" + paySelectionCheck.getPaymentRule());
                    throw new AdempiereException("Unsupported Payment Rule=" + paySelectionCheck.getPaymentRule());
                }
                payment.setTrxType("C");
                if (docTypeId > 0) {
                    payment.setC_DocType_ID(docTypeId);
                }
                payment.setAmount(paySelectionCheck.getParent().getC_Currency_ID(), paySelectionCheck.getPayAmt());
                payment.setDiscountAmt(paySelectionCheck.getDiscountAmt());
                payment.setDateTrx(paySelectionCheck.getParent().getPayDate());
                payment.setDateAcct(payment.getDateTrx());
                payment.setC_BPartner_ID(paySelectionCheck.getC_BPartner_ID());
                if (!paySelectionCheck.getPaymentRule().equals("S")) {
                    payment.setDocumentNo(paySelectionCheck.getDocumentNo());
                }
                if (batch != null) {
                    if (batch.getC_PaymentBatch_ID() == 0) {
                        batch.saveEx();
                    }
                    payment.setC_PaymentBatch_ID(batch.getC_PaymentBatch_ID());
                }
                logger.fine("confirmPrint - " + paySelectionCheck + " (#SelectionLines=" + ((paySelectionLines = paySelectionCheck.getPaySelectionLinesAsList(false)) != null ? paySelectionLines.size() : 0) + ")");
                if (documentType.isBankTransfer()) {
                    payment.setC_Invoice_ID(-1);
                    payment.setC_Order_ID(-1);
                    payment.setTenderType("A");
                    payment.saveEx();
                    if (paySelectionLines != null) {
                        for (MPaySelectionLine line : paySelectionLines) {
                            if (line.getC_BankAccountTo_ID() == 0) {
                                throw new AdempiereException("@C_BankAccountTo_ID@ @NotFound@");
                            }
                            MPayment receiptAccount = new MPayment(paySelectionCheck.getCtx(), 0, paySelectionCheck.get_TrxName());
                            PO.copyValues(payment, receiptAccount);
                            receiptAccount.setC_BankAccount_ID(line.getC_BankAccountTo_ID());
                            receiptAccount.setIsReceipt(!payment.isReceipt());
                            receiptAccount.setC_DocType_ID(!payment.isReceipt());
                            receiptAccount.setRelatedPayment_ID(payment.getC_Payment_ID());
                            receiptAccount.setTenderType("A");
                            receiptAccount.setC_Charge_ID(line.getC_Charge_ID());
                            receiptAccount.saveEx();
                            receiptAccount.processIt("CO");
                            receiptAccount.saveEx();
                            payment.setRelatedPayment_ID(receiptAccount.getC_Payment_ID());
                            payment.setC_Charge_ID(receiptAccount.getC_Charge_ID());
                            payment.saveEx();
                        }
                    }
                } else if (paySelectionCheck.getQty() == 1 && paySelectionLines != null && paySelectionLines.size() == 1) {
                    MPaySelectionLine paySelectionLine = paySelectionLines.get(0);
                    logger.fine("Map to Invoice " + paySelectionLine);
                    if (paySelectionLine.getC_Order_ID() != 0) {
                        payment.setC_Order_ID(paySelectionLine.getC_Order_ID());
                    }
                    if (paySelectionLine.getC_Charge_ID() != 0) {
                        payment.setC_Charge_ID(paySelectionLine.getC_Charge_ID());
                        if (paySelectionLine.getHR_Movement_ID() > 0) {
                            payment.setC_Project_ID(paySelectionLine.getHRMovement().getC_Project_ID());
                        }
                    }
                    if (paySelectionLine.getC_ConversionType_ID() != 0) {
                        payment.setC_ConversionType_ID(paySelectionLine.getC_ConversionType_ID());
                    }
                    if (paySelectionLine.getC_Invoice_ID() != 0) {
                        payment.setC_Invoice_ID(paySelectionLine.getC_Invoice_ID());
                    }
                    payment.setIsPrepayment(paySelectionLine.isPrepayment());
                    payment.setDiscountAmt(paySelectionLine.getDiscountAmt());
                    payment.setWriteOffAmt(paySelectionLine.getDifferenceAmt());
                    BigDecimal overUnder = paySelectionLine.getOpenAmt().subtract(paySelectionLine.getPayAmt()).subtract(paySelectionLine.getDiscountAmt()).subtract(paySelectionLine.getDifferenceAmt());
                    payment.setOverUnderAmt(overUnder);
                } else {
                    payment.setDiscountAmt(Env.ZERO);
                }
                payment.setWriteOffAmt(Env.ZERO);
                payment.saveEx();
                paySelectionCheck.setC_Payment_ID(payment.getC_Payment_ID());
                paySelectionCheck.saveEx();
                payment.processIt("CO");
                payment.saveEx();
            }
            try {
                int no = Integer.parseInt(paySelectionCheck.getDocumentNo());
                if (lastDocumentNo.get() < no) {
                    lastDocumentNo.set(no);
                }
            }
            catch (NumberFormatException ex) {
                logger.log(Level.SEVERE, "DocumentNo=" + paySelectionCheck.getDocumentNo(), ex);
            }
            paySelectionCheck.setIsPrinted(true);
            paySelectionCheck.setProcessed(true);
            paySelectionCheck.saveEx();
        });
        logger.fine("Last Document No = " + lastDocumentNo.get());
        return lastDocumentNo.get();
    }

    public MPaySelectionCheck(Properties ctx, int paySelectionCheckId, String trxName) {
        super(ctx, paySelectionCheckId, trxName);
        if (paySelectionCheckId == 0) {
            this.setPayAmt(Env.ZERO);
            this.setDiscountAmt(Env.ZERO);
            this.setIsPrinted(false);
            this.setIsReceipt(false);
            this.setQty(0);
        }
    }

    public MPaySelectionCheck(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MPaySelectionCheck(MPaySelectionLine paySelectionLine, String paymentRule) {
        this(paySelectionLine.getCtx(), 0, paySelectionLine.get_TrxName());
        boolean isPayrollAccount;
        this.setClientOrg(paySelectionLine);
        this.setC_PaySelection_ID(paySelectionLine.getC_PaySelection_ID());
        int partnerId = paySelectionLine.getC_BPartner_ID();
        this.setC_BPartner_ID(partnerId);
        if (paymentRule == null) {
            paymentRule = paySelectionLine.getPaymentRule();
        }
        boolean bl = isPayrollAccount = paySelectionLine.getHR_Movement_ID() > 0;
        if (paySelectionLine.getC_BP_BankAccount_ID() != 0) {
            this.setC_BP_BankAccount_ID(paySelectionLine.getC_BP_BankAccount_ID());
        } else if ("D".equals(paymentRule)) {
            List<MBPBankAccount> partnerBankAccounts = MBPBankAccount.getByPartner(paySelectionLine.getCtx(), partnerId);
            partnerBankAccounts.stream().filter(partnerBankAccount -> partnerBankAccount != null && partnerBankAccount.isDirectDebit()).filter(employeeAccount -> employeeAccount.isPayrollAccount() || !isPayrollAccount).findFirst().ifPresent(partnerBankAccount -> {
                this.setC_BP_BankAccount_ID(partnerBankAccount.getC_BP_BankAccount_ID());
                paySelectionLine.setC_BP_BankAccount_ID(partnerBankAccount.getC_BP_BankAccount_ID());
                paySelectionLine.saveEx();
            });
        } else if ("T".equals(paymentRule)) {
            List<MBPBankAccount> partnerBankAccounts = MBPBankAccount.getByPartner(paySelectionLine.getCtx(), partnerId);
            partnerBankAccounts.stream().filter(partnerBankAccount -> partnerBankAccount != null && partnerBankAccount.isDirectDeposit()).filter(employeeAccount -> employeeAccount.isPayrollAccount() || !isPayrollAccount).findFirst().ifPresent(partnerBankAccount -> {
                this.setC_BP_BankAccount_ID(partnerBankAccount.getC_BP_BankAccount_ID());
                paySelectionLine.setC_BP_BankAccount_ID(partnerBankAccount.getC_BP_BankAccount_ID());
                paySelectionLine.saveEx();
            });
        }
        this.setPaymentRule(paymentRule);
        this.setIsReceipt(paySelectionLine.isSOTrx());
        this.setPayAmt(paySelectionLine.getPayAmt());
        this.setDiscountAmt(paySelectionLine.getDiscountAmt());
        this.setQty(1);
    }

    public MPaySelectionCheck(MPaySelection paySelection, String paymentRule) {
        this(paySelection.getCtx(), 0, paySelection.get_TrxName());
        this.setClientOrg(paySelection);
        this.setC_PaySelection_ID(paySelection.getC_PaySelection_ID());
        this.setPaymentRule(paymentRule);
    }

    public void addLine(MPaySelectionLine paySelectionLine) {
        if (this.getC_BPartner_ID() != paySelectionLine.getC_BPartner_ID()) {
            throw new IllegalArgumentException("@BPartnerDiff@");
        }
        if (this.isReceipt() == paySelectionLine.isSOTrx()) {
            this.setPayAmt(this.getPayAmt().add(paySelectionLine.getPayAmt()));
            this.setDiscountAmt(this.getDiscountAmt().add(paySelectionLine.getDiscountAmt()));
        } else {
            this.setPayAmt(this.getPayAmt().subtract(paySelectionLine.getPayAmt()));
            this.setDiscountAmt(this.getDiscountAmt().subtract(paySelectionLine.getDiscountAmt()));
        }
        this.setQty(this.getQty() + 1);
    }

    public MPaySelection getParent() {
        if (this.m_parent == null) {
            this.m_parent = new MPaySelection(this.getCtx(), this.getC_PaySelection_ID(), this.get_TrxName());
        }
        return this.m_parent;
    }

    public boolean isValid() {
        if (this.getC_BP_BankAccount_ID() != 0) {
            return true;
        }
        return !this.isDirect();
    }

    public boolean isDirect() {
        return "T".equals(this.getPaymentRule()) || "D".equals(this.getPaymentRule());
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MPaymentCheck[");
        sb.append(this.get_ID()).append("-").append(this.getDocumentNo()).append("-").append(this.getPayAmt()).append(",PaymetRule=").append(this.getPaymentRule()).append(",Qty=").append(this.getQty()).append("]");
        return sb.toString();
    }

    public MPaySelectionLine[] getPaySelectionLines(boolean reQuery) {
        List<MPaySelectionLine> paySelectionLinesAsList = this.getPaySelectionLinesAsList(reQuery);
        MPaySelectionLine[] paySelectionLine = new MPaySelectionLine[paySelectionLinesAsList.size()];
        return paySelectionLinesAsList.toArray(paySelectionLine);
    }

    public List<MPaySelectionLine> getPaySelectionLinesAsList(boolean reQuery) {
        if (this.paySelectionLines != null && !reQuery) {
            this.paySelectionLines.stream().filter(paySelectionLine -> paySelectionLine != null).forEach(paySelectionLine -> paySelectionLine.set_TrxName(this.get_TrxName()));
            return this.paySelectionLines;
        }
        this.paySelectionLines = new Query(this.getCtx(), "C_PaySelectionLine", "C_PaySelectionCheck_ID=?", this.get_TrxName()).setClient_ID().setOrderBy("Line").setParameters(this.getC_PaySelectionCheck_ID()).list();
        return this.paySelectionLines;
    }

    public static boolean deleteGeneratedDraft(Properties ctx, int C_Payment_ID, String trxName) {
        MPaySelectionCheck paySelectionCheck = MPaySelectionCheck.getOfPayment(ctx, C_Payment_ID, trxName);
        if (paySelectionCheck != null && paySelectionCheck.isGeneratedDraft()) {
            MPaySelection paySelection = new MPaySelection(ctx, paySelectionCheck.getC_PaySelection_ID(), trxName);
            List<MPaySelectionLine> paySelectionLines = paySelection.getLines(true);
            paySelectionLines.stream().filter(paySelectionLine -> paySelectionLine != null).forEach(paySelectionLine -> paySelectionLine.deleteEx(true));
            if (!paySelectionCheck.delete(true, trxName)) {
                return false;
            }
            if (!paySelection.delete(true, trxName)) {
                return false;
            }
        }
        return true;
    }

    public MPayment generatePayment(AtomicInteger lastDocumentNo, String paymentRule, MPaySelection selection) {
        MPayment mPayment = new MPayment(this.getCtx(), this.getC_Payment_ID(), this.get_TrxName());
        if (this.getC_Payment_ID() != 0 && (mPayment.getDocStatus().equals("CO") || mPayment.getDocStatus().equals("CL"))) {
            if (paymentRule.equals("S")) {
                mPayment.setCheckNo(this.getDocumentNo());
                mPayment.saveEx();
            }
        } else {
            String mPaymentDescription;
            MDocType documentType = MDocType.get(this.getCtx(), this.getC_PaySelection().getC_DocType_ID());
            int docTypeId = documentType.getC_DocTypePayment_ID();
            mPayment = new MPayment(this.getCtx(), 0, this.get_TrxName());
            mPayment.setAD_Org_ID(this.getAD_Org_ID());
            if (paymentRule.equals("S")) {
                mPayment.setBankCheck(this.getParent().getC_BankAccount_ID(), false, this.getDocumentNo());
            } else if (paymentRule.equals("K")) {
                mPayment.setTenderType("C");
            } else if (paymentRule.equals("T") || this.getPaymentRule().equals("D")) {
                mPayment.setBankACH(this);
            } else {
                this.log.log(Level.SEVERE, "Unsupported Payment Rule=" + paymentRule);
                throw new AdempiereException("Unsupported Payment Rule=" + paymentRule);
            }
            if (paymentRule.equalsIgnoreCase("S")) {
                mPayment.setTenderType("K");
            }
            if (paymentRule.equalsIgnoreCase("T")) {
                mPayment.setTenderType("A");
            }
            mPayment.setTrxType("C");
            if (docTypeId > 0) {
                mPayment.setC_DocType_ID(docTypeId);
            }
            mPayment.setAmount(this.getParent().getC_Currency_ID(), this.getPayAmt());
            mPayment.setDiscountAmt(this.getDiscountAmt());
            mPayment.setDateTrx(this.getParent().getPayDate());
            mPayment.setDateAcct(mPayment.getDateTrx());
            mPayment.setC_BPartner_ID(this.getC_BPartner_ID());
            List<MPaySelectionLine> paySelectionLines = this.getPaySelectionLinesAsList(false);
            this.log.fine("confirmPrint - " + this.toString() + " (#SelectionLines=" + (paySelectionLines != null ? paySelectionLines.size() : 0) + ")");
            if (documentType.isBankTransfer()) {
                mPayment.setC_Invoice_ID(-1);
                mPayment.setC_Order_ID(-1);
                mPayment.setTenderType("A");
                mPayment.saveEx();
                if (paySelectionLines != null) {
                    for (MPaySelectionLine line : paySelectionLines) {
                        if (line.getC_BankAccountTo_ID() == 0) {
                            throw new AdempiereException("@C_BankAccountTo_ID@ @NotFound@");
                        }
                        MPayment receiptAccount = new MPayment(this.getCtx(), 0, this.get_TrxName());
                        PO.copyValues(mPayment, receiptAccount);
                        receiptAccount.setC_BankAccount_ID(line.getC_BankAccountTo_ID());
                        receiptAccount.setIsReceipt(!mPayment.isReceipt());
                        receiptAccount.setC_DocType_ID(!mPayment.isReceipt());
                        receiptAccount.setRelatedPayment_ID(mPayment.getC_Payment_ID());
                        receiptAccount.setTenderType("A");
                        receiptAccount.saveEx();
                        receiptAccount.processIt("CO");
                        receiptAccount.saveEx();
                        mPayment.setRelatedPayment_ID(receiptAccount.getC_Payment_ID());
                    }
                }
            } else if (this.getQty() == 1 && paySelectionLines != null && paySelectionLines.size() == 1) {
                MPaySelectionLine paySelectionLine = paySelectionLines.get(0);
                this.log.fine("Map to Invoice " + paySelectionLine);
                if (paySelectionLine.getC_Order_ID() != 0) {
                    mPayment.setC_Order_ID(paySelectionLine.getC_Order_ID());
                }
                if (paySelectionLine.getC_Charge_ID() != 0) {
                    mPayment.setC_Charge_ID(paySelectionLine.getC_Charge_ID());
                    if (paySelectionLine.getHR_Movement_ID() > 0) {
                        mPayment.setC_Project_ID(paySelectionLine.getHRMovement().getC_Project_ID());
                    }
                }
                if (paySelectionLine.getC_ConversionType_ID() != 0) {
                    mPayment.setC_ConversionType_ID(paySelectionLine.getC_ConversionType_ID());
                }
                if (paySelectionLine.getC_Invoice_ID() != 0) {
                    mPayment.setC_Invoice_ID(paySelectionLine.getC_Invoice_ID());
                }
                mPayment.setIsPrepayment(paySelectionLine.isPrepayment());
                mPayment.setDiscountAmt(paySelectionLine.getDiscountAmt());
                mPayment.setWriteOffAmt(paySelectionLine.getDifferenceAmt());
                BigDecimal overUnder = paySelectionLine.getOpenAmt().subtract(paySelectionLine.getPayAmt()).subtract(paySelectionLine.getDiscountAmt()).subtract(paySelectionLine.getDifferenceAmt());
                mPayment.setOverUnderAmt(overUnder);
            } else {
                mPayment.setDiscountAmt(Env.ZERO);
            }
            mPayment.setWriteOffAmt(Env.ZERO);
            mPayment.setDescription(this.getParent().getDescription());
            int docNo = 0;
            try {
                docNo = lastDocumentNo.get();
            }
            catch (Exception overUnder) {
                // empty catch block
            }
            if (docNo > 0) {
                mPayment.setCheckNo(String.valueOf(lastDocumentNo.get()));
                mPayment.setDocumentNo(String.valueOf(lastDocumentNo.get()));
                lastDocumentNo.incrementAndGet();
            }
            mPayment.setDescription((String)((mPaymentDescription = mPayment.getDescription()) != null && !mPaymentDescription.isEmpty() ? mPaymentDescription + " - " : "") + "Generado desde Seleccion de Pago Nro. '" + this.getC_PaySelection().getDocumentNo() + "'");
            mPayment.set_ValueOfColumn("C_PaySelection_ID", (Object)selection.get_ID());
            mPayment.saveEx();
            this.setC_Payment_ID(mPayment.getC_Payment_ID());
            mPayment.processIt("CO");
            mPayment.saveEx();
        }
        this.setIsPrinted(true);
        this.setProcessed(true);
        return mPayment;
    }

    public void changePayment(AtomicInteger lastDocumentNo, String paymentRule, MPaySelection selection) {
        MPayment oldPayment = this.voidPayment();
        MPayment newPayment = this.generatePayment(lastDocumentNo, paymentRule, selection);
        Object description = oldPayment.getDescription();
        description = description != null && !((String)description).isEmpty() ? (String)description + " | " : "";
        description = (String)description + "Modificado por documento " + newPayment.getDocumentNo();
        oldPayment.setDescription((String)description);
        oldPayment.saveEx();
    }

    private MPayment voidPayment() {
        try {
            MPayment mPayment = (MPayment)this.getC_Payment();
            if (mPayment != null && mPayment.get_ID() > 0 && !"VO".equals(mPayment.getDocStatus())) {
                if (!mPayment.processIt("VO")) {
                    throw new AdempiereException(mPayment.getProcessMsg());
                }
                mPayment.saveEx();
                this.setC_Payment_ID(0);
            }
            return mPayment;
        }
        catch (Exception e) {
            throw new AdempiereException(e);
        }
    }
}

