/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_CM_NewsChannel;
import org.compiere.model.MIndex;
import org.compiere.model.MNewsItem;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MNewsChannel
extends X_CM_NewsChannel {
    private static final long serialVersionUID = 6310767119517226147L;

    public MNewsChannel(Properties ctx, int CM_NewsChannel_ID, String trxName) {
        super(ctx, CM_NewsChannel_ID, trxName);
    }

    public MNewsChannel(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MNewsItem[] getNewsItems(String where) {
        ArrayList<MNewsItem> list = new ArrayList<MNewsItem>();
        Object sql = "SELECT * FROM CM_NewsItem WHERE CM_NewsChannel_ID=? AND IsActive='Y'";
        if (where != null && where.length() > 0) {
            sql = (String)sql + " AND " + where;
        }
        sql = (String)sql + " ORDER BY pubDate DESC";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement((String)sql, this.get_TrxName());
            pstmt.setInt(1, this.get_ID());
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                list.add(new MNewsItem(this.getCtx(), rs, this.get_TrxName()));
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, (String)sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MNewsItem[] retValue = new MNewsItem[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public StringBuffer get_rss2ChannelCode(StringBuffer xmlCode, boolean showFutureItems) {
        if (this != null) {
            xmlCode.append("<channel>");
            xmlCode.append("  <title><![CDATA[" + this.getName() + "]]></title>");
            xmlCode.append("  <link>" + this.getLink() + "</link>");
            xmlCode.append("  <description><![CDATA[" + this.getDescription() + "]]></description>");
            xmlCode.append("  <language>" + this.getAD_Language() + "</language>");
            xmlCode.append("  <copyright></copyright>");
            xmlCode.append("  <pubDate>" + this.getCreated() + "</pubDate>");
            xmlCode.append("  <image>");
            xmlCode.append("    <url></url>");
            xmlCode.append("    <title><![CDATA[]]></title>");
            xmlCode.append("    <link></link>");
            xmlCode.append("  </image>");
            String whereClause = "";
            if (!showFutureItems) {
                whereClause = "sysdate>pubdate";
            }
            MNewsItem[] theseItems = this.getNewsItems(whereClause);
            for (int i2 = 0; i2 < theseItems.length; ++i2) {
                xmlCode = theseItems[i2].get_rss2ItemCode(xmlCode, this);
            }
            xmlCode.append("</channel>");
        }
        return xmlCode;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success) {
            return success;
        }
        this.reIndex(newRecord);
        return success;
    }

    public void reIndex(boolean newRecord) {
        String[] toBeIndexed = new String[]{this.getName(), this.getDescription()};
        MIndex.reIndex(newRecord, toBeIndexed, this.getCtx(), this.getAD_Client_ID(), this.get_Table_ID(), this.get_ID(), this.getCM_WebProject_ID(), this.getUpdated());
    }
}

