/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_R_IssueProject;
import org.compiere.model.MIssue;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MIssueProject
extends X_R_IssueProject {
    private static final long serialVersionUID = -9115162283984109370L;
    private static CLogger s_log = CLogger.getCLogger(MIssueProject.class);

    public static MIssueProject get(MIssue issue) {
        if (issue.getName() == null) {
            return null;
        }
        X_R_IssueProject pj = null;
        String sql = "SELECT * FROM R_IssueProject WHERE Name=?";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setString(1, issue.getName());
            ResultSet rs = pstmt.executeQuery();
            if (rs.next()) {
                pj = new MIssueProject(issue.getCtx(), rs, null);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        if (pj == null) {
            pj = new MIssueProject(issue.getCtx(), 0, null);
            pj.setName(issue.getName());
            ((MIssueProject)pj).setA_Asset_ID(issue);
        }
        pj.setSystemStatus(issue.getSystemStatus());
        pj.setStatisticsInfo(issue.getStatisticsInfo());
        pj.setProfileInfo(issue.getProfileInfo());
        if (!pj.save()) {
            return null;
        }
        issue.setR_IssueProject_ID(pj.getR_IssueProject_ID());
        if (pj.getA_Asset_ID() != 0) {
            issue.setA_Asset_ID(pj.getA_Asset_ID());
        }
        return pj;
    }

    public MIssueProject(Properties ctx, int R_IssueProject_ID, String trxName) {
        super(ctx, R_IssueProject_ID, trxName);
    }

    public MIssueProject(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public void setA_Asset_ID(MIssue issue) {
        int A_Asset_ID = 0;
        String sql = "SELECT * FROM A_Asset a WHERE EXISTS (SELECT * FROM A_Asset_Group ag WHERE a.A_Asset_Group_ID=ag.A_Asset_Group_ID AND ag.IsTrackIssues='Y') AND EXISTS (SELECT * FROM AD_User u WHERE (a.C_BPartner_ID=u.C_BPartner_ID OR a.C_BPartnerSR_ID=u.C_BPartner_ID) AND u.EMail=?) AND (SerNo IS NULL OR SerNo=?)";
        super.setA_Asset_ID(A_Asset_ID);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MIssueProject[");
        sb.append(this.get_ID()).append("-").append(this.getName()).append(",A_Asset_ID=").append(this.getA_Asset_ID()).append(",C_Project_ID=").append(this.getC_Project_ID()).append("]");
        return sb.toString();
    }
}

