/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_C_Invoice;
import org.adempiere.core.domains.models.X_C_Order;
import org.adempiere.core.domains.models.X_C_OrderLine;
import org.adempiere.core.domains.models.X_M_InOutLine;
import org.adempiere.core.domains.models.X_M_RMA;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.BPartnerNoAddressException;
import org.adempiere.exceptions.DBException;
import org.compiere.model.MAllocationHdr;
import org.compiere.model.MAllocationLine;
import org.compiere.model.MBPartner;
import org.compiere.model.MBPartnerLocation;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatement;
import org.compiere.model.MCash;
import org.compiere.model.MCashBook;
import org.compiere.model.MCashLine;
import org.compiere.model.MClient;
import org.compiere.model.MConversionRate;
import org.compiere.model.MCurrency;
import org.compiere.model.MDocType;
import org.compiere.model.MDocTypeCounter;
import org.compiere.model.MInOut;
import org.compiere.model.MInOutLine;
import org.compiere.model.MInvoiceBatch;
import org.compiere.model.MInvoiceBatchLine;
import org.compiere.model.MInvoiceLine;
import org.compiere.model.MInvoicePaySchedule;
import org.compiere.model.MInvoiceTax;
import org.compiere.model.MMatchInv;
import org.compiere.model.MMatchPO;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.MOrg;
import org.compiere.model.MPOS;
import org.compiere.model.MPayment;
import org.compiere.model.MPaymentTerm;
import org.compiere.model.MPeriod;
import org.compiere.model.MPriceList;
import org.compiere.model.MProduct;
import org.compiere.model.MProject;
import org.compiere.model.MRMA;
import org.compiere.model.MRMALine;
import org.compiere.model.MRefList;
import org.compiere.model.MSysConfig;
import org.compiere.model.MTax;
import org.compiere.model.MUser;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.PO;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.print.ReportEngine;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.process.DocumentReversalEnabled;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.eevolution.manufacturing.model.MPPProductBOM;
import org.eevolution.manufacturing.model.MPPProductBOMLine;

public class MInvoice
extends X_C_Invoice
implements DocAction,
DocumentReversalEnabled {
    private static final long serialVersionUID = 816227083897031327L;
    private static CCache<Integer, MInvoice> s_cache = new CCache("C_Invoice", 20, 2);
    private BigDecimal openAmount = null;
    private MInvoiceLine[] InvoiceLines;
    private MInvoiceTax[] invoiceTaxes;
    private static CLogger s_log = CLogger.getCLogger(MInvoice.class);
    private boolean isReversal = false;
    private String processMsg = null;
    private boolean justPrepared = false;
    ArrayList<PO> docsPostProcess = new ArrayList();

    public static MInvoice[] getOfBPartner(Properties ctx, int C_BPartner_ID, String trxName) {
        List<MInvoice> list = new Query(ctx, "C_Invoice", "C_BPartner_ID=?", trxName).setParameters(C_BPartner_ID).list();
        return list.toArray(new MInvoice[list.size()]);
    }

    public static MInvoice copyFrom(MInvoice from, Timestamp dateDoc, Timestamp dateAcct, int docTypeTargetId, boolean isSOTrx, boolean counter, boolean isReversal, String trxName, boolean setOrder) {
        MDocType docFrom = (MDocType)from.getC_DocTypeTarget();
        MInvoice to = new MInvoice(from.getCtx(), 0, trxName);
        PO.copyValues(from, to, from.getAD_Client_ID(), from.getAD_Org_ID());
        to.set_ValueNoCheck("C_Invoice_ID", I_ZERO);
        if (docFrom.getDocBaseType() != null && (docFrom.getDocBaseType().equalsIgnoreCase("ARI") || docFrom.getDocBaseType().equalsIgnoreCase("ARC"))) {
            to.set_ValueNoCheck("DocumentNo", from.getDocumentNo());
        } else {
            to.set_ValueNoCheck("DocumentNo", null);
        }
        if (isReversal) {
            to.setReversal(true);
            to.setReversal_ID(from.getC_Invoice_ID());
            MDocType docType = MDocType.get(from.getCtx(), from.getC_DocType_ID());
            if (docType.isCopyDocNoOnReversal()) {
                to.setDocumentNo(from.getDocumentNo() + Msg.getMsg(from.getCtx(), "^"));
            }
        }
        to.setDocStatus("DR");
        to.setDocAction("CO");
        to.setC_DocType_ID(0);
        to.setC_DocTypeTarget_ID(docTypeTargetId);
        to.setIsSOTrx(isSOTrx);
        to.setDateInvoiced(dateDoc);
        to.setDateAcct(dateAcct);
        to.setDatePrinted(null);
        to.setIsPrinted(false);
        to.setIsApproved(false);
        to.setC_Payment_ID(0);
        to.setC_CashLine_ID(0);
        to.setIsPaid(false);
        to.setIsInDispute(false);
        to.setGrandTotal(Env.ZERO);
        to.setTotalLines(Env.ZERO);
        to.setIsTransferred(false);
        to.setPosted(false);
        to.setProcessed(false);
        to.setProcessing(false);
        to.setIsSelfService(false);
        if (!setOrder) {
            to.setC_Order_ID(0);
        }
        if (counter) {
            PO peer;
            to.setRef_Invoice_ID(from.getC_Invoice_ID());
            if (from.getC_Order_ID() != 0 && ((X_C_Order)(peer = new MOrder(from.getCtx(), from.getC_Order_ID(), from.get_TrxName()))).getRef_Order_ID() != 0) {
                to.setC_Order_ID(((X_C_Order)peer).getRef_Order_ID());
            }
            if (from.getM_RMA_ID() != 0 && ((X_M_RMA)(peer = new MRMA(from.getCtx(), from.getM_RMA_ID(), from.get_TrxName()))).getRef_RMA_ID() > 0) {
                to.setM_RMA_ID(((X_M_RMA)peer).getRef_RMA_ID());
            }
        } else {
            to.setRef_Invoice_ID(0);
        }
        to.saveEx(trxName);
        if (counter) {
            from.setRef_Invoice_ID(to.getC_Invoice_ID());
        }
        if (from.getLines(true).length > 0 && to.copyLinesFrom(from, counter, setOrder) == 0) {
            throw new IllegalStateException("Could not create Invoice Lines");
        }
        return to;
    }

    public static String getPDFFileName(String documentDir, int C_Invoice_ID) {
        StringBuffer sb = new StringBuffer(documentDir);
        if (sb.length() == 0) {
            sb.append(".");
        }
        if (!sb.toString().endsWith(File.separator)) {
            sb.append(File.separator);
        }
        sb.append("C_Invoice_ID_").append(C_Invoice_ID).append(".pdf");
        return sb.toString();
    }

    public static MInvoice get(Properties ctx, int C_Invoice_ID) {
        Integer key = new Integer(C_Invoice_ID);
        MInvoice retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MInvoice(ctx, C_Invoice_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MInvoice(Properties ctx, int C_Invoice_ID, String trxName) {
        super(ctx, C_Invoice_ID, trxName);
        if (C_Invoice_ID == 0) {
            this.setDocStatus("DR");
            this.setDocAction("CO");
            this.setPaymentRule("P");
            this.setDateInvoiced(new Timestamp(System.currentTimeMillis()));
            this.setDateAcct(new Timestamp(System.currentTimeMillis()));
            this.setChargeAmt(Env.ZERO);
            this.setTotalLines(Env.ZERO);
            this.setGrandTotal(Env.ZERO);
            this.setIsSOTrx(true);
            this.setIsTaxIncluded(false);
            this.setIsApproved(false);
            this.setIsDiscountPrinted(false);
            this.setIsPaid(false);
            this.setSendEMail(false);
            this.setIsPrinted(false);
            this.setIsTransferred(false);
            this.setIsSelfService(false);
            this.setIsPayScheduleValid(false);
            this.setIsInDispute(false);
            this.setPosted(false);
            super.setProcessed(false);
            this.setProcessing(false);
        }
    }

    public MInvoice(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MInvoice(MOrder order, int C_DocTypeTarget_ID, Timestamp invoiceDate) {
        this(order.getCtx(), 0, order.get_TrxName());
        MDocType odt;
        this.setClientOrg(order);
        this.setOrder(order);
        if (C_DocTypeTarget_ID <= 0 && (odt = MDocType.get(order.getCtx(), order.getC_DocType_ID())) != null && (C_DocTypeTarget_ID = odt.getC_DocTypeInvoice_ID()) <= 0) {
            throw new AdempiereException("@NotFound@ @C_DocTypeInvoice_ID@ - @C_DocType_ID@:" + odt.get_Translation("Name"));
        }
        this.setC_DocTypeTarget_ID(C_DocTypeTarget_ID);
        if (invoiceDate != null) {
            this.setDateInvoiced(invoiceDate);
        }
        this.setDateAcct(this.getDateInvoiced());
        this.setSalesRep_ID(order.getSalesRep_ID());
        this.setC_BPartner_ID(order.getBill_BPartner_ID());
        this.setC_BPartner_Location_ID(order.getBill_Location_ID());
        this.setAD_User_ID(order.getBill_User_ID());
    }

    public MInvoice(MInOut ship, Timestamp invoiceDate) {
        this(ship.getCtx(), 0, ship.get_TrxName());
        this.setClientOrg(ship);
        this.setShipment(ship);
        this.setC_DocTypeTarget_ID();
        if (invoiceDate != null) {
            this.setDateInvoiced(invoiceDate);
        }
        this.setDateAcct(this.getDateInvoiced());
        this.setSalesRep_ID(ship.getSalesRep_ID());
    }

    public MInvoice(MInvoiceBatch batch, MInvoiceBatchLine line) {
        this(line.getCtx(), 0, line.get_TrxName());
        this.setClientOrg(line);
        this.setDocumentNo(line.getDocumentNo());
        this.setIsSOTrx(batch.isSOTrx());
        MBPartner bp = new MBPartner(line.getCtx(), line.getC_BPartner_ID(), line.get_TrxName());
        this.setBPartner(bp);
        this.setIsTaxIncluded(line.isTaxIncluded());
        this.setC_Currency_ID(batch.getC_Currency_ID());
        this.setC_ConversionType_ID(batch.getC_ConversionType_ID());
        this.setDescription(batch.getDescription());
        this.setAD_OrgTrx_ID(line.getAD_OrgTrx_ID());
        this.setC_Project_ID(line.getC_Project_ID());
        this.setC_Activity_ID(line.getC_Activity_ID());
        this.setUser1_ID(line.getUser1_ID());
        this.setUser2_ID(line.getUser2_ID());
        this.setUser3_ID(line.getUser3_ID());
        this.setUser4_ID(line.getUser4_ID());
        this.setC_DocTypeTarget_ID(line.getC_DocType_ID());
        this.setDateInvoiced(line.getDateInvoiced());
        this.setDateAcct(line.getDateAcct());
        this.setSalesRep_ID(batch.getSalesRep_ID());
        this.setC_BPartner_ID(line.getC_BPartner_ID());
        this.setC_BPartner_Location_ID(line.getC_BPartner_Location_ID());
        this.setAD_User_ID(line.getAD_User_ID());
    }

    @Override
    public void setClientOrg(int AD_Client_ID, int AD_Org_ID) {
        super.setClientOrg(AD_Client_ID, AD_Org_ID);
    }

    public void setBPartner(MBPartner bp) {
        MUser[] contacts;
        MBPartnerLocation[] locs;
        String ss;
        if (bp == null) {
            return;
        }
        this.setC_BPartner_ID(bp.getC_BPartner_ID());
        int ii = 0;
        ii = this.isSOTrx() ? bp.getC_PaymentTerm_ID() : bp.getPO_PaymentTerm_ID();
        if (ii != 0) {
            this.setC_PaymentTerm_ID(ii);
        }
        if ((ii = this.isSOTrx() ? bp.getM_PriceList_ID() : bp.getPO_PriceList_ID()) != 0) {
            this.setM_PriceList_ID(ii);
        }
        if ((ss = bp.getPaymentRule()) != null) {
            this.setPaymentRule(ss);
        }
        if ((locs = bp.getLocations(false)) != null) {
            for (int i = 0; i < locs.length; ++i) {
                if ((!locs[i].isBillTo() || !this.isSOTrx()) && (!locs[i].isPayFrom() || this.isSOTrx())) continue;
                this.setC_BPartner_Location_ID(locs[i].getC_BPartner_Location_ID());
            }
            if (this.getC_BPartner_Location_ID() == 0 && locs.length > 0) {
                this.setC_BPartner_Location_ID(locs[0].getC_BPartner_Location_ID());
            }
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.log.log(Level.SEVERE, new BPartnerNoAddressException(bp).getLocalizedMessage());
        }
        if ((contacts = bp.getContacts(false)) != null && contacts.length > 0) {
            this.setAD_User_ID(contacts[0].getAD_User_ID());
        }
    }

    public void setOrder(MOrder order) {
        if (order == null) {
            return;
        }
        this.setC_Order_ID(order.getC_Order_ID());
        this.setIsSOTrx(order.isSOTrx());
        this.setIsDiscountPrinted(order.isDiscountPrinted());
        this.setIsSelfService(order.isSelfService());
        this.setSendEMail(order.isSendEMail());
        this.setM_PriceList_ID(order.getM_PriceList_ID());
        this.setIsTaxIncluded(order.isTaxIncluded());
        int c_currency_id = order.getC_Currency_ID();
        int c_currency_id_to = order.get_ValueAsInt("C_Currency_ID_To");
        if (c_currency_id_to > 0 && c_currency_id != c_currency_id_to) {
            MCurrency mCurrency_to = new MCurrency(this.getCtx(), c_currency_id_to, this.get_TrxName());
            this.setC_Currency_ID(c_currency_id_to);
            try {
                this.setM_PriceList_ID(MPriceList.getDefault(this.getCtx(), true, mCurrency_to.getISO_Code()).get_ID());
            }
            catch (Exception e) {
                throw new AdempiereException("Lista de Precios por defecto para " + mCurrency_to.getISO_Code() + " no encontrada", e);
            }
        } else {
            this.setC_Currency_ID(order.getC_Currency_ID());
            this.setM_PriceList_ID(order.getM_PriceList_ID());
        }
        this.setC_ConversionType_ID(order.getC_ConversionType_ID());
        this.setPaymentRule(order.getPaymentRule());
        this.setC_PaymentTerm_ID(order.getC_PaymentTerm_ID());
        this.setPOReference(order.getPOReference());
        this.setDescription(order.getDescription());
        this.setDateOrdered(order.getDateOrdered());
        this.setAD_OrgTrx_ID(order.getAD_OrgTrx_ID());
        this.setC_Project_ID(order.getC_Project_ID());
        this.setC_Campaign_ID(order.getC_Campaign_ID());
        this.setC_Activity_ID(order.getC_Activity_ID());
        this.setUser1_ID(order.getUser1_ID());
        this.setUser2_ID(order.getUser2_ID());
        this.setUser3_ID(order.getUser3_ID());
        this.setUser4_ID(order.getUser4_ID());
    }

    public void setShipment(MInOut ship) {
        MDocType dt;
        if (ship == null) {
            return;
        }
        this.setIsSOTrx(ship.isSOTrx());
        MBPartner bp = new MBPartner(this.getCtx(), ship.getC_BPartner_ID(), null);
        this.setBPartner(bp);
        this.setAD_User_ID(ship.getAD_User_ID());
        this.setSendEMail(ship.isSendEMail());
        this.setPOReference(ship.getPOReference());
        this.setDescription(ship.getDescription());
        this.setDateOrdered(ship.getDateOrdered());
        this.setAD_OrgTrx_ID(ship.getAD_OrgTrx_ID());
        this.setC_Project_ID(ship.getC_Project_ID());
        this.setC_Campaign_ID(ship.getC_Campaign_ID());
        this.setC_Activity_ID(ship.getC_Activity_ID());
        this.setUser1_ID(ship.getUser1_ID());
        this.setUser2_ID(ship.getUser2_ID());
        this.setUser3_ID(ship.getUser3_ID());
        this.setUser4_ID(ship.getUser4_ID());
        if (ship.getC_Order_ID() != 0) {
            this.setC_Order_ID(ship.getC_Order_ID());
            MOrder order = new MOrder(this.getCtx(), ship.getC_Order_ID(), this.get_TrxName());
            this.setIsDiscountPrinted(order.isDiscountPrinted());
            this.setM_PriceList_ID(order.getM_PriceList_ID());
            this.setIsTaxIncluded(order.isTaxIncluded());
            this.setC_Currency_ID(order.getC_Currency_ID());
            this.setC_ConversionType_ID(order.getC_ConversionType_ID());
            this.setPaymentRule(order.getPaymentRule());
            this.setC_PaymentTerm_ID(order.getC_PaymentTerm_ID());
            dt = MDocType.get(this.getCtx(), order.getC_DocType_ID());
            if (dt.getC_DocTypeInvoice_ID() != 0) {
                this.setC_DocTypeTarget_ID(dt.getC_DocTypeInvoice_ID());
            }
            this.setC_BPartner_ID(order.getBill_BPartner_ID());
            this.setC_BPartner_Location_ID(order.getBill_Location_ID());
            this.setAD_User_ID(order.getBill_User_ID());
        }
        if (ship.getM_RMA_ID() != 0) {
            this.setM_RMA_ID(ship.getM_RMA_ID());
            MRMA rma = new MRMA(this.getCtx(), ship.getM_RMA_ID(), this.get_TrxName());
            dt = MDocType.get(this.getCtx(), rma.getC_DocType_ID());
            if (dt.getC_DocTypeInvoice_ID() != 0) {
                this.setC_DocTypeTarget_ID(dt.getC_DocTypeInvoice_ID());
            }
            this.setIsSOTrx(rma.isSOTrx());
            MOrder rmaOrder = rma.getOriginalOrder();
            if (rmaOrder != null) {
                this.setM_PriceList_ID(rmaOrder.getM_PriceList_ID());
                this.setIsTaxIncluded(rmaOrder.isTaxIncluded());
                this.setC_Currency_ID(rmaOrder.getC_Currency_ID());
                this.setC_ConversionType_ID(rmaOrder.getC_ConversionType_ID());
                this.setPaymentRule(rmaOrder.getPaymentRule());
                this.setC_PaymentTerm_ID(rmaOrder.getC_PaymentTerm_ID());
                this.setC_BPartner_Location_ID(rmaOrder.getBill_Location_ID());
            }
        }
    }

    public void setC_DocTypeTarget_ID(String DocBaseType) {
        String sql = "SELECT C_DocType_ID FROM C_DocType WHERE AD_Client_ID=? AND AD_Org_ID in (0,?) AND DocBaseType=? AND IsActive='Y' ORDER BY IsDefault DESC, AD_Org_ID DESC";
        int C_DocType_ID = DB.getSQLValueEx(null, sql, this.getAD_Client_ID(), this.getAD_Org_ID(), DocBaseType);
        if (C_DocType_ID <= 0) {
            this.log.log(Level.SEVERE, "Not found for AD_Client_ID=" + this.getAD_Client_ID() + " - " + DocBaseType);
        } else {
            this.log.fine(DocBaseType);
            this.setC_DocTypeTarget_ID(C_DocType_ID);
            boolean isSOTrx = "ARI".equals(DocBaseType) || "ARC".equals(DocBaseType);
            this.setIsSOTrx(isSOTrx);
        }
    }

    public void setC_DocTypeTarget_ID() {
        if (this.getC_DocTypeTarget_ID() > 0) {
            return;
        }
        if (this.isSOTrx()) {
            this.setC_DocTypeTarget_ID("ARI");
        } else {
            this.setC_DocTypeTarget_ID("API");
        }
    }

    public BigDecimal getGrandTotal(boolean creditMemoAdjusted) {
        if (!creditMemoAdjusted) {
            return super.getGrandTotal();
        }
        BigDecimal amt = this.getGrandTotal();
        if (this.isCreditMemo()) {
            return amt.negate();
        }
        return amt;
    }

    private MInvoiceLine[] getLines(String whereClause) {
        Object whereClauseFinal = "C_Invoice_ID=? ";
        if (whereClause != null) {
            whereClauseFinal = (String)whereClauseFinal + whereClause;
        }
        List<MInvoiceLine> list = new Query(this.getCtx(), "C_InvoiceLine", (String)whereClauseFinal, this.get_TrxName()).setParameters(this.getC_Invoice_ID()).setOrderBy("Line").list();
        return list.toArray(new MInvoiceLine[list.size()]);
    }

    public MInvoiceLine[] getLines(boolean requery) {
        if (this.InvoiceLines == null || this.InvoiceLines.length == 0 || requery) {
            this.InvoiceLines = this.getLines(null);
        }
        MInvoice.set_TrxName(this.InvoiceLines, this.get_TrxName());
        return this.InvoiceLines;
    }

    public MInvoiceLine[] getLines() {
        return this.getLines(false);
    }

    public void renumberLines(int step) {
        int number = step;
        MInvoiceLine[] lines = this.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MInvoiceLine line = lines[i];
            line.setLine(number);
            line.saveEx();
            number += step;
        }
        this.InvoiceLines = null;
    }

    public int copyLinesFrom(MInvoice invoiceFrom, boolean counter, boolean setOrder) {
        if (this.isProcessed() || this.isPosted() || invoiceFrom == null) {
            return 0;
        }
        List<MInvoiceLine> fromLines = Arrays.asList(invoiceFrom.getLines(false));
        AtomicInteger count = new AtomicInteger();
        fromLines.stream().forEach(invoiceLineFrom -> {
            MInvoiceLine invoiceLineTo = new MInvoiceLine(this.getCtx(), 0, this.get_TrxName());
            if (counter) {
                PO.copyValues(invoiceLineFrom, invoiceLineTo, this.getAD_Client_ID(), this.getAD_Org_ID());
            } else {
                PO.copyValues(invoiceLineFrom, invoiceLineTo, invoiceLineFrom.getAD_Client_ID(), invoiceLineFrom.getAD_Org_ID());
            }
            invoiceLineTo.setC_Invoice_ID(this.getC_Invoice_ID());
            invoiceLineTo.setInvoice(this);
            invoiceLineTo.set_ValueNoCheck("C_InvoiceLine_ID", I_ZERO);
            invoiceLineTo.set_ValueOfColumn("S_ContractLine_ID", invoiceLineFrom.get_Value("S_ContractLine_ID"));
            invoiceLineTo.set_ValueOfColumn("S_TimeExpenseLine_ID", invoiceLineFrom.get_Value("S_TimeExpenseLine_ID"));
            if (!setOrder) {
                invoiceLineTo.setC_OrderLine_ID(0);
            }
            invoiceLineTo.setRef_InvoiceLine_ID(0);
            invoiceLineTo.setM_InOutLine_ID(0);
            invoiceLineTo.setA_Asset_ID(0);
            invoiceLineTo.setM_AttributeSetInstance_ID(0);
            invoiceLineTo.setS_ResourceAssignment_ID(0);
            if (this.getC_BPartner_ID() != invoiceFrom.getC_BPartner_ID()) {
                invoiceLineTo.setTax();
            }
            if (counter) {
                PO peer;
                invoiceLineTo.setRef_InvoiceLine_ID(invoiceLineFrom.getC_InvoiceLine_ID());
                if (invoiceLineFrom.getC_OrderLine_ID() != 0 && ((X_C_OrderLine)(peer = new MOrderLine(this.getCtx(), invoiceLineFrom.getC_OrderLine_ID(), this.get_TrxName()))).getRef_OrderLine_ID() != 0) {
                    invoiceLineTo.setC_OrderLine_ID(((X_C_OrderLine)peer).getRef_OrderLine_ID());
                }
                invoiceLineTo.setM_InOutLine_ID(0);
                if (invoiceLineFrom.getM_InOutLine_ID() != 0 && ((X_M_InOutLine)(peer = new MInOutLine(this.getCtx(), invoiceLineFrom.getM_InOutLine_ID(), this.get_TrxName()))).getRef_InOutLine_ID() != 0) {
                    invoiceLineTo.setM_InOutLine_ID(((X_M_InOutLine)peer).getRef_InOutLine_ID());
                }
            }
            invoiceLineTo.setProcessed(false);
            if (invoiceLineTo.save(this.get_TrxName())) {
                count.updateAndGet(no -> no + 1);
            }
            if (counter) {
                invoiceLineFrom.setRef_InvoiceLine_ID(invoiceLineTo.getC_InvoiceLine_ID());
                invoiceLineFrom.save(this.get_TrxName());
                invoiceLineTo.setUser1_ID(invoiceLineFrom.getUser3_ID());
                invoiceLineTo.setUser3_ID(invoiceLineFrom.getUser1_ID());
                invoiceLineTo.save(this.get_TrxName());
            }
            invoiceLineTo.copyLandedCostFrom((MInvoiceLine)invoiceLineFrom);
            invoiceLineTo.allocateLandedCosts();
            if (invoiceFrom.isReversal()) {
                invoiceLineTo.setReversalLine_ID(invoiceLineFrom.get_ID());
                invoiceLineTo.saveEx();
                invoiceLineFrom.setReversalLine_ID(invoiceLineTo.get_ID());
                invoiceLineFrom.saveEx();
            }
        });
        if (fromLines.size() != count.get()) {
            this.log.log(Level.SEVERE, "Line difference - From=" + fromLines.size() + " <> Saved=" + count);
        }
        return count.get();
    }

    @Override
    public void setReversal(boolean isReversal) {
        this.isReversal = isReversal;
    }

    @Override
    public boolean isReversal() {
        return this.isReversal;
    }

    public MInvoiceTax[] getTaxes(boolean requery) {
        if (this.invoiceTaxes != null && !requery) {
            return this.invoiceTaxes;
        }
        String whereClause = "C_Invoice_ID=?";
        List<MInvoiceTax> list = new Query(this.getCtx(), "C_InvoiceTax", "C_Invoice_ID=?", this.get_TrxName()).setParameters(this.get_ID()).list();
        this.invoiceTaxes = list.toArray(new MInvoiceTax[list.size()]);
        return this.invoiceTaxes;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    public boolean isCreditMemo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID() == 0 ? this.getC_DocTypeTarget_ID() : this.getC_DocType_ID());
        return "APC".equals(dt.getDocBaseType()) || "ARC".equals(dt.getDocBaseType()) || dt.getDocBaseType().equals("DPC") || dt.getDocBaseType().equals("DRC");
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String set = "SET Processed='" + (processed ? "Y" : "N") + "' WHERE C_Invoice_ID=" + this.getC_Invoice_ID();
        int noLine = DB.executeUpdate("UPDATE C_InvoiceLine " + set, this.get_TrxName());
        int noTax = DB.executeUpdate("UPDATE C_InvoiceTax " + set, this.get_TrxName());
        this.InvoiceLines = null;
        this.invoiceTaxes = null;
        this.log.fine(processed + " - Lines=" + noLine + ", Tax=" + noTax);
    }

    public boolean validatePaySchedule() {
        MInvoicePaySchedule[] schedule = MInvoicePaySchedule.getInvoicePaySchedule(this.getCtx(), this.getC_Invoice_ID(), 0, this.get_TrxName());
        this.log.fine("#" + schedule.length);
        if (schedule.length == 0) {
            this.setIsPayScheduleValid(false);
            return false;
        }
        BigDecimal total = Env.ZERO;
        for (int i = 0; i < schedule.length; ++i) {
            schedule[i].setParent(this);
            BigDecimal due = schedule[i].getDueAmt();
            if (due == null) continue;
            total = total.add(due);
        }
        boolean valid = this.getGrandTotal().compareTo(total) == 0;
        this.setIsPayScheduleValid(valid);
        for (int i = 0; i < schedule.length; ++i) {
            if (schedule[i].isValid() == valid) continue;
            schedule[i].setIsValid(valid);
            schedule[i].saveEx(this.get_TrxName());
        }
        return valid;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        int ii;
        String sql;
        this.log.fine("");
        if (this.getC_BPartner_ID() == 0) {
            this.setBPartner(MBPartner.getTemplate(this.getCtx(), this.getAD_Client_ID()));
        }
        if (this.getC_BPartner_Location_ID() == 0) {
            this.setBPartner(new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName()));
        }
        if (this.getM_PriceList_ID() == 0) {
            int ii2 = Env.getContextAsInt(this.getCtx(), "#M_PriceList_ID");
            if (ii2 != 0) {
                this.setM_PriceList_ID(ii2);
            } else {
                sql = "SELECT M_PriceList_ID FROM M_PriceList WHERE AD_Client_ID=? AND IsDefault='Y'";
                ii2 = DB.getSQLValue(null, sql, this.getAD_Client_ID());
                if (ii2 != 0) {
                    this.setM_PriceList_ID(ii2);
                }
            }
        }
        if (this.getC_Currency_ID() == 0) {
            String sql2 = "SELECT C_Currency_ID FROM M_PriceList WHERE M_PriceList_ID=?";
            int ii3 = DB.getSQLValue(null, sql2, this.getM_PriceList_ID());
            if (ii3 != 0) {
                this.setC_Currency_ID(ii3);
            } else {
                this.setC_Currency_ID(Env.getContextAsInt(this.getCtx(), "#C_Currency_ID"));
            }
        }
        if (this.getSalesRep_ID() == 0 && (ii = Env.getContextAsInt(this.getCtx(), "#SalesRep_ID")) != 0) {
            this.setSalesRep_ID(ii);
        }
        if (this.getC_DocType_ID() == 0) {
            this.setC_DocType_ID(0);
        }
        if (this.getC_DocTypeTarget_ID() == 0) {
            this.setC_DocTypeTarget_ID(this.isSOTrx() ? "ARI" : "API");
        }
        if (this.getC_PaymentTerm_ID() == 0) {
            ii = Env.getContextAsInt(this.getCtx(), "#C_PaymentTerm_ID");
            if (ii != 0) {
                this.setC_PaymentTerm_ID(ii);
            } else {
                sql = "SELECT C_PaymentTerm_ID FROM C_PaymentTerm WHERE AD_Client_ID=? AND IsDefault='Y'";
                ii = DB.getSQLValue(null, sql, this.getAD_Client_ID());
                if (ii != 0) {
                    this.setC_PaymentTerm_ID(ii);
                }
            }
        }
        if (this.getDocumentNo() == null) {
            this.setDocumentNo("");
        }
        return true;
    }

    @Override
    protected boolean beforeDelete() {
        if (this.getC_Order_ID() != 0) {
            this.log.saveError("Error", Msg.getMsg(this.getCtx(), "CannotDelete"));
            return false;
        }
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MInvoice[").append(this.get_ID()).append("-").append(this.getDocumentNo()).append(",GrandTotal=").append(this.getGrandTotal());
        if (this.InvoiceLines != null) {
            sb.append(" (#").append(this.InvoiceLines.length).append(")");
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getDocumentInfo() {
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        return dt.getName() + " " + this.getDocumentNo();
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (!success || newRecord) {
            return success;
        }
        if (this.is_ValueChanged("AD_Org_ID")) {
            String sql = "UPDATE C_InvoiceLine ol SET AD_Org_ID =(SELECT AD_Org_ID FROM C_Invoice o WHERE ol.C_Invoice_ID=o.C_Invoice_ID) WHERE C_Invoice_ID=" + this.getC_Invoice_ID();
            int no = DB.executeUpdate(sql, this.get_TrxName());
            this.log.fine("Lines -> #" + no);
        }
        return true;
    }

    @Override
    public void setM_PriceList_ID(int M_PriceList_ID) {
        MPriceList pl = MPriceList.get(this.getCtx(), M_PriceList_ID, null);
        if (pl != null) {
            this.setC_Currency_ID(pl.getC_Currency_ID());
            super.setM_PriceList_ID(M_PriceList_ID);
        }
    }

    public BigDecimal getAllocatedAmt() {
        BigDecimal retValue = null;
        String sql = "SELECT coalesce(SUM(currencyConvert(al.Amount+al.DiscountAmt+al.WriteOffAmt,ah.C_Currency_ID, i.C_Currency_ID,ah.DateTrx,\nCOALESCE(p.C_ConversionType_ID, i.C_ConversionType_ID,0), al.AD_Client_ID,al.AD_Org_ID)),0) +\n(SELECT coalesce(SUM(currencyconvert_receipt (al.Amount+al.DiscountAmt+al.WriteOffAmt,ah.currencyrate,ah.c_currency_id,i.c_currency_id, al.ad_client_id,al.ad_org_id)),0)\nFROM C_AllocationLine al\nINNER JOIN C_AllocationHdr ah ON (al.C_AllocationHdr_ID=ah.C_AllocationHdr_ID)\nINNER JOIN C_Invoice i ON (al.C_Invoice_ID=i.C_Invoice_ID) \nLEFT JOIN C_Payment p ON (al.C_Payment_ID=p.C_Payment_ID) \nWHERE al.C_Invoice_ID=?\nAND ah.IsActive='Y' AND al.IsActive='Y'\nAND ah.IsMultiCurrency = 'Y')\nFROM C_AllocationLine al\nINNER JOIN C_AllocationHdr ah ON (al.C_AllocationHdr_ID=ah.C_AllocationHdr_ID)\nINNER JOIN C_Invoice i ON (al.C_Invoice_ID=i.C_Invoice_ID) \nLEFT JOIN C_Payment p ON (al.C_Payment_ID=p.C_Payment_ID) \nWHERE al.C_Invoice_ID=?\nAND ah.IsActive='Y' AND al.IsActive='Y'\nAND ah.IsMultiCurrency = 'N'";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, this.get_TrxName());
            pstmt.setInt(1, this.getC_Invoice_ID());
            pstmt.setInt(2, this.getC_Invoice_ID());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                retValue = rs.getBigDecimal(1);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql);
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        return retValue;
    }

    public boolean testAllocation() {
        boolean change = false;
        if (this.isProcessed()) {
            BigDecimal alloc = this.getAllocatedAmt();
            if (alloc == null) {
                alloc = Env.ZERO;
            }
            BigDecimal total = this.getGrandTotal();
            if (!this.isSOTrx()) {
                total = total.negate();
            }
            if (this.isCreditMemo()) {
                total = total.negate();
            }
            boolean test = total.compareTo(alloc) == 0;
            boolean bl = change = test != this.isPaid();
            if (change) {
                this.setIsPaid(test);
            }
            this.log.fine("Paid=" + test + " (" + alloc + "=" + total + ")");
        }
        return change;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setIsPaid(Properties ctx, int C_BPartner_ID, String trxName) {
        ArrayList<Object> params = new ArrayList<Object>();
        StringBuffer whereClause = new StringBuffer("IsPaid='N' AND DocStatus IN ('CO','CL')");
        if (C_BPartner_ID > 1) {
            whereClause.append(" AND C_BPartner_ID=?");
            params.add(C_BPartner_ID);
        } else {
            whereClause.append(" AND AD_Client_ID=?");
            params.add(Env.getAD_Client_ID(ctx));
        }
        POResultSet rs = new Query(ctx, "C_Invoice", whereClause.toString(), trxName).setParameters(params).scroll();
        int counter = 0;
        try {
            while (rs.hasNext()) {
                MInvoice invoice = (MInvoice)rs.next();
                if (!invoice.testAllocation() || !invoice.save()) continue;
                ++counter;
            }
        }
        finally {
            DB.close(rs);
        }
        s_log.config("#" + counter);
    }

    public BigDecimal getOpenAmt() {
        return this.getOpenAmt(true, null);
    }

    public BigDecimal getOpenAmt(boolean creditMemoAdjusted, Timestamp paymentDate) {
        if (this.isPaid()) {
            return Env.ZERO;
        }
        if (this.openAmount == null) {
            BigDecimal allocated;
            this.openAmount = this.getGrandTotal();
            if (paymentDate != null) {
                // empty if block
            }
            if ((allocated = this.getAllocatedAmt()) != null) {
                allocated = allocated.abs();
                this.openAmount = this.openAmount.subtract(allocated);
            }
        }
        if (!creditMemoAdjusted) {
            return this.openAmount;
        }
        if (this.isCreditMemo()) {
            return this.openAmount.negate();
        }
        return this.openAmount;
    }

    public String getDocStatusName() {
        return MRefList.getListName(this.getCtx(), 131, this.getDocStatus());
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        ReportEngine re = ReportEngine.get(this.getCtx(), 2, this.getC_Invoice_ID(), this.get_TrxName());
        if (re == null) {
            return null;
        }
        return re.getPDF(file);
    }

    public String getPDFFileName(String documentDir) {
        return MInvoice.getPDFFileName(documentDir, this.getC_Invoice_ID());
    }

    public String getCurrencyISO() {
        return MCurrency.getISO_Code(this.getCtx(), this.getC_Currency_ID());
    }

    public int getPrecision() {
        return MCurrency.getStdPrecision(this.getCtx(), this.getC_Currency_ID());
    }

    @Override
    public boolean processIt(String processAction) {
        this.processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        MBPartner bp;
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getDateAcct(), this.getC_DocTypeTarget_ID(), this.getAD_Org_ID());
        MInvoiceLine[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.processMsg = "@NoLines@";
            return "IN";
        }
        if ("B".equals(this.getPaymentRule()) && MCashBook.get(this.getCtx(), this.getAD_Org_ID(), this.getC_Currency_ID()) == null) {
            this.processMsg = "@NoCashBook@";
            return "IN";
        }
        if (this.getC_DocType_ID() != this.getC_DocTypeTarget_ID()) {
            this.setC_DocType_ID(this.getC_DocTypeTarget_ID());
        }
        if (this.getC_DocType_ID() == 0) {
            this.processMsg = "No Document Type";
            return "IN";
        }
        this.explodeBOM();
        if (!this.calculateTaxTotal()) {
            this.processMsg = "Error calculating Tax";
            return "IN";
        }
        MDocType doc = (MDocType)this.getC_DocTypeTarget();
        if (!doc.getDocBaseType().equalsIgnoreCase("DRI") && !doc.getDocBaseType().equalsIgnoreCase("DPI")) {
            this.createPaySchedule();
        }
        if (this.isSOTrx() && !this.isReversal() && "S".equals((bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), null)).getSOCreditStatus())) {
            this.processMsg = "@BPartnerCreditStop@ - @TotalOpenBalance@=" + bp.getTotalOpenBalance() + ", @SO_CreditLimit@=" + bp.getSO_CreditLimit();
            return "IN";
        }
        if (!this.isSOTrx()) {
            for (int i = 0; i < lines.length; ++i) {
                MInvoiceLine line = lines[i];
                String error = line.allocateLandedCosts();
                if (error == null || error.length() <= 0) continue;
                this.processMsg = error;
                return "IN";
            }
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.processMsg != null) {
            return "IN";
        }
        this.justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    private void explodeBOM() {
        String where = "AND IsActive='Y' AND EXISTS (SELECT * FROM M_Product p WHERE C_InvoiceLine.M_Product_ID=p.M_Product_ID AND\tp.IsBOM='Y' AND p.IsVerified='Y' AND p.IsStocked='N')";
        String sql = "SELECT COUNT(*) FROM C_InvoiceLine WHERE C_Invoice_ID=? " + where;
        int count = DB.getSQLValueEx(this.get_TrxName(), sql, this.getC_Invoice_ID());
        while (count != 0) {
            this.renumberLines(100);
            MInvoiceLine[] lines = this.getLines(where);
            for (int i = 0; i < lines.length; ++i) {
                MInvoiceLine line = lines[i];
                MProduct product = MProduct.get(this.getCtx(), line.getM_Product_ID());
                this.log.fine(product.getName());
                int lineNo = line.getLine();
                MPPProductBOM bom = MPPProductBOM.get(product, this.getAD_Org_ID(), this.getDateInvoiced(), this.get_TrxName());
                if (bom != null) {
                    MPPProductBOMLine[] bomlines = bom.getLines(this.getDateInvoiced());
                    for (int j = 0; j < bomlines.length; ++j) {
                        MPPProductBOMLine bomline = bomlines[j];
                        MInvoiceLine newLine = new MInvoiceLine(this);
                        newLine.setLine(++lineNo);
                        newLine.setM_Product_ID(bomline.getM_Product_ID());
                        newLine.setC_UOM_ID(bomline.getC_UOM_ID());
                        newLine.setQty(line.getQtyInvoiced().multiply(bomline.getQtyBOM()));
                        if (bomline.getDescription() != null) {
                            newLine.setDescription(bomline.getDescription());
                        }
                        newLine.setPrice();
                        newLine.saveEx(this.get_TrxName());
                    }
                }
                line.setM_Product_ID(0);
                line.setM_AttributeSetInstance_ID(0);
                line.setPriceEntered(Env.ZERO);
                line.setPriceActual(Env.ZERO);
                line.setPriceLimit(Env.ZERO);
                line.setPriceList(Env.ZERO);
                line.setLineNetAmt(Env.ZERO);
                Object description = product.getName();
                if (product.getDescription() != null) {
                    description = (String)description + " " + product.getDescription();
                }
                if (line.getDescription() != null) {
                    description = (String)description + " " + line.getDescription();
                }
                line.setDescription((String)description);
                line.saveEx(this.get_TrxName());
            }
            this.InvoiceLines = null;
            count = DB.getSQLValue(this.get_TrxName(), sql, this.getC_Invoice_ID());
            this.renumberLines(10);
        }
    }

    public boolean calculateTaxTotal() {
        this.log.fine("");
        DB.executeUpdateEx("DELETE C_InvoiceTax WHERE C_Invoice_ID=" + this.getC_Invoice_ID(), this.get_TrxName());
        this.invoiceTaxes = null;
        BigDecimal totalLines = Env.ZERO;
        ArrayList<Integer> taxList = new ArrayList<Integer>();
        MInvoiceLine[] lines = this.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MInvoiceTax iTax;
            MInvoiceLine line = lines[i];
            if (!taxList.contains(line.getC_Tax_ID()) && (iTax = MInvoiceTax.get(line, this.getPrecision(), false, this.get_TrxName())) != null) {
                iTax.setIsTaxIncluded(this.isTaxIncluded());
                if (!iTax.calculateTaxFromLines()) {
                    return false;
                }
                iTax.saveEx();
                taxList.add(line.getC_Tax_ID());
            }
            totalLines = totalLines.add(line.getLineNetAmt());
        }
        BigDecimal grandTotal = totalLines;
        MInvoiceTax[] taxes = this.getTaxes(true);
        for (int i = 0; i < taxes.length; ++i) {
            MInvoiceTax iTax = taxes[i];
            MTax tax = iTax.getTax();
            if (tax.isSummary()) {
                MTax[] cTaxes = tax.getChildTaxes(false);
                for (int j = 0; j < cTaxes.length; ++j) {
                    MTax cTax = cTaxes[j];
                    BigDecimal taxAmt = cTax.calculateTax(iTax.getTaxBaseAmt(), this.isTaxIncluded(), this.getPrecision());
                    MInvoiceTax newITax = new MInvoiceTax(this.getCtx(), 0, this.get_TrxName());
                    newITax.setClientOrg(this);
                    newITax.setC_Invoice_ID(this.getC_Invoice_ID());
                    newITax.setC_Tax_ID(cTax.getC_Tax_ID());
                    newITax.setPrecision(this.getPrecision());
                    newITax.setIsTaxIncluded(this.isTaxIncluded());
                    newITax.setTaxBaseAmt(iTax.getTaxBaseAmt());
                    newITax.setTaxAmt(taxAmt);
                    newITax.saveEx(this.get_TrxName());
                    if (this.isTaxIncluded()) continue;
                    grandTotal = grandTotal.add(taxAmt);
                }
                iTax.deleteEx(true, this.get_TrxName());
                continue;
            }
            grandTotal = grandTotal.add(iTax.getTaxAmt());
        }
        this.setTotalLines(totalLines);
        this.setGrandTotal(grandTotal);
        return true;
    }

    private boolean createPaySchedule() {
        if (this.getC_PaymentTerm_ID() == 0) {
            return false;
        }
        MPaymentTerm pt = new MPaymentTerm(this.getCtx(), this.getC_PaymentTerm_ID(), null);
        this.log.fine(pt.toString());
        return pt.apply(this);
    }

    @Override
    public boolean approveIt() {
        this.log.info(this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info(this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        if (!this.justPrepared) {
            String status = this.prepareIt();
            this.justPrepared = false;
            if (!"IP".equals(status)) {
                return status;
            }
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info(this.toString());
        StringBuffer info = new StringBuffer();
        boolean fromPOS = false;
        if (this.getC_Order_ID() > 0) {
            boolean bl = fromPOS = this.getC_Order().getC_POS_ID() > 0;
        }
        if ("B".equals(this.getPaymentRule()) && !fromPOS) {
            MCash cash;
            if (MSysConfig.getBooleanValue("CASH_AS_PAYMENT", true, this.getAD_Client_ID())) {
                info.append(this.payWithCashAsPayment());
            } else {
                info.append(this.payWithCash());
            }
            int posId = Env.getContextAsInt(this.getCtx(), "#POS_ID");
            if (posId != 0) {
                MPOS pos = new MPOS(this.getCtx(), posId, this.get_TrxName());
                int cashBookId = pos.getC_CashBook_ID();
                cash = MCash.get(this.getCtx(), cashBookId, this.getDateInvoiced(), this.get_TrxName());
            } else {
                cash = MCash.get(this.getCtx(), this.getAD_Org_ID(), this.getDateInvoiced(), this.getC_Currency_ID(), this.get_TrxName());
            }
            if (cash == null || cash.get_ID() == 0) {
                this.processMsg = "@NoCashBook@";
                return "IN";
            }
            MCashLine cl = new MCashLine(cash);
            cl.setInvoice(this);
            if (!cl.save(this.get_TrxName())) {
                this.processMsg = "Could not save Cash Journal Line";
                return "IN";
            }
            info.append("@C_Cash_ID@: " + cash.getName() + " #" + cl.getLine());
            this.setC_CashLine_ID(cl.getC_CashLine_ID());
        }
        AtomicInteger matchInvoices = new AtomicInteger(0);
        AtomicInteger matchOrders = new AtomicInteger(0);
        String docBaseType = this.getC_DocType().getDocBaseType();
        Arrays.stream(this.getLines(false)).filter(invoiceLine -> invoiceLine != null).forEach(invoiceLine -> {
            BigDecimal multiplier;
            if (invoiceLine.getM_InOutLine_ID() != 0 && invoiceLine.getM_Product_ID() != 0 && !this.isReversal()) {
                MInOutLine receiptLine = new MInOutLine(this.getCtx(), invoiceLine.getM_InOutLine_ID(), this.get_TrxName());
                BigDecimal matchQty = invoiceLine.getQtyInvoiced();
                if (receiptLine.getMovementQty().compareTo(matchQty) < 0) {
                    matchQty = receiptLine.getMovementQty();
                }
                MMatchInv matchInvoice2 = new MMatchInv((MInvoiceLine)invoiceLine, this.getDateInvoiced(), matchQty);
                matchInvoice2.setDateAcct(this.getDateAcct());
                if (matchInvoice2.getM_InOutLine_ID() > 0) {
                    MInOutLine ioLine = new MInOutLine(this.getCtx(), matchInvoice2.getM_InOutLine_ID(), this.get_TrxName());
                    MInOut inout = new MInOut(this.getCtx(), ioLine.getM_InOut_ID(), this.get_TrxName());
                    matchInvoice2.set_Value("S_Contract_ID", inout.get_Value("S_Contract_ID"));
                }
                matchInvoice2.saveEx();
                matchInvoices.getAndUpdate(record -> record + 1);
                this.addDocsPostProcess(matchInvoice2);
            }
            MOrderLine orderLine = null;
            BigDecimal bigDecimal = multiplier = this.getC_DocTypeTarget().getDocBaseType().contains("C") ? Env.ONE.negate() : Env.ONE;
            if (invoiceLine.getC_OrderLine_ID() != 0) {
                if (this.isSOTrx() || invoiceLine.getM_Product_ID() == 0) {
                    BigDecimal qtyInvoiced = invoiceLine.getQtyInvoiced().multiply(multiplier);
                    orderLine = (MOrderLine)invoiceLine.getC_OrderLine();
                    orderLine.setQtyInvoiced(orderLine.getQtyInvoiced().add(qtyInvoiced));
                    orderLine.saveEx();
                } else if (!this.isSOTrx() && invoiceLine.getM_Product_ID() != 0 && !this.isReversal()) {
                    BigDecimal matchQty = invoiceLine.getQtyInvoiced();
                    MMatchPO matchPO = new MMatchPO((MInvoiceLine)invoiceLine, this.getDateInvoiced(), matchQty.multiply(multiplier));
                    matchPO.saveEx();
                    matchOrders.getAndUpdate(record -> record + 1);
                    if (!matchPO.isPosted() && matchPO.getM_InOutLine_ID() > 0) {
                        this.addDocsPostProcess(matchPO);
                    }
                    Arrays.stream(MMatchInv.getInvoiceLine(this.getCtx(), invoiceLine.getC_InvoiceLine_ID(), this.get_TrxName())).filter(matchInvoice -> matchInvoice != null && !matchInvoice.isPosted()).forEach(matchInvoice -> this.addDocsPostProcess((PO)matchInvoice));
                }
            }
            if (invoiceLine.getM_RMALine_ID() != 0) {
                MRMALine rmaLine = new MRMALine(this.getCtx(), invoiceLine.getM_RMALine_ID(), this.get_TrxName());
                if (rmaLine.getQtyInvoiced() != null) {
                    rmaLine.setQtyInvoiced(rmaLine.getQtyInvoiced().add(invoiceLine.getQtyInvoiced()));
                } else {
                    rmaLine.setQtyInvoiced(invoiceLine.getQtyInvoiced());
                }
                rmaLine.saveEx();
            }
        });
        if (matchInvoices.get() > 0) {
            info.append(" @M_MatchInv_ID@#").append(matchInvoices.get()).append(" ");
        }
        if (matchOrders.get() > 0) {
            info.append(" @M_MatchPO_ID@#").append(matchOrders.get()).append(" ");
        }
        MBPartner partner = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        BigDecimal invAmt = MConversionRate.convertBase(this.getCtx(), this.getGrandTotal(true), this.getC_Currency_ID(), this.getDateAcct(), this.getC_ConversionType_ID(), this.getAD_Client_ID(), this.getAD_Org_ID());
        if (invAmt == null) {
            MCurrency curFrom = new MCurrency(this.getCtx(), this.getC_Currency_ID(), this.get_TrxName());
            MCurrency curTo = new MCurrency(this.getCtx(), MClient.get(Env.getCtx()).getC_Currency_ID(), this.get_TrxName());
            this.processMsg = "No se puede convertir " + curFrom.getISO_Code() + " a " + curTo.getISO_Code() + ". Verifique existencia de tasa de cambio para fecha de documento.";
            return "IN";
        }
        BigDecimal newBalance = partner.getTotalOpenBalance(false);
        if (newBalance == null) {
            newBalance = Env.ZERO;
        }
        if (this.isSOTrx()) {
            BigDecimal newLifeAmt;
            newBalance = newBalance.add(invAmt);
            if (partner.getFirstSale() == null) {
                partner.setFirstSale(this.getDateInvoiced());
            }
            newLifeAmt = (newLifeAmt = partner.getActualLifeTimeValue()) == null ? invAmt : newLifeAmt.add(invAmt);
            BigDecimal newCreditAmt = partner.getSO_CreditUsed();
            newCreditAmt = newCreditAmt == null ? invAmt : newCreditAmt.add(invAmt);
            this.log.fine("GrandTotal=" + this.getGrandTotal(true) + "(" + invAmt + ") BP Life=" + partner.getActualLifeTimeValue() + "->" + newLifeAmt + ", Credit=" + partner.getSO_CreditUsed() + "->" + newCreditAmt + ", Balance=" + partner.getTotalOpenBalance(false) + " -> " + newBalance);
            partner.setActualLifeTimeValue(newLifeAmt);
            partner.setSO_CreditUsed(newCreditAmt);
        } else {
            newBalance = newBalance.subtract(invAmt);
            this.log.fine("GrandTotal=" + this.getGrandTotal(true) + "(" + invAmt + ") Balance=" + partner.getTotalOpenBalance(false) + " -> " + newBalance);
        }
        partner.setTotalOpenBalance(newBalance);
        partner.setSOCreditStatus();
        if (!partner.save(this.get_TrxName())) {
            this.processMsg = "Could not update Business Partner";
            return "IN";
        }
        if (this.getAD_User_ID() != 0) {
            MUser user = new MUser(this.getCtx(), this.getAD_User_ID(), this.get_TrxName());
            user.setLastContact(new Timestamp(System.currentTimeMillis()));
            user.setLastResult(Msg.translate(this.getCtx(), "C_Invoice_ID") + ": " + this.getDocumentNo());
            if (!user.save(this.get_TrxName())) {
                this.processMsg = "Could not update Business Partner User";
                return "IN";
            }
        }
        if (this.isSOTrx() && this.getC_Project_ID() != 0) {
            MProject project = new MProject(this.getCtx(), this.getC_Project_ID(), this.get_TrxName());
            BigDecimal amt = this.getGrandTotal(true);
            int C_CurrencyTo_ID = project.getC_Currency_ID();
            if (C_CurrencyTo_ID != this.getC_Currency_ID()) {
                amt = MConversionRate.convert(this.getCtx(), amt, this.getC_Currency_ID(), C_CurrencyTo_ID, this.getDateAcct(), 0, this.getAD_Client_ID(), this.getAD_Org_ID());
            }
            if (amt == null) {
                this.processMsg = "Could not convert C_Currency_ID=" + this.getC_Currency_ID() + " to Project C_Currency_ID=" + C_CurrencyTo_ID;
                return "IN";
            }
            BigDecimal newAmt = project.getInvoicedAmt();
            newAmt = newAmt == null ? amt : newAmt.add(amt);
            this.log.fine("GrandTotal=" + this.getGrandTotal(true) + "(" + amt + ") Project " + project.getName() + " - Invoiced=" + project.getInvoicedAmt() + "->" + newAmt);
            project.setInvoicedAmt(newAmt);
            if (!project.save(this.get_TrxName())) {
                this.processMsg = "Could not update Project";
                return "IN";
            }
        }
        this.setDefiniteDocumentNo();
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.processMsg = valid;
            return "IN";
        }
        MInvoice counter = this.createCounterDoc();
        if (counter != null) {
            info.append(" - @CounterDoc@: @C_Invoice_ID@=").append(counter.getDocumentNo());
        }
        this.processMsg = info.toString().trim();
        this.setProcessed(true);
        this.setDocAction("VO");
        return "CO";
    }

    private void addDocsPostProcess(PO doc) {
        this.docsPostProcess.add(doc);
    }

    public ArrayList<PO> getDocsPostProcess() {
        return this.docsPostProcess;
    }

    private void setDefiniteDocumentNo() {
        String value;
        Boolean isOverwrite;
        MDocType dt = MDocType.get(this.getCtx(), this.getC_DocType_ID());
        if (dt.isOverwriteDateOnComplete()) {
            this.setDateInvoiced(new Timestamp(System.currentTimeMillis()));
        }
        if (dt.isOverwriteSeqOnComplete() && (isOverwrite = Boolean.valueOf(!this.isReversal() || this.isReversal() && !dt.isCopyDocNoOnReversal())).booleanValue() && (value = DB.getDocumentNo(this.getC_DocType_ID(), this.get_TrxName(), true, (PO)this)) != null) {
            this.setDocumentNo(value);
        }
    }

    private MInvoice createCounterDoc() {
        if (this.getRef_Invoice_ID() != 0 || this.getReversal_ID() != 0) {
            return null;
        }
        MOrg org = MOrg.get(this.getCtx(), this.getAD_Org_ID());
        int counterC_BPartner_ID = org.getLinkedC_BPartner_ID(this.get_TrxName());
        if (counterC_BPartner_ID == 0) {
            return null;
        }
        MBPartner bp = new MBPartner(this.getCtx(), this.getC_BPartner_ID(), this.get_TrxName());
        int counterAD_Org_ID = bp.getAD_OrgBP_ID_Int();
        if (counterAD_Org_ID == 0) {
            return null;
        }
        MBPartner counterBP = new MBPartner(this.getCtx(), counterC_BPartner_ID, this.get_TrxName());
        this.log.info("Counter BP=" + counterBP.getName());
        int C_DocTypeTarget_ID = 0;
        MDocTypeCounter counterDT = MDocTypeCounter.getCounterDocType(this.getCtx(), this.getC_DocType_ID());
        if (counterDT != null) {
            this.log.fine(counterDT.toString());
            if (!counterDT.isCreateCounter() || !counterDT.isValid()) {
                return null;
            }
            C_DocTypeTarget_ID = counterDT.getCounter_C_DocType_ID();
        } else {
            C_DocTypeTarget_ID = MDocTypeCounter.getCounterDocType_ID(this.getCtx(), this.getC_DocType_ID());
            this.log.fine("Indirect C_DocTypeTarget_ID=" + C_DocTypeTarget_ID);
            if (C_DocTypeTarget_ID <= 0) {
                return null;
            }
        }
        MInvoice counter = MInvoice.copyFrom(this, this.getDateInvoiced(), this.getDateAcct(), C_DocTypeTarget_ID, !this.isSOTrx(), true, false, this.get_TrxName(), true);
        counter.setAD_Org_ID(counterAD_Org_ID);
        counter.setBPartner(counterBP);
        counter.setSalesRep_ID(this.getSalesRep_ID());
        counter.save(this.get_TrxName());
        MDocType docCounter = new MDocType(this.getCtx(), C_DocTypeTarget_ID, this.get_TrxName());
        if (!docCounter.get_ValueAsBoolean("IsSetPOPriceFromSO")) {
            MInvoiceLine[] counterLines = counter.getLines(true);
            for (int i = 0; i < counterLines.length; ++i) {
                MInvoiceLine counterLine = counterLines[i];
                counterLine.setClientOrg(counter);
                counterLine.setInvoice(counter);
                counterLine.setPrice();
                counterLine.setTax();
                counterLine.save(this.get_TrxName());
            }
        }
        this.log.fine(counter.toString());
        if (counterDT != null && counterDT.getDocAction() != null) {
            counter.setDocAction(counterDT.getDocAction());
            counter.processIt(counterDT.getDocAction());
            counter.save(this.get_TrxName());
        }
        return counter;
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if ("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus())) {
            MInvoiceLine[] lines = this.getLines(false);
            for (int i = 0; i < lines.length; ++i) {
                MInvoiceLine line = lines[i];
                BigDecimal old = line.getQtyInvoiced();
                if (old.compareTo(Env.ZERO) == 0) continue;
                line.setQty(Env.ZERO);
                line.setTaxAmt(Env.ZERO);
                line.setLineNetAmt(Env.ZERO);
                line.setLineTotalAmt(Env.ZERO);
                line.addDescription(Msg.getMsg(this.getCtx(), "Voided") + " (" + old + ")");
                if (line.getM_InOutLine_ID() != 0) {
                    MInOutLine ioLine = new MInOutLine(this.getCtx(), line.getM_InOutLine_ID(), this.get_TrxName());
                    ioLine.setIsInvoiced(false);
                    ioLine.save(this.get_TrxName());
                    line.setM_InOutLine_ID(0);
                }
                line.save(this.get_TrxName());
            }
            this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
            this.setIsPaid(true);
            this.setC_Payment_ID(0);
        } else {
            MDocType doc = (MDocType)this.getC_DocTypeTarget();
            boolean reverse = true;
            if ((doc.getDocBaseType().equalsIgnoreCase("DRC") || doc.getDocBaseType().equalsIgnoreCase("DRI")) && this.get_ValueAsInt("UY_PayReceipt_ID") > 0) {
                String sql = "select docstatus from uy_payreceipt where uy_payreceipt_id = " + this.get_ValueAsInt("UY_PayReceipt_ID");
                String docStatus = DB.getSQLValueStringEx(this.get_TrxName(), sql, new Object[0]);
                if (!docStatus.equalsIgnoreCase("CO")) {
                    reverse = false;
                }
            }
            if (!this.getC_DocTypeTarget().getDocBaseType().startsWith("B") && reverse) {
                return this.reverseCorrectIt();
            }
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.processMsg == null;
    }

    private void reverseAllocations(boolean isAccrual, MInvoice invoice) {
        Arrays.stream(MAllocationHdr.getOfInvoice(this.getCtx(), invoice.getC_Invoice_ID(), invoice.get_TrxName())).forEach(allocationHdr -> {
            if (isAccrual) {
                allocationHdr.setDocAction("RA");
                allocationHdr.reverseAccrualIt();
            } else {
                allocationHdr.setDocAction("RC");
                allocationHdr.reverseCorrectIt();
            }
            allocationHdr.saveEx(this.get_TrxName());
        });
    }

    @Override
    public MInvoice reverseIt(boolean isAccrual) {
        Timestamp currentDate = new Timestamp(System.currentTimeMillis());
        Optional<Timestamp> loginDateOptional = Optional.of(Env.getContextAsDate(this.getCtx(), "#Date"));
        Timestamp reversalDate = isAccrual ? loginDateOptional.orElse(currentDate) : this.getDateAcct();
        Timestamp reversalDateInvoice = isAccrual ? reversalDate : this.getDateInvoiced();
        MPeriod.testPeriodOpen(this.getCtx(), reversalDate, this.getC_DocType_ID(), this.getAD_Org_ID());
        this.reverseAllocations(isAccrual, this);
        this.load(this.get_TrxName());
        this.setReversal(true);
        MInvoice reversal = MInvoice.copyFrom(this, reversalDateInvoice, reversalDate, this.getC_DocType_ID(), this.isSOTrx(), false, true, this.get_TrxName(), true);
        if (reversal == null) {
            this.processMsg = "Could not create Invoice Reversal";
            return null;
        }
        reversal.setReversal(true);
        Arrays.stream(reversal.getLines(false)).forEach(reversalInvoiceLine -> {
            reversalInvoiceLine.setQtyEntered(reversalInvoiceLine.getQtyEntered().negate());
            reversalInvoiceLine.setQtyInvoiced(reversalInvoiceLine.getQtyInvoiced().negate());
            reversalInvoiceLine.setLineNetAmt(reversalInvoiceLine.getLineNetAmt().negate());
            if (reversalInvoiceLine.getTaxAmt() != null && reversalInvoiceLine.getTaxAmt().compareTo(Env.ZERO) != 0) {
                reversalInvoiceLine.setTaxAmt(reversalInvoiceLine.getTaxAmt().negate());
            }
            if (reversalInvoiceLine.getLineTotalAmt() != null && reversalInvoiceLine.getLineTotalAmt().compareTo(Env.ZERO) != 0) {
                reversalInvoiceLine.setLineTotalAmt(reversalInvoiceLine.getLineTotalAmt().negate());
            }
            reversalInvoiceLine.saveEx(this.get_TrxName());
        });
        if (!this.isSOTrx() && !this.reverseMatching(reversalDate)) {
            return null;
        }
        reversal.setC_Order_ID(this.getC_Order_ID());
        reversal.addDescription("{->" + this.getDocumentNo() + ")");
        reversal.setReversal_ID(this.getC_Invoice_ID());
        reversal.saveEx(this.get_TrxName());
        if (!reversal.processIt("CO")) {
            this.processMsg = "Reversal ERROR: " + reversal.getProcessMsg();
            return null;
        }
        reversal.setC_Payment_ID(0);
        reversal.setIsPaid(true);
        reversal.closeIt();
        reversal.setProcessing(false);
        reversal.setDocStatus("RE");
        reversal.setDocAction("--");
        reversal.saveEx(this.get_TrxName());
        this.processMsg = reversal.getDocumentNo();
        this.addDescription("(" + reversal.getDocumentNo() + "<-)");
        Arrays.stream(this.getLines(false)).filter(invoiceLine -> invoiceLine.getM_InOutLine_ID() != 0).forEach(invoiceLine -> {
            MInOutLine inOutLine = new MInOutLine(this.getCtx(), invoiceLine.getM_InOutLine_ID(), this.get_TrxName());
            inOutLine.setIsInvoiced(false);
            inOutLine.saveEx(this.get_TrxName());
            invoiceLine.setM_InOutLine_ID(0);
            invoiceLine.saveEx(this.get_TrxName());
        });
        this.setProcessed(true);
        this.setReversal_ID(reversal.getC_Invoice_ID());
        this.setDocStatus("RE");
        this.setDocAction("--");
        this.setC_Payment_ID(0);
        this.setIsPaid(true);
        MAllocationHdr allocationHdr = new MAllocationHdr(this.getCtx(), false, reversalDate, this.getC_Currency_ID(), Msg.translate(this.getCtx(), "C_Invoice_ID") + ": " + this.getDocumentNo() + "/" + reversal.getDocumentNo(), this.get_TrxName());
        allocationHdr.setAD_Org_ID(this.getAD_Org_ID());
        allocationHdr.saveEx();
        BigDecimal grandTotal = this.getGrandTotal(true);
        if (!this.isSOTrx()) {
            grandTotal = grandTotal.negate();
        }
        MAllocationLine allocationLine = new MAllocationLine(allocationHdr, grandTotal, Env.ZERO, Env.ZERO, Env.ZERO);
        allocationLine.setC_Invoice_ID(this.getC_Invoice_ID());
        allocationLine.saveEx();
        MAllocationLine reversalAllocationLine = new MAllocationLine(allocationHdr, grandTotal.negate(), Env.ZERO, Env.ZERO, Env.ZERO);
        reversalAllocationLine.setC_Invoice_ID(reversal.getC_Invoice_ID());
        reversalAllocationLine.saveEx();
        if (!allocationHdr.processIt("CO")) {
            throw new AdempiereException("Failed when processing document - " + allocationHdr.getProcessMsg());
        }
        allocationHdr.saveEx();
        return reversal;
    }

    protected boolean reverseMatching(Timestamp reversalDate) {
        MMatchInv.getByInvoiceId(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName()).stream().filter(matchInv -> matchInv.getReversal_ID() <= 0).forEach(matchInv -> {
            MMatchInv matchInvReverse = matchInv.reverseIt(reversalDate);
            if (matchInvReverse == null) {
                this.processMsg = "Could not Reverse MatchInv";
                throw new AdempiereException(this.processMsg);
            }
            this.addDocsPostProcess(matchInvReverse);
        });
        MMatchPO.getByInvoiceId(this.getCtx(), this.getC_Invoice_ID(), this.get_TrxName()).stream().filter(matchPO -> matchPO.getReversal_ID() <= 0).forEach(matchPO -> {
            if (matchPO.getM_InOutLine_ID() == 0) {
                MMatchPO matchPOReverse = matchPO.reverseIt(reversalDate);
                if (matchPOReverse == null) {
                    this.processMsg = "Could not Reverse MatchPO";
                    throw new AdempiereException(this.processMsg);
                }
                this.addDocsPostProcess(matchPOReverse);
            } else {
                matchPO.setC_InvoiceLine_ID(null);
                matchPO.saveEx(this.get_TrxName());
            }
        });
        return true;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.processMsg != null) {
            return false;
        }
        MInvoice reversal = this.reverseIt(false);
        if (reversal == null) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.processMsg != null) {
            return false;
        }
        this.processMsg = reversal.getDocumentNo();
        return true;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.processMsg != null) {
            return false;
        }
        MInvoice reversal = this.reverseIt(true);
        if (reversal == null) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        return this.processMsg == null;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info(this.toString());
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.processMsg != null) {
            return false;
        }
        this.processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getDocumentNo());
        sb.append(": ").append(Msg.translate(this.getCtx(), "GrandTotal")).append("=").append(this.getGrandTotal()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getSalesRep_ID();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getGrandTotal();
    }

    public void setRMA(MRMA rma) {
        this.setM_RMA_ID(rma.getM_RMA_ID());
        this.setAD_Org_ID(rma.getAD_Org_ID());
        this.setDescription(rma.getDescription());
        this.setC_BPartner_ID(rma.getC_BPartner_ID());
        this.setSalesRep_ID(rma.getSalesRep_ID());
        this.setGrandTotal(rma.getAmt());
        this.setIsSOTrx(rma.isSOTrx());
        this.setTotalLines(rma.getAmt());
        MInvoice originalInvoice = rma.getOriginalInvoice();
        if (originalInvoice == null && rma.getShipment() != null) {
            String sql = "select il.c_invoice_id from c_orderline ol join c_invoiceline il on ol.c_orderline_id = il.c_orderline_id where ol.c_order_id = " + rma.getShipment().getC_Order_ID();
            int invID = DB.getSQLValueEx(this.get_TrxName(), sql, new Object[0]);
            if (invID > 0) {
                originalInvoice = new MInvoice(this.getCtx(), invID, this.get_TrxName());
            }
        }
        if (originalInvoice == null) {
            throw new IllegalStateException("Not invoiced - RMA: " + rma.getDocumentNo());
        }
        this.setC_BPartner_Location_ID(originalInvoice.getC_BPartner_Location_ID());
        this.setAD_User_ID(originalInvoice.getAD_User_ID());
        this.setC_Currency_ID(originalInvoice.getC_Currency_ID());
        this.setIsTaxIncluded(originalInvoice.isTaxIncluded());
        this.setM_PriceList_ID(originalInvoice.getM_PriceList_ID());
        this.setC_Project_ID(originalInvoice.getC_Project_ID());
        this.setC_Activity_ID(originalInvoice.getC_Activity_ID());
        this.setC_Campaign_ID(originalInvoice.getC_Campaign_ID());
        this.setUser1_ID(originalInvoice.getUser1_ID());
        this.setUser2_ID(originalInvoice.getUser2_ID());
        this.setUser3_ID(originalInvoice.getUser3_ID());
        this.setUser4_ID(originalInvoice.getUser4_ID());
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }

    private int getCashBankAccount() {
        if (!MSysConfig.getBooleanValue("CASH_AS_PAYMENT", true, this.getAD_Client_ID())) {
            return -1;
        }
        if (this.getC_POS_ID() != 0) {
            return MPOS.get(this.getCtx(), this.getC_POS_ID()).getC_BankAccount_ID();
        }
        MBankAccount bankAccount = MBankAccount.getDefault(this.getCtx(), this.getAD_Org_ID(), "C");
        if (bankAccount != null) {
            return bankAccount.getC_BankAccount_ID();
        }
        return -1;
    }

    private int getCashBook() {
        if (MSysConfig.getBooleanValue("CASH_AS_PAYMENT", true, this.getAD_Client_ID())) {
            return -1;
        }
        if (this.getC_POS_ID() != 0) {
            return MPOS.get(this.getCtx(), this.getC_POS_ID()).getC_CashBook_ID();
        }
        MCash cash = MCash.get(this.getCtx(), this.getAD_Org_ID(), this.getDateInvoiced(), this.getC_Currency_ID(), this.get_TrxName());
        if (cash != null) {
            return cash.getC_CashBook_ID();
        }
        return -1;
    }

    private boolean isValidCashBook() {
        return this.getCashBankAccount() > 0 || this.getCashBook() > 0;
    }

    private String payWithCashAsPayment() {
        int cashAccountId = this.getCashBankAccount();
        if (cashAccountId <= 0) {
            throw new AdempiereException("@NoCashBook@");
        }
        MPayment paymentCash = new MPayment(this.getCtx(), 0, this.get_TrxName());
        paymentCash.setC_BankAccount_ID(cashAccountId);
        paymentCash.setC_DocType_ID(this.isSOTrx());
        String value = DB.getDocumentNo(paymentCash.getC_DocType_ID(), this.get_TrxName(), false, (PO)paymentCash);
        paymentCash.setDocumentNo(value);
        paymentCash.setDateAcct(this.getDateAcct());
        paymentCash.setDateTrx(this.getDateInvoiced());
        paymentCash.setTenderType("X");
        paymentCash.setDescription(this.getDescription());
        paymentCash.setC_BPartner_ID(this.getC_BPartner_ID());
        paymentCash.setC_Currency_ID(this.getC_Currency_ID());
        paymentCash.setPayAmt(this.getGrandTotal());
        paymentCash.setOverUnderAmt(Env.ZERO);
        paymentCash.setC_Invoice_ID(this.getC_Invoice_ID());
        paymentCash.saveEx();
        if (!paymentCash.processIt("CO")) {
            this.processMsg = paymentCash.getProcessMsg();
            throw new AdempiereException("@Error@: " + paymentCash.getProcessMsg());
        }
        paymentCash.saveEx();
        MBankStatement.addPayment(paymentCash);
        return "@C_Payment_ID@: " + paymentCash.getDocumentNo();
    }

    private String payWithCash() {
        int cashBookId = this.getCashBook();
        if (cashBookId <= 0) {
            throw new AdempiereException("@NoCashBook@");
        }
        MCash cash = MCash.get(this.getCtx(), cashBookId, this.getDateInvoiced(), this.get_TrxName());
        MCashLine cashLine = new MCashLine(cash);
        cashLine.setInvoice(this);
        cashLine.saveEx(this.get_TrxName());
        this.setC_CashLine_ID(cashLine.getC_CashLine_ID());
        return "@C_Cash_ID@: " + cash.getName() + " #" + cashLine.getLine();
    }
}

