/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.X_R_InterestArea;
import org.compiere.model.MContactInterest;
import org.compiere.util.CCache;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class MInterestArea
extends X_R_InterestArea {
    private static final long serialVersionUID = -6910076559329764930L;
    private static CCache<Integer, MInterestArea> s_cache = new CCache("R_InterestArea", 5);
    private static CLogger s_log = CLogger.getCLogger(MInterestArea.class);
    private int m_AD_User_ID = -1;
    private MContactInterest m_ci = null;

    public static MInterestArea[] getAll(Properties ctx) {
        ArrayList<MInterestArea> list = new ArrayList<MInterestArea>();
        String sql = "SELECT * FROM R_InterestArea WHERE IsActive='Y'";
        CPreparedStatement pstmt = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                MInterestArea ia = new MInterestArea(ctx, rs, null);
                list.add(ia);
            }
            rs.close();
            pstmt.close();
            pstmt = null;
        }
        catch (Exception e) {
            s_log.log(Level.SEVERE, sql, e);
        }
        try {
            if (pstmt != null) {
                pstmt.close();
            }
            pstmt = null;
        }
        catch (Exception e) {
            pstmt = null;
        }
        MInterestArea[] retValue = new MInterestArea[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public static MInterestArea get(Properties ctx, int R_InterestArea_ID) {
        Integer key = R_InterestArea_ID;
        MInterestArea retValue = s_cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MInterestArea(ctx, R_InterestArea_ID, null);
        if (retValue.get_ID() != 0) {
            s_cache.put(key, retValue);
        }
        return retValue;
    }

    public MInterestArea(Properties ctx, int R_InterestArea_ID, String trxName) {
        super(ctx, R_InterestArea_ID, trxName);
        if (R_InterestArea_ID == 0) {
            this.setIsSelfService(false);
        }
    }

    public MInterestArea(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    @Override
    public String getValue() {
        String s = super.getValue();
        if (s != null && s.length() > 0) {
            return s;
        }
        return super.getName();
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("MInterestArea[").append(this.get_ID()).append(" - ").append(this.getName()).append("]");
        return sb.toString();
    }

    public void setSubscriptionInfo(int AD_User_ID) {
        this.m_AD_User_ID = AD_User_ID;
        this.m_ci = MContactInterest.get(this.getCtx(), this.getR_InterestArea_ID(), AD_User_ID, false, this.get_TrxName());
    }

    public void setAD_User_ID(int AD_User_ID) {
        this.m_AD_User_ID = AD_User_ID;
    }

    public int getAD_User_ID() {
        return this.m_AD_User_ID;
    }

    public Timestamp getSubscribeDate() {
        if (this.m_ci != null) {
            return this.m_ci.getSubscribeDate();
        }
        return null;
    }

    public Timestamp getOptOutDate() {
        if (this.m_ci != null) {
            return this.m_ci.getOptOutDate();
        }
        return null;
    }

    public boolean isSubscribed() {
        if (this.m_AD_User_ID <= 0 || this.m_ci == null) {
            return false;
        }
        return this.m_ci.isSubscribed();
    }
}

