/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.awt.Container;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.adempiere.core.domains.models.X_AD_Image;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.util.CCache;
import org.compiere.util.Ini;
import org.spin.util.AttachmentUtil;

public class MImage
extends X_AD_Image {
    private static final long serialVersionUID = -7361463683427300715L;
    private static CCache<Integer, MImage> cache = new CCache("AD_Image", 20);
    private Image m_image = null;
    private Icon m_icon = null;
    private byte[] data = null;

    public static MImage get(Properties ctx, int AD_Image_ID) {
        return MImage.get(ctx, AD_Image_ID, null);
    }

    public static MImage get(Properties ctx, int ad_image_id, String trxName) {
        if (ad_image_id == 0) {
            return new MImage(ctx, ad_image_id, trxName);
        }
        Integer key = ad_image_id;
        MImage retValue = cache.get(key);
        if (retValue != null) {
            return retValue;
        }
        retValue = new MImage(ctx, ad_image_id, trxName);
        if (retValue.get_ID() != 0 && Ini.isClient()) {
            cache.put(key, retValue);
        }
        return retValue;
    }

    public MImage(Properties ctx, int AD_Image_ID, String trxName) {
        super(ctx, AD_Image_ID, trxName);
        if (AD_Image_ID < 1) {
            this.setName("-");
        }
    }

    public MImage(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public Image getImage() {
        if (this.m_image != null) {
            return this.m_image;
        }
        byte[] data = this.getBinaryData();
        if (data != null && data.length > 0) {
            try {
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(data));
                this.m_image = bufferedImage;
                return this.m_image;
            }
            catch (IOException e) {
                this.log.log(Level.WARNING, "(byteArray)", e);
                return null;
            }
        }
        URL url = this.getURL();
        if (url == null) {
            return null;
        }
        try {
            Toolkit tk = Toolkit.getDefaultToolkit();
            this.m_image = tk.getImage(url);
            MediaTracker mediaTracker = new MediaTracker(new Container());
            mediaTracker.addImage(this.m_image, 0);
            mediaTracker.waitForID(0);
            return this.m_image;
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "(URL)", e);
            return null;
        }
    }

    public Icon getIcon() {
        if (this.m_icon != null) {
            return this.m_icon;
        }
        byte[] data = this.getBinaryData();
        if (data != null && data.length > 0) {
            try {
                BufferedImage bufferedImage = ImageIO.read(new ByteArrayInputStream(data));
                this.m_icon = new ImageIcon(bufferedImage, this.getName());
                return this.m_icon;
            }
            catch (Exception e) {
                this.log.log(Level.WARNING, "(byteArray)", e);
                return null;
            }
        }
        URL url = this.getURL();
        if (url == null) {
            return null;
        }
        try {
            this.m_icon = new ImageIcon(url, this.getName());
            return this.m_icon;
        }
        catch (Exception e) {
            this.log.log(Level.WARNING, "(URL)", e);
            return null;
        }
    }

    private URL getURL() {
        String str = this.getImageURL();
        if (str == null || str.length() == 0) {
            return null;
        }
        URL url = null;
        try {
            url = str.indexOf("://") != -1 ? new URL(str) : this.getClass().getResource(str);
            if (url == null) {
                this.log.warning("Not found: " + str);
            }
        }
        catch (Exception e) {
            this.log.warning("Not found: " + str + " - " + e.getMessage());
        }
        return url;
    }

    @Override
    public void setImageURL(String ImageURL) {
        this.m_image = null;
        this.m_icon = null;
        super.setImageURL(ImageURL);
    }

    @Override
    public void setBinaryData(byte[] BinaryData) {
        this.m_image = null;
        this.m_icon = null;
        super.setBinaryData(BinaryData);
    }

    @Override
    public byte[] getBinaryData() {
        byte[] data = null;
        if (this.getAD_Image_ID() != 0) {
            if (AttachmentUtil.getInstance().isValidForClient(this.getAD_Client_ID())) {
                try {
                    data = AttachmentUtil.getInstance().clear().withImageId(this.getAD_Image_ID()).withClientId(this.getAD_Client_ID()).getAttachment();
                }
                catch (Exception e) {
                    this.log.warning("Error loading image: " + e.getLocalizedMessage());
                }
                return data;
            }
            data = super.getBinaryData();
        }
        return data;
    }

    public byte[] getData() {
        byte[] data = this.getBinaryData();
        if (data != null) {
            return data;
        }
        String str = this.getImageURL();
        if (str == null || str.length() == 0) {
            this.log.config("No Image URL");
            return null;
        }
        URL url = this.getURL();
        if (url == null) {
            this.log.config("No URL");
            return null;
        }
        try {
            URLConnection conn = url.openConnection();
            conn.setUseCaches(false);
            InputStream is = conn.getInputStream();
            byte[] buffer = new byte[8192];
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            int length = -1;
            while ((length = is.read(buffer)) != -1) {
                os.write(buffer, 0, length);
            }
            is.close();
            data = os.toByteArray();
            os.close();
        }
        catch (Exception e) {
            this.log.config(e.toString());
        }
        return data;
    }

    @Override
    public String toString() {
        return "MImage[ID=" + this.get_ID() + ",Name=" + this.getName() + "]";
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getAD_Org_ID() != 0) {
            this.setAD_Org_ID(0);
        }
        if (AttachmentUtil.getInstance().isValidForClient(this.getAD_Client_ID())) {
            this.data = super.getBinaryData();
            super.setBinaryData(null);
        }
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (AttachmentUtil.getInstance().isValidForClient(this.getAD_Client_ID())) {
            try {
                AttachmentUtil.getInstance().clear().withImageId(this.getAD_Image_ID()).withFileName(this.getName()).withDescription(this.getDescription()).withData(this.data).withTansactionName(this.get_TrxName()).saveAttachment();
            }
            catch (Exception e) {
                throw new AdempiereException(e);
            }
        }
        this.data = null;
        return super.afterSave(newRecord, success);
    }
}

