/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.sql.ResultSet;
import java.util.List;
import java.util.Properties;
import java.util.stream.Collectors;
import org.adempiere.core.domains.models.X_C_CommissionType;
import org.adempiere.model.MView;
import org.adempiere.model.MViewColumn;
import org.compiere.model.MColumn;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;

public class MCommissionType
extends X_C_CommissionType {
    private static CCache<Integer, MCommissionType> commissionTypeCacheIds = new CCache("C_CommissionType", 30);
    private static CCache<String, MCommissionType> commissionTypeCacheValues = new CCache("C_CommissionType", 30);
    private static final long serialVersionUID = 6876713053371206663L;
    private MView view = null;

    public MCommissionType(Properties ctx, int C_CommissionType_ID, String trxName) {
        super(ctx, C_CommissionType_ID, trxName);
    }

    public MCommissionType(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public static MCommissionType getById(Properties ctx, int commissionTypeId, String trxName) {
        if (commissionTypeId <= 0) {
            return null;
        }
        MCommissionType commissionType = commissionTypeCacheIds.get(commissionTypeId);
        if (commissionType != null && commissionType.get_ID() > 0) {
            return commissionType;
        }
        commissionType = (MCommissionType)new Query(ctx, "C_CommissionType", "C_CommissionType_ID=?", trxName).setClient_ID().setParameters(commissionTypeId).first();
        if (commissionType != null && commissionType.get_ID() > 0) {
            int clientId = Env.getAD_Client_ID(ctx);
            String key = clientId + "#" + commissionType.getValue();
            commissionTypeCacheValues.put(key, commissionType);
            commissionTypeCacheIds.put(commissionType.get_ID(), commissionType);
        }
        return commissionType;
    }

    public static MCommissionType getByValue(Properties ctx, String value, String trxName) {
        int clientId;
        String key;
        MCommissionType commissionType;
        if (value == null) {
            return null;
        }
        if (commissionTypeCacheValues.size() == 0) {
            MCommissionType.getAll(ctx, true, trxName);
        }
        if ((commissionType = commissionTypeCacheValues.get(key = (clientId = Env.getAD_Client_ID(ctx)) + "#" + value)) != null && commissionType.get_ID() > 0) {
            return commissionType;
        }
        commissionType = (MCommissionType)new Query(ctx, "C_CommissionType", "Value=?", trxName).setClient_ID().setParameters(value).setOrderBy("Value").first();
        if (commissionType != null && commissionType.get_ID() > 0) {
            commissionTypeCacheValues.put(key, commissionType);
            commissionTypeCacheIds.put(commissionType.get_ID(), commissionType);
        }
        return commissionType;
    }

    public static List<MCommissionType> getAll(Properties ctx, boolean resetCache, String trxName) {
        if (resetCache || commissionTypeCacheIds.size() > 0) {
            List<MCommissionType> commissionTypeList = new Query(Env.getCtx(), "C_CommissionType", null, trxName).setClient_ID().setOrderBy("Name").list();
            commissionTypeList.stream().forEach(definition -> {
                int clientId = Env.getAD_Client_ID(ctx);
                String key = clientId + "#" + definition.getValue();
                commissionTypeCacheIds.put(definition.getC_CommissionType_ID(), (MCommissionType)definition);
                commissionTypeCacheValues.put(key, (MCommissionType)definition);
            });
            return commissionTypeList;
        }
        List<MCommissionType> commissionTypeList = commissionTypeCacheIds.entrySet().stream().map(activity -> (MCommissionType)activity.getValue()).collect(Collectors.toList());
        return commissionTypeList;
    }

    public MView getView() {
        if (this.view == null) {
            this.view = (MView)this.getAD_View();
        }
        return this.view;
    }

    private MViewColumn getAmountViewColumn() {
        return MViewColumn.getById(this.getCtx(), this.getAmountColumn_ID(), this.get_TrxName());
    }

    private MViewColumn getQuantityViewColumn() {
        return MViewColumn.getById(this.getCtx(), this.getQuantityColumn_ID(), this.get_TrxName());
    }

    private MViewColumn getCurrencyViewColumn() {
        return MViewColumn.getById(this.getCtx(), this.getCurrencyColumn_ID(), this.get_TrxName());
    }

    private MViewColumn getDateDocViewColumn() {
        return MViewColumn.getById(this.getCtx(), this.getDateDocColumn_ID(), this.get_TrxName());
    }

    public String getSQLAmountColumnName() {
        MViewColumn viewColumn = this.getAmountViewColumn();
        if (viewColumn == null) {
            return null;
        }
        return viewColumn.getColumnSQL();
    }

    public String getSQLQuantityColumnName() {
        MViewColumn viewColumn = this.getQuantityViewColumn();
        if (viewColumn == null) {
            return null;
        }
        return viewColumn.getColumnSQL();
    }

    public String getSQLCurrencyColumnName() {
        MViewColumn viewColumn = this.getCurrencyViewColumn();
        if (viewColumn == null) {
            return null;
        }
        return viewColumn.getColumnSQL();
    }

    public String getSQLDateDocColumnName() {
        MViewColumn viewColumn = this.getDateDocViewColumn();
        if (viewColumn == null) {
            return null;
        }
        return viewColumn.getColumnSQL();
    }

    public String getAmountColumnName() {
        MViewColumn viewColumn = this.getAmountViewColumn();
        if (viewColumn == null) {
            return null;
        }
        return viewColumn.getColumnName();
    }

    public String getQuantityColumnName() {
        MViewColumn viewColumn = this.getQuantityViewColumn();
        if (viewColumn == null) {
            return null;
        }
        return viewColumn.getColumnName();
    }

    public String getCurrencyColumnName() {
        MViewColumn viewColumn = this.getCurrencyViewColumn();
        if (viewColumn == null) {
            return null;
        }
        return viewColumn.getColumnName();
    }

    public String getDateDocColumnName() {
        MViewColumn viewColumn = this.getDateDocViewColumn();
        if (viewColumn == null) {
            return null;
        }
        return viewColumn.getColumnName();
    }

    public String getSQLColumnName(String ... columnNames) {
        MView view = this.getView();
        if (view == null) {
            return null;
        }
        for (MViewColumn viewColumn : view.getViewColumns()) {
            if (viewColumn.getAD_Column_ID() > 0) {
                MColumn column = MColumn.get(this.getCtx(), viewColumn.getAD_Column_ID());
                String[] stringArray = columnNames;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String columnName = stringArray[i];
                    if (!column.getColumnName().equals(columnName)) continue;
                    return viewColumn.getColumnSQL();
                }
                continue;
            }
            for (String columnName : columnNames) {
                if (!viewColumn.getColumnName().contains(columnName)) continue;
                return viewColumn.getColumnSQL();
            }
        }
        return null;
    }

    public String getColumnName(String ... columnNames) {
        MView view = this.getView();
        if (view == null) {
            return null;
        }
        for (MViewColumn viewColumn : view.getViewColumns()) {
            if (viewColumn.getAD_Column_ID() > 0) {
                MColumn column = MColumn.get(this.getCtx(), viewColumn.getAD_Column_ID());
                String[] stringArray = columnNames;
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    String columnName = stringArray[i];
                    if (!column.getColumnName().equals(columnName)) continue;
                    return viewColumn.getColumnName();
                }
                continue;
            }
            for (String columnName : columnNames) {
                if (!viewColumn.getColumnName().contains(columnName)) continue;
                return viewColumn.getColumnName();
            }
        }
        return null;
    }

    public boolean isValidColumn(String columnName) {
        MView view = this.getView();
        if (view == null) {
            return false;
        }
        for (MViewColumn viewColumn : view.getViewColumns()) {
            MColumn column;
            if (viewColumn.getAD_Column_ID() <= 0 || !(column = MColumn.get(this.getCtx(), viewColumn.getAD_Column_ID())).getColumnName().equals(columnName)) continue;
            return true;
        }
        return false;
    }
}

