/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.io.File;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.adempiere.core.domains.models.X_C_BankStatement;
import org.adempiere.exceptions.AdempiereException;
import org.compiere.model.MBankAccount;
import org.compiere.model.MBankStatementLine;
import org.compiere.model.MDocType;
import org.compiere.model.MFactAcct;
import org.compiere.model.MPayment;
import org.compiere.model.MPeriod;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.Query;
import org.compiere.process.DocAction;
import org.compiere.process.DocumentEngine;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;
import org.compiere.util.Util;

public class MBankStatement
extends X_C_BankStatement
implements DocAction {
    private static final long serialVersionUID = -859925588789443186L;
    private MBankStatementLine[] m_lines = null;
    private String m_processMsg = null;
    private boolean m_justPrepared = false;

    public static MBankStatementLine addPayment(MPayment payment) {
        MBankStatementLine bankStatementLine = payment.getBankStatementLine();
        if (bankStatementLine != null && bankStatementLine.getC_BankStatement_ID() > 0) {
            return bankStatementLine;
        }
        StringBuilder whereClause = new StringBuilder();
        whereClause.append("C_BankAccount_ID").append("=? AND ").append("TRUNC(").append("StatementDate").append(",'DD')=? AND ").append("Processed").append("=?");
        MBankStatement bankStatement = (MBankStatement)new Query(payment.getCtx(), "C_BankStatement", whereClause.toString(), payment.get_TrxName()).setClient_ID().setParameters(payment.getC_BankAccount_ID(), TimeUtil.getDay(payment.getDateTrx()), false).first();
        if (bankStatement == null || bankStatement.get_ID() <= 0) {
            bankStatement = new MBankStatement(payment.getCtx(), 0, payment.get_TrxName());
            bankStatement.setC_BankAccount_ID(payment.getC_BankAccount_ID());
            bankStatement.setStatementDate(payment.getDateAcct());
            if (payment.getDescription() != null) {
                bankStatement.setName(payment.getDescription());
            } else {
                SimpleDateFormat format = DisplayType.getDateFormat(15);
                bankStatement.setName(Msg.parseTranslation(payment.getCtx(), "@Generate@: ") + format.format(payment.getDateAcct()));
            }
            bankStatement.saveEx();
        }
        bankStatementLine = new MBankStatementLine(bankStatement);
        bankStatementLine.setPayment(payment);
        bankStatementLine.setStatementLineDate(payment.getDateAcct());
        bankStatementLine.setDateAcct(payment.getDateAcct());
        bankStatementLine.saveEx();
        return bankStatementLine;
    }

    public MBankStatement(Properties ctx, int C_BankStatement_ID, String trxName) {
        super(ctx, C_BankStatement_ID, trxName);
        if (C_BankStatement_ID == 0) {
            this.setStatementDate(new Timestamp(System.currentTimeMillis()));
            this.setDocAction("CO");
            this.setDocStatus("DR");
            this.setBeginningBalance(Env.ZERO);
            this.setStatementDifference(Env.ZERO);
            this.setEndingBalance(Env.ZERO);
            this.setIsApproved(false);
            this.setIsManual(true);
            this.setPosted(false);
            super.setProcessed(false);
        }
    }

    public MBankStatement(Properties ctx, ResultSet rs, String trxName) {
        super(ctx, rs, trxName);
    }

    public MBankStatement(MBankAccount account, boolean isManual) {
        this(account.getCtx(), 0, account.get_TrxName());
        this.setClientOrg(account);
        this.setC_BankAccount_ID(account.getC_BankAccount_ID());
        this.setStatementDate(new Timestamp(System.currentTimeMillis()));
        this.setBeginningBalance(account.getCurrentBalance());
        this.setName(this.getStatementDate().toString());
        this.setIsManual(isManual);
    }

    public MBankStatement(MBankAccount account) {
        this(account, false);
    }

    public MBankStatementLine[] getLines(boolean requery) {
        if (this.m_lines != null && !requery) {
            MBankStatement.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        String whereClause = "C_BankStatement_ID=?";
        List<MBankStatementLine> list = new Query(this.getCtx(), "C_BankStatementLine", "C_BankStatement_ID=?", this.get_TrxName()).setParameters(this.getC_BankStatement_ID()).setOrderBy("Line").list();
        MBankStatementLine[] retValue = new MBankStatementLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public MBankStatementLine[] getLinesWhere(boolean requery, String where) {
        if (this.m_lines != null && !requery) {
            MBankStatement.set_TrxName(this.m_lines, this.get_TrxName());
            return this.m_lines;
        }
        Object whereClause = "C_BankStatement_ID=?";
        if (where != null) {
            whereClause = (String)whereClause + where;
        }
        List<MBankStatementLine> list = new Query(this.getCtx(), "C_BankStatementLine", (String)whereClause, this.get_TrxName()).setParameters(this.getC_BankStatement_ID()).setOrderBy("Line").list();
        MBankStatementLine[] retValue = new MBankStatementLine[list.size()];
        list.toArray(retValue);
        return retValue;
    }

    public void addDescription(String description) {
        String desc = this.getDescription();
        if (desc == null) {
            this.setDescription(description);
        } else {
            this.setDescription(desc + " | " + description);
        }
    }

    @Override
    public void setProcessed(boolean processed) {
        super.setProcessed(processed);
        if (this.get_ID() == 0) {
            return;
        }
        String sql = "UPDATE C_BankStatementLine SET Processed='" + (processed ? "Y" : "N") + "' WHERE C_BankStatement_ID=" + this.getC_BankStatement_ID();
        int noLine = DB.executeUpdate(sql, this.get_TrxName());
        this.m_lines = null;
        this.log.fine("setProcessed - " + processed + " - Lines=" + noLine);
    }

    public MBankAccount getBankAccount() {
        return MBankAccount.get(this.getCtx(), this.getC_BankAccount_ID());
    }

    @Override
    public String getDocumentInfo() {
        return this.getBankAccount().getName() + " " + this.getDocumentNo();
    }

    @Override
    public File createPDF() {
        try {
            File temp = File.createTempFile(this.get_TableName() + this.get_ID() + "_", ".pdf");
            return this.createPDF(temp);
        }
        catch (Exception e) {
            this.log.severe("Could not create PDF - " + e.getMessage());
            return null;
        }
    }

    public File createPDF(File file) {
        return null;
    }

    @Override
    protected boolean beforeSave(boolean newRecord) {
        if (this.getC_DocType_ID() <= 0) {
            Optional<MDocType> doctypeOptional = Arrays.stream(MDocType.getOfDocBaseType(this.getCtx(), "CMB")).sorted((docType1, dt2) -> Boolean.compare(dt2.isDefault(), docType1.isDefault())).findFirst();
            doctypeOptional.ifPresent(docType -> this.setC_DocType_ID(docType.getC_DocType_ID()));
            if (this.getC_DocType_ID() <= 0) {
                throw new AdempiereException("@C_DocType_ID@ @FillMandatory@");
            }
        }
        if (!this.isProcessed() && this.getBeginningBalance().compareTo(Env.ZERO) == 0) {
            MBankAccount ba = this.getBankAccount();
            ba.load(this.get_TrxName());
            this.setBeginningBalance(ba.getCurrentBalance());
        }
        this.setEndingBalance(this.getBeginningBalance().add(this.getStatementDifference()));
        return true;
    }

    @Override
    protected boolean afterSave(boolean newRecord, boolean success) {
        if (this.getDocumentNo() == null || this.getDocumentNo().isEmpty()) {
            this.setDocumentNo(String.valueOf(this.getC_BankStatement_ID()));
            this.saveEx();
        }
        return true;
    }

    @Override
    public boolean processIt(String processAction) {
        this.m_processMsg = null;
        DocumentEngine engine = new DocumentEngine(this, this.getDocStatus());
        return engine.processIt(processAction, this.getDocAction());
    }

    @Override
    public boolean unlockIt() {
        this.log.info("unlockIt - " + this.toString());
        this.setProcessing(false);
        return true;
    }

    @Override
    public boolean invalidateIt() {
        this.log.info("invalidateIt - " + this.toString());
        this.setDocAction("PR");
        return true;
    }

    @Override
    public String prepareIt() {
        Timestamp minDate;
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 1);
        if (this.m_processMsg != null) {
            return "IN";
        }
        MPeriod.testPeriodOpen(this.getCtx(), this.getStatementDate(), "CMB", this.getAD_Org_ID());
        MBankStatementLine[] lines = this.getLines(true);
        if (lines.length == 0) {
            this.m_processMsg = "@NoLines@";
            return "IN";
        }
        BigDecimal total = Env.ZERO;
        Timestamp maxDate = minDate = this.getStatementDate();
        for (int i = 0; i < lines.length; ++i) {
            MBankStatementLine line = lines[i];
            total = total.add(line.getStmtAmt());
            if (line.getDateAcct().before(minDate)) {
                minDate = line.getDateAcct();
            }
            if (!line.getDateAcct().after(maxDate)) continue;
            maxDate = line.getDateAcct();
        }
        this.setStatementDifference(total);
        this.setEndingBalance(this.getBeginningBalance().add(total));
        MPeriod.testPeriodOpen(this.getCtx(), minDate, "CMB", 0);
        MPeriod.testPeriodOpen(this.getCtx(), maxDate, "CMB", 0);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 8);
        if (this.m_processMsg != null) {
            return "IN";
        }
        this.m_justPrepared = true;
        if (!"CO".equals(this.getDocAction())) {
            this.setDocAction("CO");
        }
        return "IP";
    }

    @Override
    public boolean approveIt() {
        this.log.info("approveIt - " + this.toString());
        this.setIsApproved(true);
        return true;
    }

    @Override
    public boolean rejectIt() {
        this.log.info("rejectIt - " + this.toString());
        this.setIsApproved(false);
        return true;
    }

    @Override
    public String completeIt() {
        String status;
        if (!this.m_justPrepared && !"IP".equals(status = this.prepareIt())) {
            return status;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 7);
        if (this.m_processMsg != null) {
            return "IN";
        }
        if (!this.isApproved()) {
            this.approveIt();
        }
        this.log.info("completeIt - " + this.toString());
        StringBuffer linesWithoutReference = new StringBuffer();
        boolean[] IsChanged = new boolean[]{false};
        Arrays.asList(this.getLines(true)).stream().filter(statementLine -> statementLine.getC_Payment_ID() == 0).forEach(statementLine -> {
            if (linesWithoutReference.length() > 0) {
                linesWithoutReference.append(Env.NL);
            }
            StringBuffer displayValue = new StringBuffer();
            displayValue.append(statementLine.getLine());
            if (!Util.isEmpty(statementLine.getReferenceNo())) {
                displayValue.append(" - @ReferenceNo@: ").append(statementLine.getReferenceNo());
                IsChanged[0] = true;
            }
            if (!Util.isEmpty(statementLine.getMemo())) {
                displayValue.append(" - @Memo@: ").append(statementLine.getMemo());
                IsChanged[0] = true;
            }
            if (!Util.isEmpty(statementLine.getEftCheckNo())) {
                displayValue.append(" - @EftCheckNo@: ").append(statementLine.getEftCheckNo());
                IsChanged[0] = true;
            }
            if (!Util.isEmpty(statementLine.getEftMemo())) {
                displayValue.append(" - @EftMemo@: ").append(statementLine.getEftMemo());
                IsChanged[0] = true;
            }
            if (statementLine.getTrxAmt().compareTo(Env.ZERO) != 0) {
                displayValue.append(" - @TrxAmt@: ").append(DisplayType.getNumberFormat(12).format(statementLine.getTrxAmt()));
                IsChanged[0] = true;
            }
            if (statementLine.getChargeAmt().compareTo(Env.ZERO) != 0 && !this.getC_BankAccount().getBankAccountType().equals("C")) {
                displayValue.append(" - @ChargeAmt@: ").append(DisplayType.getNumberFormat(12).format(statementLine.getChargeAmt()));
                IsChanged[0] = true;
            }
            if (statementLine.getInterestAmt().compareTo(Env.ZERO) != 0) {
                displayValue.append(" - @InterestAmt@: ").append(DisplayType.getNumberFormat(12).format(statementLine.getInterestAmt()));
                IsChanged[0] = true;
            }
            linesWithoutReference.append(displayValue);
        });
        if (linesWithoutReference.length() > 0 && IsChanged[0]) {
            throw new AdempiereException("@Error@" + Env.NL + " @C_Payment_ID@ @NotFound@ " + Env.NL + linesWithoutReference.toString());
        }
        MBankStatementLine[] lines = this.getLines(false);
        for (int i = 0; i < lines.length; ++i) {
            MBankStatementLine line = lines[i];
            if (line.getC_Payment_ID() == 0) continue;
            MPayment payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.get_TrxName());
            payment.setIsReconciled(true);
            payment.save(this.get_TrxName());
        }
        MBankAccount ba = this.getBankAccount();
        ba.load(this.get_TrxName());
        ba.setCurrentBalance(ba.getCurrentBalance().add(this.getStatementDifference()));
        ba.save(this.get_TrxName());
        String valid = ModelValidationEngine.get().fireDocValidate(this, 9);
        if (valid != null) {
            this.m_processMsg = valid;
            return "IN";
        }
        this.setProcessed(true);
        this.setDocAction("CL");
        return "CO";
    }

    @Override
    public boolean voidIt() {
        this.log.info(this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 2);
        if (this.m_processMsg != null) {
            return false;
        }
        if ("CL".equals(this.getDocStatus()) || "RE".equals(this.getDocStatus()) || "VO".equals(this.getDocStatus())) {
            this.m_processMsg = "Document Closed: " + this.getDocStatus();
            this.setDocAction("--");
            return false;
        }
        if (!("DR".equals(this.getDocStatus()) || "IN".equals(this.getDocStatus()) || "IP".equals(this.getDocStatus()) || "AP".equals(this.getDocStatus()) || "NA".equals(this.getDocStatus()))) {
            MPeriod.testPeriodOpen(this.getCtx(), this.getStatementDate(), "CMB", this.getAD_Org_ID());
            MFactAcct.deleteEx(Table_ID, this.getC_BankStatement_ID(), this.get_TrxName());
        }
        if (this.isProcessed()) {
            MBankAccount bankAccount = this.getBankAccount();
            bankAccount.load(this.get_TrxName());
            bankAccount.setCurrentBalance(bankAccount.getCurrentBalance().subtract(this.getStatementDifference()));
            bankAccount.saveEx();
        }
        MBankStatementLine[] lines = this.getLines(true);
        for (int i = 0; i < lines.length; ++i) {
            MBankStatementLine line = lines[i];
            if (line.getStmtAmt().compareTo(Env.ZERO) == 0) continue;
            String description = Msg.getMsg(this.getCtx(), "Voided") + " (" + Msg.translate(this.getCtx(), "StmtAmt") + "=" + line.getStmtAmt();
            if (line.getTrxAmt().compareTo(Env.ZERO) != 0) {
                description = description + ", " + Msg.translate(this.getCtx(), "TrxAmt") + "=" + line.getTrxAmt();
            }
            if (line.getChargeAmt().compareTo(Env.ZERO) != 0) {
                description = description + ", " + Msg.translate(this.getCtx(), "ChargeAmt") + "=" + line.getChargeAmt();
            }
            if (line.getInterestAmt().compareTo(Env.ZERO) != 0) {
                description = description + ", " + Msg.translate(this.getCtx(), "InterestAmt") + "=" + line.getInterestAmt();
            }
            description = description + ")";
            line.addDescription(description);
            line.setStmtAmt(Env.ZERO);
            line.setTrxAmt(Env.ZERO);
            line.setChargeAmt(Env.ZERO);
            line.setInterestAmt(Env.ZERO);
            if (line.getC_Payment_ID() != 0) {
                MPayment payment = new MPayment(this.getCtx(), line.getC_Payment_ID(), this.get_TrxName());
                payment.setIsReconciled(false);
                payment.saveEx();
                line.setC_Payment_ID(0);
            }
            line.saveEx();
        }
        this.addDescription(Msg.getMsg(this.getCtx(), "Voided"));
        this.setStatementDifference(Env.ZERO);
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 10);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setProcessed(true);
        this.setDocAction("--");
        return true;
    }

    @Override
    public boolean closeIt() {
        this.log.info("closeIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 3);
        if (this.m_processMsg != null) {
            return false;
        }
        this.setDocAction("--");
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 11);
        return this.m_processMsg == null;
    }

    @Override
    public boolean reverseCorrectIt() {
        this.log.info("reverseCorrectIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 5);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 13);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reverseAccrualIt() {
        this.log.info("reverseAccrualIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 6);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 14);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public boolean reActivateIt() {
        this.log.info("reActivateIt - " + this.toString());
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 4);
        if (this.m_processMsg != null) {
            return false;
        }
        this.m_processMsg = ModelValidationEngine.get().fireDocValidate(this, 12);
        if (this.m_processMsg != null) {
            return false;
        }
        return false;
    }

    @Override
    public String getSummary() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName());
        sb.append(": ").append(Msg.translate(this.getCtx(), "StatementDifference")).append("=").append(this.getStatementDifference()).append(" (#").append(this.getLines(false).length).append(")");
        if (this.getDescription() != null && this.getDescription().length() > 0) {
            sb.append(" - ").append(this.getDescription());
        }
        return sb.toString();
    }

    @Override
    public String getProcessMsg() {
        return this.m_processMsg;
    }

    @Override
    public int getDoc_User_ID() {
        return this.getUpdatedBy();
    }

    @Override
    public BigDecimal getApprovalAmt() {
        return this.getStatementDifference();
    }

    @Override
    public int getC_Currency_ID() {
        return 0;
    }

    public boolean isComplete() {
        String ds = this.getDocStatus();
        return "CO".equals(ds) || "CL".equals(ds) || "RE".equals(ds);
    }
}

