/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.adempiere.core.domains.models.I_M_InventoryLine;
import org.adempiere.model.GridTabWrapper;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MInventoryLine;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutInventory
extends CalloutEngine {
    public String product(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive()) {
            return "";
        }
        Integer InventoryLine = (Integer)mTab.getValue("M_InventoryLine_ID");
        BigDecimal bd = null;
        if (InventoryLine != null && InventoryLine != 0) {
            MInventoryLine _ILine = new MInventoryLine(ctx, InventoryLine, null);
            Integer M_Product_ID = (Integer)mTab.getValue("M_Product_ID");
            Integer M_Locator_ID = (Integer)mTab.getValue("M_Locator_ID");
            Integer M_AttributeSetInstance_ID = 0;
            if (M_Product_ID != null && M_Product_ID.intValue() != _ILine.getM_Product_ID() || M_Locator_ID != null && M_Locator_ID.intValue() != _ILine.getM_Locator_ID()) {
                if (M_Product_ID.intValue() == _ILine.getM_Product_ID()) {
                    M_AttributeSetInstance_ID = (Integer)mTab.getValue("M_AttributeSetInstance_ID");
                    if (M_AttributeSetInstance_ID == null) {
                        M_AttributeSetInstance_ID = 0;
                    }
                } else {
                    mTab.setValue("M_AttributeSetInstance_ID", null);
                }
                try {
                    bd = this.setQtyBook(M_AttributeSetInstance_ID, M_Product_ID, M_Locator_ID);
                    mTab.setValue("QtyBook", (Object)bd);
                }
                catch (Exception e) {
                    return mTab.setValue("QtyBook", (Object)bd);
                }
            }
            return "";
        }
        int M_Product_ID = 0;
        Integer Product2 = (Integer)mTab.getValue("M_Product_ID");
        if (Product2 != null) {
            M_Product_ID = Product2;
        }
        if (M_Product_ID == 0) {
            return "";
        }
        int M_Locator_ID = 0;
        Integer Locator2 = (Integer)mTab.getValue("M_Locator_ID");
        if (Locator2 != null) {
            M_Locator_ID = Locator2;
        }
        if (M_Locator_ID == 0) {
            return "";
        }
        int M_AttributeSetInstance_ID = 0;
        Integer ASI = (Integer)mTab.getValue("M_AttributeSetInstance_ID");
        if (ASI != null) {
            M_AttributeSetInstance_ID = ASI;
        }
        if ("M_Product_ID".equals(mField.getColumnName())) {
            M_AttributeSetInstance_ID = Env.getContextAsInt(ctx, WindowNo, 1113, "M_Product_ID") == M_Product_ID ? Env.getContextAsInt(ctx, WindowNo, 1113, "M_AttributeSetInstance_ID") : 0;
            if (M_AttributeSetInstance_ID != 0) {
                mTab.setValue("M_AttributeSetInstance_ID", (Object)M_AttributeSetInstance_ID);
            } else {
                mTab.setValue("M_AttributeSetInstance_ID", null);
            }
        }
        try {
            bd = this.setQtyBook(M_AttributeSetInstance_ID, M_Product_ID, M_Locator_ID);
            mTab.setValue("QtyBook", (Object)bd);
        }
        catch (Exception e) {
            return mTab.setValue("QtyBook", (Object)bd);
        }
        this.log.info("M_Product_ID=" + M_Product_ID + ", M_Locator_ID=" + M_Locator_ID + ", M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID + " - QtyBook=" + bd);
        return "";
    }

    private BigDecimal setQtyBook(int M_AttributeSetInstance_ID, int M_Product_ID, int M_Locator_ID) throws Exception {
        BigDecimal bd = null;
        String sql = "SELECT QtyOnHand FROM M_Storage WHERE M_Product_ID=? AND M_Locator_ID=? AND M_AttributeSetInstance_ID=?";
        if (M_AttributeSetInstance_ID == 0) {
            sql = "SELECT SUM(QtyOnHand) FROM M_Storage WHERE M_Product_ID=? AND M_Locator_ID=?";
        }
        try {
            ResultSet rs;
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, M_Product_ID);
            pstmt.setInt(2, M_Locator_ID);
            if (M_AttributeSetInstance_ID != 0) {
                pstmt.setInt(3, M_AttributeSetInstance_ID);
            }
            if ((rs = pstmt.executeQuery()).next()) {
                bd = rs.getBigDecimal(1);
                if (bd != null) {
                    return bd;
                }
            } else {
                return new BigDecimal(0);
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, sql, e);
            throw new Exception(e.getLocalizedMessage());
        }
        return new BigDecimal(0);
    }

    public String checkOnHand(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        I_M_InventoryLine line = GridTabWrapper.create(mTab, I_M_InventoryLine.class);
        if (line.getM_Product_ID() == 0) {
            return "";
        }
        if (line.getM_Product().isStocked() && line.getQtyInternalUse().signum() > 0) {
            BigDecimal qtyInternalUse = line.getQtyInternalUse();
            BigDecimal qtyOnHand = DB.getSQLValueBD(null, "SELECT bomQtyOnHand(M_Product_ID,?,?) FROM M_Product WHERE M_Product_ID=?", line.getM_Inventory().getM_Warehouse_ID(), 0, line.getM_Product_ID());
            if (qtyOnHand == null) {
                qtyOnHand = Env.ZERO;
            }
            if (qtyOnHand.signum() == 0) {
                mTab.fireDataStatusEEvent("NoQtyAvailable", "0", false);
            } else if (qtyOnHand.compareTo(qtyInternalUse) < 0) {
                mTab.fireDataStatusEEvent("InsufficientQtyAvailable", qtyOnHand.toString(), false);
            }
        }
        return "";
    }
}

