/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutCashJournal
extends CalloutEngine {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String invoice(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        Timestamp ts;
        if (this.isCalloutActive()) {
            return "";
        }
        Integer C_Invoice_ID = (Integer)value;
        if (C_Invoice_ID == null || C_Invoice_ID == 0) {
            mTab.setValue("C_Currency_ID", null);
            return "";
        }
        int C_InvoicePaySchedule_ID = 0;
        if (Env.getContextAsInt(ctx, WindowNo, 1113, "C_Invoice_ID") == C_Invoice_ID && Env.getContextAsInt(ctx, WindowNo, 1113, "C_InvoicePaySchedule_ID") != 0) {
            C_InvoicePaySchedule_ID = Env.getContextAsInt(ctx, WindowNo, 1113, "C_InvoicePaySchedule_ID");
        }
        if ((ts = Env.getContextAsDate(ctx, WindowNo, "DateAcct")) == null) {
            ts = new Timestamp(System.currentTimeMillis());
        }
        String sql = "SELECT C_BPartner_ID, C_Currency_ID,invoiceOpen(C_Invoice_ID, ?), IsSOTrx, invoiceDiscount(C_Invoice_ID,?,?) FROM C_Invoice WHERE C_Invoice_ID=?";
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, C_InvoicePaySchedule_ID);
            pstmt.setTimestamp(2, ts);
            pstmt.setInt(3, C_InvoicePaySchedule_ID);
            pstmt.setInt(4, C_Invoice_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                mTab.setValue("C_Currency_ID", (Object)rs.getInt(2));
                BigDecimal PayAmt = rs.getBigDecimal(3);
                BigDecimal DiscountAmt = rs.getBigDecimal(5);
                boolean isSOTrx = "Y".equals(rs.getString(4));
                if (!isSOTrx) {
                    PayAmt = PayAmt.negate();
                    DiscountAmt = DiscountAmt.negate();
                }
                mTab.setValue("Amount", (Object)PayAmt.subtract(DiscountAmt));
                mTab.setValue("DiscountAmt", (Object)DiscountAmt);
                mTab.setValue("WriteOffAmt", (Object)Env.ZERO);
                Env.setContext(ctx, WindowNo, "InvTotalAmt", PayAmt.toString());
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            this.log.log(Level.SEVERE, "invoice", e);
            String string = e.getLocalizedMessage();
            return string;
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        return "";
    }

    public String amounts(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (this.isCalloutActive() || !"I".equals(mTab.getValue("CashType"))) {
            return "";
        }
        String total = Env.getContext(ctx, WindowNo, "InvTotalAmt");
        if (total == null || total.length() == 0) {
            return "";
        }
        BigDecimal InvTotalAmt = new BigDecimal(total);
        BigDecimal PayAmt = (BigDecimal)mTab.getValue("Amount");
        BigDecimal DiscountAmt = (BigDecimal)mTab.getValue("DiscountAmt");
        BigDecimal WriteOffAmt = (BigDecimal)mTab.getValue("WriteOffAmt");
        String colName = mField.getColumnName();
        this.log.fine(colName + " - Invoice=" + InvTotalAmt + " - Amount=" + PayAmt + ", Discount=" + DiscountAmt + ", WriteOff=" + WriteOffAmt);
        if (colName.equals("Amount")) {
            WriteOffAmt = InvTotalAmt.subtract(PayAmt).subtract(DiscountAmt);
            mTab.setValue("WriteOffAmt", (Object)WriteOffAmt);
        } else {
            PayAmt = InvTotalAmt.subtract(DiscountAmt).subtract(WriteOffAmt);
            mTab.setValue("Amount", (Object)PayAmt);
        }
        return "";
    }
}

