/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MBankAccount;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;

public class CalloutBankStatement
extends CalloutEngine {
    public String bankAccount(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        if (value == null) {
            return "";
        }
        int C_BankAccount_ID = (Integer)value;
        MBankAccount ba = MBankAccount.get(ctx, C_BankAccount_ID);
        ba.load(ba.get_TrxName());
        mTab.setValue("BeginningBalance", (Object)ba.getCurrentBalance());
        return "";
    }

    public String amount(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        BigDecimal trx;
        if (this.isCalloutActive()) {
            return "";
        }
        BigDecimal stmt = (BigDecimal)mTab.getValue("StmtAmt");
        if (stmt == null) {
            stmt = Env.ZERO;
        }
        if ((trx = (BigDecimal)mTab.getValue("TrxAmt")) == null) {
            trx = Env.ZERO;
        }
        BigDecimal bd = stmt.subtract(trx);
        if (mField.getColumnName().equals("ChargeAmt")) {
            BigDecimal charge = (BigDecimal)value;
            if (charge == null) {
                charge = Env.ZERO;
            }
            bd = bd.subtract(charge);
            mTab.setValue("InterestAmt", (Object)bd);
        } else {
            BigDecimal interest = (BigDecimal)mTab.getValue("InterestAmt");
            if (interest == null) {
                interest = Env.ZERO;
            }
            bd = bd.subtract(interest);
            mTab.setValue("ChargeAmt", (Object)bd);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String payment(Properties ctx, int WindowNo, GridTab mTab, GridField mField, Object value) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block7: {
            Integer C_Payment_ID = (Integer)value;
            if (C_Payment_ID == null || C_Payment_ID == 0) {
                return "";
            }
            BigDecimal stmt = (BigDecimal)mTab.getValue("StmtAmt");
            if (stmt == null) {
                stmt = Env.ZERO;
            }
            String sql = "SELECT PayAmt FROM C_Payment_v WHERE C_Payment_ID=?";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setInt(1, C_Payment_ID);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block7;
                BigDecimal bd = rs.getBigDecimal(1);
                mTab.setValue("TrxAmt", (Object)bd);
                if (stmt.compareTo(Env.ZERO) == 0) {
                    mTab.setValue("StmtAmt", (Object)bd);
                }
            }
            catch (SQLException e) {
                String string;
                try {
                    this.log.log(Level.SEVERE, "BankStmt_Payment", e);
                    string = e.getLocalizedMessage();
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                return string;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.amount(ctx, WindowNo, mTab, mField, value);
        return "";
    }
}

