/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.grid.ed;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.adempiere.core.domains.models.X_M_AttributeValue;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.AWindow;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.search.PAttributeInstance;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VNumber;
import org.compiere.grid.ed.VString;
import org.compiere.model.MAttribute;
import org.compiere.model.MAttributeInstance;
import org.compiere.model.MAttributeSet;
import org.compiere.model.MAttributeSetInstance;
import org.compiere.model.MAttributeValue;
import org.compiere.model.MDocType;
import org.compiere.model.MLot;
import org.compiere.model.MLotCtl;
import org.compiere.model.MProduct;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MSerNoCtl;
import org.compiere.model.MWindow;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CDialog;
import org.compiere.swing.CEditor;
import org.compiere.swing.CLabel;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VPAttributeDialog
extends CDialog
implements ActionListener {
    private static final long serialVersionUID = -1062346984681892620L;
    private boolean m_readWrite;
    private int windowNo;
    private MAttributeSetInstance attributeSetInstance;
    private int attributeSetInstanceId;
    private int locatorId;
    private String attributeSetInstanceName;
    private int productId;
    private int partnerId;
    private int columnId;
    private int windowNoParent;
    private boolean productWindow = false;
    private boolean changed = false;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private int row = 0;
    private ArrayList<CEditor> editors = new ArrayList();
    private static final int INSTANCE_VALUE_LENGTH = 40;
    private CCheckBox cbNewEdit = new CCheckBox();
    private CButton bSelect = new CButton(Env.getImageIcon("PAttribute16.gif"));
    private VString fieldLotString = new VString("Lot", false, false, true, 20, 20, null, null);
    private CComboBox fieldLot = null;
    private CButton bLot = new CButton(Msg.getMsg(Env.getCtx(), "New"));
    JPopupMenu popupMenu = new JPopupMenu();
    private CMenuItem mZoom;
    private VString fieldSerNo = new VString("SerNo", false, false, true, 20, 20, null, null);
    private CButton bSerNo = new CButton(Msg.getMsg(Env.getCtx(), "New"));
    private VDate fieldGuaranteeDate = new VDate("GuaranteeDate", false, false, true, 15, Msg.translate(Env.getCtx(), "GuaranteeDate"));
    private CTextField fieldDescription = new CTextField(20);
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel centerPanel = new CPanel();
    private ALayout centerLayout = new ALayout(5, 5, true);
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private String m_columnName = null;
    private MProduct m_product;
    private boolean m_productASI;

    public VPAttributeDialog(Frame frame, int M_AttributeSetInstance_ID, int M_Product_ID, int C_BPartner_ID, boolean productWindow, int AD_Column_ID, int WindowNo, boolean readWrite) {
        super(frame, Msg.translate(Env.getCtx(), "M_AttributeSetInstance_ID"), true);
        this.log.config("M_AttributeSetInstance_ID=" + M_AttributeSetInstance_ID + ", M_Product_ID=" + M_Product_ID + ", C_BPartner_ID=" + C_BPartner_ID + ", ProductW=" + productWindow + ", Column=" + AD_Column_ID);
        this.windowNo = Env.createWindowNo(this);
        this.attributeSetInstanceId = M_AttributeSetInstance_ID;
        this.productId = M_Product_ID;
        this.partnerId = C_BPartner_ID;
        this.productWindow = productWindow;
        this.columnId = AD_Column_ID;
        this.windowNoParent = WindowNo;
        this.m_readWrite = readWrite;
        this.m_columnName = DB.getSQLValueString(null, "SELECT ColumnName FROM AD_Column WHERE AD_Column_ID = ?", this.columnId);
        if (this.m_columnName == null || this.m_columnName.trim().length() == 0) {
            this.m_columnName = "M_AttributeSetInstance_ID";
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "VPAttributeDialog" + ex);
        }
        if (!this.initAttributes()) {
            this.dispose();
            return;
        }
        AEnv.showCenterWindow(frame, this);
    }

    private void jbInit() throws Exception {
        this.getContentPane().setLayout(this.mainLayout);
        this.getContentPane().add((Component)this.centerPanel, "Center");
        this.getContentPane().add((Component)this.confirmPanel, "South");
        this.centerPanel.setLayout(this.centerLayout);
        this.confirmPanel.addActionListener(this);
    }

    private boolean initAttributes() {
        int i;
        if (this.productId == 0 && !this.productWindow) {
            return false;
        }
        MAttributeSet as = null;
        if (this.productId != 0) {
            this.m_product = MProduct.get(Env.getCtx(), this.productId);
            if (this.m_product.getM_AttributeSetInstance_ID() > 0) {
                this.m_productASI = true;
                if (this.attributeSetInstanceId != this.m_product.getM_AttributeSetInstance_ID()) {
                    this.log.fine("Different ASI than what is specified on Product!");
                }
            } else {
                this.m_productASI = this.productWindow;
            }
            this.attributeSetInstance = MAttributeSetInstance.get(Env.getCtx(), this.attributeSetInstanceId, this.productId);
            if (this.attributeSetInstance == null) {
                this.log.severe("No Model for M_AttributeSetInstance_ID=" + this.attributeSetInstanceId + ", M_Product_ID=" + this.productId);
                return false;
            }
            Env.setContext(Env.getCtx(), this.windowNo, "M_AttributeSet_ID", this.attributeSetInstance.getM_AttributeSet_ID());
            as = this.attributeSetInstance.getMAttributeSet();
        } else {
            int M_AttributeSet_ID = Env.getContextAsInt(Env.getCtx(), this.windowNoParent, "M_AttributeSet_ID");
            this.attributeSetInstance = new MAttributeSetInstance(Env.getCtx(), 0, M_AttributeSet_ID, null);
            as = this.attributeSetInstance.getMAttributeSet();
        }
        if (as == null) {
            // empty if block
        }
        if (!this.productWindow || !this.m_productASI) {
            if (!this.m_productASI) {
                if (this.attributeSetInstanceId == 0) {
                    this.cbNewEdit.setText(Msg.getMsg(Env.getCtx(), "NewRecord"));
                } else {
                    this.cbNewEdit.setText(Msg.getMsg(Env.getCtx(), "EditRecord"));
                }
                this.cbNewEdit.addActionListener(this);
                this.centerPanel.add((Component)this.cbNewEdit, new ALayoutConstraint(this.row++, 0));
                this.bSelect.setText(Msg.getMsg(Env.getCtx(), "SelectExisting"));
                this.bSelect.addActionListener(this);
                this.centerPanel.add((Component)this.bSelect, null);
            }
            MAttribute[] attributes = as.getMAttributes(true);
            this.log.fine("Instance Attributes=" + attributes.length);
            for (i = 0; i < attributes.length; ++i) {
                this.addAttributeLine(attributes[i], false, false);
            }
        }
        if (as != null) {
            MAttribute[] attributes = as.getMAttributes(false);
            this.log.fine("Product Attributes=" + attributes.length);
            for (i = 0; i < attributes.length; ++i) {
                this.addAttributeLine(attributes[i], true, !this.productWindow);
            }
        }
        if (!(this.productWindow && this.m_productASI || !as.isLot())) {
            CLabel label = new CLabel(Msg.translate(Env.getCtx(), "Lot"));
            label.setLabelFor(this.fieldLotString);
            this.centerPanel.add((Component)label, new ALayoutConstraint(this.row++, 0));
            this.centerPanel.add((Component)this.fieldLotString, null);
            this.fieldLotString.setText(this.attributeSetInstance.getLot());
            List keyNamePairLotList = MLot.getByAttributeSetId(Env.getCtx(), this.attributeSetInstance.getM_AttributeSet_ID(), this.attributeSetInstance.get_TrxName()).stream().map(lot -> new KeyNamePair(lot.getM_Lot_ID(), lot.getName())).collect(Collectors.toList());
            this.fieldLot = new CComboBox(keyNamePairLotList.toArray());
            label = new CLabel(Msg.translate(Env.getCtx(), "M_Lot_ID"));
            label.setLabelFor(this.fieldLot);
            this.centerPanel.add((Component)label, new ALayoutConstraint(this.row++, 0));
            this.centerPanel.add((Component)this.fieldLot, null);
            if (this.attributeSetInstance.getM_Lot_ID() != 0) {
                for (int i2 = 1; i2 < this.fieldLot.getItemCount(); ++i2) {
                    KeyNamePair pp = (KeyNamePair)this.fieldLot.getItemAt(i2);
                    if (pp.getKey() != this.attributeSetInstance.getM_Lot_ID()) continue;
                    this.fieldLot.setSelectedIndex(i2);
                    this.fieldLotString.setEditable(false);
                    break;
                }
            }
            this.fieldLot.addActionListener(this);
            if (this.attributeSetInstance.getMAttributeSet().getM_LotCtl_ID() != 0 && this.m_readWrite && MRole.getDefault().isTableAccess(MLot.Table_ID, false) && MRole.getDefault().isTableAccess(MLotCtl.Table_ID, false) && !this.attributeSetInstance.isExcludeLot(this.columnId, Env.isSOTrx(Env.getCtx(), this.windowNoParent))) {
                this.centerPanel.add((Component)this.bLot, null);
                this.bLot.addActionListener(this);
            }
            this.fieldLot.addMouseListener(new VPAttributeDialog_mouseAdapter(this));
            this.mZoom = new CMenuItem(Msg.getMsg(Env.getCtx(), "Zoom"), Env.getImageIcon("Zoom16.gif"));
            this.mZoom.addActionListener(this);
            this.popupMenu.add(this.mZoom);
        }
        if (!(this.productWindow && this.m_productASI || !as.isSerNo())) {
            CLabel label = new CLabel(Msg.translate(Env.getCtx(), "SerNo"));
            label.setLabelFor(this.fieldSerNo);
            this.fieldSerNo.setText(this.attributeSetInstance.getSerNo());
            this.centerPanel.add((Component)label, new ALayoutConstraint(this.row++, 0));
            this.centerPanel.add((Component)this.fieldSerNo, null);
            if (this.attributeSetInstance.getMAttributeSet().getM_SerNoCtl_ID() != 0 && this.m_readWrite && MRole.getDefault().isTableAccess(MSerNoCtl.Table_ID, false) && !this.attributeSetInstance.isExcludeSerNo(this.columnId, Env.isSOTrx(Env.getCtx(), this.windowNoParent))) {
                this.centerPanel.add((Component)this.bSerNo, null);
                this.bSerNo.addActionListener(this);
            }
        }
        if (!(this.productWindow && this.m_productASI || !as.isGuaranteeDate())) {
            CLabel label = new CLabel(Msg.translate(Env.getCtx(), "GuaranteeDate"));
            label.setLabelFor(this.fieldGuaranteeDate);
            if (this.attributeSetInstanceId == 0) {
                this.fieldGuaranteeDate.setValue(this.attributeSetInstance.getGuaranteeDate(true));
            } else {
                this.fieldGuaranteeDate.setValue(this.attributeSetInstance.getGuaranteeDate());
            }
            this.centerPanel.add((Component)label, new ALayoutConstraint(this.row++, 0));
            this.centerPanel.add((Component)this.fieldGuaranteeDate, null);
        }
        if (this.row == 0) {
            ADialog.error(this.windowNo, this, "PAttributeNoInfo");
        }
        if (!(this.productWindow && this.m_productASI || this.columnId == 0 || !this.m_readWrite)) {
            this.cbNewEdit.setSelected(this.attributeSetInstanceId == 0);
            this.cmd_newEdit();
        }
        CLabel label = new CLabel(Msg.translate(Env.getCtx(), "Description"));
        label.setLabelFor(this.fieldDescription);
        this.fieldDescription.setText(this.attributeSetInstance.getDescription());
        this.fieldDescription.setEditable(false);
        this.centerPanel.add((Component)label, new ALayoutConstraint(this.row++, 0));
        this.centerPanel.add((Component)this.fieldDescription, null);
        Dimension dd = this.centerPanel.getPreferredSize();
        dd.width = Math.min(500, dd.width);
        this.centerPanel.setPreferredSize(dd);
        return true;
    }

    private void addAttributeLine(MAttribute attribute, boolean product, boolean readOnly) {
        this.log.fine(attribute + ", Product=" + product + ", R/O=" + readOnly);
        CLabel label = new CLabel(attribute.getName());
        if (product) {
            label.setFont(new Font(label.getFont().getFontName(), 1, label.getFont().getSize()));
        }
        if (attribute.getDescription() != null) {
            label.setToolTipText(attribute.getDescription());
        }
        this.centerPanel.add((Component)label, new ALayoutConstraint(this.row++, 0));
        MAttributeInstance instance = attribute.getMAttributeInstance(this.attributeSetInstanceId);
        if ("L".equals(attribute.getAttributeValueType())) {
            Object[] values = attribute.getMAttributeValues();
            CComboBox editor = new CComboBox(values);
            boolean found = false;
            if (instance != null) {
                for (int i = 0; i < values.length; ++i) {
                    if (values[i] == null || ((X_M_AttributeValue)values[i]).getM_AttributeValue_ID() != instance.getM_AttributeValue_ID()) continue;
                    editor.setSelectedIndex(i);
                    found = true;
                    break;
                }
                if (found) {
                    this.log.fine("Attribute=" + attribute.getName() + " #" + values.length + " - found: " + instance);
                } else {
                    this.log.warning("Attribute=" + attribute.getName() + " #" + values.length + " - NOT found: " + instance);
                }
            } else {
                this.log.fine("Attribute=" + attribute.getName() + " #" + values.length + " no instance");
            }
            label.setLabelFor(editor);
            this.centerPanel.add((Component)editor, null);
            if (readOnly) {
                editor.setEnabled(false);
            } else {
                this.editors.add(editor);
            }
        } else if ("N".equals(attribute.getAttributeValueType())) {
            VNumber editor = new VNumber(attribute.getName(), attribute.isMandatory(), readOnly, !readOnly, 22, attribute.getName());
            if (instance != null) {
                editor.setValue(instance.getValueNumber());
            } else {
                editor.setValue(Env.ZERO);
            }
            label.setLabelFor(editor);
            this.centerPanel.add((Component)editor, null);
            if (readOnly) {
                editor.setEnabled(false);
            } else {
                this.editors.add(editor);
            }
        } else {
            VString editor = new VString(attribute.getName(), attribute.isMandatory(), false, true, 20, 40, null, null);
            if (instance != null) {
                editor.setText(instance.getValue());
            }
            label.setLabelFor(editor);
            this.centerPanel.add((Component)editor, null);
            if (readOnly) {
                editor.setEnabled(false);
            } else {
                this.editors.add(editor);
            }
        }
    }

    @Override
    public void dispose() {
        this.removeAll();
        Env.clearWinContext(this.windowNo);
        Env.setContext(Env.getCtx(), this.windowNo, 1113, this.m_columnName, String.valueOf(this.attributeSetInstanceId));
        Env.setContext(Env.getCtx(), this.windowNo, 1113, "M_Locator_ID", String.valueOf(this.locatorId));
        super.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bSelect) {
            if (this.cmd_select()) {
                this.dispose();
            }
        } else if (e.getSource() == this.cbNewEdit) {
            this.cmd_newEdit();
        } else if (e.getSource() == this.fieldLot) {
            KeyNamePair pp = (KeyNamePair)this.fieldLot.getSelectedItem();
            if (pp != null && pp.getKey() != -1) {
                this.fieldLotString.setText(pp.getName());
                this.fieldLotString.setEditable(false);
                this.attributeSetInstance.setM_Lot_ID(pp.getKey());
            } else {
                this.fieldLotString.setEditable(true);
                this.attributeSetInstance.setM_Lot_ID(0);
            }
        } else if (e.getSource() == this.bLot) {
            KeyNamePair pp = this.attributeSetInstance.createLot(this.productId);
            if (pp != null) {
                this.fieldLot.addItem(pp);
                this.fieldLot.setSelectedItem(pp);
                this.fieldLotString.setText(this.attributeSetInstance.getLot());
                this.fieldLotString.setEditable(false);
            }
        } else if (e.getSource() == this.bSerNo) {
            this.fieldSerNo.setText(this.attributeSetInstance.getSerNo(true));
        } else if (e.getActionCommand().equals("Ok")) {
            if (this.saveSelection()) {
                this.dispose();
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            if (this.productWindow || !this.m_productASI) {
                this.changed = this.attributeSetInstanceId != 0;
                this.attributeSetInstanceId = 0;
                this.locatorId = 0;
            }
            this.dispose();
        } else if (e.getSource() == this.mZoom) {
            this.cmd_zoom();
        } else {
            this.log.log(Level.SEVERE, "not found - " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean cmd_select() {
        MDocType doctype;
        String docbase;
        this.log.config("");
        int M_Warehouse_ID = Env.getContextAsInt(Env.getCtx(), this.windowNoParent, "M_Warehouse_ID");
        int C_DocType_ID = Env.getContextAsInt(Env.getCtx(), this.windowNoParent, "C_DocType_ID");
        if (C_DocType_ID > 0 && ((docbase = (doctype = new MDocType(Env.getCtx(), C_DocType_ID, null)).getDocBaseType()).equals("MMR") || docbase.equals("MMI"))) {
            M_Warehouse_ID = 0;
        }
        int M_Locator_ID = 0;
        M_Locator_ID = Env.getContextAsInt(Env.getCtx(), this.windowNoParent, "M_Locator_ID", true);
        Object title = "";
        String sql = "SELECT p.Name, w.Name, w.M_Warehouse_ID FROM M_Product p, M_Warehouse w WHERE p.M_Product_ID=? AND w.M_Warehouse_ID" + (M_Locator_ID <= 0 ? "=?" : " IN (SELECT M_Warehouse_ID FROM M_Locator where M_Locator_ID=?)");
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            pstmt.setInt(1, this.productId);
            pstmt.setInt(2, M_Locator_ID <= 0 ? M_Warehouse_ID : M_Locator_ID);
            rs = pstmt.executeQuery();
            if (rs.next()) {
                title = ": " + rs.getString(1) + " - " + rs.getString(2);
                M_Warehouse_ID = rs.getInt(3);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        PAttributeInstance pai = new PAttributeInstance(this, (String)title, M_Warehouse_ID, M_Locator_ID, this.productId, this.partnerId);
        if (this.attributeSetInstanceId != pai.getM_AttributeSetInstance_ID() || this.attributeSetInstanceId != 0 || pai.getM_AttributeSetInstance_ID() != -1) {
            this.changed = true;
            if (pai.getM_AttributeSetInstance_ID() != -1) {
                this.attributeSetInstanceId = pai.getM_AttributeSetInstance_ID();
                this.attributeSetInstanceName = pai.getM_AttributeSetInstanceName();
                this.locatorId = pai.getM_Locator_ID();
            } else {
                this.attributeSetInstanceId = 0;
                this.attributeSetInstanceName = "";
            }
        }
        return this.changed;
    }

    private void cmd_newEdit() {
        boolean rw = this.cbNewEdit.isSelected();
        this.log.config("R/W=" + rw + " " + this.attributeSetInstance);
        this.fieldLotString.setEditable(rw && this.attributeSetInstance.getM_Lot_ID() == 0);
        if (this.fieldLot != null) {
            this.fieldLot.setReadWrite(rw);
        }
        this.bLot.setReadWrite(rw);
        this.fieldSerNo.setReadWrite(rw);
        this.bSerNo.setReadWrite(rw);
        this.fieldGuaranteeDate.setReadWrite(rw);
        for (int i = 0; i < this.editors.size(); ++i) {
            CEditor editor = this.editors.get(i);
            editor.setReadWrite(rw);
        }
    }

    private void cmd_zoom() {
        int M_Lot_ID = 0;
        KeyNamePair pp = (KeyNamePair)this.fieldLot.getSelectedItem();
        if (pp != null) {
            M_Lot_ID = pp.getKey();
        }
        MQuery zoomQuery = new MQuery("M_Lot");
        zoomQuery.addRestriction("M_Lot_ID", "=", M_Lot_ID);
        this.log.info(zoomQuery.toString());
        this.setCursor(Cursor.getPredefinedCursor(3));
        int AD_Window_ID = MWindow.getWindow_ID("Lot");
        AWindow frame = new AWindow();
        if (frame.initWindow(AD_Window_ID, zoomQuery)) {
            this.setVisible(false);
            this.setModal(false);
            this.setVisible(true);
            AEnv.addToWindowManager(frame);
            AEnv.showScreen(frame, 3);
        }
        frame = null;
        this.setCursor(Cursor.getDefaultCursor());
    }

    private boolean saveSelection() {
        String text;
        if (!this.m_readWrite) {
            return true;
        }
        this.log.info("");
        MAttributeSet as = this.attributeSetInstance.getMAttributeSet();
        if (as == null) {
            return true;
        }
        this.changed = false;
        Object mandatory = "";
        if (!(this.productWindow && this.m_productASI || !as.isLot())) {
            this.log.fine("Lot=" + this.fieldLotString.getText());
            text = this.fieldLotString.getText();
            this.attributeSetInstance.setLot(text);
            if (as.isLotMandatory() && (text == null || text.length() == 0)) {
                mandatory = (String)mandatory + " - " + Msg.translate(Env.getCtx(), "Lot");
            }
            this.changed = true;
        }
        if (!(this.productWindow && this.m_productASI || !as.isSerNo())) {
            this.log.fine("SerNo=" + this.fieldSerNo.getText());
            text = this.fieldSerNo.getText();
            this.attributeSetInstance.setSerNo(text);
            if (as.isSerNoMandatory() && (text == null || text.length() == 0)) {
                mandatory = (String)mandatory + " - " + Msg.translate(Env.getCtx(), "SerNo");
            }
            this.changed = true;
        }
        if (!(this.productWindow && this.m_productASI || !as.isGuaranteeDate())) {
            this.log.fine("GuaranteeDate=" + this.fieldGuaranteeDate.getValue());
            Timestamp ts = (Timestamp)this.fieldGuaranteeDate.getValue();
            this.attributeSetInstance.setGuaranteeDate(ts);
            if (as.isGuaranteeDateMandatory() && ts == null) {
                mandatory = (String)mandatory + " - " + Msg.translate(Env.getCtx(), "GuaranteeDate");
            }
            this.changed = true;
        }
        if (this.changed || this.attributeSetInstance.getM_AttributeSetInstance_ID() == 0) {
            this.attributeSetInstance.save();
            this.attributeSetInstanceId = this.attributeSetInstance.getM_AttributeSetInstance_ID();
            this.attributeSetInstanceName = this.attributeSetInstance.getDescription();
        }
        if (this.attributeSetInstanceId > 0 && this.m_readWrite) {
            MAttribute[] attributes = as.getMAttributes(!this.m_productASI);
            for (int i = 0; i < attributes.length; ++i) {
                Object value;
                JComponent editor;
                if ("L".equals(attributes[i].getAttributeValueType())) {
                    editor = (CComboBox)this.editors.get(i);
                    value = (MAttributeValue)((JComboBox)editor).getSelectedItem();
                    this.log.fine(attributes[i].getName() + "=" + (MAttributeValue)value);
                    if (attributes[i].isMandatory() && value == null) {
                        mandatory = (String)mandatory + " - " + attributes[i].getName();
                    }
                    attributes[i].setMAttributeInstance(this.attributeSetInstanceId, (MAttributeValue)value);
                    continue;
                }
                if ("N".equals(attributes[i].getAttributeValueType())) {
                    editor = (VNumber)this.editors.get(i);
                    value = (BigDecimal)((VNumber)editor).getValue();
                    this.log.fine(attributes[i].getName() + "=" + (BigDecimal)value);
                    if (attributes[i].isMandatory() && value == null) {
                        mandatory = (String)mandatory + " - " + attributes[i].getName();
                    }
                    if (value != null && ((BigDecimal)value).scale() == 0) {
                        value = ((BigDecimal)value).setScale(1, RoundingMode.HALF_UP);
                    }
                    attributes[i].setMAttributeInstance(this.attributeSetInstanceId, (BigDecimal)value);
                    continue;
                }
                editor = (VString)this.editors.get(i);
                value = ((VString)editor).getText();
                this.log.fine(attributes[i].getName() + "=" + (String)value);
                if (attributes[i].isMandatory() && (value == null || ((String)value).length() == 0)) {
                    mandatory = (String)mandatory + " - " + attributes[i].getName();
                }
                attributes[i].setMAttributeInstance(this.attributeSetInstanceId, (String)value);
            }
            this.changed = true;
        }
        if (this.changed) {
            this.attributeSetInstance.setDescription();
            this.attributeSetInstance.save();
        }
        this.attributeSetInstanceId = this.attributeSetInstance.getM_AttributeSetInstance_ID();
        this.attributeSetInstanceName = this.attributeSetInstance.getDescription();
        if (((String)mandatory).length() > 0) {
            ADialog.error(this.windowNo, this, "FillMandatory", (String)mandatory);
            return false;
        }
        return true;
    }

    public int getM_AttributeSetInstance_ID() {
        return this.attributeSetInstanceId;
    }

    public String getM_AttributeSetInstanceName() {
        return this.attributeSetInstanceName;
    }

    public int getM_Locator_ID() {
        return this.locatorId;
    }

    public boolean isChanged() {
        return this.changed;
    }

    final class VPAttributeDialog_mouseAdapter
    extends MouseAdapter {
        private VPAttributeDialog m_adaptee;

        VPAttributeDialog_mouseAdapter(VPAttributeDialog adaptee) {
            this.m_adaptee = adaptee;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (SwingUtilities.isRightMouseButton(e)) {
                this.m_adaptee.popupMenu.show((Component)e.getSource(), e.getX(), e.getY());
            }
        }
    }
}

