/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.db;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Optional;
import java.util.logging.Level;
import javax.naming.InitialContext;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.RowSet;
import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.DBException;
import org.compiere.Adempiere;
import org.compiere.db.AdempiereDatabase;
import org.compiere.db.CConnection;
import org.compiere.db.Database;
import org.compiere.dbPort.Convert;
import org.compiere.dbPort.Convert_MySQL;
import org.compiere.model.PO;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Ini;

public class DB_MySQL
implements AdempiereDatabase {
    private org.gjt.mm.mysql.Driver s_driver = null;
    public static final String DRIVER = "org.gjt.mm.mysql.Driver";
    public static final int DEFAULT_PORT = 3306;
    private DataSource datasourceLongRunning = null;
    private DataSource datasourceShortRunning = null;
    private Convert_MySQL m_convert = new Convert_MySQL();
    private String m_connection;
    private String m_dbName = null;
    private String m_userName = null;
    private String m_connectionURL;
    private static CLogger log = CLogger.getCLogger(DB_MySQL.class);
    private static int m_maxbusyconnections = 0;

    @Override
    public Convert getConvert() {
        return this.m_convert;
    }

    @Override
    public String getName() {
        return Database.DB_MYSQL;
    }

    @Override
    public String getDescription() {
        try {
            if (this.s_driver == null) {
                this.getDriver();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.s_driver != null) {
            return this.s_driver.toString();
        }
        return "No Driver for MySQL";
    }

    @Override
    public int getStandardPort() {
        return 3306;
    }

    @Override
    public Driver getDriver() throws SQLException {
        if (this.s_driver == null) {
            this.s_driver = new org.gjt.mm.mysql.Driver();
            DriverManager.registerDriver((Driver)this.s_driver);
            DriverManager.setLoginTimeout(Database.CONNECTION_TIMEOUT);
        }
        return this.s_driver;
    }

    @Override
    public String getConnectionURL(CConnection connection) {
        StringBuffer sb = new StringBuffer("jdbc:mysql:");
        sb.append("//").append(connection.getDbHost()).append(":").append(connection.getDbPort()).append("/").append(connection.getDbName()).append("?encoding=UNICODE");
        this.m_connection = sb.toString();
        return this.m_connection;
    }

    @Override
    public String getConnectionURL(String dbHost, int dbPort, String dbName, String userName) {
        return "jdbc:mysql://" + dbHost + ":" + dbPort + "/" + dbName;
    }

    @Override
    public String getConnectionURL(String connectionURL, String userName) {
        this.m_userName = userName;
        this.m_connectionURL = connectionURL;
        return this.m_connectionURL;
    }

    @Override
    public String getCatalog() {
        if (this.m_dbName != null) {
            return this.m_dbName;
        }
        log.severe("Database Name not set (yet) - call getConnectionURL first");
        return null;
    }

    @Override
    public String getSchema() {
        if (this.m_userName == null) {
            CConnection cconn = CConnection.get(Adempiere.getCodeBaseHost());
            this.m_userName = cconn.getDbUid();
        }
        if (this.m_userName == null) {
            log.severe("User Name not set (yet) - call getConnectionURL first");
            return null;
        }
        return this.m_userName;
    }

    @Override
    public boolean supportsBLOB() {
        return true;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer("DB_MySQL[");
        sb.append(this.m_connectionURL);
        try {
            StringBuffer logBuffer = new StringBuffer(50);
            logBuffer.append("# Connections: ").append(this.datasourceLongRunning.toString());
        }
        catch (Exception e) {
            sb.append("=").append(e.getLocalizedMessage());
        }
        sb.append("]");
        return sb.toString();
    }

    @Override
    public String getStatus() {
        if (this.datasourceLongRunning == null) {
            return null;
        }
        StringBuffer sb = new StringBuffer();
        try {
            sb.append("# Connections: ").append(this.datasourceLongRunning.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sb.toString();
    }

    @Override
    public String convertStatement(String oraStatement) {
        String[] retValue = this.m_convert.convert(oraStatement);
        if (retValue == null) {
            log.log(Level.SEVERE, "DB_MySQL.convertStatement - Not Converted (" + oraStatement + ") - " + this.m_convert.getConversionError());
            throw new IllegalArgumentException("DB_MySQL.convertStatement - Not Converted (" + oraStatement + ") - " + this.m_convert.getConversionError());
        }
        if (retValue.length == 0) {
            return oraStatement;
        }
        if (retValue.length != 1) {
            log.log(Level.SEVERE, "DB_MySQL.convertStatement - Convert Command Number=" + retValue.length + " (" + oraStatement + ") - " + this.m_convert.getConversionError());
            throw new IllegalArgumentException("DB_MySQL.convertStatement - Convert Command Number=" + retValue.length + " (" + oraStatement + ") - " + this.m_convert.getConversionError());
        }
        if (!oraStatement.equals(retValue[0]) && retValue[0].indexOf("AD_Error") == -1) {
            log.log(Level.ALL, "MySQL =>" + retValue[0] + "<= <" + oraStatement + ">");
        }
        Convert.logMigrationScript(oraStatement, null, retValue[0]);
        return retValue[0];
    }

    @Override
    public String getSystemUser() {
        return "root";
    }

    @Override
    public String getSystemDatabase(String databaseName) {
        return "adempiere";
    }

    @Override
    public String TO_DATE(Timestamp time, boolean dayOnly) {
        if (time == null) {
            if (dayOnly) {
                return "current_date()";
            }
            return "now()";
        }
        StringBuffer dateString = new StringBuffer("TO_DATE('");
        String myDate = time.toString();
        if (dayOnly) {
            dateString.append(myDate.substring(0, 10));
            dateString.append("','YYYY-MM-DD')");
        } else {
            dateString.append(myDate.substring(0, myDate.indexOf(46)));
            dateString.append("','YYYY-MM-DD HH24:MI:SS')");
        }
        return dateString.toString();
    }

    @Override
    public String TO_CHAR(String columnName, int displayType, String AD_Language) {
        StringBuffer retValue = new StringBuffer("CAST (");
        retValue.append(columnName);
        retValue.append(" AS Char)");
        return retValue.toString();
    }

    @Override
    public String TO_NUMBER(BigDecimal number, int displayType) {
        if (number == null) {
            return "NULL";
        }
        BigDecimal result = number;
        int scale = DisplayType.getDefaultPrecision(displayType);
        if (scale > number.scale()) {
            try {
                result = number.setScale(scale, RoundingMode.HALF_UP);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return result.toString();
    }

    @Override
    public String[] getCommands(int cmdType) {
        if (0 == cmdType) {
            return new String[]{"CREATE USER adempiere;"};
        }
        if (1 == cmdType) {
            return new String[]{"CREATE DATABASE adempiere OWNER adempiere;", "GRANT ALL PRIVILEGES ON adempiere TO adempiere;", "CREATE SCHEMA adempiere;", "SET search_path TO adempiere;"};
        }
        if (2 == cmdType) {
            return new String[]{"DROP DATABASE adempiere;"};
        }
        return null;
    }

    public RowSet getRowSet(ResultSet rs) throws SQLException {
        throw new UnsupportedOperationException("MySQL does not support RowSets");
    }

    @Override
    public Connection getFromConnectionPool(CConnection connection, boolean autoCommit, int transactionIsolation) throws Exception {
        Connection conn;
        if (this.datasourceLongRunning == null) {
            this.getDataSource(connection);
        }
        if ((conn = this.datasourceLongRunning.getConnection()) != null) {
            conn.setAutoCommit(autoCommit);
            conn.setTransactionIsolation(transactionIsolation);
        }
        return conn;
    }

    @Override
    public Connection getFromConnectionPoolShortRunning(CConnection connection, boolean autoCommit, int transactionIsolation) throws Exception {
        Connection localConnection;
        if (this.datasourceShortRunning == null) {
            this.getDataSourceShortRunning(connection);
        }
        if ((localConnection = this.datasourceShortRunning.getConnection()) != null) {
            localConnection.setAutoCommit(autoCommit);
            localConnection.setTransactionIsolation(transactionIsolation);
        }
        return localConnection;
    }

    @Override
    public DataSource getDataSource(CConnection connection) {
        if (this.datasourceLongRunning != null) {
            return this.datasourceLongRunning;
        }
        try {
            if (Ini.isClient()) {
                log.warning("Config Hikari Connection Pool Datasource");
                HikariConfig config = new HikariConfig();
                config.setDriverClassName(DRIVER);
                config.setJdbcUrl(this.getConnectionURL(connection));
                config.setUsername(connection.getDbUid());
                config.setPassword(connection.getDbPwd());
                config.setConnectionTestQuery("SELECT Version FROM AD_System");
                config.setIdleTimeout(0L);
                config.setMinimumIdle(15);
                config.setMaximumPoolSize(150);
                config.setPoolName("AdempiereDS");
                config.addDataSourceProperty("cachePrepStmts", (Object)"true");
                config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
                config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
                this.datasourceLongRunning = new HikariDataSource(config);
                log.warning("Starting Client Hikari Connection Pool");
            } else {
                Optional<String> maybeApplicationType = Optional.ofNullable(System.getenv("ADEMPIERE_APPS_TYPE"));
                this.datasourceLongRunning = maybeApplicationType.map(applicationType -> {
                    if ("wildfly".equals(applicationType)) {
                        try {
                            InitialContext initCtx = new InitialContext();
                            DataSource dataSource = (DataSource)initCtx.lookup("java:/AdempiereDS");
                            log.warning("Connection Lookup JNDI Datasource for java:/AdempiereDS Hikari Connection Pool");
                            return dataSource;
                        }
                        catch (Exception namingException) {
                            this.datasourceLongRunning = null;
                            log.log(Level.SEVERE, "Could not initialise Hikari Connection Pool", namingException);
                            namingException.printStackTrace();
                        }
                    }
                    try {
                        DataSource dataSource = (DataSource)InitialContext.doLookup("java:comp/env/java/AdempiereDS");
                        log.warning("Connection Lookup JNDI Datasource for java:comp/env/java/AdempiereDS Hikari Connection Pool");
                        return dataSource;
                    }
                    catch (Exception namingException) {
                        this.datasourceLongRunning = null;
                        log.log(Level.SEVERE, "Application Server does not exist Could not initialise Hikari Connection Pool", namingException);
                        namingException.printStackTrace();
                        log.warning("Connection successful using Standalone Hikari Config Connection Pool");
                        HikariConfig config = new HikariConfig();
                        config.setDriverClassName(DRIVER);
                        config.setJdbcUrl(this.getConnectionURL(connection));
                        config.setUsername(connection.getDbUid());
                        config.setPassword(connection.getDbPwd());
                        config.setConnectionTestQuery("SELECT Version FROM AD_System");
                        config.setIdleTimeout(60000L);
                        config.setKeepaliveTime(30000L);
                        config.setMinimumIdle(15);
                        config.setMaximumPoolSize(150);
                        config.setPoolName("AdempiereDS");
                        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
                        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
                        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
                        return new HikariDataSource(config);
                    }
                }).orElseThrow(() -> new AdempiereException("The ADEMPIERE_APPS_TYPE environment variable is not set, so it is not possible to initialize the Hikari Connection Pool"));
            }
        }
        catch (Exception exception) {
            this.datasourceLongRunning = null;
            log.log(Level.SEVERE, "Application Server does not exist, no is possible to initialize the initialise Hikari Connection Pool", exception);
            exception.printStackTrace();
        }
        return this.datasourceLongRunning;
    }

    public DataSource getDataSourceShortRunning(CConnection connection) {
        if (this.datasourceShortRunning != null) {
            return this.datasourceShortRunning;
        }
        try {
            if (Ini.isClient()) {
                log.warning("Config Hikari Connection Pool Short Running Datasource");
                HikariConfig config = new HikariConfig();
                config.setDriverClassName(DRIVER);
                config.setJdbcUrl(this.getConnectionURL(connection));
                config.setUsername(connection.getDbUid());
                config.setPassword(connection.getDbPwd());
                config.addDataSourceProperty("poolName", (Object)"AdempiereSRDS");
                config.addDataSourceProperty("cachePrepStmts", (Object)"true");
                config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
                config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
                config.addDataSourceProperty("connectionTestQuery", (Object)"SELECT Version FROM AD_System");
                config.addDataSourceProperty("idleTimeout", (Object)"1200");
                config.addDataSourceProperty("maximumPoolSize", (Object)"10");
                HikariDataSource cpds = new HikariDataSource(config);
                this.datasourceShortRunning = cpds;
                log.warning("Starting Client Hikari Connection Pool");
            } else {
                Optional<String> maybeApplicationType = Optional.ofNullable(System.getenv("ADEMPIERE_APPS_TYPE"));
                this.datasourceShortRunning = maybeApplicationType.map(applicationType -> {
                    if ("wildfly".equals(applicationType)) {
                        try {
                            InitialContext initCtx = new InitialContext();
                            DataSource dataSource = (DataSource)initCtx.lookup("java:/AdempiereSRDS");
                            log.warning("Connection Lookup JNDI Short Running Datasource for java:/AdempiereSRDS Hikari Connection Pool");
                            return dataSource;
                        }
                        catch (Exception namingException) {
                            this.datasourceShortRunning = null;
                            log.log(Level.SEVERE, "Could not initialise Short Running Hikari Connection Pool", namingException);
                            namingException.printStackTrace();
                        }
                    }
                    try {
                        DataSource dataSource = (DataSource)InitialContext.doLookup("java:comp/env/java/AdempiereSRDS");
                        log.warning("Connection Lookup JNDI Short Running Datasource for java:comp/env/java/AdempiereSRDS Hikari Connection Pool");
                        return dataSource;
                    }
                    catch (Exception namingException) {
                        this.datasourceShortRunning = null;
                        log.log(Level.SEVERE, "Application Server does not exist Could not initialise Short Running Hikari Connection Pool", namingException);
                        namingException.printStackTrace();
                        log.warning("Connection successful using Standalone Short Running Hikari Config Connection Pool");
                        HikariConfig config = new HikariConfig();
                        config.setDriverClassName(DRIVER);
                        config.setJdbcUrl(this.getConnectionURL(connection));
                        config.setUsername(connection.getDbUid());
                        config.setPassword(connection.getDbPwd());
                        config.addDataSourceProperty("poolName", (Object)"AdempiereSRDS");
                        config.addDataSourceProperty("cachePrepStmts", (Object)"true");
                        config.addDataSourceProperty("prepStmtCacheSize", (Object)"250");
                        config.addDataSourceProperty("prepStmtCacheSqlLimit", (Object)"2048");
                        config.addDataSourceProperty("connectionTestQuery", (Object)"SELECT Version FROM AD_System");
                        config.addDataSourceProperty("idleTimeout", (Object)"1200");
                        config.addDataSourceProperty("maximumPoolSize", (Object)"5");
                        return new HikariDataSource(config);
                    }
                }).orElseThrow(() -> new AdempiereException("The ADEMPIERE_APPS_TYPE environment variable is not set, so it is not possible to initialize the Short Running Hikari Connection Pool"));
            }
        }
        catch (Exception exception) {
            this.datasourceShortRunning = null;
            log.log(Level.SEVERE, "Application Server does not exist, no is possible to initialize the Short Running initialise Short Running Hikari Connection Pool", exception);
            exception.printStackTrace();
        }
        return this.datasourceShortRunning;
    }

    public ConnectionPoolDataSource createPoolDataSource(CConnection connection) {
        throw new UnsupportedOperationException("Not supported/implemented");
    }

    @Override
    public Connection getDriverConnection(CConnection connection) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(this.getConnectionURL(connection), connection.getDbUid(), connection.getDbPwd());
    }

    @Override
    public Connection getDriverConnection(String dbUrl, String dbUid, String dbPwd) throws SQLException {
        this.getDriver();
        return DriverManager.getConnection(dbUrl, dbUid, dbPwd);
    }

    @Override
    public void close() {
        log.config(this.toString());
        if (this.datasourceLongRunning != null) {
            try {
                this.datasourceLongRunning.getConnection().close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        this.datasourceLongRunning = null;
    }

    @Override
    public String getAlternativeSQL(int reExNo, String msg, String sql) {
        return null;
    }

    @Override
    public String getConstraintType(Connection conn, String tableName, String IXName) {
        if (IXName == null || IXName.length() == 0) {
            return "0";
        }
        if (IXName.toUpperCase().endsWith("_KEY")) {
            return "1" + IXName;
        }
        return "0";
    }

    @Override
    public boolean isSupported(String sql) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dumpLocks(Connection conn) {
        Statement stmt = null;
        ResultSet rs = null;
        try {
            String sql = "select pg_class.relname,pg_locks.* from pg_class,pg_locks where pg_class.relfilenode=pg_locks.relation order by 1";
            stmt = conn.createStatement();
            rs = stmt.executeQuery(sql);
            int cnt = rs.getMetaData().getColumnCount();
            System.out.println();
            while (rs.next()) {
                for (int i = 0; i < cnt; ++i) {
                    Object value = rs.getObject(i + 1);
                    if (i > 0) {
                        System.out.print(", ");
                    }
                    System.out.print(value != null ? value.toString() : "");
                }
                System.out.println();
            }
            System.out.println();
        }
        catch (Exception exception) {
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
        }
        catch (Throwable throwable) {
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
            throw throwable;
        }
        DB.close(rs, stmt);
        rs = null;
        stmt = null;
    }

    public static void main(String[] args) {
        DB_MySQL mysql = new DB_MySQL();
        String databaseName = "adempiere";
        String uid = "adempiere";
        String pwd = "adempiere";
        String jdbcURL = mysql.getConnectionURL("localhost", 3306, databaseName, uid);
        System.out.println(jdbcURL);
        try {
            mysql.getDriver();
            System.out.println(mysql.getDriver());
            Connection conn = DriverManager.getConnection(jdbcURL, uid, pwd);
            conn.close();
            conn = null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public int getNextID(String name) {
        int m_sequence_id = DB.getSQLValue(null, "SELECT nextval('" + name.toLowerCase() + "')");
        return m_sequence_id;
    }

    @Override
    public boolean createSequence(String name, int increment, int minvalue, int maxvalue, int start, String trxName) {
        int no = DB.executeUpdate("CREATE SEQUENCE " + name.toUpperCase() + " INCREMENT " + increment + " MINVALUE " + minvalue + " MAXVALUE " + maxvalue + " START " + start, trxName);
        return no != -1;
    }

    @Override
    public String addPagingSQL(String sql, int start, int end) {
        return null;
    }

    @Override
    public boolean isPagingSupported() {
        return false;
    }

    @Override
    public boolean isQueryTimeoutSupported() {
        return false;
    }

    @Override
    public boolean forUpdate(PO po, int timeout) {
        if (po.get_TrxName() == null) {
            return false;
        }
        String[] keyColumns = po.get_KeyColumns();
        if (keyColumns != null && keyColumns.length > 0 && !po.is_new()) {
            int i;
            ResultSet rs;
            CPreparedStatement stmt;
            block13: {
                StringBuilder sqlBuffer = new StringBuilder(" SELECT ");
                sqlBuffer.append(keyColumns[0]).append(" FROM ").append(po.get_TableName()).append(" WHERE ");
                for (int i2 = 0; i2 < keyColumns.length; ++i2) {
                    if (i2 > 0) {
                        sqlBuffer.append(" AND ");
                    }
                    sqlBuffer.append(keyColumns[i2]).append("=?");
                }
                sqlBuffer.append(" FOR UPDATE ");
                Object[] parameters = new Object[keyColumns.length];
                for (int i3 = 0; i3 < keyColumns.length; ++i3) {
                    Object parameter = po.get_Value(keyColumns[i3]);
                    if (parameter != null && parameter instanceof Boolean) {
                        parameter = (Boolean)parameter != false ? "Y" : "N";
                    }
                    parameters[i3] = parameter;
                }
                stmt = null;
                rs = null;
                stmt = DB.prepareStatement(sqlBuffer.toString(), 1003, 1008, po.get_TrxName());
                for (i = 0; i < keyColumns.length; ++i) {
                    stmt.setObject(i + 1, parameters[i]);
                }
                stmt.setQueryTimeout(timeout > 0 ? timeout : 60);
                rs = stmt.executeQuery();
                if (!rs.next()) break block13;
                i = 1;
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                return i != 0;
            }
            try {
                i = 0;
            }
            catch (Exception e) {
                try {
                    if (log.isLoggable(Level.INFO)) {
                        log.log(Level.INFO, e.getLocalizedMessage(), e);
                    }
                    throw new DBException("Could not lock record for " + po.toString() + " caused by " + e.getLocalizedMessage());
                }
                catch (Throwable throwable) {
                    DB.close(rs, stmt);
                    rs = null;
                    stmt = null;
                    throw throwable;
                }
            }
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
            return i != 0;
        }
        return false;
    }

    @Override
    public String getNameOfUniqueConstraintError(Exception e) {
        String info = e.getMessage();
        int fromIndex = info.indexOf("\"");
        if (fromIndex == -1) {
            fromIndex = info.indexOf("\u00ab");
        }
        if (fromIndex == -1) {
            return info;
        }
        int toIndex = info.indexOf("\"", fromIndex + 1);
        if (toIndex == -1) {
            toIndex = info.indexOf("\u00bb", fromIndex + 1);
        }
        if (toIndex == -1) {
            return info;
        }
        return info.substring(fromIndex + 1, toIndex);
    }
}

