/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.process;

import org.compiere.asset.model.MAssetAddition;
import org.compiere.asset.process.ProjectCreateAssetAbstract;
import org.compiere.model.MProduct;
import org.compiere.model.MProductCategory;
import org.compiere.model.MProject;

public class ProjectCreateAsset
extends ProjectCreateAssetAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    @Override
    protected String doIt() throws Exception {
        if (this.getProjectId() == 0) {
            return "Missing Mandatory Field Value (Project)";
        }
        MProject mProject = new MProject(this.getCtx(), this.getProjectId(), this.get_TrxName());
        this.log.info("doIt - " + mProject);
        if (!"A".equals(mProject.getProjectCategory())) {
            return "Project is not asset type";
        }
        MProduct mProduct = new MProduct(this.getCtx(), this.getProjectId(), this.get_TrxName());
        MProductCategory mProductCategory = MProductCategory.get(this.getCtx(), mProduct.getM_Product_Category_ID());
        if (mProductCategory.getA_Asset_Group_ID() == 0) {
            return "Product is not asset type";
        }
        MAssetAddition mAssetAddition = MAssetAddition.createAsset(mProject, mProduct);
        mAssetAddition.setDateAcct(this.getDateTrx());
        mAssetAddition.setDateDoc(this.getDateTrx());
        mAssetAddition.setM_Product_ID(this.getProjectId());
        if (this.getUseLifeYears() > 0) {
            mAssetAddition.setDeltaUseLifeYears(this.getUseLifeYears());
            mAssetAddition.setDeltaUseLifeYears_F(this.getUseLifeYears());
        }
        mAssetAddition.saveEx();
        if (!mAssetAddition.processIt("CO")) {
            return "Error Process Asset Addition";
        }
        mAssetAddition.saveEx();
        return "Asset Created. @A_Asset_Addition_ID@ - " + mAssetAddition;
    }
}

