/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.process;

import java.math.BigDecimal;
import org.adempiere.core.domains.models.X_I_FixedAsset;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MAssetAddition;
import org.compiere.asset.model.MIFixedAsset;
import org.compiere.asset.process.ImportFixedAssetAbstract;
import org.compiere.model.MSysConfig;
import org.compiere.model.POResultSet;
import org.compiere.model.Query;
import org.compiere.util.DB;

public class ImportFixedAsset
extends ImportFixedAssetAbstract {
    @Override
    protected void prepare() {
        super.prepare();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        block21: {
            double d;
            StringBuffer stringBuffer = null;
            int n = 0;
            String string = " AND AD_Client_ID=" + this.getAD_Client_ID();
            if (this.isDeleteOldImported()) {
                stringBuffer = new StringBuffer("DELETE I_FixedAsset WHERE I_IsImported='Y'").append(string);
                n = DB.executeUpdateEx(stringBuffer.toString(), this.get_TrxName());
                this.log.fine("Delete Old Imported =" + n);
            }
            stringBuffer = new StringBuffer("UPDATE I_FixedAsset SET AD_Client_ID = COALESCE (AD_Client_ID,").append(this.getAD_Client_ID()).append("), AD_Org_ID = COALESCE (AD_Org_ID,").append("0").append("), IsActive = COALESCE (IsActive, 'Y'), Created = COALESCE (Created, SysDate), CreatedBy = COALESCE (CreatedBy, 0), Updated = COALESCE (Updated, SysDate), UpdatedBy = COALESCE (UpdatedBy, 0), I_ErrorMsg = ' ', I_IsImported = 'N' WHERE I_IsImported<>'Y' OR I_IsImported IS NULL");
            n = DB.executeUpdate(stringBuffer.toString(), this.get_TrxName());
            this.log.info("Reset=" + n);
            stringBuffer = new StringBuffer("UPDATE I_FixedAsset ifa SET AD_Org_ID=(SELECT MAX(AD_Org_ID) FROM AD_Org org WHERE ifa.OrgValue=org.Value AND org.IsSummary='N' AND org.AD_Client_ID=ifa.AD_Client_ID) WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0) AND OrgValue IS NOT NULL AND I_IsImported<>'Y'").append(string);
            n = DB.executeUpdate(stringBuffer.toString(), this.get_TrxName());
            this.log.fine("Set Organization from Value=" + n);
            stringBuffer = new StringBuffer("UPDATE I_FixedAsset ifa SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Org, 'WHERE (AD_Org_ID IS NULL OR AD_Org_ID=0 OR EXISTS (SELECT * FROM AD_Org oo WHERE ifa.AD_Org_ID=oo.AD_Org_ID AND (oo.IsSummary='Y' OR oo.IsActive='N'))) AND I_IsImported<>'Y'").append(string);
            n = DB.executeUpdate(stringBuffer.toString(), this.get_TrxName());
            if (n != 0) {
                this.log.warning("Invalid Org=" + n);
            }
            if ((n = DB.executeUpdate((stringBuffer = new StringBuffer("UPDATE I_FixedAsset ifa SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Name Is Mandatory, 'WHERE Name IS NULL AND I_IsImported<>'Y'").append(string)).toString(), this.get_TrxName())) != 0) {
                this.log.warning("Invalid Name=" + n);
            }
            stringBuffer = new StringBuffer("UPDATE I_FixedAsset ifa SET A_Asset_Group_ID=(SELECT MAX(A_Asset_Group_ID) FROM A_Asset_Group t WHERE ifa.A_Asset_Group_Value=t.Name AND ifa.AD_Client_ID=t.AD_Client_ID) WHERE A_Asset_Group_ID IS NULL AND A_Asset_Group_Value IS NOT NULL AND I_IsImported<>'Y'").append(string);
            n = DB.executeUpdate(stringBuffer.toString(), this.get_TrxName());
            this.log.fine("Set Asset Group from Value=" + n);
            stringBuffer = new StringBuffer("UPDATE I_FixedAsset ifa SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Asset Group Doesnt Have Asset Group Acct Record, ' WHERE A_Asset_Group_ID IS NOT NULL AND A_Asset_Group_ID>0 AND NOT EXISTS (SELECT 1 FROM A_Asset_Group_Acct aga WHERE ifa.A_Asset_Group_ID=aga.A_Asset_Group_ID) AND I_IsImported<>'Y'").append(string);
            n = DB.executeUpdate(stringBuffer.toString(), this.get_TrxName());
            if (n != 0) {
                this.log.warning("Invalid Asset Group=" + n);
            }
            stringBuffer = new StringBuffer("UPDATE I_FixedAsset ifa SET C_BPartnerSR_ID=(SELECT MAX(C_BPartner_ID) FROM C_BPartner t WHERE ifa.BPartner_Value=t.Value AND ifa.AD_Client_ID=t.AD_Client_ID) WHERE C_BPartnerSR_ID IS NULL AND BPartner_Value IS NOT NULL AND I_IsImported<>'Y'").append(string);
            n = DB.executeUpdate(stringBuffer.toString(), this.get_TrxName());
            this.log.fine("Set BP from Value=" + n);
            stringBuffer = new StringBuffer("UPDATE I_FixedAsset ifa SET C_City_ID=(SELECT MAX(C_City_ID) FROM C_City t WHERE ifa.C_City_Value=t.Name AND ifa.AD_Client_ID=t.AD_Client_ID) WHERE C_City_ID IS NULL AND C_City_Value IS NOT NULL AND I_IsImported<>'Y'").append(string);
            n = DB.executeUpdate(stringBuffer.toString(), this.get_TrxName());
            this.log.fine("Set City from Value=" + n);
            stringBuffer = new StringBuffer("UPDATE I_FixedAsset ifa SET M_Product_ID=(SELECT MAX(M_Product_ID) FROM M_Product t WHERE ifa.ProductValue=t.Value AND ifa.AD_Client_ID=t.AD_Client_ID) WHERE M_Product_ID IS NULL AND ProductValue IS NOT NULL AND I_IsImported<>'Y'").append(string);
            n = DB.executeUpdate(stringBuffer.toString(), this.get_TrxName());
            this.log.fine("Set Product from Value=" + n);
            stringBuffer = new StringBuffer("UPDATE I_FixedAsset ifa SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Product, ' WHERE M_Product_ID IS NULL AND ProductValue IS NOT NULL AND I_IsImported<>'Y'").append(string);
            n = DB.executeUpdate(stringBuffer.toString(), this.get_TrxName());
            if (n != 0) {
                this.log.warning("Invalid Product=" + n);
            }
            if ((n = DB.executeUpdate((stringBuffer = new StringBuffer("UPDATE I_FixedAsset ifa SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Product Using Product Category Without Asset Group Defined, ' WHERE EXISTS (SELECT 1 FROM M_Product p JOIN M_Product_Category pc ON p.M_Product_Category_ID=pc.M_Product_Category_ID WHERE ifa.M_Product_ID=p.M_Product_ID AND (pc.A_Asset_Group_ID=0 OR pc.A_Asset_Group_ID IS NULL)) AND I_IsImported<>'Y'").append(string)).toString(), this.get_TrxName())) != 0) {
                this.log.warning("Invalid Product Category=" + n);
            }
            stringBuffer = new StringBuffer("UPDATE I_FixedAsset ifa SET M_Locator_ID=(SELECT MAX(M_Locator_ID) FROM M_Locator t WHERE ifa.LocatorValue=t.Value AND ifa.AD_Client_ID=t.AD_Client_ID) WHERE M_Locator_ID IS NULL AND LocatorValue IS NOT NULL AND I_IsImported<>'Y'").append(string);
            n = DB.executeUpdate(stringBuffer.toString(), this.get_TrxName());
            this.log.fine("Set Locator from Value=" + n);
            stringBuffer = new StringBuffer("UPDATE I_FixedAsset SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Current Period, ' WHERE a_current_period < 0 OR a_current_period > uselifemonths AND I_IsImported<>'Y'").append(string);
            n = DB.executeUpdate(stringBuffer.toString(), this.get_TrxName());
            if (n != 0) {
                this.log.warning("Invalid Current Period=" + n);
            }
            if ((n = DB.executeUpdate((stringBuffer = new StringBuffer("UPDATE I_FixedAsset SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg ||'ERR=Invalid Asset Cost, ' WHERE a_asset_cost < 1 AND I_IsImported<>'Y'").append(string)).toString(), this.get_TrxName())) != 0) {
                this.log.warning("Invalid Asset Cost=" + n);
            }
            if ((n = DB.executeUpdate((stringBuffer = new StringBuffer("UPDATE I_FixedAsset SET I_IsImported='E', I_ErrorMsg=I_ErrorMsg||'ERR=Invalid Accumulated Depreciation, ' WHERE uselifemonths<>a_current_period AND ABS(((a_asset_cost / uselifemonths) * (a_current_period - 1)) - a_accumulated_depr) > " + BigDecimal.valueOf(d = MSysConfig.getDoubleValue("TOLERANCE_AMT", 1.0, 0, 0)) + " AND I_IsImported<>'Y' AND a_current_period <> 0").append(string)).toString(), this.get_TrxName())) != 0) {
                this.log.warning("Invalid Accumulated Depreciation=" + n);
            }
            if (this.isValidateOnly()) {
                return "Data Was Validated";
            }
            int n2 = 0;
            int n3 = 0;
            String string2 = "COALESCE(I_IsImported,'N')='N'" + string;
            POResultSet pOResultSet = new Query(this.getCtx(), "I_FixedAsset", string2, this.get_TrxName()).scroll();
            block5: while (true) {
                while (pOResultSet.hasNext()) {
                    X_I_FixedAsset x_I_FixedAsset = (X_I_FixedAsset)pOResultSet.next();
                    MIFixedAsset mIFixedAsset = new MIFixedAsset(this.getCtx(), x_I_FixedAsset.getI_FixedAsset_ID(), this.get_TrxName());
                    try {
                        MAssetAddition mAssetAddition = MAssetAddition.createAsset(mIFixedAsset);
                        if (mAssetAddition == null) {
                            mIFixedAsset.setI_ErrorMsg("Failed Create Assets");
                            ++n3;
                            mAssetAddition = null;
                            continue;
                        }
                        if (this.getDateAcct() != null) {
                            mAssetAddition.setDateAcct(this.getDateAcct());
                        }
                        mAssetAddition.saveEx();
                        if (!mAssetAddition.processIt(mIFixedAsset.getDocAction())) {
                            mIFixedAsset.setI_ErrorMsg("Failed Process Asset Addition");
                            ++n3;
                            mAssetAddition = null;
                            continue;
                        }
                        mAssetAddition.saveEx();
                        if (mIFixedAsset.getA_Current_Period() == 0) {
                            MAsset mAsset = new MAsset(this.getCtx(), mAssetAddition.getA_Asset_ID(), this.get_TrxName());
                            mAsset.setUseLifeYears(0);
                            mAsset.setUseLifeMonths(0);
                            mAsset.setLifeUseUnits(0);
                            mAsset.setUseUnits(0);
                            mAsset.saveEx();
                        }
                        mIFixedAsset.setI_IsImported(true);
                        mIFixedAsset.setI_ErrorMsg(null);
                        mIFixedAsset.setA_Asset_ID(mAssetAddition.getA_Asset_ID());
                        mIFixedAsset.setProcessed(true);
                        mIFixedAsset.saveEx();
                        ++n2;
                        continue block5;
                    }
                    catch (Exception exception) {
                        mIFixedAsset.setI_ErrorMsg(exception.getLocalizedMessage());
                        ++n3;
                        mIFixedAsset.saveEx();
                    }
                }
                break block21;
                {
                    continue block5;
                    break;
                }
                break;
            }
            finally {
                DB.close(pOResultSet);
                pOResultSet = null;
                stringBuffer = new StringBuffer("UPDATE I_FixedAsset SET I_IsImported='N', Updated=SysDate WHERE I_IsImported<>'Y'").append(string);
                n = DB.executeUpdate(stringBuffer.toString(), this.get_TrxName());
                this.addLog(0, null, new BigDecimal(n), "@Errors@");
                this.addLog(0, null, new BigDecimal(n2), "@A_Asset_ID@: @Inserted@");
                this.addLog(0, null, new BigDecimal(n3), "@A_Asset_ID@: @Failed@");
            }
        }
        return "";
    }
}

