/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.process;

import org.adempiere.exceptions.AdempiereException;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.asset.model.MDepreciationEntry;
import org.compiere.asset.model.MDepreciationExp;
import org.compiere.process.ProcessInfoParameter;
import org.compiere.process.SvrProcess;

public class DepreciationExpModify
extends SvrProcess {
    private int p_A_Depreciation_Exp_ID = -1;
    private int p_DR_Account_ID = -1;
    private int p_CR_Account_ID = -1;
    private boolean p_IsTest = true;

    @Override
    protected void prepare() {
        for (ProcessInfoParameter processInfoParameter : this.getParameter()) {
            String string = processInfoParameter.getParameterName();
            if (processInfoParameter.getParameter() == null) continue;
            if (string.equals("IsTest")) {
                this.p_IsTest = processInfoParameter.getParameterAsBoolean();
                continue;
            }
            if (string.equals("A_Depreciation_Exp_ID")) {
                this.p_A_Depreciation_Exp_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (string.equals("DR_Account_ID")) {
                this.p_DR_Account_ID = processInfoParameter.getParameterAsInt();
                continue;
            }
            if (!string.equals("CR_Account_ID")) continue;
            this.p_CR_Account_ID = processInfoParameter.getParameterAsInt();
        }
    }

    @Override
    protected String doIt() throws Exception {
        if (this.p_A_Depreciation_Exp_ID <= 0) {
            throw new FillMandatoryException(new String[]{"A_Depreciation_Exp_ID"});
        }
        MDepreciationExp mDepreciationExp = new MDepreciationExp(this.getCtx(), this.p_A_Depreciation_Exp_ID, this.get_TrxName());
        if (mDepreciationExp.get_ID() != this.p_A_Depreciation_Exp_ID) {
            throw new AdempiereException("@NotFound@ @A_Depreciation_Exp_ID@ = " + this.p_A_Depreciation_Exp_ID);
        }
        MDepreciationEntry.deleteFacts(mDepreciationExp);
        mDepreciationExp.setDR_Account_ID(this.p_DR_Account_ID);
        mDepreciationExp.setCR_Account_ID(this.p_CR_Account_ID);
        mDepreciationExp.saveEx();
        if (this.p_IsTest) {
            this.rollback();
        }
        return "Ok";
    }
}

