/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Properties;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.adempiere.core.domains.models.X_A_Registration;
import org.compiere.asset.model.MRegistrationAttribute;
import org.compiere.asset.model.MRegistrationValue;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.WebUtil;

public class MRegistration
extends X_A_Registration {
    private static final long serialVersionUID = -5178339895228217372L;
    private MRegistrationAttribute[] m_allAttributes = null;

    public MRegistration(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setIsRegistered(true);
        }
    }

    public MRegistration(Properties properties, String string, boolean bl, boolean bl2, Timestamp timestamp, String string2) {
        this(properties, 0, string2);
        this.setName(string);
        this.setIsAllowPublish(bl);
        this.setIsInProduction(bl2);
        this.setAssetServiceDate(timestamp);
    }

    public MRegistration(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MRegistrationAttribute[] getAttributes() {
        if (this.m_allAttributes == null) {
            this.m_allAttributes = MRegistrationAttribute.getAll(this.getCtx());
        }
        return this.m_allAttributes;
    }

    public MRegistrationValue[] getValues() {
        return this.getValues(true);
    }

    public MRegistrationValue[] getValues(boolean bl) {
        Object[] objectArray;
        this.createMissingValues();
        Object object = "SELECT * FROM A_RegistrationValue rv WHERE A_Registration_ID=?";
        if (bl) {
            object = (String)object + " AND EXISTS (SELECT * FROM A_RegistrationAttribute ra WHERE rv.A_RegistrationAttribute_ID=ra.A_RegistrationAttribute_ID AND ra.IsActive='Y' AND ra.IsSelfService='Y')";
        }
        ArrayList<MRegistrationValue> arrayList = new ArrayList<MRegistrationValue>();
        CPreparedStatement cPreparedStatement = null;
        try {
            cPreparedStatement = DB.prepareStatement((String)object, this.get_TrxName());
            cPreparedStatement.setInt(1, this.getA_Registration_ID());
            objectArray = cPreparedStatement.executeQuery();
            while (objectArray.next()) {
                arrayList.add(new MRegistrationValue(this.getCtx(), (ResultSet)objectArray, this.get_TrxName()));
            }
            objectArray.close();
            cPreparedStatement.close();
            cPreparedStatement = null;
        }
        catch (Exception exception) {
            this.log.log(Level.SEVERE, (String)object, exception);
        }
        try {
            if (cPreparedStatement != null) {
                cPreparedStatement.close();
            }
            cPreparedStatement = null;
        }
        catch (Exception exception) {
            cPreparedStatement = null;
        }
        objectArray = new MRegistrationValue[arrayList.size()];
        arrayList.toArray(objectArray);
        Arrays.sort(objectArray);
        return objectArray;
    }

    private void createMissingValues() {
        String string = "SELECT ra.A_RegistrationAttribute_ID FROM A_RegistrationAttribute ra LEFT OUTER JOIN A_RegistrationProduct rp ON (rp.A_RegistrationAttribute_ID=ra.A_RegistrationAttribute_ID) LEFT OUTER JOIN A_Registration r ON (r.M_Product_ID=rp.M_Product_ID) WHERE r.A_Registration_ID=? AND NOT EXISTS (SELECT A_RegistrationAttribute_ID FROM A_RegistrationValue v WHERE ra.A_RegistrationAttribute_ID=v.A_RegistrationAttribute_ID AND r.A_Registration_ID=v.A_Registration_ID)";
        CPreparedStatement cPreparedStatement = null;
        try {
            cPreparedStatement = DB.prepareStatement(string, this.get_TrxName());
            cPreparedStatement.setInt(1, this.getA_Registration_ID());
            ResultSet resultSet = cPreparedStatement.executeQuery();
            while (resultSet.next()) {
                MRegistrationValue mRegistrationValue = new MRegistrationValue(this, resultSet.getInt(1), "?");
                mRegistrationValue.saveEx();
            }
            resultSet.close();
            cPreparedStatement.close();
            cPreparedStatement = null;
        }
        catch (Exception exception) {
            this.log.log(Level.SEVERE, null, exception);
        }
        try {
            if (cPreparedStatement != null) {
                cPreparedStatement.close();
            }
            cPreparedStatement = null;
        }
        catch (Exception exception) {
            cPreparedStatement = null;
        }
    }

    public int loadAttributeValues(HttpServletRequest httpServletRequest) {
        if (this.get_ID() == 0) {
            this.save();
        }
        int n = 0;
        MRegistrationAttribute[] mRegistrationAttributeArray = this.getAttributes();
        for (int i = 0; i < mRegistrationAttributeArray.length; ++i) {
            MRegistrationValue mRegistrationValue;
            MRegistrationAttribute mRegistrationAttribute = mRegistrationAttributeArray[i];
            String string = WebUtil.getParameter(httpServletRequest, mRegistrationAttribute.getName());
            if (string == null || !(mRegistrationValue = new MRegistrationValue(this, mRegistrationAttribute.getA_RegistrationAttribute_ID(), string)).save()) continue;
            ++n;
        }
        this.log.fine("loadAttributeValues - #" + n + " (of " + mRegistrationAttributeArray.length + ")");
        return n;
    }

    public int updateAttributeValues(HttpServletRequest httpServletRequest) {
        if (this.get_ID() == 0) {
            this.save();
        }
        int n = 0;
        MRegistrationValue[] mRegistrationValueArray = this.getValues(false);
        for (int i = 0; i < mRegistrationValueArray.length; ++i) {
            MRegistrationValue mRegistrationValue = mRegistrationValueArray[i];
            String string = mRegistrationValue.getRegistrationAttribute();
            String string2 = WebUtil.getParameter(httpServletRequest, string);
            if (string2 == null) continue;
            mRegistrationValue.setDescription("Previous=" + mRegistrationValue.getName());
            mRegistrationValue.setName(string2);
            if (!mRegistrationValue.save()) continue;
            ++n;
        }
        this.log.fine("updateAttributeValues - #" + n + " (of " + mRegistrationValueArray.length + ")");
        return n;
    }
}

