/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Properties;
import org.adempiere.core.domains.models.X_I_FixedAsset;
import org.adempiere.core.domains.models.X_M_Product;
import org.adempiere.exceptions.FillMandatoryException;
import org.compiere.asset.model.MAssetGroup;
import org.compiere.asset.model.MDepreciation;
import org.compiere.model.MClient;
import org.compiere.model.MProduct;
import org.compiere.model.MUOM;
import org.compiere.model.PO;
import org.compiere.util.CLogMgt;
import org.compiere.util.DB;
import org.compiere.util.DisplayType;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class MIFixedAsset
extends X_I_FixedAsset {
    private static final long serialVersionUID = 1L;
    private static final String s_defaultDepreciationType = "SL";
    private int m_M_Product_Category_ID = 0;
    private int m_A_Asset_Group_ID = 0;
    private MProduct m_product = null;

    public MIFixedAsset(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MIFixedAsset(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public MProduct getCreateProduct() {
        Object object;
        String string;
        Serializable serializable;
        Properties properties = this.getCtx();
        String string2 = this.get_TrxName();
        int n = this.getM_Product_ID();
        if (n <= 0) {
            serializable = new StringBuffer();
            string = this.getProductValue();
            if (string == null || string.trim().length() == 0) {
                string = this.getName();
                ((StringBuffer)serializable).append("UPPER(Name)=");
            } else {
                ((StringBuffer)serializable).append("UPPER(Value)=");
            }
            if (string == null || string.trim().length() == 0) {
                throw new FillMandatoryException("ProductValue", "Name");
            }
            string = string.toUpperCase();
            ((StringBuffer)serializable).append(DB.TO_STRING(string));
            ((StringBuffer)serializable).append(" AND AD_Client_ID=").append(this.getAD_Client_ID());
            object = "SELECT M_Product_ID FROM M_Product WHERE " + ((StringBuffer)serializable).toString();
            n = DB.getSQLValueEx(string2, (String)object, new Object[0]);
            this.log.fine("M_Product_ID=" + n + " -- sql=" + (String)object);
        }
        serializable = null;
        if (n <= 0) {
            serializable = new MProduct(properties, 0, string2);
            ((X_M_Product)serializable).setName(this.getName());
            string = this.getProductValue();
            if (string != null && string.trim().length() > 0) {
                ((X_M_Product)serializable).setValue(string);
            }
            ((X_M_Product)serializable).setM_Product_Category_ID(this.m_M_Product_Category_ID);
            if (this.getC_UOM_ID() > 0) {
                ((X_M_Product)serializable).setC_UOM_ID(this.getC_UOM_ID());
            } else {
                ((X_M_Product)serializable).setC_UOM_ID(MUOM.getDefault_UOM_ID(properties));
            }
            object = "SELECT C_TaxCategory_ID FROM C_TaxCategory WHERE AD_Client_ID IN (0,?) ORDER BY IsDefault DESC, AD_Client_ID DESC, C_TaxCategory_ID";
            int n2 = DB.getSQLValueEx(null, (String)object, Env.getAD_Client_ID(properties));
            ((X_M_Product)serializable).setC_TaxCategory_ID(n2);
            ((PO)serializable).saveEx(string2);
        } else {
            serializable = new MProduct(properties, n, string2);
        }
        this.setProduct((MProduct)serializable);
        return serializable;
    }

    private void fixAmount(int n) {
        BigDecimal bigDecimal = (BigDecimal)this.get_Value(n);
        if (bigDecimal == null) {
            return;
        }
        int n2 = this.getStdPrecision();
        BigDecimal bigDecimal2 = bigDecimal.setScale(this.getStdPrecision(), RoundingMode.HALF_UP);
        this.set_Value(n, (Object)bigDecimal2);
        if (CLogMgt.isLevelFine()) {
            this.log.fine(this.getInventoryNo() + ": " + this.get_ColumnName(n) + "=" + bigDecimal + "->" + bigDecimal2 + " (precision=" + n2 + ")");
        }
    }

    private void fixKeyValue(int n) {
        String string = (String)this.get_Value(n);
        if (string == null) {
            return;
        }
        String string2 = string.trim().replaceAll("[ ]+", " ");
        if (CLogMgt.isLevelFine()) {
            this.log.fine(this.getInventoryNo() + ": " + this.get_ColumnName(n) + "=[" + string + "]->[" + string2 + "]");
        }
        this.set_Value(n, (Object)string2);
    }

    public void process() {
        if (this.isProcessed()) {
            return;
        }
        try {
            int n;
            if (this.getUseLifeMonths() <= 0) {
                throw new FillMandatoryException(new String[]{"UseLifeMonths"});
            }
            int n2 = this.get_ColumnCount();
            for (int i = 0; i < n2; ++i) {
                n = this.get_ColumnDisplayType(i);
                if (12 == n) {
                    this.fixAmount(i);
                    continue;
                }
                if (!DisplayType.isText(n)) continue;
                this.fixKeyValue(i);
            }
            MProduct mProduct = this.getCreateProduct();
            this.log.fine("product=" + mProduct);
            if (this.getM_Product_ID() <= 0) {
                throw new FillMandatoryException(new String[]{"M_Product_ID"});
            }
            n = this.getA_Asset_Group_ID();
            if (n <= 0) {
                n = this.m_A_Asset_Group_ID > 0 ? this.m_A_Asset_Group_ID : mProduct.getA_Asset_Group_ID();
            }
            if (n <= 0) {
                throw new FillMandatoryException(new String[]{"A_Asset_Group_ID"});
            }
            this.setA_Asset_Group_ID(n);
            if (this.getA_Remaining_Period() == 0) {
                this.setDateAcct(this.getAssetDepreciationDate());
            } else {
                Timestamp timestamp = this.getDateAcct();
                if (timestamp == null) {
                    timestamp = Env.getContextAsDate(this.getCtx(), "#Date");
                    this.setDateAcct(timestamp);
                }
            }
            if (this.getDateAcct() == null) {
                throw new FillMandatoryException(new String[]{"DateAcct"});
            }
            this.setProcessed(true);
            this.setI_ErrorMsg(null);
            this.saveEx();
        }
        catch (Exception exception) {
            this.setError(exception.getLocalizedMessage());
            this.saveEx();
        }
    }

    public boolean isFullyDepreciated() {
        BigDecimal bigDecimal = this.getA_Asset_Cost();
        BigDecimal bigDecimal2 = this.getA_Accumulated_Depr();
        BigDecimal bigDecimal3 = this.getA_Accumulated_Depr_F();
        return bigDecimal.compareTo(bigDecimal2) == 0 && bigDecimal.compareTo(bigDecimal3) == 0;
    }

    public boolean isDepreciating() {
        MAssetGroup mAssetGroup = MAssetGroup.get(this.getCtx(), this.getA_Asset_Group_ID());
        if (mAssetGroup == null) {
            return false;
        }
        return mAssetGroup.isDepreciated();
    }

    public int getA_Last_Period() {
        int n;
        int n2 = this.getUseLifeMonths();
        return n2 > (n = this.getUseLifeMonths_F()) ? n2 : n;
    }

    public void setDefault_Product_Category_ID(int n) {
        this.m_M_Product_Category_ID = n;
    }

    public void setDefault_Asset_Group_ID(int n) {
        this.m_A_Asset_Group_ID = n;
    }

    public void setProduct(MProduct mProduct) {
        this.m_product = mProduct;
        this.setM_Product_ID(mProduct.get_ID());
        this.setProductValue(mProduct.getValue());
        if (Util.isEmpty(this.getName())) {
            this.setName(mProduct.getName());
        }
    }

    public MProduct getProduct() {
        if (this.m_product == null && this.getM_Product_ID() > 0) {
            this.m_product = new MProduct(this.getCtx(), this.getM_Product_ID(), this.get_TrxName());
        }
        return this.m_product;
    }

    public int getA_Depreciation_ID() {
        MDepreciation mDepreciation = MDepreciation.get(this.getCtx(), s_defaultDepreciationType);
        return mDepreciation != null ? mDepreciation.get_ID() : 0;
    }

    public int getA_Depreciation_F_ID() {
        return this.getA_Depreciation_ID();
    }

    public int getStdPrecision() {
        return MClient.get(this.getCtx()).getAcctSchema().getStdPrecision();
    }

    public String getSummary() {
        return this.getInventoryNo() + " - " + this.getName();
    }

    public void setError(String string) {
        String string2 = Msg.parseTranslation(this.getCtx(), string);
        this.setI_ErrorMsg(string2);
    }
}

