/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.ResultSet;
import java.util.Properties;
import java.util.logging.Logger;
import org.adempiere.core.domains.models.X_A_Depreciation;
import org.compiere.asset.exceptions.AssetNotImplementedException;
import org.compiere.asset.exceptions.AssetNotSupportedException;
import org.compiere.asset.model.MAssetAcct;
import org.compiere.asset.model.MDepreciationWorkfile;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class MDepreciation
extends X_A_Depreciation {
    private static final long serialVersionUID = 1L;
    private static CCache<Integer, MDepreciation> s_cache = new CCache("A_Depreciation", 5);
    private static CCache<String, MDepreciation> s_cache_forType = new CCache("A_Depreciation_DepreciationType", 5);
    private static Logger s_log = CLogger.getCLogger(MDepreciation.class);
    private static final int m_precision = 2;
    private static final BigDecimal BD_12 = BigDecimal.valueOf(12L);

    public MDepreciation(Properties properties, int n, String string) {
        super(properties, n, string);
    }

    public MDepreciation(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    private static void addToCache(MDepreciation mDepreciation) {
        if (mDepreciation == null) {
            return;
        }
        s_cache.put(mDepreciation.get_ID(), mDepreciation);
        String string = mDepreciation.getAD_Client_ID() + "_" + mDepreciation.getDepreciationType();
        s_cache_forType.put(string, mDepreciation);
    }

    public static MDepreciation get(Properties properties, int n) {
        MDepreciation mDepreciation = s_cache.get(n);
        if (mDepreciation != null) {
            return mDepreciation;
        }
        mDepreciation = new MDepreciation(properties, n, null);
        if (mDepreciation.get_ID() > 0) {
            MDepreciation.addToCache(mDepreciation);
        } else {
            mDepreciation = null;
        }
        return mDepreciation;
    }

    public static MDepreciation get(Properties properties, String string) {
        int n = Env.getAD_Client_ID(properties);
        String string2 = n + "_" + string;
        MDepreciation mDepreciation = s_cache_forType.get(string2);
        if (mDepreciation != null) {
            return mDepreciation;
        }
        mDepreciation = (MDepreciation)new Query(properties, "A_Depreciation", "DepreciationType=? AND AD_Client_ID IN (0,?)", null).setOrderBy("AD_Client_ID DESC").setParameters(string, n).firstOnly();
        MDepreciation.addToCache(mDepreciation);
        return mDepreciation;
    }

    public static int getPrecision() {
        return 2;
    }

    public boolean requireLastPeriodAdjustment() {
        return !"ARH_ZERO".equals(this.getDepreciationType());
    }

    public BigDecimal invoke(MDepreciationWorkfile mDepreciationWorkfile, MAssetAcct mAssetAcct, int n, BigDecimal bigDecimal) {
        String string = this.getDepreciationType();
        BigDecimal bigDecimal2 = null;
        if (CLogMgt.isLevelFinest()) {
            this.log.fine("Entering: DepreciationType=" + string + ", assetwk=" + mDepreciationWorkfile + ", assetacct=" + mAssetAcct + ", A_Current_Period=" + n + ", Accum_Dep=" + bigDecimal);
        }
        if (!this.canInvoke(mDepreciationWorkfile, mAssetAcct, n, bigDecimal)) {
            return BigDecimal.ZERO;
        }
        if (string.equalsIgnoreCase("SL")) {
            bigDecimal2 = this.apply_SL(mDepreciationWorkfile, mAssetAcct, n, bigDecimal);
        } else if (string.equalsIgnoreCase("ARH_VAR")) {
            bigDecimal2 = this.apply_ARH_VAR(mDepreciationWorkfile, mAssetAcct, n, bigDecimal);
        } else if (string.equalsIgnoreCase("ARH_AD1")) {
            bigDecimal2 = this.apply_ARH_AD1(mDepreciationWorkfile, mAssetAcct, n, bigDecimal);
        } else if (string.equalsIgnoreCase("ARH_AD2")) {
            bigDecimal2 = this.apply_ARH_AD2(mDepreciationWorkfile, mAssetAcct, n, bigDecimal);
        } else if (string.equalsIgnoreCase("ARH_ZERO")) {
            bigDecimal2 = this.apply_ARH_ZERO(mDepreciationWorkfile, mAssetAcct, n, bigDecimal);
        } else {
            throw new AssetNotSupportedException("DepreciationType", string);
        }
        if (bigDecimal2 == null) {
            bigDecimal2 = BigDecimal.ZERO;
        }
        bigDecimal2 = bigDecimal2.setScale(MDepreciation.getPrecision(), RoundingMode.HALF_UP);
        if (CLogMgt.isLevelFinest()) {
            this.log.fine("Leaving: retValue=" + bigDecimal2);
        }
        return bigDecimal2;
    }

    public boolean canInvoke(MDepreciationWorkfile mDepreciationWorkfile, MAssetAcct mAssetAcct, int n, BigDecimal bigDecimal) {
        boolean bl;
        if (mDepreciationWorkfile == null) {
            this.log.warning("@NotFound@ @A_Depreciation_Workfile_ID@");
            return false;
        }
        int n2 = 0;
        int n3 = mDepreciationWorkfile.getUseLifeMonths(mDepreciationWorkfile.isFiscal());
        boolean bl2 = bl = n2 <= n;
        if (CLogMgt.isLevelFinest()) {
            this.log.finest("A_Current_Period=" + n + ", lifePeriods=" + n3 + " (offset=" + n2 + ") ==> OK=" + bl);
        }
        return bl;
    }

    private BigDecimal apply_ARH_ZERO(MDepreciationWorkfile mDepreciationWorkfile, MAssetAcct mAssetAcct, int n, BigDecimal bigDecimal) {
        return Env.ZERO;
    }

    private BigDecimal apply_SL(MDepreciationWorkfile mDepreciationWorkfile, MAssetAcct mAssetAcct, int n, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = new BigDecimal(mDepreciationWorkfile.getRemainingPeriods(n - 1));
        BigDecimal bigDecimal3 = mDepreciationWorkfile.getRemainingCost(bigDecimal);
        BigDecimal bigDecimal4 = Env.ZERO;
        if (bigDecimal2.signum() != 0) {
            bigDecimal4 = bigDecimal3.divide(bigDecimal2, MDepreciation.getPrecision(), RoundingMode.HALF_UP);
        }
        if (CLogMgt.isLevelFinest()) {
            this.log.finest("currentPeriod=" + n + ", remainingAmt=" + bigDecimal3 + ", remainingPeriods=" + bigDecimal2 + " => amtPerPeriod=" + bigDecimal4);
        }
        return bigDecimal4;
    }

    private BigDecimal apply_ARH_VAR(MDepreciationWorkfile mDepreciationWorkfile, MAssetAcct mAssetAcct, int n, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = mDepreciationWorkfile.getActualCost();
        BigDecimal bigDecimal3 = mAssetAcct.getA_Depreciation_Variable_Perc(mDepreciationWorkfile.isFiscal()).setScale(MDepreciation.getPrecision(), RoundingMode.HALF_UP);
        BigDecimal bigDecimal4 = BigDecimal.ZERO;
        if (n == 0) {
            bigDecimal4 = bigDecimal2.multiply(bigDecimal3);
        } else if (n >= 12) {
            BigDecimal bigDecimal5 = mDepreciationWorkfile.getRemainingCost(bigDecimal);
            BigDecimal bigDecimal6 = new BigDecimal(mDepreciationWorkfile.getRemainingPeriods(n));
            bigDecimal4 = bigDecimal5.divide(bigDecimal6, MDepreciation.getPrecision(), RoundingMode.HALF_UP);
            if (CLogMgt.isLevelFinest()) {
                this.log.fine("remainingAmt=" + bigDecimal5 + ", remainingPeriods=" + bigDecimal6 + " => assetExp=" + bigDecimal4);
            }
        }
        return bigDecimal4;
    }

    private BigDecimal apply_ARH_AD1(MDepreciationWorkfile mDepreciationWorkfile, MAssetAcct mAssetAcct, int n, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = mDepreciationWorkfile.getActualCost();
        int n2 = mDepreciationWorkfile.getA_Life_Period();
        int n3 = n / 12;
        int n4 = n2 / 12;
        BigDecimal bigDecimal3 = BigDecimal.ONE.divide(new BigDecimal(n4), MDepreciation.getPrecision() + 2, RoundingMode.DOWN);
        BigDecimal bigDecimal4 = bigDecimal3.multiply(new BigDecimal(2.0));
        if (CLogMgt.isLevelFinest()) {
            this.log.fine("assetAmt=" + bigDecimal2 + ", A_Life_Period=" + n2);
            this.log.fine("A_Current_Year=" + n3 + ", A_Life_Year=" + n4);
        }
        BigDecimal bigDecimal5 = BigDecimal.ZERO;
        boolean bl = false;
        BigDecimal bigDecimal6 = BigDecimal.ZERO;
        BigDecimal bigDecimal7 = bigDecimal2;
        for (int i = 0; i <= n3; ++i) {
            if (!bl) {
                int n5 = n4 - i;
                BigDecimal bigDecimal8 = bigDecimal7.multiply(bigDecimal4);
                bigDecimal6 = bigDecimal7.divide(new BigDecimal(n5), MDepreciation.getPrecision(), RoundingMode.HALF_UP);
                if (CLogMgt.isLevelFinest()) {
                    s_log.fine("amt_r=" + bigDecimal7 + ", amt_ad1=amt_r*coef_ad1=" + bigDecimal8 + ", amt_sl=amt_r/A_RemainingLife_Year=" + bigDecimal6 + ", A_Current_Year=" + n3 + ", A_RemainingLife_Year=" + n5);
                }
                if (i == 0 || bigDecimal8.compareTo(bigDecimal6) >= 0) {
                    bigDecimal5 = bigDecimal8;
                } else {
                    bigDecimal5 = bigDecimal6;
                    bl = true;
                    s_log.fine("*** PASS IT ON linear amt_sl= " + bigDecimal6 + " ***");
                }
            } else {
                bigDecimal5 = bigDecimal6;
                s_log.fine("* linear *");
            }
            bigDecimal7 = bigDecimal7.subtract(bigDecimal5);
            if (!CLogMgt.isLevelFinest()) continue;
            s_log.fine("year=" + i + ", amtPerYear=" + bigDecimal5 + ", amt_r=" + bigDecimal7);
        }
        if (CLogMgt.isLevelFinest()) {
            s_log.fine("amt_r=" + bigDecimal7 + ", amtPerYear=" + bigDecimal5);
        }
        BigDecimal bigDecimal9 = this.getPeriodExp(n, bigDecimal5);
        if (CLogMgt.isLevelFinest()) {
            this.log.fine("assetExp=" + bigDecimal9);
        }
        return bigDecimal9;
    }

    private BigDecimal apply_ARH_AD2(MDepreciationWorkfile mDepreciationWorkfile, MAssetAcct mAssetAcct, int n, BigDecimal bigDecimal) {
        throw new AssetNotImplementedException("AD2");
    }

    private static BigDecimal get_AD_K(int n) {
        if (n < 2) {
            throw new IllegalArgumentException("@A_Life_Year@ = " + n + " < 2");
        }
        if (n <= 5) {
            return new BigDecimal(1.5);
        }
        if (n <= 10) {
            return new BigDecimal(2.0);
        }
        return new BigDecimal(2.5);
    }

    protected BigDecimal getPeriodExp(int n, BigDecimal bigDecimal) {
        BigDecimal bigDecimal2 = bigDecimal.divide(BD_12, MDepreciation.getPrecision(), RoundingMode.HALF_UP);
        BigDecimal bigDecimal3 = BigDecimal.ZERO;
        BigDecimal bigDecimal4 = bigDecimal2;
        if (n % 12 == 11) {
            bigDecimal3 = bigDecimal.subtract(bigDecimal2.multiply(BD_12));
            bigDecimal4 = bigDecimal4.add(bigDecimal3).setScale(MDepreciation.getPrecision(), RoundingMode.HALF_UP);
        }
        if (CLogMgt.isLevelFinest()) {
            this.log.fine("amtPerYear=" + bigDecimal + ", amtPerMonth=" + bigDecimal2 + ", adj=" + bigDecimal3 + " => assetExp=" + bigDecimal4);
        }
        return bigDecimal4;
    }

    public int getFixMonthOffset() {
        return 0;
    }
}

