/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.model;

import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Properties;
import org.adempiere.core.domains.models.X_A_Asset_Acct;
import org.apache.commons.collections4.keyvalue.MultiKey;
import org.compiere.asset.model.MAsset;
import org.compiere.asset.model.MAssetGroupAcct;
import org.compiere.model.MAccount;
import org.compiere.model.MAcctSchema;
import org.compiere.model.PO;
import org.compiere.model.ProductCost;
import org.compiere.model.Query;
import org.compiere.util.CCache;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class MAssetAcct
extends X_A_Asset_Acct {
    private static final long serialVersionUID = 4779953750434068382L;
    private static CCache<Integer, MAssetAcct> s_cache = new CCache("A_Asset_Acct", 5);
    private static CCache<MultiKey, MAssetAcct> s_cacheAsset = new CCache("A_Asset_Acct_Asset", 5);

    public MAssetAcct(Properties properties, int n, String string) {
        super(properties, n, string);
        if (n == 0) {
            this.setA_Salvage_Value(Env.ZERO);
        }
    }

    public MAssetAcct(Properties properties, ResultSet resultSet, String string) {
        super(properties, resultSet, string);
    }

    public static MAssetAcct get(Properties properties, int n) {
        MAssetAcct mAssetAcct = s_cache.get(n);
        if (mAssetAcct != null) {
            return mAssetAcct;
        }
        mAssetAcct = new MAssetAcct(properties, n, null);
        if (mAssetAcct.get_ID() > 0) {
            MAssetAcct.addToCache(mAssetAcct, null);
        } else {
            mAssetAcct = null;
        }
        return mAssetAcct;
    }

    public static MAssetAcct forA_Asset_ID(Properties properties, int n, String string, Timestamp timestamp, String string2) {
        MultiKey multiKey = new MultiKey((Object)n, (Object)string, (Object)timestamp);
        MAssetAcct mAssetAcct = null;
        if (string2 == null) {
            // empty if block
        }
        if (mAssetAcct != null) {
            return mAssetAcct;
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        StringBuffer stringBuffer = new StringBuffer("A_Asset_ID=? AND PostingType=?");
        arrayList.add(n);
        arrayList.add(string);
        if (timestamp != null) {
            stringBuffer.append(" AND ValidFrom").append("<=?");
            arrayList.add(timestamp);
        }
        mAssetAcct = (MAssetAcct)new Query(properties, "A_Asset_Acct", stringBuffer.toString(), string2).setParameters(arrayList).setOrderBy("ValidFrom DESC NULLS LAST").first();
        if (string2 == null) {
            MAssetAcct.addToCache(mAssetAcct, multiKey);
        }
        return mAssetAcct;
    }

    private static void addToCache(MAssetAcct mAssetAcct, MultiKey multiKey) {
        if (mAssetAcct == null || mAssetAcct.get_ID() <= 0) {
            return;
        }
        s_cache.put(mAssetAcct.get_ID(), mAssetAcct);
        if (multiKey != null) {
            s_cacheAsset.put(multiKey, mAssetAcct);
        }
    }

    public MAssetAcct(MAsset mAsset, MAssetGroupAcct mAssetGroupAcct) {
        this(mAssetGroupAcct.getCtx(), 0, mAsset.get_TrxName());
        PO.copyValues(mAssetGroupAcct, this);
        this.setA_Asset_ID(mAsset.getA_Asset_ID());
        if (mAsset.getA_Depreciation_ID() > 0) {
            this.setA_Depreciation_ID(mAsset.getA_Depreciation_ID());
        }
        if (mAsset.getA_Depreciation_F_ID() > 0) {
            this.setA_Depreciation_F_ID(mAsset.getA_Depreciation_F_ID());
        }
        this.setA_Period_Start(1);
        this.setA_Period_End(mAsset.getUseLifeMonths());
        this.dump();
    }

    public BigDecimal getA_Depreciation_Variable_Perc(boolean bl) {
        return bl ? this.getA_Depreciation_Variable_Perc_F() : this.getA_Depreciation_Variable_Perc();
    }

    @Override
    public MAcctSchema getC_AcctSchema() {
        return MAcctSchema.get(this.getCtx(), this.getC_AcctSchema_ID());
    }

    public MAccount getP_Asset_Acct(int n) {
        MAcctSchema mAcctSchema = this.getC_AcctSchema();
        ProductCost productCost = new ProductCost(this.getCtx(), n, 0, null);
        return productCost.getAccount(3, mAcctSchema);
    }

    @Override
    protected boolean beforeSave(boolean bl) {
        if (this.getValidFrom() == null && bl) {
            this.setValidFrom(TimeUtil.getDay(1970, 1, 1));
        }
        return true;
    }
}

