/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.feature;

import java.sql.Timestamp;
import java.util.Properties;
import org.compiere.asset.feature.UseLife;
import org.compiere.asset.model.MAssetGroup;
import org.compiere.asset.model.SetGetModel;
import org.compiere.asset.model.SetGetUtil;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.Msg;
import org.compiere.util.TimeUtil;

public class UseLifeImpl
implements UseLife {
    private static final String FIELD_UseLifeYears = "UseLifeYears";
    private static final String FIELD_UseLifeMonths = "UseLifeMonths";
    private static final String FIELD_FiscalPostfix = "_F";
    private SetGetModel m_obj = null;
    private CLogger log = CLogger.getCLogger(this.getClass());
    private boolean fiscal = false;

    public static UseLifeImpl get(SetGetModel setGetModel) {
        return new UseLifeImpl(setGetModel, false);
    }

    public static UseLifeImpl get(SetGetModel setGetModel, boolean bl) {
        return new UseLifeImpl(setGetModel, bl);
    }

    public UseLifeImpl(SetGetModel setGetModel, boolean bl) {
        this.m_obj = setGetModel;
        this.fiscal = bl;
    }

    @Override
    public Properties getCtx() {
        return this.m_obj.getCtx();
    }

    @Override
    public int get_Table_ID() {
        return this.m_obj.get_Table_ID();
    }

    @Override
    public String get_TableName() {
        return this.m_obj.get_TableName();
    }

    private static final String getFieldName(String string, boolean bl) {
        Object object = string;
        if (bl) {
            object = (String)object + FIELD_FiscalPostfix;
        }
        return object;
    }

    public boolean isFiscal() {
        return this.fiscal;
    }

    @Override
    public boolean set_AttrValue(String string, Object object) {
        return this.m_obj.set_AttrValue(string, object);
    }

    @Override
    public Object get_AttrValue(String string) {
        return this.m_obj.get_AttrValue(string);
    }

    @Override
    public boolean is_AttrValueChanged(String string) {
        return this.m_obj.is_AttrValueChanged(string);
    }

    @Override
    public String get_TrxName() {
        return this.m_obj.get_TrxName();
    }

    public void setUseLifeMonths(int n) {
        if (CLogMgt.isLevelFine()) {
            this.log.fine("Entering: value=" + n + ", " + this);
        }
        this.m_obj.set_AttrValue(UseLifeImpl.getFieldName(FIELD_UseLifeMonths, this.fiscal), n);
        this.m_obj.set_AttrValue(UseLifeImpl.getFieldName(FIELD_UseLifeYears, this.fiscal), n / 12);
        if (CLogMgt.isLevelFine()) {
            this.log.fine("Leaving: value=" + n + ", " + this);
        }
    }

    public int getUseLifeMonths() {
        Object object = this.m_obj.get_AttrValue(UseLifeImpl.getFieldName(FIELD_UseLifeMonths, this.fiscal));
        if (object != null && object instanceof Number) {
            return ((Number)object).intValue();
        }
        return 0;
    }

    public void setUseLifeYears(int n) {
        if (CLogMgt.isLevelFine()) {
            this.log.fine("Entering: value=" + n + ", " + this);
        }
        this.m_obj.set_AttrValue(UseLifeImpl.getFieldName(FIELD_UseLifeYears, this.fiscal), n);
        this.m_obj.set_AttrValue(UseLifeImpl.getFieldName(FIELD_UseLifeMonths, this.fiscal), n * 12);
        if (CLogMgt.isLevelFine()) {
            this.log.fine("Leaving: value=" + n + ", " + this);
        }
    }

    public int getUseLifeYears() {
        Object object = this.m_obj.get_AttrValue(UseLifeImpl.getFieldName(FIELD_UseLifeYears, this.fiscal));
        if (object != null && object instanceof Number) {
            return ((Number)object).intValue();
        }
        return 0;
    }

    public void adjustUseLifeYears(int n, boolean bl) {
        int n2 = bl ? 0 : this.getUseLifeYears();
        int n3 = n2 + n;
        this.setUseLifeYears(n3);
        if (CLogMgt.isLevelFine()) {
            this.log.fine("UseLifeYears=" + n2 + ", delta=" + n + " => new UseLifeYears=" + n3 + " (isFiscal=" + this.isFiscal() + ")");
        }
    }

    @Override
    public Timestamp getAssetServiceDate() {
        if (this.m_obj instanceof UseLife) {
            return ((UseLife)this.m_obj).getAssetServiceDate();
        }
        Object object = this.m_obj.get_AttrValue("AssetServiceDate");
        if (object != null && object instanceof Timestamp) {
            return (Timestamp)object;
        }
        return null;
    }

    public boolean validate() {
        return this.validate(true);
    }

    public boolean validate(boolean bl) {
        if (CLogMgt.isLevelFine()) {
            this.log.fine("Entering: " + this);
        }
        int n = 0;
        int n2 = 0;
        n = this.getUseLifeYears();
        n2 = this.getUseLifeMonths();
        if (n2 == 0) {
            n2 = n * 12;
        }
        if (n2 % 12 != 0) {
            if (bl) {
                this.log.saveError("Error", "@Invalid@ @UseLifeMonths@=" + n2 + "(@Diff@=" + n2 % 12 + ")");
            }
            return false;
        }
        if (n == 0) {
            n = n2 / 12;
        }
        this.setUseLifeMonths(n2);
        this.setUseLifeYears(n);
        this.log.fine("Leaving [RETURN TRUE]");
        return true;
    }

    public String toString() {
        return "UseLifeImpl[UseLife=" + this.getUseLifeYears() + "|" + this.getUseLifeMonths() + ", isFiscal=" + this.isFiscal() + ", AssetServiceDate=" + this.getAssetServiceDate() + ", m_obj=" + this.m_obj + "]";
    }

    public static Timestamp getDateAcct(Timestamp timestamp, int n) {
        if (timestamp == null) {
            return null;
        }
        return TimeUtil.addMonths(timestamp, n);
    }

    public static class Callout
    extends CalloutEngine {
        private String validate(Properties properties, int n, GridTab gridTab, GridField gridField, Object object, Object object2) {
            Timestamp timestamp = (Timestamp)gridTab.getValue("AssetServiceDate");
            if (timestamp == null) {
                return "";
            }
            Integer n2 = (Integer)gridTab.getValue(UseLifeImpl.FIELD_UseLifeMonths);
            if (n2 == null) {
                n2 = 0;
            }
            return "";
        }

        public String assetServiceDate(Properties properties, int n, GridTab gridTab, GridField gridField, Object object, Object object2) {
            if (this.isCalloutActive() || object == null) {
                return "";
            }
            return this.validate(properties, n, gridTab, gridField, object, object2);
        }

        public String useLife(Properties properties, int n, GridTab gridTab, GridField gridField, Object object, Object object2) {
            String string;
            if (this.isCalloutActive()) {
                return "";
            }
            String string2 = "";
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            Object object3 = "";
            if (object != null) {
                n2 = (Integer)object;
            }
            if ((string = gridField.getColumnName().toUpperCase()).endsWith(UseLifeImpl.FIELD_FiscalPostfix)) {
                string2 = UseLifeImpl.FIELD_FiscalPostfix;
                string = string.substring(0, string.length() - UseLifeImpl.FIELD_FiscalPostfix.length());
            }
            if (string.equalsIgnoreCase(UseLifeImpl.FIELD_UseLifeMonths)) {
                if (n2 % 12 != 0) {
                    object3 = "@Invalid@ @UseLifeMonths " + string2 + "@=" + n2;
                } else {
                    n3 = n2 / 12;
                    gridTab.setValue(UseLifeImpl.FIELD_UseLifeYears + string2, (Object)n3);
                }
            } else if (string.equalsIgnoreCase(UseLifeImpl.FIELD_UseLifeYears)) {
                n4 = n2 * 12;
                gridTab.setValue(UseLifeImpl.FIELD_UseLifeMonths + string2, (Object)n4);
            }
            if (((String)object3).length() > 0) {
                object3 = Msg.parseTranslation(properties, (String)object3);
            }
            return object3;
        }

        public String assetGroup(Properties properties, int n, GridTab gridTab, GridField gridField, Object object, Object object2) {
            if (this.isCalloutActive()) {
                return "";
            }
            int n2 = -1;
            if (object != null && object instanceof Number) {
                n2 = ((Number)object).intValue();
            }
            MAssetGroup.updateAsset(SetGetUtil.wrap(gridTab), n2);
            return "";
        }
    }
}

