/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.asset.controller;

import java.math.BigDecimal;
import java.util.Properties;
import org.adempiere.core.domains.models.I_A_Asset_Addition;
import org.adempiere.model.GridTabWrapper;
import org.compiere.asset.model.MAssetAddition;
import org.compiere.asset.model.MConversionRateUtil;
import org.compiere.asset.model.SetGetUtil;
import org.compiere.model.CalloutEngine;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MProject;
import org.compiere.util.Env;
import org.compiere.util.TimeUtil;

public class CalloutAssetAddition
extends CalloutEngine {
    public String matchInv(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        if (this.isCalloutActive() || object == null) {
            return "";
        }
        int n2 = ((Number)object).intValue();
        if (n2 > 0) {
            MAssetAddition.setM_MatchInv(SetGetUtil.wrap(gridTab), n2);
        }
        return this.amt(properties, n, gridTab, gridField, object);
    }

    public String project(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        if (this.isCalloutActive()) {
            return "";
        }
        int n2 = 0;
        if (object == null || !(object instanceof Number)) {
            return "";
        }
        n2 = ((Number)object).intValue();
        BigDecimal bigDecimal = Env.ZERO;
        if (n2 > 0) {
            MProject mProject = new MProject(properties, n2, null);
            bigDecimal = mProject.getProjectBalanceAmt();
            gridTab.setValue("C_Currency_ID", (Object)mProject.getC_Currency_ID());
        }
        gridTab.setValue("AssetSourceAmt", (Object)bigDecimal);
        return this.amt(properties, n, gridTab, gridField, object);
    }

    public String amt(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        if (this.isCalloutActive()) {
            return "";
        }
        String string = gridField.getColumnName();
        if ("A_Accumulated_Depr".equals(string)) {
            gridTab.setValue("A_Accumulated_Depr_F", object);
        } else {
            BigDecimal bigDecimal = (BigDecimal)gridTab.getValue("AssetAmtEntered");
            gridTab.setValue("AssetSourceAmt", (Object)bigDecimal);
            MConversionRateUtil.convertBase(SetGetUtil.wrap(gridTab), "DateAcct", "AssetSourceAmt", "AssetValueAmt", gridField.getColumnName());
        }
        return "";
    }

    public String dateDoc(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        if (this.isCalloutActive() || object == null) {
            return "";
        }
        gridTab.setValue("DateAcct", object);
        return "";
    }

    public String uselife(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        if ("DeltaUseLifeYears".equals(gridField.getColumnName())) {
            gridTab.setValue("DeltaUseLifeYears_F", object);
        }
        return "";
    }

    public String periodOffset(Properties properties, int n, GridTab gridTab, GridField gridField, Object object) {
        I_A_Asset_Addition i_A_Asset_Addition = GridTabWrapper.create(gridTab, I_A_Asset_Addition.class);
        if (!i_A_Asset_Addition.isA_Accumulated_Depr_Adjust()) {
            return "";
        }
        int n2 = TimeUtil.getMonthsBetween(i_A_Asset_Addition.getDateDoc(), i_A_Asset_Addition.getDateAcct());
        if (n2 <= 0) {
            return "";
        }
        int n3 = i_A_Asset_Addition.getDeltaUseLifeYears() * 12;
        if (n3 == 0) {
            return "";
        }
        double d = i_A_Asset_Addition.getAssetValueAmt().doubleValue() / (double)n3 * (double)n2;
        i_A_Asset_Addition.setA_Period_Start(n2 + 1);
        i_A_Asset_Addition.setA_Accumulated_Depr(BigDecimal.valueOf(d));
        i_A_Asset_Addition.setA_Accumulated_Depr_F(BigDecimal.valueOf(d));
        return "";
    }
}

