/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Component;
import java.awt.Frame;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.ALayoutConstraint;
import org.compiere.apps.search.Info;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MQuery;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.Env;
import org.compiere.util.Msg;
import org.compiere.util.Util;

public class InfoInOut
extends Info {
    private static final long serialVersionUID = -2066307179999903184L;
    int fieldID = 0;
    private CLabel lDocumentNo = new CLabel(Msg.translate(Env.getCtx(), "DocumentNo"));
    private CTextField fDocumentNo = new CTextField(10);
    private CLabel lDescription = new CLabel(Msg.translate(Env.getCtx(), "Description"));
    private CTextField fDescription = new CTextField(10);
    private CLabel lPOReference = new CLabel(Msg.translate(Env.getCtx(), "POReference"));
    private CTextField fPOReference = new CTextField(10);
    private CLabel lBPartner_ID = new CLabel(Msg.translate(Env.getCtx(), "BPartner"));
    private VLookup fBPartner_ID;
    private CLabel lShipper_ID = new CLabel(Msg.translate(Env.getCtx(), "Shipper"));
    private VLookup fShipper_ID;
    private CLabel lDateFrom = new CLabel(Msg.translate(Env.getCtx(), "MovementDate"));
    private VDate fDateFrom = new VDate("DateFrom", false, false, true, 15, Msg.translate(Env.getCtx(), "DateFrom"));
    private CLabel lDateTo = new CLabel("- ");
    private VDate fDateTo = new VDate("DateTo", false, false, true, 15, Msg.translate(Env.getCtx(), "DateTo"));
    private VCheckBox fIsSOTrx = new VCheckBox("IsSOTrx", false, false, true, Msg.translate(Env.getCtx(), "IsSOTrx"), "", false);
    private static String s_From = " M_InOut i";
    private static String s_Order = " i.MovementDate desc, i.DocumentNo";
    private static final Info_Column[] s_Layout = new Info_Column[]{new Info_Column(" ", "i.M_InOut_ID", IDColumn.class), new Info_Column(Msg.translate(Env.getCtx(), "C_BPartner_ID"), "(SELECT Name FROM C_BPartner bp WHERE bp.C_BPartner_ID=i.C_BPartner_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "MovementDate"), "i.MovementDate", Timestamp.class), new Info_Column(Msg.translate(Env.getCtx(), "DocumentNo"), "i.DocumentNo", String.class), new Info_Column(Msg.translate(Env.getCtx(), "Description"), "i.Description", String.class), new Info_Column(Msg.translate(Env.getCtx(), "POReference"), "i.POReference", String.class), new Info_Column(Msg.translate(Env.getCtx(), "M_Shipper_ID"), "(SELECT Name FROM M_Shipper ms WHERE ms.M_Shipper_ID = i.M_Shipper_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "ShipDate"), "i.ShipDate", Timestamp.class), new Info_Column(Msg.translate(Env.getCtx(), "TrackingNo"), "i.TrackingNo", String.class), new Info_Column(Msg.translate(Env.getCtx(), "IsDropShip"), "i.IsDropShip", Boolean.class), new Info_Column(Msg.translate(Env.getCtx(), "DropShip_BPartner_ID"), "(SELECT Name FROM C_BPartner bp WHERE bp.C_BPartner_ID=i.DropShip_BPartner_ID)", String.class), new Info_Column(Msg.translate(Env.getCtx(), "DocStatus"), "i.docstatus", String.class)};

    @Deprecated
    protected InfoInOut(Frame frame, boolean modal, int WindowNo, String value, boolean multiSelection, String whereClause) {
        this(frame, modal, WindowNo, 0, value, multiSelection, true, whereClause);
    }

    protected InfoInOut(Frame frame, boolean modal, int WindowNo, int record_id, String value, boolean multiSelection, boolean saveResults, String whereClause) {
        super(frame, modal, WindowNo, "i", "M_InOut_ID", multiSelection, saveResults, whereClause);
        this.log.info("InfoInOut");
        this.setTitle(Msg.getMsg(Env.getCtx(), "InfoInOut"));
        StringBuffer where = new StringBuffer("i.IsActive='Y'");
        if (whereClause.length() > 0) {
            where.append(" AND ").append(Util.replace(whereClause, "M_InOut.", "i."));
        }
        this.setWhereClause(where.toString());
        this.setTableLayout(s_Layout);
        this.setFromClause(s_From);
        this.setOrderClause(s_Order);
        this.statInit();
        this.initInfo(record_id, value);
        this.m_heldLastFocus = this.fDocumentNo;
        if (this.autoQuery() || record_id != 0 || value != null && value.length() > 0 && value != "%") {
            this.executeQuery();
        }
        this.p_loadedOK = true;
        AEnv.positionCenterWindow(frame, this);
    }

    private void statInit() {
        this.lDocumentNo.setLabelFor(this.fDocumentNo);
        this.fDocumentNo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDocumentNo.addActionListener(this);
        this.lDescription.setLabelFor(this.fDescription);
        this.fDescription.setBackground(AdempierePLAF.getInfoBackground());
        this.fDescription.addActionListener(this);
        this.lPOReference.setLabelFor(this.fPOReference);
        this.fPOReference.setBackground(AdempierePLAF.getInfoBackground());
        this.fPOReference.addActionListener(this);
        this.fIsSOTrx.setSelected(!"N".equals(Env.getContext(Env.getCtx(), this.p_WindowNo, "IsSOTrx")));
        this.fIsSOTrx.addActionListener(this);
        this.fBPartner_ID = new VLookup("C_BPartner_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("M_InOut", "C_BPartner_ID"), 30));
        this.lBPartner_ID.setLabelFor(this.fBPartner_ID);
        this.fBPartner_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fBPartner_ID.addActionListener(this);
        this.fShipper_ID = new VLookup("M_Shipper_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.p_WindowNo, 0, MColumn.getColumn_ID("M_InOut", "M_Shipper_ID"), 19));
        this.lShipper_ID.setLabelFor(this.fShipper_ID);
        this.fShipper_ID.setBackground(AdempierePLAF.getInfoBackground());
        this.fShipper_ID.addActionListener(this);
        this.lDateFrom.setLabelFor(this.fDateFrom);
        this.fDateFrom.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateFrom.setToolTipText(Msg.translate(Env.getCtx(), "DateFrom"));
        this.fDateFrom.addActionListener(this);
        this.lDateTo.setLabelFor(this.fDateTo);
        this.fDateTo.setBackground(AdempierePLAF.getInfoBackground());
        this.fDateTo.setToolTipText(Msg.translate(Env.getCtx(), "DateTo"));
        this.fDateTo.addActionListener(this);
        CPanel datePanel = new CPanel();
        datePanel.setLayout(new ALayout(0, 0, true));
        datePanel.add((Component)this.fDateFrom, new ALayoutConstraint(0, 0));
        datePanel.add((Component)this.lDateTo, null);
        datePanel.add((Component)this.fDateTo, null);
        this.p_criteriaGrid.add((Component)this.lDocumentNo, new ALayoutConstraint(0, 0));
        this.p_criteriaGrid.add((Component)this.fDocumentNo, null);
        this.p_criteriaGrid.add((Component)this.lBPartner_ID, null);
        this.p_criteriaGrid.add((Component)this.fBPartner_ID, null);
        this.p_criteriaGrid.add((Component)this.fIsSOTrx, new ALayoutConstraint(0, 5));
        this.p_criteriaGrid.add((Component)this.lDescription, new ALayoutConstraint(1, 0));
        this.p_criteriaGrid.add((Component)this.fDescription, null);
        this.p_criteriaGrid.add((Component)this.lDateFrom, null);
        this.p_criteriaGrid.add((Component)datePanel, null);
        this.p_criteriaGrid.add((Component)this.lPOReference, new ALayoutConstraint(2, 0));
        this.p_criteriaGrid.add((Component)this.fPOReference, null);
        this.p_criteriaGrid.add((Component)this.lShipper_ID, null);
        this.p_criteriaGrid.add((Component)this.fShipper_ID, null);
    }

    @Override
    protected void initInfo(int record_id, String value) {
        if (record_id != 0 && value != null && value.length() > 0) {
            this.log.severe("Received both a record_id and a value: " + record_id + " - " + value);
        }
        if (record_id != 0) {
            this.fieldID = record_id;
        } else if (value != null && value.length() > 0) {
            this.fDocumentNo.setValue(value);
        } else {
            String id = Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "M_InOut_ID", true);
            if (id != null && id.length() != 0 && Integer.valueOf(id) > 0) {
                this.fieldID = Integer.valueOf(id);
            }
            if ((id = Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "C_BPartner_ID", true)) != null && id.length() != 0 && Integer.valueOf(id) > 0) {
                this.fBPartner_ID.setValue(Integer.valueOf(id));
            }
            if ((id = Env.getContext(Env.getCtx(), this.p_WindowNo, this.p_TabNo, "M_Shipper_ID", true)) != null && id.length() != 0 && Integer.valueOf(id) > 0) {
                this.fShipper_ID.setValue((int)Integer.valueOf(id));
            }
        }
    }

    @Override
    protected String getSQLWhere() {
        StringBuffer sql = new StringBuffer();
        if (this.isResetRecordID()) {
            this.fieldID = 0;
        }
        if (this.fieldID != 0) {
            sql.append(" AND i.M_InOut_ID = ?");
        }
        if (this.fDocumentNo.getText().length() > 0) {
            sql.append(" AND UPPER(i.DocumentNo) LIKE ?");
        }
        if (this.fDescription.getText().length() > 0) {
            sql.append(" AND UPPER(i.Description) LIKE ?");
        }
        if (this.fPOReference.getText().length() > 0) {
            sql.append(" AND UPPER(i.POReference) LIKE ?");
        }
        if (this.fBPartner_ID.getValue() != null) {
            sql.append(" AND i.C_BPartner_ID=?");
        }
        if (this.fShipper_ID.getValue() != null) {
            sql.append(" AND i.M_Shipper_ID=?");
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            Timestamp from = (Timestamp)this.fDateFrom.getValue();
            Timestamp to = (Timestamp)this.fDateTo.getValue();
            if (from == null && to != null) {
                sql.append(" AND TRUNC(i.MovementDate, 'DD') <= ?");
            } else if (from != null && to == null) {
                sql.append(" AND TRUNC(i.MovementDate, 'DD') >= ?");
            } else if (from != null && to != null) {
                sql.append(" AND TRUNC(i.MovementDate, 'DD') BETWEEN ? AND ?");
            }
        }
        sql.append(" AND i.IsSOTrx=?");
        return sql.toString();
    }

    @Override
    protected void setParameters(PreparedStatement pstmt, boolean forCount) throws SQLException {
        Integer bp;
        int index = 1;
        if (this.fieldID != 0) {
            pstmt.setInt(index++, this.fieldID);
        }
        if (this.fDocumentNo.getText().length() > 0) {
            pstmt.setString(index++, InfoInOut.getSQLText(this.fDocumentNo));
        }
        if (this.fDescription.getText().length() > 0) {
            pstmt.setString(index++, InfoInOut.getSQLText(this.fDescription));
        }
        if (this.fPOReference.getText().length() > 0) {
            pstmt.setString(index++, InfoInOut.getSQLText(this.fPOReference));
        }
        if (this.fBPartner_ID.getValue() != null) {
            bp = (Integer)this.fBPartner_ID.getValue();
            pstmt.setInt(index++, bp);
            this.log.fine("BPartner=" + bp);
        }
        if (this.fShipper_ID.getValue() != null) {
            bp = (Integer)this.fShipper_ID.getValue();
            pstmt.setInt(index++, bp);
            this.log.fine("Shipper=" + bp);
        }
        if (this.fDateFrom.getValue() != null || this.fDateTo.getValue() != null) {
            Timestamp from = (Timestamp)this.fDateFrom.getValue();
            Timestamp to = (Timestamp)this.fDateTo.getValue();
            this.log.fine("Date From=" + from + ", To=" + to);
            if (from == null && to != null) {
                pstmt.setTimestamp(index++, to);
            } else if (from != null && to == null) {
                pstmt.setTimestamp(index++, from);
            } else if (from != null && to != null) {
                pstmt.setTimestamp(index++, from);
                pstmt.setTimestamp(index++, to);
            }
        }
        pstmt.setString(index++, this.fIsSOTrx.isSelected() ? "Y" : "N");
    }

    @Override
    protected void zoom(int record_ID) {
        this.log.info("InfoInOut.zoom");
        Integer M_InOut_ID = record_ID;
        if (M_InOut_ID == null) {
            return;
        }
        MQuery query = new MQuery("M_InOut");
        query.addRestriction("M_InOut_ID", "=", M_InOut_ID);
        query.setRecordCount(1);
        int AD_WindowNo = this.getAD_Window_ID("M_InOut", this.fIsSOTrx.isSelected());
        this.zoom(AD_WindowNo, query);
    }

    @Override
    protected boolean hasZoom() {
        return true;
    }

    @Override
    protected boolean hasOutstandingChanges() {
        return this.fDocumentNo.hasChanged() || this.fDescription.hasChanged() || this.fPOReference.hasChanged() || this.fIsSOTrx.hasChanged() || this.fBPartner_ID.hasChanged() || this.fShipper_ID.hasChanged() || this.fDateFrom.hasChanged() || this.fDateTo.hasChanged();
    }

    @Override
    protected void setFieldOldValues() {
        this.fDocumentNo.set_oldValue();
        this.fDescription.set_oldValue();
        this.fPOReference.set_oldValue();
        this.fIsSOTrx.set_oldValue();
        this.fBPartner_ID.set_oldValue();
        this.fShipper_ID.set_oldValue();
        this.fDateFrom.set_oldValue();
        this.fDateTo.set_oldValue();
    }

    @Override
    protected void clearParameters() {
        Object nullObject = null;
        this.fDocumentNo.setValue("");
        this.fDescription.setValue("");
        this.fPOReference.setValue("");
        this.fBPartner_ID.setValue(null);
        this.fShipper_ID.setValue(null);
        this.fDateFrom.setValue(nullObject);
        this.fDateTo.setValue(nullObject);
        this.fIsSOTrx.setSelected(!"N".equals(Env.getContext(Env.getCtx(), this.p_WindowNo, "IsSOTrx")));
    }
}

