/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.plaf.ColorUIResource;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.DefaultTableModel;
import org.adempiere.plaf.AdempiereTaskPaneUI;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ALayout;
import org.compiere.apps.AWindow;
import org.compiere.apps.AppsAction;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.PrintScreenPainter;
import org.compiere.apps.StatusBar;
import org.compiere.apps.search.InfoAsset;
import org.compiere.apps.search.InfoAssignment;
import org.compiere.apps.search.InfoBPartner;
import org.compiere.apps.search.InfoCashLine;
import org.compiere.apps.search.InfoGeneral;
import org.compiere.apps.search.InfoInOut;
import org.compiere.apps.search.InfoInvoice;
import org.compiere.apps.search.InfoOrder;
import org.compiere.apps.search.InfoPayment;
import org.compiere.apps.search.InfoProduct;
import org.compiere.apps.search.Info_Column;
import org.compiere.grid.ed.Calculator;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VLookup;
import org.compiere.grid.ed.VPAttribute;
import org.compiere.minigrid.IDColumn;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.GridTab;
import org.compiere.model.MQuery;
import org.compiere.model.MRole;
import org.compiere.model.MSysConfig;
import org.compiere.swing.CButton;
import org.compiere.swing.CDialog;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.jdesktop.swingx.JXTaskPane;
import org.jdesktop.swingx.plaf.TaskPaneUI;

public abstract class Info
extends CDialog
implements ListSelectionListener,
PropertyChangeListener {
    private static final long serialVersionUID = -5606614040914295869L;
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    Dimension screensize = this.toolkit.getScreenSize();
    protected final int INFO_WIDTH;
    protected final int SCREEN_HEIGHT;
    private static String SYSCONFIG_INFO_AUTO_WILDCARD = "INFO_AUTO_WILDCARD";
    private static String SYSCONFIG_INFO_AUTO_QUERY = "INFO_AUTO_QUERY";
    protected int p_WindowNo;
    protected int p_TabNo;
    protected String p_tableName;
    protected String p_keyColumn;
    protected String p_whereClause;
    protected boolean p_saveResults;
    protected boolean p_resetColumns;
    boolean p_triggerRefresh;
    boolean p_refreshNow;
    protected MiniTable p_table;
    protected int p_selectedRecordKey;
    private boolean m_ok;
    private boolean m_cancel;
    protected boolean m_resetRecordID;
    private ArrayList<Integer> m_results;
    protected Info_Column[] p_layout;
    protected String p_sqlFrom;
    protected String p_sqlWhere;
    protected String p_sqlOrder;
    private String m_sqlMain;
    private String m_sqlCount;
    private String m_sqlOrder;
    ListSelectionEvent m_lse;
    protected boolean p_loadedOK;
    private int m_SO_Window_ID;
    private int m_PO_Window_ID;
    private Worker m_worker;
    protected Boolean m_ignoreEvents;
    protected CLogger log;
    private CButton bReset;
    private VCheckBox checkAutoQuery;
    private CPanel southPanel;
    private BorderLayout southLayout;
    ConfirmPanel confirmPanel;
    private CPanel buttonPanel;
    protected CPanel p_criteriaGrid;
    protected JXTaskPane p_detailTaskPane;
    protected CPanel addonPanel;
    protected StatusBar statusBar;
    protected CPanel parameterPanel;
    private JScrollPane scrollPane;
    private JPopupMenu popup;
    private CMenuItem calcMenu;
    private CMenuItem zoomMenu;
    protected Object m_heldLastFocus;
    protected int m_leadSelection;
    private int m_popupRow;
    private int m_popupColumn;
    protected Container m_parentPanel;
    private Action doDispose;
    private boolean m_showTotals;

    @Deprecated
    public static Info create(Frame frame, boolean modal, int WindowNo, String tableName, String keyColumn, String value, boolean multiSelection, String whereClause) {
        return Info.create(frame, modal, WindowNo, tableName, keyColumn, 0, value, multiSelection, true, whereClause);
    }

    public static Info create(Frame frame, boolean modal, int windowNo, String tableName, String keyColumn, int record_id, String value, boolean multiSelection, boolean saveResult, String whereClause) {
        Info info = null;
        info = tableName.equals("C_BPartner") ? new InfoBPartner(frame, modal, windowNo, record_id, value, !Env.getContext(Env.getCtx(), "IsSOTrx").equals("N"), false, multiSelection, saveResult, whereClause) : (tableName.equals("M_Product") ? new InfoProduct(frame, modal, windowNo, 0, 0, record_id, value, multiSelection, saveResult, whereClause) : (tableName.equals("C_Invoice") ? new InfoInvoice(frame, modal, windowNo, record_id, value, multiSelection, saveResult, whereClause) : (tableName.equals("A_Asset") ? new InfoAsset(frame, modal, windowNo, record_id, value, multiSelection, saveResult, whereClause) : (tableName.equals("C_Order") ? new InfoOrder(frame, modal, windowNo, record_id, value, multiSelection, saveResult, whereClause) : (tableName.equals("M_InOut") ? new InfoInOut(frame, modal, windowNo, record_id, value, multiSelection, saveResult, whereClause) : (tableName.equals("C_Payment") ? new InfoPayment(frame, modal, windowNo, record_id, value, multiSelection, saveResult, whereClause) : (tableName.equals("C_CashLine") ? new InfoCashLine(frame, modal, windowNo, record_id, value, multiSelection, saveResult, whereClause) : (tableName.equals("S_ResourceAssigment") ? new InfoAssignment(frame, modal, windowNo, record_id, value, multiSelection, saveResult, whereClause) : new InfoGeneral(frame, modal, windowNo, record_id, value, tableName, keyColumn, multiSelection, saveResult, whereClause)))))))));
        AEnv.positionCenterWindow(frame, info);
        return info;
    }

    public static void showBPartner(Frame frame, int WindowNo) {
        InfoBPartner info = new InfoBPartner(frame, false, WindowNo, 0, "", !Env.getContext(Env.getCtx(), "IsSOTrx").equals("N"), false, false, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showAsset(Frame frame, int WindowNo) {
        InfoAsset info = new InfoAsset(frame, false, WindowNo, 0, "", false, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showProduct(Frame frame, int WindowNo) {
        InfoProduct info = new InfoProduct(frame, false, WindowNo, Env.getContextAsInt(Env.getCtx(), WindowNo, "M_Warehouse_ID"), Env.getContextAsInt(Env.getCtx(), WindowNo, "M_PriceList_ID"), 0, "", false, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showOrder(Frame frame, int WindowNo, String value) {
        InfoOrder info = new InfoOrder(frame, false, WindowNo, 0, value, false, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showInvoice(Frame frame, int WindowNo, String value) {
        InfoInvoice info = new InfoInvoice(frame, false, WindowNo, 0, value, false, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showInOut(Frame frame, int WindowNo, String value) {
        InfoInOut info = new InfoInOut(frame, false, WindowNo, 0, value, false, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showPayment(Frame frame, int WindowNo, String value) {
        InfoPayment info = new InfoPayment(frame, false, WindowNo, 0, value, false, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showCashLine(Frame frame, int WindowNo, String value) {
        InfoCashLine info = new InfoCashLine(frame, false, WindowNo, 0, value, false, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    public static void showAssignment(Frame frame, int WindowNo, String value) {
        InfoAssignment info = new InfoAssignment(frame, false, WindowNo, 0, value, false, false, "");
        AEnv.showCenterWindow(frame, info);
    }

    protected Info(Frame frame, boolean modal, int WindowNo, String tableName, String keyColumn, boolean multiSelection, boolean saveResults, String whereClause) {
        super(frame, modal);
        GridTab tab;
        this.INFO_WIDTH = this.screensize.width > 1500 ? 1500 : this.screensize.width - 100;
        this.SCREEN_HEIGHT = this.screensize.height;
        this.p_whereClause = "";
        this.p_saveResults = true;
        this.p_resetColumns = true;
        this.p_triggerRefresh = false;
        this.p_refreshNow = false;
        this.p_table = new MiniTable();
        this.p_selectedRecordKey = 0;
        this.m_ok = false;
        this.m_cancel = false;
        this.m_resetRecordID = false;
        this.m_results = new ArrayList(3);
        this.m_lse = new ListSelectionEvent(this, 0, 0, true);
        this.p_loadedOK = false;
        this.m_SO_Window_ID = -1;
        this.m_PO_Window_ID = -1;
        this.m_worker = null;
        this.m_ignoreEvents = false;
        this.log = CLogger.getCLogger(this.getClass());
        this.bReset = new CButton();
        this.checkAutoQuery = new VCheckBox();
        this.southPanel = new CPanel();
        this.southLayout = new BorderLayout();
        this.confirmPanel = new ConfirmPanel(true, true, true, true, true, true, true);
        this.buttonPanel = new CPanel();
        this.p_criteriaGrid = new CPanel();
        this.p_detailTaskPane = new JXTaskPane();
        this.addonPanel = new CPanel();
        this.statusBar = new StatusBar();
        this.parameterPanel = new CPanel();
        this.scrollPane = new JScrollPane();
        this.popup = new JPopupMenu();
        this.calcMenu = new CMenuItem();
        this.zoomMenu = new CMenuItem();
        this.m_heldLastFocus = null;
        this.m_popupRow = -1;
        this.m_popupColumn = -1;
        this.doDispose = new AbstractAction(){
            private static final long serialVersionUID = 1L;

            @Override
            public void actionPerformed(ActionEvent e) {
                Info.this.dispose(Info.this.p_saveResults);
            }
        };
        this.log.info("WinNo=" + this.p_WindowNo + " " + whereClause);
        this.p_saveResults = saveResults;
        this.p_tableName = tableName;
        this.p_keyColumn = keyColumn;
        this.p_table.setMultiSelection(multiSelection);
        this.p_WindowNo = WindowNo;
        this.p_TabNo = 0;
        Class<?> frameClass = frame.getClass();
        if (frameClass == AWindow.class && (tab = ((AWindow)frame).getAPanel().getCurrentTab()) != null) {
            this.p_TabNo = tab.getTabNo();
        }
        if (whereClause == null || whereClause.indexOf(64) == -1) {
            this.setWhereClause(whereClause);
        } else {
            String tempClause = "";
            tempClause = Env.parseContext(Env.getCtx(), this.p_WindowNo, whereClause, false, false);
            if (tempClause.length() == 0) {
                this.log.log(Level.SEVERE, "Cannot parse context= " + whereClause);
            }
            this.setWhereClause(tempClause);
        }
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            this.log.log(Level.SEVERE, "Info", ex);
        }
    }

    protected void jbInit() throws Exception {
        this.getContentPane().add((Component)this.parameterPanel, "North");
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.getContentPane().add((Component)this.southPanel, "South");
        this.setDefaultCloseOperation(2);
        AppsAction aa = new AppsAction("Reset", null, "reset");
        this.bReset = (CButton)aa.getButton();
        this.bReset.setMargin(ConfirmPanel.s_insets);
        this.bReset.setSize(this.bReset.getHeight(), this.bReset.getHeight());
        Dimension bSize = this.bReset.getSize();
        bSize.height = this.bReset.getHeight();
        bSize.width = this.bReset.getHeight();
        this.bReset.setMaximumSize(bSize);
        this.bReset.addActionListener(this);
        this.buttonPanel = new CPanel(new FlowLayout(0));
        this.buttonPanel.add((Component)this.bReset, 0);
        this.p_criteriaGrid.setLayout(new ALayout());
        this.parameterPanel.setLayout(new BorderLayout());
        this.parameterPanel.add((Component)this.buttonPanel, "West");
        this.parameterPanel.add((Component)this.p_criteriaGrid, "Center");
        this.p_detailTaskPane.setVisible(false);
        this.p_detailTaskPane.setCollapsed(true);
        this.p_detailTaskPane.setLayout((LayoutManager)new BorderLayout());
        this.p_detailTaskPane.setUI((TaskPaneUI)new AdempiereTaskPaneUI());
        this.p_detailTaskPane.getContentPane().setBackground(new ColorUIResource(251, 248, 241));
        this.p_detailTaskPane.getContentPane().setForeground(new ColorUIResource(251, 0, 0));
        this.addonPanel.setLayout(new BorderLayout());
        this.addonPanel.add((Component)this.p_detailTaskPane, "Center");
        this.southPanel.setLayout(this.southLayout);
        this.southPanel.add((Component)this.addonPanel, "North");
        this.southPanel.add((Component)this.confirmPanel, "Center");
        this.southPanel.add((Component)this.statusBar, "South");
        this.scrollPane.getViewport().add((Component)this.p_table, null);
        this.confirmPanel.addActionListener(this);
        this.confirmPanel.getResetButton().setVisible(this.hasReset());
        this.confirmPanel.getCustomizeButton().setVisible(this.hasCustomize());
        this.confirmPanel.getHistoryButton().setVisible(this.hasHistory());
        this.confirmPanel.getZoomButton().setVisible(this.hasZoom());
        this.confirmPanel.setOKVisible(this.p_saveResults);
        CButton print = ConfirmPanel.createPrintButton(true);
        print.addActionListener(this);
        this.confirmPanel.addButton(print);
        this.checkAutoQuery.setText(Msg.getMsg(Env.getCtx(), "AutoRefresh"));
        this.checkAutoQuery.setToolTipText(Msg.getMsg(Env.getCtx(), "AutoRefresh"));
        this.checkAutoQuery.setName("AutoQuery");
        this.checkAutoQuery.setSelected(MSysConfig.getValue(SYSCONFIG_INFO_AUTO_QUERY, "Y", Env.getAD_Client_ID(Env.getCtx())).equals("Y"));
        this.checkAutoQuery.addActionListener(this);
        CPanel leftButtons = (CPanel)this.confirmPanel.getComponent(1);
        leftButtons.add((Component)this.checkAutoQuery, 0);
        this.popup.add(this.zoomMenu);
        this.zoomMenu.setText(Msg.getMsg(Env.getCtx(), "Zoom"));
        this.zoomMenu.setIcon(new ImageIcon(Adempiere.class.getResource("images/Zoom16.gif")));
        this.zoomMenu.addActionListener(this);
        this.popup.add(this.calcMenu);
        this.calcMenu.setText(Msg.getMsg(Env.getCtx(), "Calculator"));
        this.calcMenu.setIcon(new ImageIcon(Adempiere.class.getResource("images/Calculator16.gif")));
        this.calcMenu.addActionListener(this);
        this.p_table.setKeyColumnIndex(-1);
        this.p_table.setCellSelectionEnabled(false);
        this.p_table.setColumnSelectionAllowed(false);
        this.p_table.setRowSelectionAllowed(true);
        if (this.p_saveResults) {
            this.p_table.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "doDispose");
        } else {
            this.p_table.getInputMap().put(KeyStroke.getKeyStroke("ENTER"), "doNothing");
        }
        this.p_table.getActionMap().put("doDispose", this.doDispose);
        this.p_table.getSelectionModel().addListSelectionListener(this);
        this.p_table.addMouseListener(this);
        this.p_table.addPropertyChangeListener("p_table_update", this);
        this.p_table.getSelectionModel().addListSelectionListener(this);
        this.m_parentPanel = this.p_criteriaGrid;
        this.enableButtons();
    }

    public boolean loadedOK() {
        return this.p_loadedOK;
    }

    public void setStatusLine(String text, boolean error) {
        this.statusBar.setStatusLine(text, error);
        Thread.yield();
    }

    public void setStatusDB(String text) {
        this.statusBar.setStatusDB(text);
    }

    protected void prepareTable(Info_Column[] layout, String from, String staticWhere, String orderBy) {
        int i;
        if (this.p_table == null) {
            return;
        }
        this.p_layout = layout;
        if (this.p_resetColumns) {
            boolean flag = this.p_table.getAutoCreateColumnsFromModel();
            this.p_table.setAutoCreateColumnsFromModel(false);
            this.p_table.setRowCount(0);
            DefaultTableColumnModel tc = new DefaultTableColumnModel();
            this.p_table.setColumnModel(tc);
            DefaultTableModel tm = new DefaultTableModel();
            this.p_table.setModel(tm);
            this.p_table.setColorColumn(-1);
            this.p_table.setAutoCreateColumnsFromModel(flag);
            this.p_resetColumns = false;
        }
        StringBuffer sql = new StringBuffer("SELECT ");
        for (i = 0; i < layout.length; ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(layout[i].getColSQL());
            if (layout[i].isIDcol()) {
                sql.append(",").append(layout[i].getIDcolSQL());
            }
            this.p_table.addColumn(layout[i].getColHeader());
            if (layout[i].isColorColumn()) {
                this.p_table.setColorColumn(i);
            }
            if (layout[i].getColClass() != IDColumn.class) continue;
            this.p_table.setKeyColumnIndex(i);
        }
        for (i = 0; i < layout.length; ++i) {
            this.p_table.setColumnClass(i, layout[i].getColClass(), layout[i].isReadOnly(), layout[i].getColHeader());
        }
        sql.append(" FROM ").append(from);
        sql.append(" WHERE ").append(staticWhere);
        this.m_sqlMain = sql.toString();
        this.m_sqlCount = "SELECT COUNT(*) FROM " + from + " WHERE " + staticWhere;
        this.m_sqlOrder = "";
        if (orderBy != null && orderBy.length() > 0) {
            this.m_sqlOrder = " ORDER BY " + orderBy;
        }
        if (this.p_table.getKeyColumnIndex() == -1) {
            this.log.log(Level.SEVERE, "No KeyColumn - " + sql);
        }
        this.parameterPanel.setPreferredSize(new Dimension(this.INFO_WIDTH, this.parameterPanel.getPreferredSize().height));
        this.scrollPane.setPreferredSize(new Dimension(this.INFO_WIDTH, 300));
    }

    protected void executeQuery() {
        if (this.m_worker != null && this.m_worker.isAlive()) {
            return;
        }
        if (this.m_ok) {
            return;
        }
        this.prepForRequery();
        if (!this.testCount()) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setStatusLine(Msg.getMsg(Env.getCtx(), "StartSearch"), false);
        this.m_worker = new Worker();
        this.m_worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean testCount() {
        int no;
        ResultSet rs;
        CPreparedStatement pstmt;
        long start;
        block6: {
            start = System.currentTimeMillis();
            String dynWhere = this.getSQLWhere();
            StringBuffer sql = new StringBuffer(this.m_sqlCount);
            if (dynWhere.length() > 0) {
                sql.append(dynWhere);
            }
            String countSql = Msg.parseTranslation(Env.getCtx(), sql.toString());
            countSql = MRole.getDefault().addAccessSQL(countSql, this.getTableName(), true, false);
            this.log.finer(countSql);
            pstmt = null;
            rs = null;
            no = -1;
            try {
                pstmt = DB.prepareStatement(countSql, null);
                this.setParameters(pstmt, true);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block6;
                no = rs.getInt(1);
            }
            catch (Exception e) {
                try {
                    this.log.log(Level.SEVERE, countSql, e);
                    no = -2;
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.log.fine("#" + no + " - " + (System.currentTimeMillis() - start) + "ms");
        MRole role = MRole.getDefault();
        if (role.isQueryMax(no)) {
            return ADialog.ask(this.p_WindowNo, this, "InfoHighRecordCount", String.valueOf(no));
        }
        return true;
    }

    protected void saveSelection() {
        if (this.p_table == null) {
            return;
        }
        this.log.config("OK=" + this.m_ok);
        if (!this.m_ok) {
            this.m_results.clear();
            this.p_table.removeAll();
            this.p_table = null;
            return;
        }
        if (this.p_table.isMultiSelection()) {
            this.m_results.addAll(this.getSelectedRowKeys());
        } else {
            Integer data = this.getSelectedRowKey();
            if (data != null) {
                this.m_results.add(data);
            }
        }
        this.log.config(this.getSelectedSQL());
        this.saveSelectionDetail();
        this.p_table.removeAll();
        this.p_table = null;
    }

    protected Integer getSelectedRowKey() {
        ArrayList<Integer> selectedDataList = this.getSelectedRowKeys();
        if (selectedDataList.size() == 0) {
            return null;
        }
        return selectedDataList.get(0);
    }

    protected ArrayList<Integer> getSelectedRowKeys() {
        int row;
        ArrayList<Integer> selectedDataList = new ArrayList<Integer>();
        if (this.p_table.getKeyColumnIndex() == -1) {
            return selectedDataList;
        }
        if (this.p_table.isMultiSelection()) {
            int rows = this.p_table.getRowCount();
            for (int row2 = 0; row2 < rows; ++row2) {
                if (this.p_table.getShowTotals() && row2 == rows - 1) continue;
                Object data = this.p_table.getModel().getValueAt(row2, this.p_table.getKeyColumnIndex());
                if (data instanceof IDColumn) {
                    IDColumn dataColumn = (IDColumn)data;
                    if (!dataColumn.isSelected()) continue;
                    selectedDataList.add(dataColumn.getRecord_ID());
                    continue;
                }
                this.log.severe("For multiple selection, IDColumn should be key column for selection");
            }
        }
        if (selectedDataList.size() == 0 && (row = this.p_table == null || this.p_table.getRowCount() <= 0 ? -1 : this.p_table.getSelectedRow()) != -1 && this.p_table.getKeyColumnIndex() != -1) {
            Object data = this.p_table.getModel().getValueAt(row, this.p_table.getKeyColumnIndex());
            if (data instanceof IDColumn) {
                selectedDataList.add(((IDColumn)data).getRecord_ID());
            }
            if (data instanceof Integer) {
                selectedDataList.add((Integer)data);
            }
        }
        return selectedDataList;
    }

    public Object[] getSelectedKeys() {
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        Object[] values = new Integer[this.m_results.size()];
        this.m_results.toArray(values);
        return values;
    }

    public Object getSelectedKey() {
        if (!this.m_ok || this.m_results.size() == 0) {
            return null;
        }
        return this.m_results.get(0);
    }

    protected boolean setSelectedRow(int record_id) {
        if (this.p_table.getKeyColumnIndex() == -1) {
            return false;
        }
        if (this.p_table == null) {
            return false;
        }
        if (this.p_table.getRowCount() == 0) {
            return false;
        }
        if (this.p_table.isMultiSelection() && this.p_table.isDefaultSelected()) {
            return false;
        }
        if (record_id <= 0) {
            this.p_table.changeSelection(0, this.p_table.getKeyColumnIndex(), false, false);
            this.log.fine("Selected the first record shown");
            return true;
        }
        Integer selectedKey = (Integer)this.getSelectedKey();
        if (selectedKey != null && selectedKey == record_id) {
            return true;
        }
        int rows = this.p_table.getRowCount();
        if (this.p_table.getShowTotals()) {
            --rows;
        }
        for (int row = 0; row < rows; ++row) {
            IDColumn dataColumn;
            Object data = this.p_table.getModel().getValueAt(row, this.p_table.getKeyColumnIndex());
            if (!(data instanceof IDColumn) || (dataColumn = (IDColumn)data).getRecord_ID() != record_id) continue;
            this.p_table.changeSelection(row, this.p_table.getKeyColumnIndex(), false, false);
            this.log.fine("Record_ID = " + record_id + " found at row " + row);
            return true;
        }
        this.p_table.changeSelection(0, this.p_table.getKeyColumnIndex(), false, false);
        this.log.fine("Record_ID = " + record_id + " not found in the current table. Selecting the first record.");
        return true;
    }

    public boolean autoQuery() {
        return this.checkAutoQuery.isSelected();
    }

    public boolean isCancelled() {
        return this.m_cancel;
    }

    public String getSelectedSQL() {
        Object[] keys = this.getSelectedKeys();
        if (keys == null || keys.length == 0) {
            this.log.config("No Results - OK=" + this.m_ok + ", Cancel=" + this.m_cancel);
            return "";
        }
        StringBuffer sb = new StringBuffer(this.getKeyColumn());
        if (keys.length > 1) {
            sb.append(" IN (");
        } else {
            sb.append("=");
        }
        for (int i = 0; i < keys.length; ++i) {
            if (this.getKeyColumn().endsWith("_ID")) {
                sb.append(keys[i].toString()).append(",");
                continue;
            }
            sb.append("'").append(keys[i].toString()).append("',");
        }
        sb.replace(sb.length() - 1, sb.length(), "");
        if (keys.length > 1) {
            sb.append(")");
        }
        return sb.toString();
    }

    public static boolean isValidSQLText(CTextField f) {
        if (f != null && f.getText() != null) {
            return Info.isValidSQLText(f.getText());
        }
        return false;
    }

    public static boolean isValidSQLText(String s) {
        return s.length() > 0;
    }

    public static String getSQLText(CTextField f) {
        String s = f.getText();
        return Info.getSQLText(s);
    }

    public static String getSQLText(String s) {
        s = ((String)s).toUpperCase();
        String wildCardPattern = MSysConfig.getValue(SYSCONFIG_INFO_AUTO_WILDCARD, "*%", Env.getAD_Client_ID(Env.getCtx()));
        if (wildCardPattern.startsWith("%") && !((String)s).startsWith("%")) {
            s = "%" + (String)s;
        }
        if (wildCardPattern.endsWith("%") && !((String)s).endsWith("%")) {
            s = (String)s + "%";
        }
        CLogger mlog = CLogger.get();
        mlog.fine("String with wild cards: " + (String)s);
        return s;
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == "p_table_update") {
            this.m_resetRecordID = true;
            if (!this.setSelectedRow(this.p_selectedRecordKey)) {
                this.noRecordSelected();
            } else {
                this.recordSelected(this.p_table.getLeadRowKey());
            }
            this.p_selectedRecordKey = 0;
            this.m_parentPanel.requestFocus();
            if (this.m_heldLastFocus instanceof CTextField) {
                ((CTextField)this.m_heldLastFocus).requestFocus();
            }
            if (this.m_heldLastFocus instanceof VLookup) {
                ((VLookup)this.m_heldLastFocus).requestFocus();
            }
            if (this.m_heldLastFocus instanceof VCheckBox) {
                ((VCheckBox)this.m_heldLastFocus).requestFocus();
            }
            this.enableButtons();
        }
    }

    protected void recordSelected(int key) {
    }

    protected void noRecordSelected() {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.p_loadedOK) {
            return;
        }
        String cmd = e.getActionCommand();
        if (cmd.equals("CausedFocusEvent")) {
            return;
        }
        Object source = null;
        if (e.getSource() != null) {
            source = e.getSource();
            this.m_heldLastFocus = this.getFocusOwner();
            if (source.equals(this.calcMenu)) {
                BigDecimal number = null;
                if (this.m_popupRow >= 0 && this.m_popupColumn >= 0) {
                    Object data = this.p_table.getValueAt(this.m_popupRow, this.m_popupColumn);
                    try {
                        if (data != null) {
                            number = data instanceof BigDecimal ? (BigDecimal)data : new BigDecimal(data.toString());
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Calculator c = new Calculator(null, number);
                    c.setVisible(true);
                }
                return;
            }
            if (e.getSource().equals(this.zoomMenu)) {
                if (this.m_popupRow >= 0 && this.m_popupColumn >= 0) {
                    this.zoom(this.p_table.getRowKey(this.m_popupRow));
                }
                return;
            }
            if (cmd.equals("Ok")) {
                if (this.hasOutstandingChanges()) {
                    return;
                }
                this.p_triggerRefresh = false;
            } else if (source instanceof VComboBox) {
                if (((VComboBox)source).getParent() instanceof VLookup) {
                    source = ((VComboBox)source).getParent();
                    VLookup vl = (VLookup)source;
                    this.m_heldLastFocus = vl;
                    if (cmd.equals("comboBoxChanged")) {
                        if (!vl.hasChanged()) {
                            return;
                        }
                        this.p_triggerRefresh = true;
                    } else if (cmd.equals("comboBoxEdited")) {
                        if (!vl.hasChanged() && !this.hasOutstandingChanges()) {
                            vl.requestFocus();
                            return;
                        }
                        this.p_triggerRefresh = true;
                    }
                }
            } else if (source instanceof CTextField) {
                CTextField tf = (CTextField)source;
                if (tf.getParent() instanceof VLookup) {
                    return;
                }
                if (tf.hasChanged() || this.hasOutstandingChanges()) {
                    this.p_triggerRefresh = true;
                } else {
                    if (this.p_TabNo == 0) {
                        return;
                    }
                    this.dispose(true);
                }
            } else if (e.getSource() instanceof VCheckBox) {
                this.p_triggerRefresh = true;
                VCheckBox cb = (VCheckBox)e.getSource();
                if (cb.getName().equals("AutoQuery") && !cb.isSelected()) {
                    return;
                }
            }
            boolean bl = this.p_resetColumns = this.p_resetColumns || this.columnIsDynamic(source);
        }
        if (cmd.equals("Ok")) {
            this.dispose(this.p_saveResults);
        } else if (cmd.equals("Cancel")) {
            this.m_cancel = true;
            this.dispose(false);
        } else if (cmd.equals("Refresh")) {
            this.p_resetColumns = true;
            this.p_triggerRefresh = true;
            this.p_refreshNow = true;
        } else if (cmd.equals("History")) {
            this.showHistory(this.p_table.getLeadRowKey());
        } else if (cmd.equals("Customize")) {
            this.customize();
        } else if (cmd.equals("Zoom")) {
            this.zoom(this.p_table.getLeadRowKey());
        } else if (cmd.equals("Reset")) {
            this.p_loadedOK = false;
            this.initInfo();
            this.p_loadedOK = true;
            this.p_resetColumns = true;
            this.p_triggerRefresh = true;
        } else if (cmd.equals("Print")) {
            PrintScreenPainter.printScreen(this);
        }
        if (this.p_triggerRefresh && (this.p_refreshNow || this.autoQuery())) {
            this.executeQuery();
        }
        this.p_triggerRefresh = false;
        this.p_refreshNow = false;
    }

    protected void prepForRequery() {
        this.setFieldOldValues();
        Integer selectedKey = this.getSelectedRowKey();
        if (selectedKey != null && selectedKey != 0) {
            this.p_selectedRecordKey = selectedKey;
        }
        if (this.p_resetColumns) {
            this.prepareTable(this.getTableLayout(), this.getFromClause(), this.getWhereClause(), this.getOrderClause());
            this.p_table.setShowTotals(this.getShowTotals());
            this.p_resetColumns = false;
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent lse) {
        if (this.m_ignoreEvents.booleanValue() || this.p_table.getRowCount() == 0) {
            return;
        }
        if (this.m_lse.equals(lse)) {
            return;
        }
        this.m_lse = lse;
        this.recordSelected(this.p_table.getLeadRowKey());
        this.enableButtons();
    }

    protected void zoom(int AD_Window_ID, MQuery zoomQuery) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        final AWindow frame = new AWindow();
        if (!frame.initWindow(AD_Window_ID, zoomQuery)) {
            return;
        }
        AEnv.addToWindowManager(frame);
        if (this.isModal()) {
            this.setModal(false);
            this.dispose();
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        new Thread(){

            @Override
            public void run() {
                try {
                    1.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AEnv.showCenterScreen(frame);
            }
        }.start();
    }

    @Override
    public void dispose() {
        this.dispose(false);
    }

    public void dispose(boolean ok) {
        this.log.config("OK=" + ok);
        this.m_ok = ok;
        if (this.m_worker != null) {
            if (this.m_worker.isAlive()) {
                this.m_worker.interrupt();
            }
            this.log.config("Worker alive=" + this.m_worker.isAlive());
        }
        this.m_worker = null;
        this.p_loadedOK = false;
        this.saveSelection();
        this.removeAll();
        super.dispose();
    }

    protected String getTableName() {
        return this.p_tableName;
    }

    protected String getKeyColumn() {
        return this.p_keyColumn;
    }

    protected void enableButtons() {
        boolean enable = false;
        try {
            enable = this.p_table.getLeadRowKey() > 0;
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.confirmPanel.getOKButton().setEnabled(this.p_saveResults && this.p_table.getSelectedRowCount() > 0);
        if (this.hasHistory()) {
            this.confirmPanel.getHistoryButton().setEnabled(enable);
        }
        if (this.hasZoom()) {
            this.confirmPanel.getZoomButton().setEnabled(enable);
            this.zoomMenu.setEnabled(enable);
        }
    }

    protected abstract String getSQLWhere();

    protected abstract void setParameters(PreparedStatement var1, boolean var2) throws SQLException;

    protected void doReset() {
    }

    protected boolean hasReset() {
        return false;
    }

    protected void showHistory(int record_id) {
    }

    protected boolean hasHistory() {
        return false;
    }

    protected void customize() {
    }

    protected boolean hasCustomize() {
        return false;
    }

    protected void zoom(int record_id) {
    }

    protected boolean hasZoom() {
        return false;
    }

    protected void saveSelectionDetail() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getAD_Window_ID(String tableName, boolean isSOTrx) {
        ResultSet rs;
        CPreparedStatement pstmt;
        block7: {
            if (!isSOTrx && this.m_PO_Window_ID > 0) {
                return this.m_PO_Window_ID;
            }
            if (this.m_SO_Window_ID > 0) {
                return this.m_SO_Window_ID;
            }
            String sql = "SELECT AD_Window_ID, PO_Window_ID FROM AD_Table WHERE TableName=?";
            pstmt = null;
            rs = null;
            try {
                pstmt = DB.prepareStatement(sql, null);
                pstmt.setString(1, tableName);
                rs = pstmt.executeQuery();
                if (!rs.next()) break block7;
                this.m_SO_Window_ID = rs.getInt(1);
                this.m_PO_Window_ID = rs.getInt(2);
            }
            catch (Exception e) {
                try {
                    this.log.log(Level.SEVERE, sql, e);
                }
                catch (Throwable throwable) {
                    DB.close(rs, pstmt);
                    rs = null;
                    pstmt = null;
                    throw throwable;
                }
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        if (!isSOTrx && this.m_PO_Window_ID > 0) {
            return this.m_PO_Window_ID;
        }
        return this.m_SO_Window_ID;
    }

    public boolean isOk() {
        return this.m_ok;
    }

    public boolean isResetRecordID() {
        return this.m_resetRecordID;
    }

    public boolean isValidVObject(Object o) {
        if (o != null) {
            try {
                if (o instanceof VLookup) {
                    return ((VLookup)o).getValue() != null && (Integer)((VLookup)o).getValue() != 0;
                }
                if (o instanceof VPAttribute) {
                    return ((VPAttribute)o).getValue() != null && (Integer)((VPAttribute)o).getValue() != 0;
                }
            }
            catch (ClassCastException e) {
                return false;
            }
        }
        return false;
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.p_saveResults && e.getID() == 500 && e.getClickCount() > 1 && this.p_table.getSelectedRow() != -1) {
            this.dispose(this.p_saveResults);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (e.getSource().equals(this.p_table)) {
                this.m_popupRow = this.p_table.rowAtPoint(e.getPoint());
                this.m_popupColumn = this.p_table.columnAtPoint(e.getPoint());
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
            return;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (e.isPopupTrigger()) {
            if (e.getSource().equals(this.p_table)) {
                this.m_popupRow = this.p_table.rowAtPoint(e.getPoint());
                this.m_popupColumn = this.p_table.columnAtPoint(e.getPoint());
                this.popup.show(e.getComponent(), e.getX(), e.getY());
            }
            return;
        }
    }

    protected void setFieldOldValues() {
    }

    protected boolean hasOutstandingChanges() {
        return false;
    }

    protected void clearParameters() {
    }

    protected void initInfo() {
        this.clearParameters();
        this.initInfo(0, "");
    }

    protected void initInfo(int record_id, String value) {
    }

    protected boolean columnIsDynamic(Object o) {
        return false;
    }

    protected void setShowTotals(boolean showTotals) {
        this.m_showTotals = showTotals;
    }

    protected boolean getShowTotals() {
        return this.m_showTotals;
    }

    protected Info_Column[] getTableLayout() {
        return this.p_layout;
    }

    protected void setTableLayout(Info_Column[] p_layout) {
        this.p_layout = p_layout;
    }

    protected String getFromClause() {
        return this.p_sqlFrom;
    }

    protected void setFromClause(String from) {
        this.p_sqlFrom = from;
    }

    protected String getWhereClause() {
        return this.p_whereClause;
    }

    protected void setWhereClause(String where) {
        this.p_whereClause = where;
    }

    protected String getOrderClause() {
        return this.p_sqlOrder;
    }

    protected void setOrderClause(String order) {
        this.p_sqlOrder = order;
    }

    protected boolean isMultipleResults() {
        return this.m_results.size() > 1;
    }

    class Worker
    extends Thread {
        private PreparedStatement m_pstmt = null;
        private ResultSet m_rs = null;

        @Override
        public void run() {
            if (Info.this.p_table == null) {
                return;
            }
            long start = System.currentTimeMillis();
            Info.this.m_ignoreEvents = true;
            Info.this.p_table.setRowCount(0);
            String dynWhere = Info.this.getSQLWhere();
            StringBuffer sql = new StringBuffer(Info.this.m_sqlMain);
            if (dynWhere.length() > 0) {
                sql.append(dynWhere);
            }
            sql.append(Info.this.m_sqlOrder);
            String dataSql = Msg.parseTranslation(Env.getCtx(), sql.toString());
            dataSql = MRole.getDefault().addAccessSQL(dataSql, Info.this.getTableName(), true, false);
            Info.this.log.finer(dataSql);
            try {
                this.m_pstmt = DB.prepareStatement(dataSql, null);
                Info.this.setParameters(this.m_pstmt, false);
                Info.this.log.fine("Start query - " + (System.currentTimeMillis() - start) + "ms");
                this.m_rs = this.m_pstmt.executeQuery();
                Info.this.log.fine("End query - " + (System.currentTimeMillis() - start) + "ms");
                while (this.m_rs.next()) {
                    if (this.isInterrupted()) {
                        Info.this.log.finer("Interrupted");
                        this.close();
                        return;
                    }
                    int row = Info.this.p_table.getRowCount();
                    Info.this.p_table.setRowCount(row + 1);
                    int colOffset = 1;
                    for (int col = 0; col < Info.this.p_layout.length; ++col) {
                        Object data = null;
                        Class<?> c = Info.this.p_layout[col].getColClass();
                        int colIndex = col + colOffset;
                        if (c == IDColumn.class) {
                            data = new IDColumn(this.m_rs.getInt(colIndex));
                            ((IDColumn)data).setSelected(false);
                            if (Info.this.p_table.isMultiSelection()) {
                                if (Info.this.p_table.isDefaultSelected()) {
                                    Info.this.p_table.changeSelection(row, 0, false, row != 0);
                                } else {
                                    Info.this.p_table.clearSelection();
                                }
                            }
                        } else if (c == Boolean.class) {
                            data = "Y".equals(this.m_rs.getString(colIndex));
                        } else if (c == Timestamp.class) {
                            data = this.m_rs.getTimestamp(colIndex);
                        } else if (c == BigDecimal.class) {
                            data = this.m_rs.getBigDecimal(colIndex);
                        } else if (c == Double.class) {
                            data = new Double(this.m_rs.getDouble(colIndex));
                        } else if (c == Integer.class) {
                            data = this.m_rs.getInt(colIndex);
                        } else if (c == KeyNamePair.class) {
                            String display = this.m_rs.getString(colIndex);
                            int key = this.m_rs.getInt(colIndex + 1);
                            data = new KeyNamePair(key, display);
                            ++colOffset;
                        } else {
                            data = this.m_rs.getString(colIndex);
                        }
                        Info.this.p_table.setValueAt(data, Info.this.p_table.convertRowIndexToView(row), Info.this.p_table.convertColumnIndexToView(col));
                    }
                }
            }
            catch (SQLException e) {
                Info.this.log.log(Level.SEVERE, dataSql, e);
            }
            this.close();
            int no = Info.this.p_table.getRowCount();
            Info.this.log.fine("#" + no + " - " + (System.currentTimeMillis() - start) + "ms");
            if (Info.this.p_table.getShowTotals()) {
                Info.this.p_table.addTotals(Info.this.p_layout);
            }
            Info.this.p_table.autoSize();
            Info.this.setCursor(Cursor.getDefaultCursor());
            Info.this.setStatusLine(Integer.toString(no) + " " + Msg.getMsg(Env.getCtx(), "SearchRows_EnterQuery"), false);
            Info.this.setStatusDB(Integer.toString(no));
            if (no == 0) {
                Info.this.log.fine(dataSql);
            } else {
                if (!Info.this.p_table.isMultiSelection()) {
                    Info.this.p_table.getSelectionModel().setSelectionInterval(0, 0);
                }
                Info.this.p_table.requestFocus();
            }
            Info.this.p_table.matchCheckWithSelectedRows();
            Info.this.p_table.clearSelection();
            Info.this.p_table.getSelectionModel().setSelectionInterval(0, 0);
            Info.this.p_table.getSelectionModel().setLeadSelectionIndex(0);
            Info.this.m_ignoreEvents = false;
            Info.this.p_table.firePropertyChange("p_table_update", 0, 1);
        }

        private void close() {
            DB.close(this.m_rs, this.m_pstmt);
            this.m_rs = null;
            this.m_pstmt = null;
        }

        @Override
        public void interrupt() {
            if (this.m_pstmt != null) {
                try {
                    this.m_pstmt.cancel();
                    this.close();
                }
                catch (SQLException e) {
                    Info.this.log.log(Level.SEVERE, "Cannot cancel SQL statement", e);
                }
            }
            super.interrupt();
        }
    }
}

