/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.search;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeListener;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.Timer;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.adempiere.exceptions.DBException;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Util;

public abstract class FieldAutoCompleter
implements MouseListener {
    private static final String AUTOCOMPLETER = FieldAutoCompleter.class.getCanonicalName() + "AUTOCOMPLETER";
    private static final int PopupDelayMillis = 500;
    public static final int DEFAULT_PopupMinimumChars = 3;
    private int m_popupMinimumChars = 3;
    public static final String ITEM_More = "...";
    public static final int DEFAULT_MaxItems = 7;
    private int m_maxItems = 7;
    protected final CLogger log = CLogger.getCLogger(this.getClass());
    final JList listBox = new JList();
    protected final JTextComponent textBox;
    final Color bgColorDefault;
    final Color bgColorNotMatched = new Color(230, 200, 200);
    private final JPopupMenu popup = new JPopupMenu();
    private final Timer timer = new Timer(500, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            FieldAutoCompleter.this.showPopup();
        }
    });
    private static final Action acceptAction = new AbstractAction(){
        private static final long serialVersionUID = -3950389799318995148L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent tf = (JComponent)e.getSource();
            FieldAutoCompleter completer = (FieldAutoCompleter)tf.getClientProperty(AUTOCOMPLETER);
            if (!completer.isEnabled()) {
                return;
            }
            completer.popup.setVisible(false);
            if (completer.listBox.getSelectedValue() == null) {
                String txt = completer.textBox.getText();
                ListModel lm = completer.listBox.getModel();
                for (int index = 0; index < lm.getSize(); ++index) {
                    if (!FieldAutoCompleter.startsWithIgnoreCase(lm.getElementAt(index).toString(), txt)) continue;
                    completer.acceptedListItem(lm.getElementAt(index));
                    break;
                }
            } else {
                completer.acceptedListItem(completer.listBox.getSelectedValue());
            }
        }
    };
    private final DocumentListener documentListener = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            FieldAutoCompleter.this.showPopupDelayed();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            FieldAutoCompleter.this.showPopupDelayed();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
        }
    };
    static Action showAction = new AbstractAction(){
        private static final long serialVersionUID = 8868536979000734628L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent tf = (JComponent)e.getSource();
            FieldAutoCompleter completer = (FieldAutoCompleter)tf.getClientProperty(AUTOCOMPLETER);
            if (tf.isEnabled() && completer.isEnabled()) {
                if (completer.popup.isVisible()) {
                    completer.selectNextPossibleValue();
                } else {
                    completer.showPopup();
                }
            }
        }
    };
    private static final Action upAction = new AbstractAction(){
        private static final long serialVersionUID = 2200136359410394434L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent tf = (JComponent)e.getSource();
            FieldAutoCompleter completer = (FieldAutoCompleter)tf.getClientProperty(AUTOCOMPLETER);
            if (tf.isEnabled() && completer.isEnabled() && completer.popup.isVisible()) {
                completer.selectPreviousPossibleValue();
            }
        }
    };
    private static final Action hidePopupAction = new AbstractAction(){
        private static final long serialVersionUID = -5683983067872135654L;

        @Override
        public void actionPerformed(ActionEvent e) {
            JComponent tf = (JComponent)e.getSource();
            FieldAutoCompleter completer = (FieldAutoCompleter)tf.getClientProperty(AUTOCOMPLETER);
            if (tf.isEnabled() && completer.isEnabled()) {
                completer.popup.setVisible(false);
            }
        }
    };
    private Object m_userObject = null;

    public FieldAutoCompleter(JTextComponent comp) {
        this.textBox = comp;
        this.bgColorDefault = this.textBox.getBackground();
        this.textBox.putClientProperty(AUTOCOMPLETER, this);
        JScrollPane scroll = new JScrollPane(this.listBox);
        scroll.setBorder(null);
        this.listBox.setFocusable(false);
        this.listBox.addMouseListener(this);
        this.setMaxItems(7);
        scroll.getVerticalScrollBar().setFocusable(false);
        scroll.getHorizontalScrollBar().setFocusable(false);
        this.popup.setBorder(BorderFactory.createLineBorder(Color.black));
        this.popup.add(scroll);
        if (this.textBox instanceof JTextField) {
            this.textBox.registerKeyboardAction(showAction, KeyStroke.getKeyStroke(40, 0), 0);
            this.textBox.getDocument().addDocumentListener(this.documentListener);
        }
        this.textBox.registerKeyboardAction(upAction, KeyStroke.getKeyStroke(38, 0), 0);
        this.textBox.registerKeyboardAction(hidePopupAction, KeyStroke.getKeyStroke(27, 0), 0);
        this.popup.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                FieldAutoCompleter.this.textBox.unregisterKeyboardAction(KeyStroke.getKeyStroke(10, 0));
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.listBox.setRequestFocusEnabled(false);
    }

    private void showPopupDelayed() {
        if (!this.isEnabled()) {
            return;
        }
        this.log.finest("showPopupDelayed..");
        String search = this.textBox.getText();
        if (search != null && search.trim().length() < this.m_popupMinimumChars) {
            this.popup.setVisible(false);
            return;
        }
        this.timer.setRepeats(false);
        this.timer.start();
    }

    private void showPopup() {
        if (!this.isEnabled()) {
            return;
        }
        this.log.finest("showPopup");
        this.popup.setVisible(false);
        if (this.textBox.isEnabled() && this.updateListData() && this.listBox.getModel().getSize() != 0) {
            if (!(this.textBox instanceof JTextField)) {
                this.textBox.getDocument().addDocumentListener(this.documentListener);
            }
            this.textBox.registerKeyboardAction(acceptAction, KeyStroke.getKeyStroke(10, 0), 0);
            int size = this.listBox.getModel().getSize();
            this.listBox.setVisibleRowCount(size < 10 ? size : 10);
            int x = 0;
            try {
                x = this.textBox.getUI().modelToView((JTextComponent)this.textBox, (int)0).x;
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
            this.popup.setMinimumSize(new Dimension(this.textBox.getWidth(), 10));
            this.popup.show(this.textBox, x, this.textBox.getHeight());
        } else {
            this.popup.setVisible(false);
        }
        this.textBox.requestFocus();
    }

    protected void hidePopup() {
        this.popup.setVisible(false);
    }

    protected void selectNextPossibleValue() {
        int si = this.listBox.getSelectedIndex();
        if (si < this.listBox.getModel().getSize() - 1) {
            this.listBox.setSelectedIndex(si + 1);
            this.listBox.ensureIndexIsVisible(si + 1);
        }
    }

    protected void selectPreviousPossibleValue() {
        int si = this.listBox.getSelectedIndex();
        if (si > 0) {
            this.listBox.setSelectedIndex(si - 1);
            this.listBox.ensureIndexIsVisible(si - 1);
        }
    }

    protected static boolean startsWithIgnoreCase(String str1, String str2) {
        String s1 = Util.stripDiacritics(str1.toUpperCase()).trim();
        String s2 = Util.stripDiacritics(str2.toUpperCase()).trim();
        return s1.startsWith(s2);
    }

    protected void acceptedListItem(Object selected) {
        if (selected == null || selected == ITEM_More) {
            this.setUserObject(null);
            return;
        }
        this.setUserObject(selected);
        this.textBox.setText(this.convertUserObjectForTextField(selected));
    }

    protected boolean updateListData() {
        String search = this.textBox.getText();
        Object userObject = this.getUserOject();
        if (userObject != null && !this.isMatching(userObject, search)) {
            this.setUserObject(null);
        }
        ArrayList<Object> list = new ArrayList<Object>();
        boolean truncated = false;
        ArrayList<Object> params = new ArrayList<Object>();
        String sql = this.getSelectSQL(search, this.textBox.getCaretPosition(), params);
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            DB.setParameters((PreparedStatement)pstmt, params);
            rs = pstmt.executeQuery();
            int i = 0;
            while (rs.next()) {
                if (i > 0 && i > this.m_maxItems) {
                    list.add(ITEM_More);
                    truncated = true;
                    break;
                }
                Object o = this.fetchUserObject(rs);
                list.add(o);
                ++i;
            }
        }
        catch (SQLException e) {
            try {
                throw new DBException(e, sql.toString());
            }
            catch (Throwable throwable) {
                DB.close(rs, pstmt);
                rs = null;
                pstmt = null;
                throw throwable;
            }
        }
        DB.close(rs, pstmt);
        rs = null;
        pstmt = null;
        this.listBox.setListData(list.toArray());
        if (list.isEmpty()) {
            return false;
        }
        userObject = this.getUserOject();
        if (!truncated && list.size() == 1 && userObject != null && list.get(0).equals(userObject)) {
            this.log.finest("nothing to do 1");
            return false;
        }
        if (this.isMatching(list.get(0), search)) {
            this.setUserObject(list.get(0));
            return true;
        }
        return true;
    }

    public void setUserObject(Object userObject) {
        this.m_userObject = userObject;
        if (this.m_userObject == null && !Util.isEmpty(this.getText(), true)) {
            this.textBox.setBackground(this.bgColorNotMatched);
        } else {
            this.textBox.setBackground(this.bgColorDefault);
        }
        this.textBox.setToolTipText(userObject == null ? "" : userObject.toString());
    }

    public Object getUserOject() {
        return this.m_userObject;
    }

    protected String convertUserObjectForTextField(Object userObject) {
        return userObject == null ? "" : userObject.toString();
    }

    protected boolean isMatching(Object userObject, String search) {
        if (userObject == null) {
            return false;
        }
        String s1 = Util.stripDiacritics(this.convertUserObjectForTextField(userObject));
        String s2 = Util.stripDiacritics(search);
        return s1.equalsIgnoreCase(s2);
    }

    protected abstract String getSelectSQL(String var1, int var2, List<Object> var3);

    protected abstract Object fetchUserObject(ResultSet var1) throws SQLException;

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e == null || this.listBox.getSelectedValue().equals(ITEM_More)) {
            this.setUserObject(null);
            return;
        }
        this.popup.setVisible(false);
        Object selected = this.listBox.getSelectedValue();
        this.setUserObject(selected);
        this.textBox.setText(this.convertUserObjectForTextField(selected));
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.listBox.addPropertyChangeListener(listener);
    }

    public void setMaxItems(int maxItems) {
        this.m_maxItems = maxItems;
        this.listBox.setVisibleRowCount(this.m_maxItems + 1);
    }

    public int getMaxItems() {
        return this.m_maxItems;
    }

    public String getText() {
        return this.textBox.getText();
    }

    public boolean isEnabled() {
        return true;
    }

    public void setPopupMinimumChars(int popupMinimumChars) {
        this.m_popupMinimumChars = popupMinimumChars;
    }

    public int getPopupMinimumChars() {
        return this.m_popupMinimumChars;
    }
}

