/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.form.TreeMaintenance;
import org.compiere.grid.tree.VTreePanel;
import org.compiere.model.MTree;
import org.compiere.model.MTreeNode;
import org.compiere.swing.CButton;
import org.compiere.swing.CCheckBox;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VTreeMaintenance
extends TreeMaintenance
implements FormPanel,
ActionListener,
ListSelectionListener,
PropertyChangeListener {
    private CPanel panel = new CPanel();
    private FormFrame m_frame;
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel northPanel = new CPanel();
    private FlowLayout northLayout = new FlowLayout();
    private CLabel treeLabel = new CLabel();
    private CComboBox treeField;
    private CButton bAddAll = new CButton(Env.getImageIcon("FastBack24.gif"));
    private CButton bAdd = new CButton(Env.getImageIcon("StepBack24.gif"));
    private CButton bDelete = new CButton(Env.getImageIcon("StepForward24.gif"));
    private CButton bDeleteAll = new CButton(Env.getImageIcon("FastForward24.gif"));
    private CCheckBox cbAllNodes = new CCheckBox();
    private CLabel treeInfo = new CLabel();
    private JSplitPane splitPane = new JSplitPane();
    private VTreePanel centerTree;
    private JList centerList = new JList();

    @Override
    public void init(int WindowNo, FormFrame frame) {
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        log.info("VMerge.init - WinNo=" + this.m_WindowNo);
        try {
            this.preInit();
            this.jbInit();
            frame.getContentPane().add((Component)this.panel, "Center");
            this.action_loadTree();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "VTreeMaintenance.init", ex);
        }
    }

    private void preInit() {
        this.treeField = new CComboBox(this.getTreeData());
        this.treeField.addActionListener(this);
        this.centerTree = new VTreePanel(this.m_WindowNo, false, true);
        this.centerTree.addPropertyChangeListener("NodeSelected", this);
    }

    private void jbInit() throws Exception {
        this.panel.setLayout(this.mainLayout);
        this.treeLabel.setText(Msg.translate(Env.getCtx(), "AD_Tree_ID"));
        this.cbAllNodes.setEnabled(false);
        this.cbAllNodes.setText(Msg.translate(Env.getCtx(), "IsAllNodes"));
        this.treeInfo.setText(" ");
        this.bAdd.setToolTipText("Add to Tree");
        this.bAddAll.setToolTipText("Add ALL to Tree");
        this.bDelete.setToolTipText("Delete from Tree");
        this.bDeleteAll.setToolTipText("Delete ALL from Tree");
        this.bAdd.addActionListener(this);
        this.bAddAll.addActionListener(this);
        this.bDelete.addActionListener(this);
        this.bDeleteAll.addActionListener(this);
        this.northPanel.setLayout(this.northLayout);
        this.northLayout.setAlignment(0);
        this.panel.add((Component)this.northPanel, "North");
        this.northPanel.add((Component)this.treeLabel, null);
        this.northPanel.add((Component)this.treeField, null);
        this.northPanel.add((Component)this.cbAllNodes, null);
        this.northPanel.add((Component)this.treeInfo, null);
        this.northPanel.add((Component)this.bAddAll, null);
        this.northPanel.add((Component)this.bAdd, null);
        this.northPanel.add((Component)this.bDelete, null);
        this.northPanel.add((Component)this.bDeleteAll, null);
        this.panel.add((Component)this.splitPane, "Center");
        this.splitPane.add((Component)this.centerTree, "left");
        this.splitPane.add((Component)new JScrollPane(this.centerList), "right");
        this.centerList.setSelectionMode(0);
        this.centerList.addListSelectionListener(this);
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.treeField) {
            this.action_loadTree();
        } else if (e.getSource() == this.bAddAll) {
            this.action_treeAddAll();
        } else if (e.getSource() == this.bAdd) {
            this.action_treeAdd((TreeMaintenance.ListItem)this.centerList.getSelectedValue());
        } else if (e.getSource() == this.bDelete) {
            this.action_treeDelete((TreeMaintenance.ListItem)this.centerList.getSelectedValue());
        } else if (e.getSource() == this.bDeleteAll) {
            this.action_treeDeleteAll();
        }
    }

    private void action_loadTree() {
        KeyNamePair tree = (KeyNamePair)this.treeField.getSelectedItem();
        log.info("Tree=" + tree);
        if (tree.getKey() <= 0) {
            this.centerList.setModel(new DefaultListModel());
            return;
        }
        this.m_tree = new MTree(Env.getCtx(), tree.getKey(), null);
        this.cbAllNodes.setSelected(this.m_tree.isAllNodes());
        this.bAddAll.setEnabled(!this.m_tree.isAllNodes());
        this.bAdd.setEnabled(!this.m_tree.isAllNodes());
        this.bDelete.setEnabled(!this.m_tree.isAllNodes());
        this.bDeleteAll.setEnabled(!this.m_tree.isAllNodes());
        DefaultListModel<TreeMaintenance.ListItem> model = new DefaultListModel<TreeMaintenance.ListItem>();
        ArrayList<TreeMaintenance.ListItem> items = this.getTreeItemData();
        for (TreeMaintenance.ListItem item : items) {
            model.addElement(item);
        }
        log.config("#" + model.getSize());
        this.centerList.setModel(model);
        this.centerTree.initTree(this.m_tree.getAD_Tree_ID());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        TreeMaintenance.ListItem selected = null;
        try {
            selected = (TreeMaintenance.ListItem)this.centerList.getSelectedValue();
        }
        catch (Exception exception) {
            // empty catch block
        }
        log.info("Selected=" + selected);
        if (selected != null) {
            this.bAdd.setEnabled(!this.centerTree.setSelectedNode(selected.id));
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        MTreeNode tn = (MTreeNode)e.getNewValue();
        log.info(tn.toString());
        if (tn == null) {
            return;
        }
        ListModel model = this.centerList.getModel();
        int size = model.getSize();
        int index = -1;
        for (index = 0; index < size; ++index) {
            TreeMaintenance.ListItem item = (TreeMaintenance.ListItem)model.getElementAt(index);
            if (item.id == tn.getNode_ID()) break;
        }
        this.centerList.setSelectedIndex(index);
    }

    private void action_treeAdd(TreeMaintenance.ListItem item) {
        log.info("Item=" + item);
        if (item != null) {
            this.centerTree.nodeChanged(true, item.id, item.name, item.description, item.isSummary, item.imageIndicator);
            this.addNode(item);
        }
    }

    private void action_treeDelete(TreeMaintenance.ListItem item) {
        log.info("Item=" + item);
        if (item != null) {
            this.centerTree.nodeChanged(false, item.id, item.name, item.description, item.isSummary, item.imageIndicator);
            this.deleteNode(item);
        }
    }

    private void action_treeAddAll() {
        log.info("");
        ListModel model = this.centerList.getModel();
        int size = model.getSize();
        int index = -1;
        for (index = 0; index < size; ++index) {
            TreeMaintenance.ListItem item = (TreeMaintenance.ListItem)model.getElementAt(index);
            this.action_treeAdd(item);
        }
    }

    private void action_treeDeleteAll() {
        log.info("");
        ListModel model = this.centerList.getModel();
        int size = model.getSize();
        int index = -1;
        for (index = 0; index < size; ++index) {
            TreeMaintenance.ListItem item = (TreeMaintenance.ListItem)model.getElementAt(index);
            this.action_treeDelete(item);
        }
    }
}

