/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Currency;
import java.util.Locale;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.model.MSetup;
import org.compiere.plaf.CompiereColor;
import org.compiere.print.PrintUtil;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.ExtensionFileFilter;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class VSetup
extends CPanel
implements FormPanel,
ActionListener,
Runnable {
    private static final long serialVersionUID = 3255776374935155456L;
    private int m_WindowNo = 0;
    private FormFrame m_frame;
    private File m_file = null;
    private static CLogger log = CLogger.getCLogger(VSetup.class);
    private JScrollPane centerPane = new JScrollPane();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private CPanel centerPanel = new CPanel();
    private GridBagLayout centerLayout = new GridBagLayout();
    private JLabel lClientName = new JLabel();
    private JTextField fClientName = new JTextField();
    private JLabel lOrgName = new JLabel();
    private JTextField fOrgName = new JTextField();
    private JTextField fOrgValue = new JTextField();
    private JLabel lCurrency = new JLabel();
    private JComboBox fCurrency = new JComboBox();
    private JLabel lUserClient = new JLabel();
    private JTextField fUserClient = new JTextField();
    private JLabel lUserOrg = new JLabel();
    private JTextField fUserOrg = new JTextField();
    private JCheckBox fProject = new JCheckBox();
    private JCheckBox fProduct = new JCheckBox();
    private JCheckBox fBPartner = new JCheckBox();
    private JLabel lAccountSeg = new JLabel();
    private JCheckBox fMCampaign = new JCheckBox();
    private JCheckBox fSRegion = new JCheckBox();
    private JButton buttonLoadAcct = new JButton();
    private JLabel lCountry = new JLabel();
    private JLabel lCity = new JLabel();
    private JComboBox fCountry = new JComboBox();
    private JTextField fCity = new JTextField();
    private JLabel lRegion = new JLabel();
    private JComboBox fRegion = new JComboBox();

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("VSetup.init");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.centerPane, "Center");
            frame.getContentPane().add((Component)this.confirmPanel, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "VSetup.init", e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this);
        this.centerPanel.setLayout(this.centerLayout);
        String optional = Msg.translate(Env.getCtx(), "Optional");
        this.lClientName.setLabelFor(this.fClientName);
        this.lClientName.setText(Msg.translate(Env.getCtx(), "AD_Client_ID"));
        this.fClientName.setText("client");
        this.fClientName.setColumns(20);
        this.lOrgName.setLabelFor(this.fOrgName);
        this.lOrgName.setText(Msg.translate(Env.getCtx(), "AD_Org_ID"));
        this.fOrgName.setText("org");
        this.fOrgName.setColumns(20);
        this.lCurrency.setLabelFor(this.fCurrency);
        this.lCurrency.setText(Msg.translate(Env.getCtx(), "C_Currency_ID"));
        this.lUserClient.setLabelFor(this.fUserClient);
        this.lUserClient.setText(Msg.parseTranslation(Env.getCtx(), "@AD_User_ID@ @AD_Client_ID@"));
        this.fUserClient.setText("clientAdmin");
        this.fUserClient.setColumns(20);
        this.lUserOrg.setLabelFor(this.fUserOrg);
        this.lUserOrg.setText(Msg.parseTranslation(Env.getCtx(), "@AD_User_ID@ @AD_Org_ID@"));
        this.fUserOrg.setText("clientUser");
        this.fUserOrg.setColumns(20);
        this.lCountry.setLabelFor(this.fCountry);
        this.lCountry.setText(Msg.translate(Env.getCtx(), "C_Country_ID"));
        this.lCity.setLabelFor(this.fCity);
        this.lCity.setText(Msg.translate(Env.getCtx(), "C_City_ID"));
        this.fCity.setText("city");
        this.fCity.setColumns(20);
        this.lRegion.setLabelFor(this.fRegion);
        this.lRegion.setText(Msg.translate(Env.getCtx(), "C_Region_ID"));
        this.lRegion.setToolTipText(optional);
        this.lAccountSeg.setText(optional);
        this.fBPartner.setSelected(true);
        this.fBPartner.setText(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        this.fProduct.setSelected(true);
        this.fProduct.setText(Msg.translate(Env.getCtx(), "M_Product_ID"));
        this.fProject.setText(Msg.translate(Env.getCtx(), "C_Project_ID"));
        this.fMCampaign.setText(Msg.translate(Env.getCtx(), "C_Campaign_ID"));
        this.fSRegion.setText(Msg.translate(Env.getCtx(), "C_SalesRegion_ID"));
        this.buttonLoadAcct.setText(Msg.getMsg(Env.getCtx(), "LoadAccountingValues"));
        this.centerPane.getViewport().add((Component)this.centerPanel, null);
        this.centerPanel.add((Component)this.lClientName, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fClientName, new GridBagConstraints(1, 0, 4, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.lOrgName, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fOrgName, new GridBagConstraints(1, 1, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.lUserClient, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fUserClient, new GridBagConstraints(1, 2, 4, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.lUserOrg, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fUserOrg, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.lAccountSeg, new GridBagConstraints(0, 8, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fProject, new GridBagConstraints(1, 9, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fBPartner, new GridBagConstraints(1, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fMCampaign, new GridBagConstraints(1, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fCurrency, new GridBagConstraints(1, 4, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.lCurrency, new GridBagConstraints(0, 4, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.buttonLoadAcct, new GridBagConstraints(1, 11, 2, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.lCountry, new GridBagConstraints(0, 5, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.lCity, new GridBagConstraints(0, 6, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fCountry, new GridBagConstraints(1, 5, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fCity, new GridBagConstraints(1, 6, 3, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fProduct, new GridBagConstraints(2, 8, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 0), 0, 0));
        this.centerPanel.add((Component)this.fSRegion, new GridBagConstraints(2, 10, 1, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.lRegion, new GridBagConstraints(0, 7, 1, 1, 0.0, 0.0, 13, 0, new Insets(0, 5, 5, 5), 0, 0));
        this.centerPanel.add((Component)this.fRegion, new GridBagConstraints(1, 7, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 0, 5, 5), 0, 0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dynInit() {
        Locale locale = Locale.getDefault();
        Currency currency = Currency.getInstance(locale);
        String sql = "SELECT C_Currency_ID, Description, ISO_Code FROM C_Currency ORDER BY 2";
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = DB.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                this.fCurrency.addItem(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                if (currency == null || !currency.getCurrencyCode().equals(rs.getString(3))) continue;
                this.fCurrency.setSelectedIndex(this.fCurrency.getItemCount() - 1);
            }
        }
        catch (SQLException e1) {
            try {
                log.log(Level.SEVERE, "VSetup.dynInit -currency", e1);
            }
            catch (Throwable throwable) {
                DB.close(rs, stmt);
                rs = null;
                stmt = null;
                throw throwable;
            }
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
        }
        DB.close(rs, stmt);
        rs = null;
        stmt = null;
        int C_Country_ID = 0;
        sql = "SELECT C_Country_ID, Name, CountryCode FROM C_Country ORDER BY 2";
        try {
            stmt = DB.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                this.fCountry.addItem(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                if (!locale.getCountry().equals(rs.getString(3))) continue;
                this.fCountry.setSelectedIndex(this.fCountry.getItemCount() - 1);
                C_Country_ID = rs.getInt(1);
            }
        }
        catch (SQLException e1) {
            log.log(Level.SEVERE, "VSetup.dynInit -country", e1);
        }
        finally {
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
        }
        sql = "SELECT C_Region_ID, Name, C_Country_ID FROM C_Region ORDER BY C_Country_ID, Name";
        boolean isSelected = false;
        try {
            this.fRegion.addItem(new KeyNamePair(0, " "));
            stmt = DB.createStatement();
            rs = stmt.executeQuery(sql);
            while (rs.next()) {
                this.fRegion.addItem(new KeyNamePair(rs.getInt(1), rs.getString(2)));
                if (isSelected || rs.getInt(3) != C_Country_ID) continue;
                this.fRegion.setSelectedIndex(this.fRegion.getItemCount() - 1);
                isSelected = true;
            }
        }
        catch (SQLException e1) {
            log.log(Level.SEVERE, "VSetup.dynInit -region", e1);
        }
        finally {
            DB.close(rs, stmt);
            rs = null;
            stmt = null;
        }
        this.confirmPanel.addActionListener(this);
        this.buttonLoadAcct.addActionListener(this);
        this.confirmPanel.getOKButton().setEnabled(false);
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.buttonLoadAcct)) {
            this.m_file = this.getFile();
        } else if (e.getActionCommand().equals("Ok") && this.m_file != null) {
            this.confirmPanel.getCancelButton().setEnabled(false);
            this.confirmPanel.getOKButton().setEnabled(false);
            if (this.createSetup()) {
                this.m_frame.startBatch(this);
            } else {
                this.confirmPanel.getCancelButton().setEnabled(true);
                this.confirmPanel.getOKButton().setEnabled(true);
            }
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
    }

    private File getFile() {
        File file = null;
        String dirName = Adempiere.getAdempiereHome() + File.separator + "data" + File.separator + "import";
        log.config(dirName);
        JFileChooser chooser = new JFileChooser(dirName);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(Msg.translate(Env.getCtx(), "LoadAccountingValues"));
        chooser.addChoosableFileFilter(new ExtensionFileFilter("csv", Msg.getMsg(Env.getCtx(), "FileCSV")));
        file = new File(dirName + File.pathSeparator + "AccountingUS.csv");
        if (file.exists()) {
            chooser.setSelectedFile(file);
        }
        file = chooser.showOpenDialog(this.getParent()) == 0 ? chooser.getSelectedFile() : null;
        chooser = null;
        if (file == null) {
            this.buttonLoadAcct.setText(Msg.translate(Env.getCtx(), "LoadAccountingValues"));
        } else {
            this.buttonLoadAcct.setText(file.getAbsolutePath());
        }
        this.confirmPanel.getOKButton().setEnabled(file != null);
        this.m_frame.pack();
        return file;
    }

    private boolean createSetup() {
        this.fClientName.setText(this.fClientName.getText().replace('\'', '\"'));
        this.fClientName.setText(this.fClientName.getText().replace('\\', '/'));
        this.fOrgName.setText(this.fOrgName.getText().replace('\'', '\"'));
        this.fOrgName.setText(this.fOrgName.getText().replace('\\', '/'));
        this.fUserClient.setText(this.fUserClient.getText().replace('\'', '\"'));
        this.fUserClient.setText(this.fUserClient.getText().replace('\\', '/'));
        this.fUserOrg.setText(this.fUserOrg.getText().replace('\'', '\"'));
        this.fUserOrg.setText(this.fUserOrg.getText().replace('\\', '/'));
        String SQL = "UPDATE AD_CLient SET CreatedBy=0 WHERE Name='" + this.fClientName.getText() + "'";
        if (DB.executeUpdate(SQL, null) != 0) {
            this.fClientName.setBackground(AdempierePLAF.getFieldBackground_Error());
            ADialog.error(this.m_WindowNo, this, "NotUnique", this.lClientName.getText());
            this.fClientName.requestFocus();
            return false;
        }
        this.fClientName.setBackground(AdempierePLAF.getFieldBackground_Normal());
        SQL = "UPDATE AD_User SET CreatedBy=0 WHERE Name='" + this.fUserClient.getText() + "'";
        if (DB.executeUpdate(SQL, null) != 0) {
            this.fUserClient.setBackground(AdempierePLAF.getFieldBackground_Error());
            ADialog.error(this.m_WindowNo, this, "NotUnique", this.lUserClient.getText());
            this.fUserClient.requestFocus();
            return false;
        }
        this.fUserClient.setBackground(AdempierePLAF.getFieldBackground_Normal());
        SQL = "UPDATE AD_User SET CreatedBy=0 WHERE Name='" + this.fUserOrg.getText() + "'";
        if (DB.executeUpdate(SQL, null) != 0 || this.fUserClient.getText().equals(this.fUserOrg.getText())) {
            this.fUserOrg.setBackground(AdempierePLAF.getFieldBackground_Error());
            ADialog.error(this.m_WindowNo, this, "NotUnique", this.lUserOrg.getText());
            this.fUserOrg.requestFocus();
            return false;
        }
        this.fUserOrg.setBackground(AdempierePLAF.getFieldBackground_Normal());
        return true;
    }

    @Override
    public void run() {
        MSetup ms = new MSetup(Env.getCtx(), this.m_WindowNo);
        this.m_frame.setBusyTimer(45);
        boolean ok = ms.createClient(this.fClientName.getText(), this.fOrgValue.getText(), this.fOrgName.getText(), this.fUserClient.getText(), this.fUserOrg.getText(), null, null, null, null, null, null, null, 0);
        Object info = ms.getInfo();
        if (ok) {
            KeyNamePair currency = (KeyNamePair)this.fCurrency.getSelectedItem();
            if (!ms.createAccounting(currency, this.fProduct.isSelected(), this.fBPartner.isSelected(), this.fProject.isSelected(), this.fMCampaign.isSelected(), this.fSRegion.isSelected(), null, 0, this.m_file)) {
                ADialog.error(this.m_WindowNo, this, "AccountSetupError");
                this.dispose();
            } else {
                KeyNamePair p2 = (KeyNamePair)this.fCountry.getSelectedItem();
                int C_Country_ID = p2.getKey();
                p2 = (KeyNamePair)this.fRegion.getSelectedItem();
                int C_Region_ID = p2.getKey();
                ms.createEntities(C_Country_ID, this.fCity.getText(), C_Region_ID, currency.getKey(), null, null);
                info = (String)info + ms.getInfo();
                PrintUtil.setupPrintForm(ms.getAD_Client_ID());
            }
        }
        ADialog.info(this.m_WindowNo, this, "VSetup", (String)info);
        this.dispose();
    }
}

