/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import org.adempiere.core.domains.models.X_C_PaySelection;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.ProcessCtl;
import org.compiere.apps.ProcessPanel;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.apps.form.PaySelect;
import org.compiere.apps.form.VPayPrint;
import org.compiere.grid.ed.VCheckBox;
import org.compiere.grid.ed.VComboBox;
import org.compiere.grid.ed.VDate;
import org.compiere.grid.ed.VLookup;
import org.compiere.minigrid.MiniTable;
import org.compiere.model.MColumn;
import org.compiere.model.MLookupFactory;
import org.compiere.model.MSysConfig;
import org.compiere.plaf.CompiereColor;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CLabel;
import org.compiere.swing.CPanel;
import org.compiere.swing.CTextField;
import org.compiere.util.ASyncProcess;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;
import org.compiere.util.ValueNamePair;

@Deprecated
public class VPaySelect
extends PaySelect
implements FormPanel,
ActionListener,
ASyncProcess,
PropertyChangeListener,
MiniTable.MiniTableSelectionListener {
    private CPanel panel = new CPanel();
    private boolean m_loadedOK = false;
    private FormFrame m_frame;
    private CPanel mainPanel = new CPanel();
    private BorderLayout mainLayout = new BorderLayout();
    private CPanel parameterPanel = new CPanel();
    private CLabel labelBankAccount = new CLabel();
    private VComboBox fieldBankAccount = new VComboBox();
    private GridBagLayout parameterLayout = new GridBagLayout();
    private CLabel labelBankBalance = new CLabel();
    private CLabel labelCurrency = new CLabel();
    private CLabel labelBalance = new CLabel();
    private VCheckBox onlyDue = new VCheckBox();
    private CLabel labelBPartner = new CLabel();
    private VLookup fieldBPartner;
    private CLabel labelDtype = new CLabel();
    private VComboBox fieldDtype = new VComboBox();
    private JLabel dataStatus = new JLabel();
    private JScrollPane dataPane = new JScrollPane();
    private MiniTable miniTable = new MiniTable();
    private CPanel commandPanel = new CPanel();
    private JButton bCancel = ConfirmPanel.createCancelButton(true);
    private JButton bGenerate = ConfirmPanel.createProcessButton(true);
    private FlowLayout commandLayout = new FlowLayout();
    private JButton bRefresh = ConfirmPanel.createRefreshButton(true);
    private CLabel labelPayDate = new CLabel();
    private VDate fieldPayDate = new VDate();
    private CLabel labelPaymentRule = new CLabel();
    private VComboBox fieldPaymentRule = new VComboBox();
    private VCheckBox checkAutoQuery = new VCheckBox();
    private static String SYSCONFIG_INFO_AUTO_QUERY = "INFO_AUTO_QUERY";
    Toolkit toolkit = Toolkit.getDefaultToolkit();
    Dimension screensize = this.toolkit.getScreenSize();
    protected final int SCREEN_WIDTH;
    protected final int SCREEN_HEIGHT;

    public VPaySelect() {
        this.SCREEN_WIDTH = this.screensize.width > 1000 ? 1000 : this.screensize.width - 100;
        this.SCREEN_HEIGHT = this.screensize.height > 1000 ? 800 : this.screensize.height - 100;
    }

    @Override
    public void init(int WindowNo, FormFrame frame) {
        log.info("");
        this.m_WindowNo = WindowNo;
        this.m_frame = frame;
        try {
            this.jbInit();
            this.dynInit();
            this.m_loadedOK = true;
            if (this.checkAutoQuery.isSelected()) {
                this.setFieldOldValues();
                this.loadTableInfo();
            }
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this.panel);
        this.mainPanel.setLayout(this.mainLayout);
        this.parameterPanel.setLayout(this.parameterLayout);
        this.labelBankAccount.setText(Msg.translate(Env.getCtx(), "C_BankAccount_ID"));
        this.fieldBankAccount.addActionListener(this);
        this.labelBPartner.setText(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        this.fieldBPartner = new VLookup("C_BPartner_ID", false, false, true, MLookupFactory.get(Env.getCtx(), this.m_WindowNo, 0, MColumn.getColumn_ID("C_BPartner", "C_BPartner_ID"), 30));
        this.fieldBPartner.addActionListener(this);
        this.bRefresh.addActionListener(this);
        this.labelDtype.setText(Msg.translate(Env.getCtx(), "C_DocType_ID"));
        this.fieldDtype.addActionListener(this);
        this.labelPayDate.setText(Msg.translate(Env.getCtx(), "PayDate"));
        this.fieldPayDate.addActionListener(this);
        this.labelPaymentRule.setText(Msg.translate(Env.getCtx(), "PaymentRule"));
        this.fieldPaymentRule.addActionListener(this);
        this.labelBankBalance.setText(Msg.translate(Env.getCtx(), "CurrentBalance"));
        this.labelBalance.setText("0");
        this.onlyDue.setText(Msg.getMsg(Env.getCtx(), "OnlyDue"));
        this.onlyDue.addActionListener(this);
        this.dataStatus.setText(" ");
        this.checkAutoQuery.setText(Msg.getMsg(Env.getCtx(), "AutoRefresh"));
        this.checkAutoQuery.setToolTipText(Msg.getMsg(Env.getCtx(), "AutoRefresh"));
        this.checkAutoQuery.setName("AutoQuery");
        this.checkAutoQuery.setSelected(MSysConfig.getValue(SYSCONFIG_INFO_AUTO_QUERY, "Y", Env.getAD_Client_ID(Env.getCtx())).equals("Y"));
        this.checkAutoQuery.addActionListener(this);
        this.bGenerate.addActionListener(this);
        this.bCancel.addActionListener(this);
        this.miniTable.addPropertyChangeListener(this);
        this.mainPanel.add((Component)this.parameterPanel, "North");
        this.mainPanel.setPreferredSize(new Dimension(this.SCREEN_WIDTH, this.SCREEN_HEIGHT));
        this.parameterPanel.add((Component)this.labelBankAccount, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldBankAccount, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelBankBalance, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelCurrency, new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelBalance, new GridBagConstraints(3, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelBPartner, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldBPartner, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelDtype, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldDtype, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelPaymentRule, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldPaymentRule, new GridBagConstraints(3, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.checkAutoQuery, new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.labelPayDate, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.fieldPayDate, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.onlyDue, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.parameterPanel.add((Component)this.bRefresh, new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.mainPanel.add((Component)this.dataStatus, "South");
        this.mainPanel.add((Component)this.dataPane, "Center");
        this.dataPane.getViewport().add((Component)this.miniTable, null);
        this.commandPanel.setLayout(this.commandLayout);
        this.commandLayout.setAlignment(2);
        this.commandLayout.setHgap(10);
        this.commandPanel.add((Component)this.bCancel, null);
        this.commandPanel.add((Component)this.bGenerate, null);
        this.m_frame.getContentPane().add((Component)this.commandPanel, "South");
        this.m_frame.getContentPane().add((Component)this.mainPanel, "Center");
    }

    private void dynInit() {
        ArrayList<PaySelect.BankInfo> bankAccountData = this.getBankAccountData();
        for (PaySelect.BankInfo bi : bankAccountData) {
            this.fieldBankAccount.addItem(bi);
        }
        if (this.fieldBankAccount.getItemCount() == 0) {
            ADialog.error(this.m_WindowNo, this.panel, "VPaySelectNoBank");
        } else {
            this.fieldBankAccount.setSelectedIndex(0);
        }
        this.loadBankInfo();
        ArrayList<KeyNamePair> docTypeData = this.getDocTypeData();
        for (KeyNamePair pp : docTypeData) {
            this.fieldDtype.addItem(pp);
        }
        this.prepareTable(this.miniTable);
        this.miniTable.addMiniTableSelectionListener(this);
        this.fieldPayDate.setMandatory(true);
        this.fieldPayDate.setValue(new Timestamp(System.currentTimeMillis()));
    }

    private void loadBankInfo() {
        this.m_loadedOK = false;
        log.fine("");
        PaySelect.BankInfo bi = (PaySelect.BankInfo)this.fieldBankAccount.getSelectedItem();
        if (bi == null) {
            return;
        }
        this.labelCurrency.setText(bi.Currency);
        this.labelBalance.setText(this.m_format.format(bi.Balance));
        this.fieldPaymentRule.removeAllItems();
        ArrayList<ValueNamePair> paymentRuleData = this.getPaymentRuleData(bi);
        for (ValueNamePair vp : paymentRuleData) {
            this.fieldPaymentRule.addItem(vp);
        }
        this.fieldPaymentRule.setSelectedIndex(0);
        this.m_loadedOK = true;
    }

    private void loadTableInfo() {
        Timestamp payDate = (Timestamp)this.fieldPayDate.getValue();
        this.miniTable.setColorCompare(payDate);
        log.config("PayDate=" + payDate);
        PaySelect.BankInfo bi = (PaySelect.BankInfo)this.fieldBankAccount.getSelectedItem();
        ValueNamePair paymentRule = (ValueNamePair)this.fieldPaymentRule.getSelectedItem();
        KeyNamePair docType = (KeyNamePair)this.fieldDtype.getSelectedItem();
        int c_bpartner_id = 0;
        if (this.fieldBPartner.getValue() != null) {
            c_bpartner_id = (Integer)this.fieldBPartner.getValue();
        }
        this.loadTableInfo(bi, payDate, paymentRule, this.onlyDue.isSelected(), c_bpartner_id, docType, this.miniTable);
        this.calculateSelection();
    }

    @Override
    public void dispose() {
        if (this.m_frame != null) {
            this.m_frame.dispose();
        }
        this.m_frame = null;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        boolean triggerRefresh = false;
        if (!this.m_loadedOK) {
            return;
        }
        Object source = e.getSource();
        String cmd = e.getActionCommand();
        if (source instanceof VComboBox && ((VComboBox)source).getParent() instanceof VLookup) {
            source = ((VComboBox)source).getParent();
            VLookup vl = (VLookup)source;
            if (cmd.equals("comboBoxChanged")) {
                if (!vl.hasChanged()) {
                    return;
                }
                triggerRefresh = true;
            } else if (cmd.equals("comboBoxEdited")) {
                if (!vl.hasChanged()) {
                    vl.requestFocus();
                    return;
                }
                triggerRefresh = true;
            }
        } else if (source instanceof CTextField) {
            CTextField tf = (CTextField)source;
            if (tf.getParent() instanceof VLookup) {
                return;
            }
            if (tf.hasChanged()) {
                triggerRefresh = true;
            }
        } else if (e.getSource() instanceof VCheckBox) {
            triggerRefresh = true;
            VCheckBox cb = (VCheckBox)e.getSource();
            if (cb.getName().equals("AutoQuery") && !cb.isSelected()) {
                return;
            }
        } else if (cmd.equals("comboBoxChanged")) {
            VComboBox vcb = (VComboBox)source;
            if (!vcb.hasChanged()) {
                return;
            }
            triggerRefresh = true;
        } else if (cmd.equals("comboBoxEdited")) {
            VComboBox vcb = (VComboBox)source;
            if (!vcb.hasChanged()) {
                vcb.requestFocus();
                return;
            }
            triggerRefresh = true;
        }
        if (triggerRefresh && e.getSource() == this.fieldBankAccount) {
            this.loadBankInfo();
        }
        if (e.getSource() == this.bGenerate) {
            this.generatePaySelect();
            this.dispose();
        } else if (e.getSource() == this.bCancel) {
            this.dispose();
        }
        if (e.getSource() == this.bRefresh || this.checkAutoQuery.isSelected() && triggerRefresh) {
            this.setFieldOldValues();
            this.loadTableInfo();
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        if (e.getPropertyName() == "p_table_update") {
            this.calculateSelection();
        }
    }

    public void calculateSelection() {
        this.dataStatus.setText(this.calculateSelection(this.miniTable));
        this.bGenerate.setEnabled(this.m_noSelected != 0);
    }

    private void generatePaySelect() {
        this.miniTable.stopEditor(true);
        if (this.miniTable.getRowCount() == 0) {
            return;
        }
        this.miniTable.setRowSelectionInterval(0, 0);
        this.calculateSelection();
        if (this.m_noSelected == 0) {
            return;
        }
        String msg = this.generatePaySelect(this.miniTable, (ValueNamePair)this.fieldPaymentRule.getSelectedItem(), this.fieldPayDate.getTimestamp(), (PaySelect.BankInfo)this.fieldBankAccount.getSelectedItem());
        if (msg != null && msg.length() > 0) {
            ADialog.error(this.m_WindowNo, this.panel, "SaveError", msg);
            return;
        }
        if (!ADialog.ask(this.m_WindowNo, this.panel, "VPaySelectGenerate?", "(" + this.m_ps.getDocumentNo() + ")")) {
            return;
        }
        int AD_Proces_ID = 155;
        ProcessInfo pi = new ProcessInfo(this.m_frame.getTitle(), AD_Proces_ID, X_C_PaySelection.Table_ID, this.m_ps.getC_PaySelection_ID());
        pi.setAD_User_ID(Env.getAD_User_ID(Env.getCtx()));
        pi.setAD_Client_ID(Env.getAD_Client_ID(Env.getCtx()));
        ProcessPanel pp = new ProcessPanel(this.m_WindowNo, pi);
        ProcessCtl.process(this, this.m_WindowNo, pp, pi, this.trx);
    }

    @Override
    public void lockUI(ProcessInfo pi) {
        this.panel.setEnabled(false);
        this.m_isLocked = true;
    }

    @Override
    public void unlockUI(ProcessInfo pi) {
        if (!ADialog.ask(0, this.panel, "VPaySelectPrint?", "(" + pi.getSummary() + ")")) {
            return;
        }
        int AD_Form_ID = 106;
        FormFrame ff = new FormFrame();
        ff.openForm(AD_Form_ID);
        if (this.m_ps != null) {
            VPayPrint pp = (VPayPrint)ff.getFormPanel();
            pp.setPaySelection(this.m_ps.getC_PaySelection_ID());
        }
        ff.pack();
        this.panel.setVisible(false);
        AEnv.addToWindowManager(ff);
        AEnv.showCenterScreen(ff);
        this.dispose();
    }

    @Override
    public boolean isUILocked() {
        return this.m_isLocked;
    }

    @Override
    public void executeASync(ProcessInfo pi) {
        log.config("-");
    }

    @Override
    public void rowSelected(MiniTable.RowSelectionEvent e) {
        this.calculateSelection();
    }

    protected void setFieldOldValues() {
        this.fieldBankAccount.set_oldValue();
        this.fieldBPartner.set_oldValue();
        this.fieldDtype.set_oldValue();
        this.fieldPaymentRule.set_oldValue();
        this.onlyDue.set_oldValue();
    }
}

