/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.adempiere.controller.FileImportController;
import org.compiere.Adempiere;
import org.compiere.apps.ADialog;
import org.compiere.apps.AppsAction;
import org.compiere.apps.ConfirmPanel;
import org.compiere.apps.SwingWorker;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.form.FormPanel;
import org.compiere.impexp.ImpFormatRow;
import org.compiere.model.MRole;
import org.compiere.plaf.CompiereColor;
import org.compiere.swing.CButton;
import org.compiere.swing.CComboBox;
import org.compiere.swing.CPanel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;

public class VFileImport
extends FileImportController
implements FormPanel,
ActionListener {
    private FormFrame frame;
    private JLabel[] m_labels;
    private JTextField[] m_fields;
    private static CLogger log = CLogger.getCLogger(VFileImport.class);
    private static final String s_none = "----";
    private CPanel mainPanel = new CPanel();
    private CPanel northPanel = new CPanel();
    private JButton bFile = new JButton();
    private JComboBox pickFormat = new JComboBox();
    private CPanel centerPanel = new CPanel();
    private BorderLayout centerLayout = new BorderLayout();
    private JScrollPane rawDataPane = new JScrollPane();
    private JTextArea rawData = new JTextArea();
    private JScrollPane previewPane = new JScrollPane();
    private CPanel previewPanel = new CPanel();
    private ConfirmPanel confirmPanel = new ConfirmPanel(true);
    private JLabel info = new JLabel();
    private JLabel labelFormat = new JLabel();
    private GridBagLayout previewLayout = new GridBagLayout();
    private JButton bNext = new JButton();
    private JButton bPrevious = new JButton();
    private JLabel record = new JLabel();
    private CButton loadData = null;
    private CComboBox fCharset = new CComboBox(Ini.getAvailableCharsets());

    @Override
    public void init(int WindowNo, FormFrame frame) {
        super.init(WindowNo);
        log.info("");
        this.frame = frame;
        try {
            this.jbInit();
            this.dynInit();
            frame.getContentPane().add((Component)this.northPanel, "North");
            frame.getContentPane().add((Component)this.centerPanel, "Center");
            frame.getContentPane().add((Component)this.confirmPanel, "South");
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "init", e);
        }
    }

    private void jbInit() throws Exception {
        CompiereColor.setBackground(this.mainPanel);
        AppsAction action = new AppsAction("Process", null, Msg.getMsg(Env.getCtx(), "ConnectToSource"));
        action.setDelegate(this);
        this.loadData = (CButton)action.getButton();
        this.bFile.setText(Msg.getMsg(Env.getCtx(), "FileImportFile"));
        this.bFile.setToolTipText(Msg.getMsg(Env.getCtx(), "FileImportFileInfo"));
        this.bFile.addActionListener(this);
        this.fCharset.setToolTipText(Msg.getMsg(Env.getCtx(), "Charset", false));
        this.info.setText("   ");
        this.labelFormat.setText(Msg.translate(Env.getCtx(), "AD_ImpFormat_ID"));
        this.bNext.setToolTipText(Msg.getMsg(Env.getCtx(), "Next"));
        this.bNext.setMargin(new Insets(2, 2, 2, 2));
        this.bNext.setText(">");
        this.bNext.addActionListener(this);
        this.record.setText("------");
        this.bPrevious.setToolTipText(Msg.getMsg(Env.getCtx(), "Previous"));
        this.bPrevious.setMargin(new Insets(2, 2, 2, 2));
        this.bPrevious.setText("<");
        this.bPrevious.addActionListener(this);
        this.northPanel.setBorder(BorderFactory.createEtchedBorder());
        this.northPanel.add((Component)this.bFile, null);
        this.northPanel.add(this.fCharset);
        this.northPanel.add((Component)this.info, null);
        this.northPanel.add((Component)this.labelFormat, null);
        this.northPanel.add((Component)this.pickFormat, null);
        this.northPanel.add((Component)this.loadData, null);
        this.northPanel.add((Component)this.bPrevious, null);
        this.northPanel.add((Component)this.record, null);
        this.northPanel.add((Component)this.bNext, null);
        this.centerPanel.setLayout(this.centerLayout);
        this.rawData.setFont(new Font("Monospaced", 0, 10));
        this.rawData.setColumns(80);
        this.rawData.setRows(10);
        this.rawDataPane.getViewport().add((Component)this.rawData, null);
        this.centerPanel.add((Component)this.rawDataPane, "Center");
        this.centerPanel.add((Component)this.previewPane, "South");
        this.previewPanel.setLayout(this.previewLayout);
        this.previewPane.getViewport().add((Component)this.previewPanel, null);
        this.previewPane.setPreferredSize(new Dimension(700, 80));
        this.confirmPanel.addActionListener(this);
        this.loadData.setVisible(false);
    }

    @Override
    public void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
        }
        this.frame = null;
    }

    private void dynInit() {
        this.pickFormat.addItem(s_none);
        String sql = MRole.getDefault().addAccessSQL("SELECT Name FROM AD_ImpFormat", "AD_ImpFormat", true, false);
        try {
            CPreparedStatement pstmt = DB.prepareStatement(sql, null);
            ResultSet rs = pstmt.executeQuery();
            while (rs.next()) {
                this.pickFormat.addItem(rs.getString(1));
            }
            rs.close();
            pstmt.close();
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        this.pickFormat.setSelectedIndex(0);
        this.pickFormat.addActionListener(this);
        Charset charset = Ini.getCharset();
        this.setCharset(charset);
        this.fCharset.setSelectedItem(charset);
        this.fCharset.addActionListener(this);
        this.confirmPanel.getOKButton().setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.bFile) {
            this.cmd_loadFile();
            this.fillView();
        } else if (e.getSource() == this.fCharset) {
            this.setCharset((Charset)this.fCharset.getSelectedItem());
            this.cmd_reloadFile();
            this.setRecordNo(this.getRecordNo() - 1);
            this.cmd_applyFormat(true);
        } else if (e.getSource() == this.pickFormat) {
            this.cmd_loadFormat();
            this.fillView();
        } else if (e.getSource() == this.bNext) {
            this.cmd_applyFormat(true);
        } else if (e.getSource() == this.bPrevious) {
            this.cmd_applyFormat(false);
        } else if (e.getActionCommand().equals("Ok")) {
            this.setBusy(true);
            SwingWorker worker = new SwingWorker(){

                @Override
                public Object construct() {
                    VFileImport.this.cmd_processData();
                    return Boolean.TRUE;
                }
            };
            worker.start();
        } else if (e.getActionCommand().equals("Process")) {
            this.readFromConnection();
        } else if (e.getActionCommand().equals("Cancel")) {
            this.dispose();
        }
        this.confirmPanel.getOKButton().setEnabled(this.getDataSize() > 0 && this.getRowCount() > 0);
    }

    private void cmd_loadFile() {
        String directory = Adempiere.getAdempiereHome() + File.separator + "data" + File.separator + "import";
        log.config(directory);
        JFileChooser chooser = new JFileChooser(directory);
        chooser.setFileSelectionMode(0);
        chooser.setMultiSelectionEnabled(false);
        chooser.setDialogTitle(Msg.getMsg(Env.getCtx(), "FileImportFileInfo"));
        if (chooser.showOpenDialog(this.frame.getContainer()) != 0) {
            return;
        }
        File file = chooser.getSelectedFile();
        log.config(file.getName());
        this.bFile.setText(file.getName());
        try {
            this.cmd_reloadFile(new FileInputStream(file));
        }
        catch (Exception e) {
            log.severe(e.getMessage());
        }
    }

    private void cmd_loadFormat() {
        this.previewPanel.removeAll();
        String formatName = this.pickFormat.getSelectedItem().toString();
        if (formatName.equals(s_none)) {
            return;
        }
        String error = this.loadFormat(formatName);
        if (error != null) {
            ADialog.error(this.getWindowNo(), this.frame.getContainer(), error, formatName);
            return;
        }
        int size = this.getRowCount();
        this.m_labels = new JLabel[size];
        this.m_fields = new JTextField[size];
        for (int i = 0; i < size; ++i) {
            ImpFormatRow row = this.getRow(i);
            this.m_labels[i] = new JLabel(row.getColumnName());
            this.previewPanel.add((Component)this.m_labels[i], new GridBagConstraints(i, 0, 1, 1, 1.0, 1.0, 10, 0, new Insets(2, 2, 2, 2), 0, 0));
            int length = row.getEndNo() - row.getStartNo();
            if (length <= 5) {
                length = 5;
            } else if (length > 20) {
                length = 20;
            }
            this.m_fields[i] = new JTextField(length);
            this.previewPanel.add((Component)this.m_fields[i], new GridBagConstraints(i, 1, 1, 1, 1.0, 1.0, 10, 2, new Insets(2, 2, 2, 2), 0, 0));
        }
        this.setRecordNo(-1);
        this.loadData.setVisible(this.isFromConnection());
        this.clearPreview();
    }

    private void cmd_applyFormat(boolean next) {
        if (this.getRowCount() == 0 || this.getDataSize() == 0) {
            return;
        }
        if (next) {
            this.addRecordNo(1);
        } else {
            this.addRecordNo(-1);
        }
        if (this.getRecordNo() < 0) {
            this.setRecordNo(0);
        } else if (this.getRecordNo() >= this.getDataSize()) {
            this.setRecordNo(this.getDataSize() - 1);
        }
        this.record.setText(" " + String.valueOf(this.getRecordNo() + 1) + " ");
        String[] lInfo = this.parseLine(this.getRecordNo());
        int size = this.getRowCount();
        if (lInfo.length != size) {
            log.log(Level.SEVERE, "FormatElements=" + size + " != Fields=" + lInfo.length);
        }
        for (int i = 0; i < size; ++i) {
            this.m_fields[i].setText(lInfo[i]);
            this.m_fields[i].setCaretPosition(0);
        }
    }

    private void cmd_processData() {
        String infoMsg = null;
        try {
            infoMsg = this.cmd_process();
            this.clearView();
        }
        catch (Exception e) {
            ADialog.error(this.getWindowNo(), this.frame.getContainer(), e.getMessage());
        }
        finally {
            this.setBusy(false);
        }
        if (infoMsg != null) {
            ADialog.info(this.getWindowNo(), this.frame.getContainer(), Msg.parseTranslation(Env.getCtx(), infoMsg));
        }
    }

    @Override
    public void setBusy(boolean busy) {
        if (busy) {
            this.frame.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.frame.setCursor(Cursor.getDefaultCursor());
        }
        this.frame.setBusy(busy);
        this.confirmPanel.setEnabled(!busy);
    }

    @Override
    public void clearView() {
        this.rawData.setText("");
        this.clearPreview();
    }

    @Override
    public void fillView() {
        this.fillInfoView();
        this.frame.getContainer().invalidate();
        this.frame.pack();
    }

    @Override
    public void addLine(String line) {
        this.rawData.append(line);
    }

    @Override
    public void clearPreview() {
        this.record.setText("------");
        this.previewPanel.invalidate();
        this.previewPanel.repaint();
    }

    @Override
    public void fillInfoView() {
        this.info.setText(Msg.getMsg(Env.getCtx(), "Records") + "=" + this.getDataSize() + ", " + Msg.getMsg(Env.getCtx(), "Length") + "=" + this.getRecordLength(1) + "   ");
    }
}

