/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps.form;

import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import java.util.logging.Level;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import org.adempiere.Adempiere;
import org.compiere.apps.AEnv;
import org.compiere.apps.AGlassPane;
import org.compiere.apps.AMenu;
import org.compiere.apps.Help;
import org.compiere.apps.WindowMenu;
import org.compiere.apps.form.FormPanel;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.process.ProcessInfo;
import org.compiere.swing.CDialog;
import org.compiere.swing.CFrame;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Trace;

public class FormFrame
implements ActionListener {
    private ProcessInfo m_pi;
    private int m_WindowNo;
    private AGlassPane m_glassPane = new AGlassPane();
    private String m_Description = null;
    private String m_Help = null;
    private JMenuBar menuBar = new JMenuBar();
    private FormPanel m_panel = null;
    public boolean m_maximize = false;
    private static CLogger log = CLogger.getCLogger(FormFrame.class);
    private int p_AD_Form_ID = 0;
    private Container m_MainContent = null;

    public FormFrame() {
        this(0);
    }

    public FormFrame(int p_ParentWindowNo) {
        JFrame owner = Env.getWindow(p_ParentWindowNo);
        if (p_ParentWindowNo == 0) {
            CFrame frame = new CFrame(owner.getGraphicsConfiguration());
            frame.setGlassPane(this.m_glassPane);
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowOpened(WindowEvent evt) {
                    FormFrame.this.formWindowOpened(evt);
                }
            });
            this.m_MainContent = frame;
            this.m_WindowNo = Env.createWindowNo(this.m_MainContent);
        } else {
            CDialog dialog = new CDialog((Frame)owner, true);
            dialog.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
            this.m_MainContent = dialog;
            this.m_WindowNo = p_ParentWindowNo;
        }
        try {
            this.jbInit();
            this.createMenu();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
    }

    public FormFrame(CFrame frame) {
        this.m_MainContent = frame;
        this.p_AD_Form_ID = frame.getAD_Form_ID();
    }

    @Deprecated
    public FormFrame(GraphicsConfiguration gc) {
        this(0);
    }

    private void jbInit() throws Exception {
        this.setIconImage(Adempiere.getImage16());
        this.setDefaultCloseOperation(2);
        this.setJMenuBar(this.menuBar);
    }

    private void createMenu() {
        JMenu mFile = AEnv.getMenu("File");
        this.menuBar.add(mFile);
        AEnv.addMenuItem("PrintScreen", null, KeyStroke.getKeyStroke(154, 0), mFile, this);
        AEnv.addMenuItem("ScreenShot", null, KeyStroke.getKeyStroke(154, 1), mFile, this);
        AEnv.addMenuItem("Report", null, KeyStroke.getKeyStroke(80, 8), mFile, this);
        mFile.addSeparator();
        AEnv.addMenuItem("End", null, KeyStroke.getKeyStroke(88, 8), mFile, this);
        AEnv.addMenuItem("Exit", null, KeyStroke.getKeyStroke(88, 9), mFile, this);
        JMenu mView = AEnv.getMenu("View");
        this.menuBar.add(mView);
        if (MRole.getDefault().isAllow_Info_Product()) {
            AEnv.addMenuItem("InfoProduct", null, KeyStroke.getKeyStroke(73, 8), mView, this);
        }
        if (MRole.getDefault().isAllow_Info_BPartner()) {
            AEnv.addMenuItem("InfoBPartner", null, KeyStroke.getKeyStroke(73, 10), mView, this);
        }
        if (MRole.getDefault().isShowAcct() && MRole.getDefault().isAllow_Info_Account()) {
            AEnv.addMenuItem("InfoAccount", null, KeyStroke.getKeyStroke(73, 10), mView, this);
        }
        if (MRole.getDefault().isAllow_Info_Schedule()) {
            AEnv.addMenuItem("InfoSchedule", null, null, mView, this);
        }
        mView.addSeparator();
        if (MRole.getDefault().isAllow_Info_Order()) {
            AEnv.addMenuItem("InfoOrder", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_Invoice()) {
            AEnv.addMenuItem("InfoInvoice", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_InOut()) {
            AEnv.addMenuItem("InfoInOut", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_Payment()) {
            AEnv.addMenuItem("InfoPayment", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_CashJournal()) {
            AEnv.addMenuItem("InfoCashLine", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_Resource()) {
            AEnv.addMenuItem("InfoAssignment", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_Asset()) {
            AEnv.addMenuItem("InfoAsset", "Info", null, mView, this);
        }
        JMenu mTools = AEnv.getMenu("Tools");
        this.menuBar.add(mTools);
        AEnv.addMenuItem("Calculator", null, null, mTools, this);
        AEnv.addMenuItem("Calendar", null, null, mTools, this);
        AEnv.addMenuItem("Editor", null, null, mTools, this);
        MUser user = MUser.get(Env.getCtx());
        if (user.isAdministrator()) {
            AEnv.addMenuItem("Script", null, null, mTools, this);
        }
        if (MRole.getDefault().isShowPreference()) {
            mTools.addSeparator();
            AEnv.addMenuItem("Preference", null, null, mTools, this);
        }
        AMenu aMenu = (AMenu)Env.getWindow(0);
        WindowMenu mWindow = new WindowMenu(aMenu.getWindowManager(), null);
        this.menuBar.add(mWindow);
        JMenu mHelp = AEnv.getMenu("Help");
        this.menuBar.add(mHelp);
        AEnv.addMenuItem("Help", "Help", KeyStroke.getKeyStroke(112, 0), mHelp, this);
        AEnv.addMenuItem("Online", null, null, mHelp, this);
        AEnv.addMenuItem("EMailSupport", null, null, mHelp, this);
        AEnv.addMenuItem("About", null, null, mHelp, this);
    }

    public void dispose() {
        log.config("");
        if (Trace.isCalledFrom("JFrame") && this.m_panel != null) {
            this.m_panel.dispose();
        }
        this.m_panel = null;
        Env.clearWinContext(this.m_WindowNo);
        this.getWindow().dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean openForm(int AD_Form_ID) {
        boolean trl;
        Properties ctx = Env.getCtx();
        String name = null;
        String className = null;
        String sql = "SELECT Name, Description, ClassName, Help FROM AD_Form WHERE AD_Form_ID=?";
        boolean bl = trl = !Env.isBaseLanguage(ctx, "AD_Form");
        if (trl) {
            sql = "SELECT t.Name, t.Description, f.ClassName, t.Help FROM AD_Form f INNER JOIN AD_Form_Trl t ON (f.AD_Form_ID=t.AD_Form_ID AND AD_Language=?)WHERE f.AD_Form_ID=?";
        }
        CPreparedStatement pstmt = null;
        ResultSet rs = null;
        try {
            pstmt = DB.prepareStatement(sql, null);
            if (trl) {
                pstmt.setString(1, Env.getAD_Language(ctx));
                pstmt.setInt(2, AD_Form_ID);
            } else {
                pstmt.setInt(1, AD_Form_ID);
            }
            rs = pstmt.executeQuery();
            if (rs.next()) {
                name = rs.getString(1);
                this.m_Description = rs.getString(2);
                className = rs.getString(3);
                this.m_Help = rs.getString(4);
            }
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        catch (SQLException e) {
            log.log(Level.SEVERE, sql, e);
        }
        finally {
            DB.close(rs, pstmt);
            rs = null;
            pstmt = null;
        }
        if (className == null) {
            return false;
        }
        return this.openForm(AD_Form_ID, className, name);
    }

    protected boolean openForm(int AD_Form_ID, String className, String name) {
        log.info("AD_Form_ID=" + AD_Form_ID + " - Class=" + className);
        Properties ctx = Env.getCtx();
        Env.setContext(ctx, this.m_WindowNo, "WindowName", name);
        this.setTitle(Env.getHeader(ctx, this.m_WindowNo));
        try {
            this.m_panel = (FormPanel)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Class=" + className + ", AD_Form_ID=" + AD_Form_ID, e);
            return false;
        }
        this.m_panel.init(this.m_WindowNo, this);
        this.p_AD_Form_ID = AD_Form_ID;
        return true;
    }

    public FormPanel getFormPanel() {
        return this.m_panel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("End")) {
            this.dispose();
        } else if (cmd.equals("Help")) {
            this.actionHelp();
        } else if (!AEnv.actionPerformed(cmd, this.m_WindowNo, this.m_MainContent)) {
            log.log(Level.SEVERE, "Not handeled=" + cmd);
        }
    }

    private void actionHelp() {
        StringBuffer sb = new StringBuffer();
        if (this.m_Description != null && this.m_Description.length() > 0) {
            sb.append("<h2>").append(this.m_Description).append("</h2>");
        }
        if (this.m_Help != null && this.m_Help.length() > 0) {
            sb.append("<p>").append(this.m_Help);
        }
        Help hlp = new Help((Frame)Env.getFrame(this.m_MainContent), this.getTitle(), sb.toString());
        hlp.setVisible(true);
    }

    public void setBusy(boolean busy) {
        if (busy == this.m_glassPane.isVisible()) {
            return;
        }
        log.info("Busy=" + busy);
        if (busy) {
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
        }
        this.m_glassPane.setMessage(null);
        this.m_glassPane.setVisible(busy);
        this.m_glassPane.requestFocus();
    }

    public void setBusyMessage(String AD_Message) {
        this.m_glassPane.setMessage(AD_Message);
    }

    public void setBusyTimer(int time) {
        this.m_glassPane.setBusyTimer(time);
    }

    public void setMaximize(boolean max) {
        this.m_maximize = max;
    }

    private void formWindowOpened(WindowEvent evt) {
        if (this.m_maximize) {
            ((CFrame)this.m_MainContent).setVisible(true);
            ((CFrame)this.m_MainContent).setExtendedState(6);
        }
    }

    public void setProcessInfo(ProcessInfo pi) {
        this.m_pi = pi;
    }

    public ProcessInfo getProcessInfo() {
        return this.m_pi;
    }

    public Thread startBatch(final Runnable process) {
        Thread worker = new Thread(){

            @Override
            public void run() {
                FormFrame.this.setBusy(true);
                process.run();
                FormFrame.this.setBusy(false);
            }
        };
        worker.start();
        return worker;
    }

    public int getAD_Form_ID() {
        return this.p_AD_Form_ID;
    }

    public JMenuBar getMenu() {
        return this.menuBar;
    }

    public void setTitle(String p_Title) {
        if (this.m_MainContent instanceof CFrame) {
            ((CFrame)this.m_MainContent).setTitle(p_Title);
        } else {
            ((CDialog)this.m_MainContent).setTitle(p_Title);
        }
    }

    public String getTitle() {
        if (this.m_MainContent instanceof CFrame) {
            return ((CFrame)this.m_MainContent).getTitle();
        }
        return ((CDialog)this.m_MainContent).getTitle();
    }

    public boolean isDialog() {
        return !(this.m_MainContent instanceof CFrame);
    }

    public void toFront() {
        this.getWindow().toFront();
    }

    public Container getContainer() {
        return this.m_MainContent;
    }

    public Window getWindow() {
        return (Window)this.m_MainContent;
    }

    public CFrame getCFrame() {
        if (!this.isDialog()) {
            CFrame frame = (CFrame)this.m_MainContent;
            frame.setAD_Form_ID(this.p_AD_Form_ID);
            return frame;
        }
        return null;
    }

    public CDialog getCDialog() {
        if (this.isDialog()) {
            return (CDialog)this.m_MainContent;
        }
        return null;
    }

    public void pack() {
        this.getWindow().pack();
    }

    public Container getContentPane() {
        return this.getContainer();
    }

    public void setIconImage(Image p_Image) {
        if (!this.isDialog()) {
            ((CFrame)this.m_MainContent).setIconImage(p_Image);
        } else {
            ((CDialog)this.m_MainContent).setIconImage(p_Image);
        }
    }

    public void setDefaultCloseOperation(int p_CloseOperetion) {
        if (!this.isDialog()) {
            ((CFrame)this.m_MainContent).setDefaultCloseOperation(p_CloseOperetion);
        } else {
            ((CDialog)this.m_MainContent).setDefaultCloseOperation(p_CloseOperetion);
        }
    }

    public void setJMenuBar(JMenuBar p_MenuBar) {
        if (!this.isDialog()) {
            ((CFrame)this.m_MainContent).setJMenuBar(p_MenuBar);
        } else {
            ((CDialog)this.m_MainContent).setJMenuBar(p_MenuBar);
        }
    }

    public void setCursor(Cursor cursor) {
        this.getWindow().setCursor(cursor);
    }

    public void setSize(Dimension size) {
        this.getWindow().setSize(size);
    }

    public Dimension getPreferredSize() {
        return this.getWindow().getPreferredSize();
    }

    public GraphicsConfiguration getGraphicsConfiguration() {
        return this.getWindow().getGraphicsConfiguration();
    }

    public void setSize(int width, int height) {
        this.getWindow().setSize(width, height);
    }

    public void addWindowListener(WindowAdapter adapter) {
        this.getWindow().addWindowListener(adapter);
    }

    public void setVisible(boolean visible) {
        this.getWindow().setVisible(visible);
    }
}

