/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPopupMenu;
import javax.swing.table.DefaultTableModel;
import org.adempiere.controller.RecordInfoController;
import org.compiere.Adempiere;
import org.compiere.apps.AEnv;
import org.compiere.apps.ConfirmPanel;
import org.compiere.grid.VTable;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.GridField;
import org.compiere.swing.CDialog;
import org.compiere.swing.CMenuItem;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.swing.CTextArea;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class RecordInfo
extends RecordInfoController {
    public static final String CHANGE_LOG_COMMAND = "ChangeLog";
    private static Icon s_icon = new ImageIcon(Adempiere.class.getResource("images/ChangeLog16.png"));
    private CDialog m_Dialog = null;
    private CPanel mainPanel = new CPanel(new BorderLayout(0, 0));
    private CScrollPane scrollPane = new CScrollPane();
    private VTable table = new VTable();
    private ConfirmPanel confirmPanel = new ConfirmPanel(false);
    protected CLogger log = CLogger.getCLogger(this.getClass());

    private RecordInfo(Frame owner, String title, DataStatusEvent dse, GridField mField) {
        super(title, dse, mField);
        this.m_Dialog = new CDialog(owner, title, true){
            private static final long serialVersionUID = -1667930305647519065L;

            @Override
            public void actionPerformed(ActionEvent e) {
                super.actionPerformed(e);
                RecordInfo.this.m_Dialog.dispose();
            }
        };
        try {
            this.dynInit();
            this.jbInit();
        }
        catch (Exception e) {
            this.log.log(Level.SEVERE, "", e);
        }
        AEnv.positionCenterWindow(owner, this.m_Dialog);
    }

    public RecordInfo(Frame owner, String title, DataStatusEvent dse) {
        this(owner, title, dse, null);
    }

    public RecordInfo(Frame owner, GridField mField) {
        this(owner, Msg.getElement(Env.getCtx(), "AD_ChangeLog_ID"), null, mField);
    }

    private void jbInit() throws Exception {
        this.m_Dialog.getContentPane().add(this.mainPanel);
        CTextArea info = new CTextArea(this.getInfo());
        info.setReadWrite(false);
        info.setOpaque(false);
        info.setForeground(Color.blue);
        info.setBorder(null);
        if (this.isOk()) {
            this.mainPanel.add((Component)info, "North");
            this.mainPanel.add((Component)this.scrollPane, "Center");
            this.scrollPane.getViewport().add(this.table);
            this.scrollPane.setPreferredSize(new Dimension(500, 100));
        } else {
            info.setPreferredSize(new Dimension(400, 75));
            this.mainPanel.add((Component)info, "Center");
        }
        this.mainPanel.add((Component)this.confirmPanel, "South");
        this.confirmPanel.addActionListener(this.m_Dialog);
    }

    protected void dynInit() {
        DefaultTableModel model = new DefaultTableModel(this.getData(), this.getColumnNames());
        this.table.setModel(model);
        this.table.autoSize(false);
    }

    public CDialog getDialog() {
        return this.m_Dialog;
    }

    public static CMenuItem addMenu(ActionListener l, JPopupMenu popupMenu) {
        CMenuItem mi = new CMenuItem(Msg.getElement(Env.getCtx(), "AD_ChangeLog_ID"), s_icon);
        mi.setActionCommand(CHANGE_LOG_COMMAND);
        mi.addActionListener(l);
        popupMenu.add(mi);
        return mi;
    }

    public static void start(GridField mField) {
        int WindowNo = mField.getWindowNo();
        JFrame frame = Env.getWindow(WindowNo);
        RecordInfo info = new RecordInfo(frame, mField);
        AEnv.showCenterScreen(info.getDialog());
    }
}

