/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import org.compiere.apps.AppsAction;
import org.compiere.apps.search.Find;
import org.compiere.grid.GridController;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.MQuery;
import org.compiere.model.MUserQuery;
import org.compiere.print.ReportEngine;
import org.compiere.print.Viewer;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class ASearch
implements ActionListener {
    private GridField[] m_findFields;
    private JPopupMenu m_popup = new JPopupMenu("SearchMenu");
    private ArrayList<KeyNamePair> m_list = new ArrayList();
    private int m_onlycurrentdays;
    private AppsAction m_appsaction;
    private JComponent m_invoker;
    private Frame m_owner;
    private int m_targetWindowNo;
    private GridTab m_gt;
    private GridController m_gc;
    private int m_AD_Tab_ID;
    private int m_AD_Table_ID;
    private String m_tableName;
    private String m_title;
    private String m_where;
    private MQuery m_query;
    private Viewer m_viewer;
    private ReportEngine m_reportEngine;

    public ASearch(AppsAction appsAction, Frame owner, int targetWindowNo, GridController gc, GridTab gridTab, int m_onlyCurrentDays) {
        this.m_onlycurrentdays = m_onlyCurrentDays;
        this.m_appsaction = appsAction;
        this.m_invoker = appsAction.getButton();
        this.m_owner = owner;
        this.m_viewer = null;
        this.m_targetWindowNo = targetWindowNo;
        this.m_AD_Tab_ID = gridTab.getAD_Tab_ID();
        this.m_AD_Table_ID = gridTab.getAD_Table_ID();
        this.m_tableName = gridTab.getTableName();
        this.m_title = gridTab.getName();
        this.m_where = gridTab.getWhereExtended();
        this.m_gt = gridTab;
        this.m_gc = gc;
        this.m_findFields = GridField.createFields(Env.getCtx(), this.m_targetWindowNo, 0, this.m_gt.getAD_Tab_ID());
        this.getSearchTargets();
    }

    public ASearch(JComponent invoker, Viewer viewer, String title, int AD_Tab_ID, int AD_Table_ID, String tableName, ReportEngine reportEngine, GridField[] findFields, int m_onlyCurrentDays) {
        this.m_onlycurrentdays = m_onlyCurrentDays;
        this.m_owner = viewer;
        this.m_viewer = viewer;
        this.m_targetWindowNo = reportEngine.getWindowNo();
        this.m_AD_Tab_ID = AD_Tab_ID;
        this.m_AD_Table_ID = AD_Table_ID;
        this.m_tableName = tableName;
        this.m_where = reportEngine.getWhereExtended();
        this.m_gt = null;
        this.m_gc = null;
        this.m_findFields = findFields;
        this.m_invoker = invoker;
        this.m_reportEngine = reportEngine;
        this.getSearchTargets();
    }

    private void getSearchTargets() {
        MUserQuery[] search = MUserQuery.get(Env.getCtx(), this.m_AD_Tab_ID);
        KeyNamePair pp = null;
        if (search.length == 0) {
            this.find();
            return;
        }
        pp = new KeyNamePair(0, Msg.getMsg(Env.getCtx(), "Search"));
        this.m_list.add(pp);
        this.m_popup.add(pp.toString()).addActionListener(this);
        for (MUserQuery query : search) {
            pp = new KeyNamePair(query.getAD_UserQuery_ID(), query.getName());
            this.m_list.add(pp);
            this.m_popup.add(pp.toString()).addActionListener(this);
        }
        if (this.m_invoker.isShowing() && this.m_list.size() > 1) {
            this.m_popup.show(this.m_invoker, 0, this.m_invoker.getHeight());
        } else {
            this.launchSearch(pp);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.m_popup.setCursor(Cursor.getPredefinedCursor(3));
        String cmd = e.getActionCommand();
        for (int i = 0; i < this.m_list.size(); ++i) {
            KeyNamePair pp = this.m_list.get(i);
            if (!cmd.equals(pp.getName())) continue;
            this.launchSearch(pp);
            return;
        }
    }

    private void launchSearch(KeyNamePair pp) {
        if (pp.getName().equals(Msg.getMsg(Env.getCtx(), "Search"))) {
            this.find();
        } else {
            this.filter(pp.getKey());
        }
    }

    private void find() {
        GridField[] findFields = GridField.createFields(Env.getCtx(), this.m_targetWindowNo, 0, this.m_AD_Tab_ID);
        Find find = new Find(Env.getFrame(this.m_owner), this.m_targetWindowNo, this.m_title, this.m_AD_Tab_ID, this.m_AD_Table_ID, this.m_tableName, this.m_where, findFields, 1);
        this.m_query = find.getQuery();
        find.dispose();
        find = null;
        if (this.m_gt != null && this.m_gc != null) {
            if (this.m_query != null) {
                this.m_gt.setQuery(this.m_query);
                this.m_gc.query(false, this.m_onlycurrentdays, 0);
            }
            this.m_appsaction.setPressed(this.m_gt.isQueryActive());
        }
        if (this.m_reportEngine != null) {
            this.m_reportEngine.setQuery(this.m_query);
            this.m_viewer.revalidate();
        }
    }

    private void filter(int AD_UserQuery_ID) {
        MUserQuery userQuery = null;
        if (AD_UserQuery_ID > 0) {
            userQuery = new MUserQuery(Env.getCtx(), AD_UserQuery_ID, null);
            this.m_query = userQuery.getQuery(this.m_AD_Table_ID, this.m_targetWindowNo, this.m_findFields);
            if (this.m_gt != null && this.m_gc != null) {
                if (this.m_query != null) {
                    this.m_gt.setQuery(this.m_query);
                    this.m_gc.query(false, this.m_onlycurrentdays, 0);
                }
                this.m_appsaction.setPressed(this.m_gt.isQueryActive());
            }
            if (this.m_reportEngine != null && this.m_viewer != null) {
                this.m_reportEngine.setQuery(this.m_query);
                this.m_viewer.revalidate();
            }
        }
    }

    public MQuery getQuery() {
        return this.m_query;
    }
}

