/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.logging.Level;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.compiere.acct.AcctViewer;
import org.compiere.apps.AArchive;
import org.compiere.apps.AChat;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.AExport;
import org.compiere.apps.AMenu;
import org.compiere.apps.AProcessAction;
import org.compiere.apps.ARequest;
import org.compiere.apps.ASearch;
import org.compiere.apps.AWindow;
import org.compiere.apps.AZoomAcross;
import org.compiere.apps.AppsAction;
import org.compiere.apps.Attachment;
import org.compiere.apps.DeleteSelection;
import org.compiere.apps.Help;
import org.compiere.apps.ProcessCtl;
import org.compiere.apps.ProcessModalDialog;
import org.compiere.apps.StatusBar;
import org.compiere.apps.WindowMenu;
import org.compiere.apps.form.FormFrame;
import org.compiere.apps.search.Find;
import org.compiere.grid.APanelTab;
import org.compiere.grid.GridController;
import org.compiere.grid.GridSynchronizer;
import org.compiere.grid.ICreateFrom;
import org.compiere.grid.RecordAccessDialog;
import org.compiere.grid.VCreateFromFactory;
import org.compiere.grid.VOnlyCurrentDays;
import org.compiere.grid.VPayment;
import org.compiere.grid.VSortTab;
import org.compiere.grid.VTabbedPane;
import org.compiere.grid.VTable;
import org.compiere.grid.ed.VButton;
import org.compiere.grid.ed.VDocAction;
import org.compiere.model.DataStatusEvent;
import org.compiere.model.DataStatusListener;
import org.compiere.model.GridField;
import org.compiere.model.GridTab;
import org.compiere.model.GridTable;
import org.compiere.model.GridWindow;
import org.compiere.model.GridWindowVO;
import org.compiere.model.GridWorkbench;
import org.compiere.model.MProcess;
import org.compiere.model.MQuery;
import org.compiere.model.MRecentItem;
import org.compiere.model.MRole;
import org.compiere.model.MUser;
import org.compiere.model.MWindow;
import org.compiere.plaf.CompiereColor;
import org.compiere.print.AReport;
import org.compiere.process.ProcessInfo;
import org.compiere.process.ProcessInfoUtil;
import org.compiere.swing.CPanel;
import org.compiere.util.ASyncProcess;
import org.compiere.util.CLogMgt;
import org.compiere.util.CLogger;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Language;
import org.compiere.util.Msg;
import org.compiere.util.Util;
import org.eevolution.form.VBrowser;
import org.spin.util.ASPUtil;
import org.spin.util.ColorUtil;

public final class APanel
extends CPanel
implements DataStatusListener,
ChangeListener,
ActionListener,
ASyncProcess {
    private static final long serialVersionUID = 6066778919781303581L;
    private boolean isNested = false;
    private static CLogger log = CLogger.getCLogger(APanel.class);
    private AWindow m_window;
    private boolean isCancel = false;
    private GridWindow mainWindow;
    private BorderLayout mainLayout = new BorderLayout();
    private VTabbedPane tabPanel = new VTabbedPane(true);
    private StatusBar statusBar = new StatusBar();
    private CPanel northPanel = new CPanel();
    private JToolBar toolBar = new JToolBar();
    private JMenuBar menuBar = new JMenuBar();
    private FlowLayout northLayout = new FlowLayout();
    private AppsAction aPrevious;
    private AppsAction aNext;
    private AppsAction aParent;
    private AppsAction aDetail;
    private AppsAction aFirst;
    private AppsAction aLast;
    private AppsAction aNew;
    private AppsAction aCopy;
    private AppsAction aDelete;
    private AppsAction aPrint;
    private AppsAction aPrintPreview;
    private AppsAction aExport = null;
    private AppsAction aRefresh;
    private AppsAction aHistory;
    private AppsAction aAttachment;
    private AppsAction aChat;
    private AppsAction aMulti;
    private AppsAction aFind;
    private AppsAction aWorkflow;
    private AppsAction aZoomAcross;
    private AppsAction aRequest;
    private AppsAction aProcess;
    private AppsAction aWinSize;
    private AppsAction aArchive;
    public AppsAction aIgnore;
    public AppsAction aSave;
    public AppsAction aLock;
    private AppsAction aReport;
    private AppsAction aEnd;
    private AppsAction aHome;
    private AppsAction aHelp;
    private AppsAction aProduct;
    private AppsAction aLogout;
    private AppsAction aAccount;
    private AppsAction aCalculator;
    private AppsAction aCalendar;
    private AppsAction aEditor;
    private AppsAction aPreference;
    private AppsAction aScript;
    private AppsAction aOnline;
    private AppsAction aMailSupport;
    private AppsAction aAbout;
    private AppsAction aPrintScr;
    private AppsAction aScrShot;
    private AppsAction aExit;
    private AppsAction aBPartner;
    private AppsAction aDeleteSelection;
    private AppsAction aShowAllWindow;
    private SwitchAction aSwitchLinesDownAction;
    private SwitchAction aSwitchLinesUpAction;
    private WindowMenu m_WindowMenu;
    private Properties ctx;
    private GridWorkbench m_mWorkbench;
    private GridTab currentTab;
    private GridController m_curGC;
    private JTabbedPane m_curWinTab = null;
    private int m_curWindowNo;
    private int currentTabIndex = -1;
    private APanelTab currentAPanelTab = null;
    private boolean m_disposing = false;
    private boolean m_errorDisplayed = false;
    private boolean m_onlyCurrentRows = true;
    private int m_onlyCurrentDays = 0;
    private boolean m_isLocked = false;
    private boolean m_isPersonalLock = MRole.getDefault().isPersonalLock();
    private int m_lastModifiers;
    private String loadError = null;
    private HashMap<Integer, GridController> includedMap;

    public APanel(GridController gc, int windowNo) {
        this.isNested = true;
        this.ctx = Env.getCtx();
        try {
            this.m_curGC = gc;
            gc.addDataStatusListener(this);
            this.currentTab = gc.getMTab();
            GridController tabElement = null;
            tabElement = gc;
            VTabbedPane tabPane = new VTabbedPane(false);
            tabPane.addTab(this.currentTab.getName().toString(), this.currentTab, (Component)tabElement);
            this.m_curWinTab = tabPane;
            this.m_curWindowNo = windowNo;
            this.jbInit();
            this.initSwitchLineAction();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
        this.createMenu();
        MRole role = MRole.getDefault();
        this.m_curGC.query(this.m_onlyCurrentRows, this.m_onlyCurrentDays, role.getMaxQueryRecords());
        this.currentTab.navigateCurrent();
        this.m_curGC.dynamicDisplay(0);
    }

    public APanel(AWindow window) {
        this.m_window = window;
        this.ctx = Env.getCtx();
        try {
            this.jbInit();
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "", e);
        }
        this.createMenu();
    }

    public void dispose() {
        this.m_disposing = true;
        if (this.currentAPanelTab != null) {
            this.currentAPanelTab.unregisterPanel();
            this.currentAPanelTab = null;
        }
        this.tabPanel.dispose(this);
        this.tabPanel = null;
        for (int i = 0; i < this.m_mWorkbench.getWindowCount(); ++i) {
            this.m_curWindowNo = this.m_mWorkbench.getWindowNo(i);
            log.info("#" + this.m_curWindowNo);
            Env.setAutoCommit(this.ctx, this.m_curWindowNo, false);
            this.m_mWorkbench.dispose(i);
            Env.clearWinContext(this.ctx, this.m_curWindowNo);
        }
        if (this.m_mWorkbench != null) {
            this.m_mWorkbench.dispose();
        }
        this.m_mWorkbench = null;
        if (this.menuBar != null) {
            this.menuBar.removeAll();
        }
        this.menuBar = null;
        if (this.toolBar != null) {
            this.toolBar.removeAll();
        }
        this.toolBar = null;
        this.removeAll();
    }

    private void jbInit() throws Exception {
        this.setLocale(Language.getLoginLanguage().getLocale());
        this.setLayout(this.mainLayout);
        this.mainLayout.setHgap(2);
        this.mainLayout.setVgap(2);
        if (this.isNested) {
            this.add((Component)this.m_curGC, "Center");
        } else {
            CPanel dummy = new CPanel();
            dummy.setLayout(new BorderLayout());
            dummy.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 2));
            dummy.add((Component)this.tabPanel, "Center");
            this.add((Component)dummy, "Center");
        }
        this.add((Component)this.statusBar, "South");
        this.add((Component)this.northPanel, "North");
        this.northPanel.setLayout(this.northLayout);
        this.northLayout.setAlignment(0);
        this.toolBar.putClientProperty("JToolBar.isRollover", Boolean.TRUE);
        this.toolBar.setBorderPainted(false);
        this.toolBar.setFloatable(false);
        this.northPanel.add((Component)this.toolBar, null);
    }

    private void createMenu() {
        JMenu mFile = AEnv.getMenu("File");
        this.menuBar.add(mFile);
        this.aPrintScr = this.addAction("PrintScreen", mFile, KeyStroke.getKeyStroke(154, 0), false);
        this.aScrShot = this.addAction("ScreenShot", mFile, KeyStroke.getKeyStroke(154, 1), false);
        this.aReport = this.addAction("Report", mFile, KeyStroke.getKeyStroke(122, 0), false);
        this.aPrint = this.addAction("Print", mFile, KeyStroke.getKeyStroke(123, 0), false);
        this.aPrintPreview = this.addAction("PrintPreview", mFile, KeyStroke.getKeyStroke(80, 9), false);
        if (MRole.getDefault().isCanExport()) {
            this.aExport = this.addAction("Export", mFile, null, false);
        }
        mFile.addSeparator();
        this.aEnd = this.addAction("End", mFile, KeyStroke.getKeyStroke(88, 8), false);
        this.aLogout = this.addAction("Logout", mFile, KeyStroke.getKeyStroke(76, 9), false);
        this.aExit = this.addAction("Exit", mFile, KeyStroke.getKeyStroke(88, 9), false);
        JMenu mEdit = AEnv.getMenu("Edit");
        this.menuBar.add(mEdit);
        this.aNew = this.addAction("New", mEdit, KeyStroke.getKeyStroke(113, 0), false);
        this.aSave = this.addAction("Save", mEdit, KeyStroke.getKeyStroke(115, 0), false);
        mEdit.addSeparator();
        this.aCopy = this.addAction("Copy", mEdit, KeyStroke.getKeyStroke(113, 1), false);
        this.aDelete = this.addAction("Delete", mEdit, KeyStroke.getKeyStroke(114, 0), false);
        this.aDeleteSelection = this.addAction("DeleteSelection", mEdit, KeyStroke.getKeyStroke(68, 2), false);
        this.aIgnore = this.addAction("Ignore", mEdit, KeyStroke.getKeyStroke(27, 0), false);
        this.aRefresh = this.addAction("Refresh", mEdit, KeyStroke.getKeyStroke(116, 0), false);
        mEdit.addSeparator();
        this.aFind = this.addAction("Find", mEdit, KeyStroke.getKeyStroke(117, 0), true);
        if (this.m_isPersonalLock) {
            this.aLock = this.addAction("Lock", mEdit, null, true);
        }
        JMenu mView = AEnv.getMenu("View");
        this.menuBar.add(mView);
        if (MRole.getDefault().isAllow_Info_Product()) {
            this.aProduct = this.addAction("InfoProduct", mView, KeyStroke.getKeyStroke(73, 8), false);
        }
        if (MRole.getDefault().isAllow_Info_BPartner()) {
            this.aBPartner = this.addAction("InfoBPartner", mView, KeyStroke.getKeyStroke(73, 9), false);
        }
        if (MRole.getDefault().isShowAcct() && MRole.getDefault().isAllow_Info_Account()) {
            this.aAccount = this.addAction("InfoAccount", mView, KeyStroke.getKeyStroke(73, 10), false);
        }
        if (MRole.getDefault().isAllow_Info_Schedule()) {
            AEnv.addMenuItem("InfoSchedule", null, null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_MRP()) {
            AEnv.addMenuItem("InfoMRP", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_CRP()) {
            AEnv.addMenuItem("InfoCRP", "Info", null, mView, this);
        }
        mView.addSeparator();
        if (MRole.getDefault().isAllow_Info_Order()) {
            AEnv.addMenuItem("InfoOrder", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_Invoice()) {
            AEnv.addMenuItem("InfoInvoice", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_InOut()) {
            AEnv.addMenuItem("InfoInOut", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_Payment()) {
            AEnv.addMenuItem("InfoPayment", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_CashJournal()) {
            AEnv.addMenuItem("InfoCashLine", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_Resource()) {
            AEnv.addMenuItem("InfoAssignment", "Info", null, mView, this);
        }
        if (MRole.getDefault().isAllow_Info_Asset()) {
            AEnv.addMenuItem("InfoAsset", "Info", null, mView, this);
        }
        mView.addSeparator();
        this.aAttachment = this.addAction("Attachment", mView, KeyStroke.getKeyStroke(118, 0), true);
        this.aChat = this.addAction("Chat", mView, null, true);
        this.aHistory = this.addAction("History", mView, KeyStroke.getKeyStroke(120, 0), true);
        mView.addSeparator();
        this.aMulti = this.addAction("Multi", mView, KeyStroke.getKeyStroke(119, 0), true);
        JMenu mGo = AEnv.getMenu("Go");
        this.menuBar.add(mGo);
        this.aFirst = this.addAction("First", mGo, KeyStroke.getKeyStroke(33, 8), false);
        this.aPrevious = this.addAction("Previous", mGo, KeyStroke.getKeyStroke(38, 8), false);
        this.aNext = this.addAction("Next", mGo, KeyStroke.getKeyStroke(40, 8), false);
        this.aLast = this.addAction("Last", mGo, KeyStroke.getKeyStroke(34, 8), false);
        mGo.addSeparator();
        this.aParent = this.addAction("Parent", mGo, KeyStroke.getKeyStroke(37, 8), false);
        this.aDetail = this.addAction("Detail", mGo, KeyStroke.getKeyStroke(39, 8), false);
        mGo.addSeparator();
        this.aZoomAcross = this.addAction("ZoomAcross", mGo, null, false);
        this.aRequest = this.addAction("Request", mGo, null, false);
        this.aProcess = AProcessAction.createAppsAction(this);
        this.aArchive = this.addAction("Archive", mGo, null, false);
        this.aHome = this.addAction("Home", mGo, null, false);
        JMenu mTools = AEnv.getMenu("Tools");
        this.menuBar.add(mTools);
        this.aCalculator = this.addAction("Calculator", mTools, null, false);
        this.aCalendar = this.addAction("Calendar", mTools, null, false);
        this.aEditor = this.addAction("Editor", mTools, null, false);
        MUser user = MUser.get(Env.getCtx());
        if (user.isAdministrator()) {
            this.aScript = this.addAction("Script", mTools, null, false);
        }
        if ("Y".equals(Env.getContext(this.ctx, "#SysAdmin"))) {
            this.aWinSize = this.addAction("WinSize", mTools, null, false);
        }
        if (AEnv.isWorkflowProcess()) {
            this.aWorkflow = this.addAction("WorkFlow", mTools, null, false);
        }
        if (MRole.getDefault().isShowPreference()) {
            mTools.addSeparator();
            this.aPreference = this.addAction("Preference", mTools, null, false);
        }
        AMenu aMenu = (AMenu)Env.getWindow(0);
        this.m_WindowMenu = new WindowMenu(aMenu.getWindowManager(), this.m_window);
        this.menuBar.add(this.m_WindowMenu);
        this.aShowAllWindow = this.addAction("ShowAllWindow", null, KeyStroke.getKeyStroke(87, 2), false);
        JMenu mHelp = AEnv.getMenu("Help");
        this.menuBar.add(mHelp);
        this.aHelp = this.addAction("Help", mHelp, KeyStroke.getKeyStroke(112, 0), false);
        this.aOnline = this.addAction("Online", mHelp, null, false);
        this.aMailSupport = this.addAction("EMailSupport", mHelp, null, false);
        this.aAbout = this.addAction("About", mHelp, null, false);
        this.toolBar.add(this.aIgnore.getButton());
        this.toolBar.addSeparator();
        this.toolBar.add(this.aHelp.getButton());
        this.toolBar.add(this.aNew.getButton());
        this.toolBar.add(this.aCopy.getButton());
        this.toolBar.add(this.aDelete.getButton());
        this.toolBar.add(this.aDeleteSelection.getButton());
        this.toolBar.add(this.aSave.getButton());
        this.toolBar.addSeparator();
        this.toolBar.add(this.aRefresh.getButton());
        this.toolBar.add(this.aFind.getButton());
        this.toolBar.add(this.aAttachment.getButton());
        this.toolBar.add(this.aChat.getButton());
        this.toolBar.add(this.aMulti.getButton());
        this.toolBar.addSeparator();
        if (this.m_curGC == null || this.m_curGC != null && !this.m_curGC.isDetailGrid()) {
            this.toolBar.add(this.aHistory.getButton());
            this.toolBar.add(this.aHome.getButton());
            this.toolBar.add(this.aParent.getButton());
            this.toolBar.add(this.aDetail.getButton());
            this.toolBar.addSeparator();
        }
        this.toolBar.add(this.aFirst.getButton());
        this.toolBar.add(this.aPrevious.getButton());
        this.toolBar.add(this.aNext.getButton());
        this.toolBar.add(this.aLast.getButton());
        this.toolBar.addSeparator();
        this.toolBar.add(this.aReport.getButton());
        this.toolBar.add(this.aArchive.getButton());
        this.toolBar.add(this.aPrintPreview.getButton());
        this.toolBar.add(this.aPrint.getButton());
        if (this.m_curGC == null || this.m_curGC != null && !this.m_curGC.isDetailGrid()) {
            this.toolBar.addSeparator();
            if (this.m_isPersonalLock) {
                this.toolBar.add(this.aLock.getButton());
            }
            this.toolBar.add(this.aZoomAcross.getButton());
            if (this.aWorkflow != null) {
                this.toolBar.add(this.aWorkflow.getButton());
            }
            this.toolBar.add(this.aRequest.getButton());
            this.toolBar.add(this.aProcess.getButton());
            if (MRole.getDefault().isAllow_Info_Product()) {
                this.toolBar.add(this.aProduct.getButton());
            }
            this.toolBar.addSeparator();
            this.toolBar.add(this.aEnd.getButton());
        }
        if (CLogMgt.isLevelAll()) {
            Util.printActionInputMap(this);
        }
    }

    private AppsAction addAction(String actionName, JMenu menu, KeyStroke accelerator, boolean toggle) {
        AppsAction action = new AppsAction(actionName, accelerator, toggle);
        if (menu != null) {
            menu.add(action.getMenuItem());
        }
        action.setDelegate(this);
        if (accelerator != null) {
            this.getInputMap(2).put(accelerator, actionName);
            this.getActionMap().put(actionName, action);
        }
        return action;
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    public String getTitle() {
        if (this.m_mWorkbench != null && this.m_mWorkbench.getWindowCount() > 1) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.m_mWorkbench.getName()).append("  ").append(Env.getContext(this.ctx, "#AD_User_Name")).append(" (").append(Env.getContext(this.ctx, "#AD_Role_Name")).append(") @ ").append(Env.getContext(this.ctx, "#AD_Client_Name")).append(".").append(Env.getContext(this.ctx, "#AD_Org_Name")).append(" [").append(Env.getContext(this.ctx, "#DB_UID")).append("]");
            return sb.toString();
        }
        return Env.getHeader(this.ctx, this.m_curWindowNo);
    }

    public boolean initPanel(int AD_Workbench_ID, int AD_Window_ID, MQuery query) {
        log.info("WB=" + AD_Workbench_ID + ", Win=" + AD_Window_ID + ", Query=" + query);
        this.setName("APanel" + AD_Window_ID);
        if (AD_Workbench_ID != 0) {
            log.warning("Workbench Not implemented yet [" + this + "]");
            this.loadError = "Workbench Not implemented yet";
            return false;
        }
        this.m_mWorkbench = new GridWorkbench(this.ctx, AD_Window_ID);
        Dimension windowSize = this.m_mWorkbench.getWindowSize();
        MQuery detailQuery = null;
        for (int wb = 0; wb < this.m_mWorkbench.getWindowCount(); ++wb) {
            this.m_curWindowNo = Env.createWindowNo(this);
            this.m_mWorkbench.setWindowNo(wb, this.m_curWindowNo);
            Env.setAutoCommit(this.ctx, this.m_curWindowNo, Env.isAutoCommit(this.ctx));
            boolean autoNew = Env.isAutoNew(this.ctx);
            Env.setAutoNew(this.ctx, this.m_curWindowNo, autoNew);
            VTabbedPane window = null;
            if (this.m_mWorkbench.getWindowCount() == 1) {
                window = this.tabPanel;
                window.setWorkbench(false);
            } else {
                VTabbedPane tp;
                window = tp = new VTabbedPane(false);
            }
            window.addChangeListener(this);
            this.m_curWinTab = window;
            int wbType = this.m_mWorkbench.getWindowType(wb);
            if (wbType == 1) {
                this.includedMap = new HashMap(4);
                GridWindowVO wVO = AEnv.getMWindowVO(this.m_curWindowNo, this.m_mWorkbench.getWindowID(wb), 0);
                if (wVO == null) {
                    log.warning("AccessTableNoView for [" + this + "]");
                    this.loadError = "AccessTableNoView";
                    return false;
                }
                this.mainWindow = new GridWindow(wVO, true);
                Env.setContext(this.ctx, this.m_curWindowNo, "IsSOTrx", this.mainWindow.isSOTrx());
                if (!autoNew && this.mainWindow.isTransaction()) {
                    Env.setAutoNew(this.ctx, this.m_curWindowNo, true);
                }
                this.m_mWorkbench.setMWindow(wb, this.mainWindow);
                if (wb == 0) {
                    this.m_onlyCurrentRows = this.mainWindow.isTransaction();
                }
                if (windowSize == null) {
                    windowSize = this.mainWindow.getWindowSize();
                }
                int tabSize = this.mainWindow.getTabCount();
                boolean goSingleRow = query != null;
                for (int tab = 0; tab < tabSize; ++tab) {
                    int pos;
                    boolean included = false;
                    if (tab == 0) {
                        this.mainWindow.initTab(0);
                    }
                    GridTab gTab = this.mainWindow.getTab(tab);
                    Env.setContext(this.ctx, this.m_curWindowNo, tab, "_TabInfo_TabLevel", Integer.toString(gTab.getTabLevel()));
                    if (tab == 0) {
                        if (this.m_mWorkbench.getWindowCount() == 1) {
                            if (query != null && query.getZoomTableName() != null && query.getZoomColumnName() != null && query.getZoomValue() instanceof Integer && (Integer)query.getZoomValue() > 0 && !query.getZoomTableName().equalsIgnoreCase(gTab.getTableName())) {
                                detailQuery = query;
                                query = new MQuery();
                                query.addRestriction("1=2");
                            }
                            this.isCancel = false;
                            query = this.initialQuery(query, gTab);
                            if (this.isCancel) {
                                return false;
                            }
                            if (query != null && query.getRecordCount() <= 1) {
                                goSingleRow = true;
                            }
                        } else if (wb != 0) {
                            query = this.m_mWorkbench.getQuery();
                        }
                        if (query != null) {
                            this.m_onlyCurrentRows = false;
                            gTab.setQuery(query);
                        }
                        if (wb == 0) {
                            this.currentTab = gTab;
                        }
                    }
                    CPanel tabElement = null;
                    if (gTab.isSortTab()) {
                        VSortTab st = new VSortTab(this.m_curWindowNo, gTab.getAD_Table_ID(), gTab.getAD_ColumnSortOrder_ID(), gTab.getAD_ColumnSortYesNo_ID(), gTab.getParent_Column_ID());
                        st.setTabLevel(gTab.getTabLevel());
                        tabElement = st;
                    } else {
                        GridController parent;
                        GridController gc = new GridController();
                        CompiereColor cc = ColorUtil.getColor(this.ctx, this.mainWindow.getColorId());
                        if (cc != null) {
                            gc.setBackgroundColor(cc);
                        }
                        gc.initGrid(gTab, false, this.m_curWindowNo, this, this.mainWindow, tab != 0);
                        gc.addDataStatusListener(this);
                        gc.registerESCAction(this.aIgnore);
                        if (wb == 0 && tab == 0) {
                            this.m_curGC = gc;
                            Dimension size = gc.getPreferredSize();
                            size.width += 4;
                            size.height += 4;
                            gc.setPreferredSize(size);
                        }
                        tabElement = gc;
                        if (tab == 0 && goSingleRow) {
                            gc.switchSingleRow();
                        }
                        GridField[] fields = gc.getMTab().getFields();
                        int m_tab_id = 0;
                        for (int f = 0; f < fields.length; ++f) {
                            m_tab_id = fields[f].getIncluded_Tab_ID();
                            if (m_tab_id == 0) continue;
                            this.includedMap.put(m_tab_id, gc);
                        }
                        if (this.includedMap.size() > 0 && (parent = this.includedMap.get(gTab.getAD_Tab_ID())) != null) {
                            gc.removeDataStatusListener(this);
                            GridSynchronizer synchronizer = new GridSynchronizer(this.mainWindow, parent, gc);
                            if (parent == this.m_curGC) {
                                synchronizer.activateChild();
                            }
                            included = parent.includeTab(gc, this, synchronizer);
                        }
                        this.initSwitchLineAction();
                    }
                    if (included) continue;
                    StringBuffer tabName = new StringBuffer();
                    tabName.append("<html>");
                    if (gTab.isReadOnly()) {
                        tabName.append("<i>");
                    }
                    if ((pos = gTab.getName().indexOf(" ")) == -1) {
                        tabName.append(gTab.getName()).append("<br>&nbsp;");
                    } else {
                        tabName.append(gTab.getName().substring(0, pos)).append("<br>").append(gTab.getName().substring(pos + 1));
                    }
                    if (gTab.isReadOnly()) {
                        tabName.append("</i>");
                    }
                    tabName.append("</html>");
                    window.addTab(tabName.toString(), gTab, (Component)tabElement);
                }
            }
            if (this.m_mWorkbench.getWindowCount() == 1) {
                window.setToolTipText(this.m_mWorkbench.getDescription(wb));
            } else {
                this.tabPanel.addTab(this.m_mWorkbench.getName(wb), this.m_mWorkbench.getIcon(wb), window, this.m_mWorkbench.getDescription(wb));
            }
            Env.setContext(this.ctx, this.m_curWindowNo, "WindowName", this.m_mWorkbench.getName(wb));
        }
        this.toolBar.setName(this.getTitle());
        this.currentTab.getTableModel().setChanged(false);
        this.aDetail.setEnabled(0 != this.m_curWinTab.getTabCount() - 1);
        if (this.m_curWinTab instanceof VTabbedPane) {
            ((VTabbedPane)this.m_curWinTab).evaluate(null);
        }
        if (windowSize != null) {
            this.setPreferredSize(windowSize);
        } else {
            this.revalidate();
        }
        if (detailQuery != null && this.zoomToDetailTab(detailQuery)) {
            return true;
        }
        Dimension size = this.getPreferredSize();
        log.info("fini - " + size);
        this.m_curWinTab.requestFocusInWindow();
        return true;
    }

    public String getLoadError() {
        return this.loadError;
    }

    private boolean zoomToDetailTab(MQuery query) {
        if (query != null && query.getZoomTableName() != null && query.getZoomColumnName() != null) {
            GridTab gTab = this.m_mWorkbench.getMWindow(0).getTab(0);
            if (!query.getZoomTableName().equalsIgnoreCase(gTab.getTableName())) {
                int tabSize = this.m_mWorkbench.getMWindow(0).getTabCount();
                for (int tab = 0; tab < tabSize; ++tab) {
                    gTab = this.m_mWorkbench.getMWindow(0).getTab(tab);
                    if (gTab.isSortTab() || !gTab.getTableName().equalsIgnoreCase(query.getZoomTableName()) || !this.doZoomToDetail(gTab, query, tab)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean doZoomToDetail(GridTab gTab, MQuery query, int tabIndex) {
        GridField[] fields;
        for (GridField field : fields = gTab.getFields()) {
            void var15_15;
            if (!field.getColumnName().equalsIgnoreCase(query.getZoomColumnName())) continue;
            this.m_mWorkbench.getMWindow(0).initTab(tabIndex);
            int parentId = DB.getSQLValue(null, "SELECT " + gTab.getLinkColumnName() + " FROM " + gTab.getTableName() + " WHERE " + query.getWhereClause());
            if (parentId <= 0) continue;
            TreeMap<Integer, Object[]> parentMap = new TreeMap<Integer, Object[]>();
            int index = tabIndex;
            int oldpid = parentId;
            Object currentTab = gTab;
            while (index > 0) {
                GridTab pTab = this.m_mWorkbench.getMWindow(0).getTab(--index);
                if (pTab.getTabLevel() >= ((GridTab)currentTab).getTabLevel()) continue;
                this.m_mWorkbench.getMWindow(0).initTab(index);
                if (index > 0) {
                    if (pTab.getLinkColumnName() == null || pTab.getLinkColumnName().trim().length() <= 0) continue;
                    int n = DB.getSQLValue(null, "SELECT " + pTab.getLinkColumnName() + " FROM " + pTab.getTableName() + " WHERE " + ((GridTab)currentTab).getLinkColumnName() + " = ?", oldpid);
                    if (n > 0) {
                        parentMap.put(index, new Object[]{((GridTab)currentTab).getLinkColumnName(), oldpid});
                        oldpid = n;
                        currentTab = pTab;
                        continue;
                    }
                    parentMap.clear();
                    break;
                }
                parentMap.put(index, new Object[]{((GridTab)currentTab).getLinkColumnName(), oldpid});
            }
            for (Map.Entry entry : parentMap.entrySet()) {
                GridTab pTab = this.m_mWorkbench.getMWindow(0).getTab((Integer)entry.getKey());
                Object[] value = (Object[])entry.getValue();
                MQuery pquery = new MQuery(pTab.getAD_Table_ID());
                pquery.addRestriction((String)value[0], "=", value[1]);
                pTab.setQuery(pquery);
                GridController gc = (GridController)this.tabPanel.getComponentAt((Integer)entry.getKey());
                gc.activate();
                gc.query(false, 0, 0);
            }
            MQuery targetQuery = new MQuery(gTab.getAD_Table_ID());
            targetQuery.addRestriction(gTab.getLinkColumnName(), "=", parentId);
            gTab.setQuery(targetQuery);
            Object var15_18 = null;
            if (!this.includedMap.containsKey(gTab.getAD_Tab_ID())) {
                int target = this.tabPanel.findTabindex(gTab);
                GridController gridController = (GridController)this.tabPanel.getComponentAt(target);
            } else {
                GridController parent = this.includedMap.get(gTab.getAD_Tab_ID());
                GridController gridController = parent.findChild(gTab);
            }
            var15_15.activate();
            var15_15.query(false, 0, 0);
            GridTable table = gTab.getTableModel();
            int count = table.getRowCount();
            for (int i = 0; i < count; ++i) {
                int id = table.getKeyID(i);
                if (id != (Integer)query.getZoomValue()) continue;
                if (!this.includedMap.containsKey(gTab.getAD_Tab_ID())) {
                    this.tabPanel.setSelectedIndex(this.tabPanel.findTabindex(gTab));
                } else {
                    GridController parent = this.includedMap.get(gTab.getAD_Tab_ID());
                    int pindex = this.tabPanel.findTabindex(parent.getMTab());
                    if (pindex >= 0) {
                        this.tabPanel.setSelectedIndex(pindex);
                    }
                }
                gTab.navigate(i);
                return true;
            }
        }
        return false;
    }

    public int getWindowNo() {
        return this.m_curWindowNo;
    }

    private MQuery initialQuery(MQuery query, GridTab mTab) {
        MRole role = MRole.getDefault(this.ctx, false);
        if (query != null && query.isActive() && !role.isQueryMax(query.getRecordCount())) {
            return query;
        }
        StringBuffer where = new StringBuffer(Env.parseContext(this.ctx, this.m_curWindowNo, mTab.getWhereExtended(), false));
        boolean require = mTab.isHighVolume();
        if (!require && !this.m_onlyCurrentRows) {
            String wh2;
            if (query != null && (wh2 = query.getWhereClause()).length() > 0) {
                if (where.length() > 0) {
                    where.append(" AND ");
                }
                where.append(wh2);
            }
            StringBuffer sql = new StringBuffer("SELECT COUNT(*) FROM ").append(mTab.getTableName());
            if (where.length() > 0) {
                sql.append(" WHERE ").append(where);
            }
            int no = DB.getSQLValue(null, sql.toString());
            require = MRole.getDefault().isQueryRequire(no);
        }
        if (require) {
            GridField[] findFields = mTab.getFields();
            Find find = new Find(Env.getFrame(this), this.m_curWindowNo, mTab.getName(), mTab.getAD_Tab_ID(), mTab.getAD_Table_ID(), mTab.getTableName(), where.toString(), findFields, 10);
            query = find.getQuery();
            this.isCancel = query == null;
            find.dispose();
            find = null;
        }
        return query;
    }

    private int getWindowIndex() {
        if (this.m_mWorkbench.getWindowCount() == 1) {
            return 0;
        }
        return this.tabPanel.getSelectedIndex();
    }

    private boolean isFirstTab() {
        return this.m_curWinTab.getSelectedIndex() == 0;
    }

    public Image getImage() {
        return this.m_mWorkbench.getImage(this.getWindowIndex());
    }

    @Override
    public void dataStatusChanged(DataStatusEvent e) {
        boolean canHaveAttachment;
        String trxInfo;
        boolean readOnly;
        boolean insertRecord;
        if (this.m_disposing) {
            return;
        }
        log.info(e.getMessage());
        Object dbInfo = e.getMessage();
        if (this.currentTab != null && this.currentTab.isQueryActive()) {
            dbInfo = "[ " + (String)dbInfo + " ]";
        }
        this.statusBar.setStatusDB((String)dbInfo, e);
        if (!this.isNested) {
            this.m_window.setTitle(this.getTitle());
        }
        if (e.getAD_Message() != null || e.getInfo() != null) {
            String info;
            StringBuffer sb = new StringBuffer();
            String msg = e.getMessage();
            if (msg != null && msg.length() > 0) {
                sb.append(Msg.getMsg(this.ctx, e.getAD_Message()));
            }
            if ((info = e.getInfo()) != null && info.length() > 0) {
                if (sb.length() > 0 && !sb.toString().trim().endsWith(":")) {
                    sb.append(": ");
                }
                sb.append(info);
            }
            if (sb.length() > 0) {
                int pos = sb.indexOf("\n");
                if (pos != -1) {
                    sb.replace(pos, pos + 1, " - ");
                }
                this.setStatusLine(sb.toString(), e.isError());
            }
        }
        if (e.isError() && !e.isConfirmed()) {
            ADialog.error(this.m_curWindowNo, this, e.getAD_Message(), e.getInfo());
            e.setConfirmed(true);
            this.m_errorDisplayed = true;
        } else if (e.isWarning() && !e.isConfirmed()) {
            ADialog.warn(this.m_curWindowNo, this, e.getAD_Message(), e.getInfo());
            e.setConfirmed(true);
        }
        boolean firstRow = e.isFirstRow();
        this.aFirst.setEnabled(!firstRow);
        this.aPrevious.setEnabled(!firstRow);
        boolean lastRow = e.isLastRow();
        this.aNext.setEnabled(!lastRow);
        this.aLast.setEnabled(!lastRow);
        boolean changed = e.isChanged() || e.isInserting();
        int changedColumn = e.getChangedColumn();
        boolean inserting = e.isInserting();
        if (e.getAD_Message() != null && e.getAD_Message().equals("Saved")) {
            changed = false;
        }
        boolean bl = insertRecord = !(readOnly = this.currentTab.isReadOnly());
        if (insertRecord) {
            insertRecord = this.currentTab.isInsertRecord();
        }
        this.aNew.setEnabled((inserting && changedColumn > 0 || !inserting) && insertRecord);
        this.aCopy.setEnabled(!changed && insertRecord);
        this.aRefresh.setEnabled(!changed);
        this.aDelete.setEnabled(!changed && !readOnly);
        this.aDeleteSelection.setEnabled(!changed && !readOnly);
        if (readOnly && this.currentTab.isAlwaysUpdateField()) {
            readOnly = false;
        }
        this.aIgnore.setEnabled(changed && !readOnly);
        if (changed && !readOnly && !this.aSave.isEnabled()) {
            this.addToRecentItems();
        }
        this.aSave.setEnabled(changed && !readOnly);
        if (e.getTotalRows() == 0 && insertRecord) {
            this.aNew.setEnabled(true);
            this.aDelete.setEnabled(false);
            this.aDeleteSelection.setEnabled(false);
        }
        this.aMulti.setPressed(!this.m_curGC.isSingleRow());
        if (this.isFirstTab()) {
            this.aHistory.setPressed(!this.currentTab.isOnlyCurrentRows());
        }
        if ((trxInfo = this.currentTab.getTrxInfo()) != null) {
            this.statusBar.setInfo(trxInfo);
        }
        if (this.m_curWinTab.getSelectedComponent() instanceof GridController) {
            GridController gridController = (GridController)this.m_curWinTab.getSelectedComponent();
            gridController.reloadFieldTrxInfo();
        }
        if ((canHaveAttachment = this.currentTab.canHaveAttachment()) && e.isLoading() && this.currentTab.getCurrentRow() > e.getLoadedRows()) {
            canHaveAttachment = false;
        }
        if (canHaveAttachment && this.currentTab.getRecord_ID() == -1) {
            canHaveAttachment = false;
        }
        if (canHaveAttachment) {
            this.aAttachment.setEnabled(true);
            this.aAttachment.setPressed(this.currentTab.hasAttachment());
            this.aChat.setEnabled(true);
            this.aChat.setPressed(this.currentTab.hasChat());
        } else {
            this.aAttachment.setEnabled(false);
            this.aChat.setEnabled(false);
        }
        if (this.m_isPersonalLock) {
            this.aLock.setPressed(this.currentTab.isLocked());
        }
        if (this.m_curWinTab instanceof VTabbedPane) {
            ((VTabbedPane)this.m_curWinTab).evaluate(e);
        }
    }

    private void addToRecentItems() {
        if (this.currentTab.getRecord_ID() > 0) {
            GridTab mainTab;
            if (this.currentTabIndex == 0) {
                MRecentItem.addWindowChange(this.ctx, this.currentTab.getAD_Table_ID(), this.currentTab.getRecord_ID(), this.currentTab.getAD_Window_ID(), this.currentTab.getAD_Tab_ID());
            } else if (this.mainWindow != null && (mainTab = this.mainWindow.getTab(0)) != null) {
                MRecentItem.addWindowChange(this.ctx, mainTab.getAD_Table_ID(), mainTab.getRecord_ID(), mainTab.getAD_Window_ID(), mainTab.getAD_Tab_ID());
            }
        }
    }

    public void setStatusLine(String text, boolean error) {
        log.fine(text);
        this.statusBar.setStatusLine(text, error);
    }

    private void setBusy(boolean busy, boolean focus) {
        this.m_isLocked = busy;
        JFrame frame = Env.getFrame(this);
        if (frame == null) {
            return;
        }
        if (frame instanceof AWindow) {
            ((AWindow)frame).setBusy(busy);
        }
        if (busy) {
            this.setCursor(Cursor.getPredefinedCursor(3));
            frame.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(Cursor.getDefaultCursor());
            frame.setCursor(Cursor.getDefaultCursor());
            if (focus) {
                this.m_curGC.requestFocus();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void stateChanged(ChangeEvent e) {
        boolean isAPanelTab;
        boolean back;
        block31: {
            GridController gc;
            int tpIndex;
            block29: {
                block32: {
                    VTabbedPane tp;
                    block30: {
                        Component cp;
                        if (this.m_curWinTab != null && (cp = this.m_window.getFocusOwner()) != null) {
                            this.m_window.dispatchEvent(new FocusEvent(cp, 1005));
                        }
                        if (this.m_disposing) {
                            return;
                        }
                        log.info(e.toString());
                        this.setBusy(true, true);
                        tp = (VTabbedPane)e.getSource();
                        back = false;
                        isAPanelTab = false;
                        if (!tp.isWorkbench()) break block30;
                        int WBIndex = this.tabPanel.getSelectedIndex();
                        this.m_curWindowNo = this.m_mWorkbench.getWindowNo(WBIndex);
                        log.info("curWin=" + this.m_curWindowNo + " - Win=" + tp);
                        if (!(tp.getSelectedComponent() instanceof JTabbedPane)) {
                            throw new IllegalArgumentException("Window does not contain Tabs");
                        }
                        this.m_curWinTab = (JTabbedPane)tp.getSelectedComponent();
                        if (!(this.m_curWinTab.getSelectedComponent() instanceof GridController)) {
                            throw new IllegalArgumentException("Window-Tab does not contain GridControler");
                        }
                        this.m_curGC = (GridController)this.m_curWinTab.getSelectedComponent();
                        this.initSwitchLineAction();
                        this.currentTabIndex = this.m_curWinTab.getSelectedIndex();
                        break block31;
                    }
                    log.info("Tab=" + tp);
                    this.m_curWinTab = tp;
                    tpIndex = this.m_curWinTab.getSelectedIndex();
                    if (tpIndex == this.currentTabIndex) {
                        return;
                    }
                    back = tpIndex < this.currentTabIndex;
                    gc = null;
                    if (this.m_curWinTab.getSelectedComponent() instanceof GridController) {
                        gc = (GridController)this.m_curWinTab.getSelectedComponent();
                    } else {
                        if (!(this.m_curWinTab.getSelectedComponent() instanceof APanelTab)) {
                            throw new IllegalArgumentException("Tab does not contain GridControler");
                        }
                        isAPanelTab = true;
                    }
                    if (this.m_curGC == null) break block29;
                    this.m_curGC.stopEditor(true);
                    if (!this.currentTab.needSave(true, false)) break block29;
                    if (!this.currentTab.needSave(true, true)) break block32;
                    if (Env.isAutoCommit(this.ctx, this.m_curWindowNo)) {
                        if (!this.currentTab.dataSave(true)) {
                            this.showLastError();
                            this.m_curWinTab.setSelectedIndex(this.currentTabIndex);
                            this.setBusy(false, true);
                            return;
                        }
                        break block29;
                    } else if (ADialog.ask(this.m_curWindowNo, this, "SaveChanges?", this.currentTab.getCommitWarning())) {
                        if (!this.currentTab.dataSave(true)) {
                            this.showLastError();
                            this.m_curWinTab.setSelectedIndex(this.currentTabIndex);
                            this.setBusy(false, true);
                            return;
                        }
                        break block29;
                    } else {
                        int newRecord = this.currentTab.getTableModel().getNewRow();
                        if (newRecord != -1) {
                            this.m_curWinTab.setSelectedIndex(this.currentTabIndex);
                            this.setBusy(false, true);
                            return;
                        }
                        this.currentTab.dataIgnore();
                    }
                    break block29;
                }
                this.currentTab.dataIgnore();
            }
            if (this.currentAPanelTab != null) {
                this.currentAPanelTab.saveData();
                this.currentAPanelTab.unregisterPanel();
                this.currentAPanelTab = null;
            }
            this.currentTabIndex = tpIndex;
            if (!isAPanelTab) {
                this.m_curGC = gc;
                this.initSwitchLineAction();
            }
        }
        if (isAPanelTab) {
            this.currentAPanelTab = (APanelTab)((Object)this.m_curWinTab.getSelectedComponent());
            this.currentAPanelTab.registerAPanel(this);
            this.currentAPanelTab.loadData();
            this.aFirst.setEnabled(false);
            this.aPrevious.setEnabled(false);
            this.aNext.setEnabled(false);
            this.aLast.setEnabled(false);
        } else {
            int gwTabIndex = this.m_mWorkbench.getMWindow(0).getTabIndex(this.m_curGC.getMTab());
            if (!this.m_mWorkbench.getMWindow(0).isTabInitialized(gwTabIndex)) {
                this.m_mWorkbench.getMWindow(0).initTab(gwTabIndex);
            }
            this.m_curGC.activate();
            this.currentTab = this.m_curGC.getMTab();
            if (back && this.currentTab.isCurrent()) {
                this.currentTab.dataRefresh();
            } else {
                MRole role = MRole.getDefault();
                this.m_curGC.query(this.m_onlyCurrentRows, this.m_onlyCurrentDays, role.getMaxQueryRecords());
            }
            if (this.currentTab.getRowCount() == 0) {
                if (!this.currentTab.isReadOnly() && (Env.isAutoNew(this.ctx, this.m_curWindowNo) || this.currentTab.isQueryNewRecord())) {
                    log.config("No record - New - AutoNew=" + Env.isAutoNew(this.ctx, this.m_curWindowNo) + " - QueryNew=" + this.currentTab.isQueryNewRecord());
                    this.currentTab.dataNew(false);
                } else {
                    this.aSave.setEnabled(false);
                    this.aDelete.setEnabled(false);
                    this.aDeleteSelection.setEnabled(false);
                }
                this.currentTab.navigateCurrent();
                this.m_curGC.dynamicDisplay(0);
            }
        }
        this.aDetail.setEnabled(this.currentTabIndex != this.m_curWinTab.getTabCount() - 1);
        this.aParent.setEnabled(this.currentTabIndex != 0 && this.m_curWinTab.getTabCount() > 1);
        if (this.m_mWorkbench.getMWindow(this.getWindowIndex()).isTransaction()) {
            this.aHistory.setEnabled(this.isFirstTab());
        } else {
            this.aHistory.setPressed(false);
            this.aHistory.setEnabled(false);
        }
        this.aPrint.setEnabled(this.currentTab.isPrinted());
        this.aPrintPreview.setEnabled(this.currentTab.isPrinted());
        this.aFind.setPressed(this.currentTab.isQueryActive());
        if (isAPanelTab) {
            this.aMulti.setPressed(false);
            this.aMulti.setEnabled(false);
            this.aNew.setEnabled(false);
            this.aCopy.setEnabled(false);
            this.aReport.setEnabled(false);
            this.aPrint.setEnabled(false);
            this.aPrintPreview.setEnabled(false);
            this.aArchive.setEnabled(false);
            this.aWorkflow.setEnabled(false);
            this.aRequest.setEnabled(false);
            this.aProcess.setEnabled(false);
            this.aProduct.setEnabled(false);
            this.aZoomAcross.setEnabled(false);
            this.aDelete.setEnabled(false);
            this.aDeleteSelection.setEnabled(false);
            this.aFind.setEnabled(false);
            this.aRefresh.setEnabled(false);
            this.aAttachment.setEnabled(false);
            this.aChat.setEnabled(false);
            this.aHistory.setEnabled(false);
        } else {
            this.aMulti.setEnabled(true);
            this.aMulti.setPressed(!this.m_curGC.isSingleRow());
            this.aFind.setEnabled(true);
            this.aRefresh.setEnabled(true);
            this.aAttachment.setEnabled(true);
            this.aChat.setEnabled(true);
            this.aReport.setEnabled(true);
            this.aArchive.setEnabled(true);
            this.aWorkflow.setEnabled(true);
            this.aRequest.setEnabled(true);
            this.aProcess.setEnabled(true);
            this.aProduct.setEnabled(true);
            this.aZoomAcross.setEnabled(true);
        }
        this.m_curWinTab.requestFocusInWindow();
        this.setBusy(false, true);
        log.config("fini");
    }

    private void cmd_detail() {
        int index = this.m_curWinTab.getSelectedIndex();
        if (index == this.m_curWinTab.getTabCount() - 1) {
            return;
        }
        if (this.m_curWinTab instanceof VTabbedPane) {
            VTabbedPane tabPane = (VTabbedPane)this.m_curWinTab;
            ++index;
            while (index < tabPane.getTabCount()) {
                if (tabPane.isEnabledAt(index)) {
                    this.m_curGC.getTable().removeEditor();
                    this.m_curGC.acceptEditorChanges();
                    tabPane.setSelectedIndex(index);
                    break;
                }
                ++index;
            }
        } else {
            this.m_curGC.getTable().removeEditor();
            this.m_curGC.acceptEditorChanges();
            this.m_curWinTab.setSelectedIndex(index + 1);
        }
    }

    private void cmd_parent() {
        int index = this.m_curWinTab.getSelectedIndex();
        if (index == 0) {
            return;
        }
        if (this.m_curWinTab instanceof VTabbedPane) {
            VTabbedPane tabPane = (VTabbedPane)this.m_curWinTab;
            --index;
            while (index >= 0) {
                if (tabPane.isEnabledAt(index)) {
                    this.m_curGC.getTable().removeEditor();
                    this.m_curGC.acceptEditorChanges();
                    tabPane.setSelectedIndex(index);
                    break;
                }
                --index;
            }
        } else {
            this.m_curGC.getTable().removeEditor();
            this.m_curGC.acceptEditorChanges();
            this.m_curWinTab.setSelectedIndex(index - 1);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        log.info(e.getActionCommand() + " - " + e.getModifiers());
        if (this.m_disposing || this.isUILocked()) {
            return;
        }
        this.m_lastModifiers = e.getModifiers();
        String cmd = e.getActionCommand();
        if (cmd.equals("ScreenShot")) {
            AEnv.actionPerformed(e.getActionCommand(), this.m_curWindowNo, this);
            return;
        }
        if (!cmd.equals(this.aShowAllWindow.getName())) {
            this.setBusy(true, true);
        }
        if (e.getSource() instanceof VButton) {
            this.setStatusLine(this.processButtonCallout((VButton)e.getSource()), true);
            this.actionButton((VButton)e.getSource());
            this.setBusy(false, true);
            return;
        }
        try {
            if (cmd.equals(this.aReport.getName())) {
                this.cmd_report();
            } else if (cmd.equals(this.aPrint.getName())) {
                this.cmd_print();
            } else if (cmd.equals(this.aPrintPreview.getName())) {
                this.cmd_print(true);
            } else if (this.aExport != null && cmd.equals(this.aExport.getName())) {
                this.cmd_export();
            } else if (cmd.equals(this.aEnd.getName())) {
                this.cmd_end(false);
            } else if (cmd.equals(this.aExit.getName())) {
                this.cmd_end(true);
            } else if (cmd.equals(this.aNew.getName())) {
                this.cmd_new(false);
            } else if (cmd.equals(this.aSave.getName())) {
                this.cmd_save(true);
            } else if (cmd.equals(this.aCopy.getName())) {
                this.cmd_new(true);
            } else if (cmd.equals(this.aDelete.getName())) {
                this.cmd_delete();
            } else if (cmd.equals(this.aDeleteSelection.getName())) {
                this.cmd_deleteSelection();
            } else if (cmd.equals(this.aIgnore.getName())) {
                this.cmd_ignore();
            } else if (cmd.equals(this.aRefresh.getName())) {
                this.cmd_refresh();
            } else if (cmd.equals(this.aFind.getName())) {
                this.cmd_find();
            } else if (this.m_isPersonalLock && cmd.equals(this.aLock.getName())) {
                this.cmd_lock();
            } else if (cmd.equals(this.aAttachment.getName())) {
                this.cmd_attachment();
            } else if (cmd.equals(this.aChat.getName())) {
                this.cmd_chat();
            } else if (cmd.equals(this.aHistory.getName())) {
                this.cmd_history();
            } else if (cmd.equals(this.aMulti.getName())) {
                this.m_curGC.switchRowPresentation();
            } else {
                if (cmd.equals(this.aHome.getName())) {
                    this.setBusy(false, false);
                    AEnv.showWindow(Env.getWindow(0));
                    return;
                }
                if (cmd.equals(this.aFirst.getName())) {
                    this.m_curGC.getTable().removeEditor();
                    this.m_curGC.acceptEditorChanges();
                    this.currentTab.navigate(0);
                } else if (cmd.equals(this.aSwitchLinesUpAction.getName())) {
                    this.m_curGC.getTable().removeEditor();
                    this.currentTab.switchRows(this.currentTab.getCurrentRow(), this.currentTab.getCurrentRow() - 1, this.m_curGC.getTable().getSortColumn(), this.m_curGC.getTable().isSortAscending());
                    this.m_curGC.getTable().requestFocus();
                } else if (cmd.equals(this.aPrevious.getName())) {
                    this.m_curGC.getTable().removeEditor();
                    this.m_curGC.acceptEditorChanges();
                    if ((e.getModifiers() & 1) != 0) {
                        this.currentTab.switchRows(this.currentTab.getCurrentRow(), this.currentTab.getCurrentRow() - 1, this.m_curGC.getTable().getSortColumn(), this.m_curGC.getTable().isSortAscending());
                    } else {
                        this.currentTab.navigateRelative(-1);
                    }
                } else if (cmd.equals(this.aSwitchLinesDownAction.getName())) {
                    this.m_curGC.getTable().removeEditor();
                    this.currentTab.switchRows(this.currentTab.getCurrentRow(), this.currentTab.getCurrentRow() + 1, this.m_curGC.getTable().getSortColumn(), this.m_curGC.getTable().isSortAscending());
                    this.m_curGC.getTable().requestFocus();
                } else if (cmd.equals(this.aNext.getName())) {
                    this.m_curGC.getTable().removeEditor();
                    this.m_curGC.acceptEditorChanges();
                    if ((e.getModifiers() & 1) != 0) {
                        this.currentTab.switchRows(this.currentTab.getCurrentRow(), this.currentTab.getCurrentRow() + 1, this.m_curGC.getTable().getSortColumn(), this.m_curGC.getTable().isSortAscending());
                    } else {
                        this.currentTab.navigateRelative(1);
                    }
                } else if (cmd.equals(this.aLast.getName())) {
                    this.m_curGC.getTable().removeEditor();
                    this.m_curGC.acceptEditorChanges();
                    this.currentTab.navigate(this.currentTab.getRowCount() - 1);
                } else if (cmd.equals(this.aParent.getName())) {
                    this.cmd_parent();
                } else if (cmd.equals(this.aDetail.getName())) {
                    this.cmd_detail();
                } else if (cmd.equals(this.aZoomAcross.getName())) {
                    this.cmd_zoomAcross();
                } else if (cmd.equals(this.aRequest.getName())) {
                    this.cmd_request();
                } else if (cmd.equals(this.aArchive.getName())) {
                    this.cmd_archive();
                } else if (this.aWorkflow != null && cmd.equals(this.aWorkflow.getName())) {
                    if (this.currentTab.getRecord_ID() > 0) {
                        if (this.currentTab.getTabNo() == 0 && this.m_mWorkbench.getMWindow(this.getWindowIndex()).isTransaction()) {
                            AEnv.startWorkflowProcess(this.currentTab.getAD_Table_ID(), this.currentTab.getRecord_ID());
                        } else {
                            AEnv.startWorkflowProcess(this.currentTab.getAD_Table_ID(), this.currentTab.getRecord_ID());
                        }
                    }
                } else if (this.aWinSize != null && cmd.equals(this.aWinSize.getName())) {
                    this.cmd_winSize();
                } else if (cmd.equals(this.aHelp.getName())) {
                    this.cmd_help();
                } else if (cmd.equals(this.aLogout.getName())) {
                    this.cmd_logout();
                } else if (cmd.equals(this.aShowAllWindow.getName())) {
                    this.m_WindowMenu.expose();
                } else if (!AEnv.actionPerformed(e.getActionCommand(), this.m_curWindowNo, this)) {
                    log.log(Level.SEVERE, "No action for: " + cmd);
                }
            }
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, cmd, ex);
            String msg = ex.getMessage();
            if (msg == null || msg.length() == 0) {
                msg = ex.toString();
            }
            msg = Msg.parseTranslation(this.ctx, msg);
            ADialog.error(this.m_curWindowNo, this, "Error", msg);
        }
        this.m_curWinTab.requestFocusInWindow();
        this.setBusy(false, true);
    }

    private void cmd_logout() {
        JFrame top = Env.getWindow(0);
        if (top instanceof AMenu) {
            ((AMenu)top).logout();
        }
    }

    private String processButtonCallout(VButton button) {
        GridField field = this.currentTab.getField(button.getColumnName());
        return this.currentTab.processCallout(field);
    }

    private void cmd_new(boolean copy) {
        log.config("copy=" + copy);
        if (!this.currentTab.isInsertRecord()) {
            log.warning("Insert Record disabled for Tab");
            return;
        }
        this.m_curGC.stopEditor(true);
        this.m_curGC.acceptEditorChanges();
        if (this.aSave.isEnabled()) {
            if (Env.isAutoCommit(this.ctx, this.m_curWindowNo)) {
                if (!this.cmd_save(true)) {
                    return;
                }
            } else if (ADialog.ask(this.m_curWindowNo, this, "SaveChanges?", this.currentTab.getCommitWarning())) {
                if (!this.cmd_save(true)) {
                    return;
                }
            } else {
                this.currentTab.dataIgnore();
            }
        }
        if (copy && this.currentTab.getCurrentRow() < 0) {
            copy = false;
        }
        this.currentTab.dataNew(copy);
        this.m_curGC.dynamicDisplay(0);
    }

    private void cmd_delete() {
        if (this.currentTab.isReadOnly()) {
            return;
        }
        VTable table = this.m_curGC.getTable();
        int[] selection = table.getSelectedRows();
        Arrays.sort(selection);
        if (selection.length <= 1) {
            int keyID = this.currentTab.getRecord_ID();
            if (ADialog.ask(this.m_curWindowNo, this, "DeleteRecord?") && this.currentTab.dataDelete()) {
                this.m_curGC.rowChanged(false, keyID);
                this.m_curGC.dynamicDisplay(0);
            }
        } else {
            ArrayList<Integer> selectionIndex = new ArrayList<Integer>();
            for (int i = 0; i < selection.length; ++i) {
                int index = table.convertRowIndexToModel(selection[i]);
                selectionIndex.add(index);
            }
            this.cmd_deleteSelection(selectionIndex);
        }
    }

    private void cmd_deleteSelection() {
        this.cmd_deleteSelection(null);
    }

    private void cmd_deleteSelection(List<Integer> selectionIndex) {
        if (this.currentTab.isReadOnly()) {
            return;
        }
        DeleteSelection dSelection = new DeleteSelection(this.m_window, this.currentTab, selectionIndex);
        dSelection.showDialog();
        if (dSelection.isOkPressed()) {
            log.fine("ok");
            int[] indices = dSelection.getSelection();
            int offset = 0;
            for (int i = 0; i < indices.length; ++i) {
                this.currentTab.navigate(indices[i] - offset);
                int keyID = this.currentTab.getRecord_ID();
                if (!this.currentTab.dataDelete()) continue;
                this.m_curGC.rowChanged(false, keyID);
                ++offset;
            }
            this.m_curGC.dynamicDisplay(0);
        } else {
            log.fine("cancel");
        }
    }

    public boolean cmd_save(boolean manualCmd) {
        if (this.currentAPanelTab != null) {
            manualCmd = false;
        }
        log.config("Manual=" + manualCmd);
        this.m_errorDisplayed = false;
        this.m_curGC.stopEditor(true);
        this.m_curGC.acceptEditorChanges();
        boolean wasChanged = this.aSave.isEnabled();
        if (this.currentAPanelTab != null) {
            this.currentAPanelTab.saveData();
            this.aSave.setEnabled(false);
        }
        if (this.currentTab.getCommitWarning().length() > 0 && this.currentTab.needSave(true, false) && !ADialog.ask(this.m_curWindowNo, this, "SaveChanges?", this.currentTab.getCommitWarning())) {
            return false;
        }
        boolean retValue = this.currentTab.dataSave(manualCmd);
        if (manualCmd && !retValue && !this.m_errorDisplayed) {
            this.showLastError();
        }
        if (retValue) {
            this.m_curGC.rowChanged(true, this.currentTab.getRecord_ID());
        }
        if (manualCmd) {
            this.m_curGC.dynamicDisplay(0);
            if (!this.isNested) {
                this.m_window.setTitle(this.getTitle());
            }
        }
        if (this.m_curGC.isDetailGrid() && retValue) {
            this.m_curGC.getGCParent().refreshMTab(this.m_curGC);
        }
        if (wasChanged) {
            this.addToRecentItems();
        }
        return retValue;
    }

    private void showLastError() {
        String msg = CLogger.retrieveErrorString(null);
        if (msg != null) {
            ADialog.error(this.m_curWindowNo, this, null, msg);
        } else {
            ADialog.error(this.m_curWindowNo, this, "SaveIgnored");
        }
        this.setStatusLine(Msg.getMsg(this.ctx, "SaveIgnored"), true);
    }

    private void cmd_ignore() {
        this.m_curGC.stopEditor(false);
        if (this.currentAPanelTab != null) {
            this.currentAPanelTab.loadData();
        }
        this.currentTab.dataIgnore();
        this.m_curGC.dynamicDisplay(0);
    }

    private void cmd_refresh() {
        this.cmd_save(false);
        this.currentTab.dataRefreshAll();
        this.m_curGC.dynamicDisplay(0);
    }

    private void cmd_report() {
        log.info("");
        if (!MRole.getDefault().isCanReport(this.currentTab.getAD_Table_ID())) {
            ADialog.error(this.m_curWindowNo, this, "AccessCannotReport");
            return;
        }
        this.cmd_save(false);
        MQuery query = new MQuery(this.currentTab.getTableName());
        String queryColumn = this.currentTab.getLinkColumnName();
        if (queryColumn.length() == 0) {
            queryColumn = this.currentTab.getKeyColumnName();
        }
        String infoName = null;
        String infoDisplay = null;
        for (int i = 0; i < this.currentTab.getFieldCount(); ++i) {
            GridField field = this.currentTab.getField(i);
            if (field.isKey()) {
                infoName = field.getHeader();
            }
            if ((field.getColumnName().equals("Name") || field.getColumnName().equals("DocumentNo")) && field.getValue() != null) {
                infoDisplay = field.getValue().toString();
            }
            if (infoName != null && infoDisplay != null) break;
        }
        if (queryColumn.length() != 0) {
            if (queryColumn.endsWith("_ID")) {
                query.addRestriction(queryColumn, "=", Env.getContextAsInt(this.ctx, this.m_curWindowNo, queryColumn), infoName, infoDisplay);
            } else {
                query.addRestriction(queryColumn, "=", Env.getContext(this.ctx, this.m_curWindowNo, queryColumn), infoName, infoDisplay);
            }
        }
        new AReport(this.currentTab.getAD_Table_ID(), this.aReport.getButton(), query, this, this.m_curWindowNo, this.currentTab.getWhereExtended());
    }

    private void cmd_zoomAcross() {
        int record_ID = this.currentTab.getRecord_ID();
        log.info("ID=" + record_ID);
        if (record_ID <= 0) {
            return;
        }
        MQuery query = new MQuery();
        String link = this.currentTab.getKeyColumnName();
        if (link.length() == 0) {
            link = this.currentTab.getLinkColumnName();
        }
        if (link.length() != 0) {
            if (link.endsWith("_ID")) {
                query.addRestriction(link, "=", (Object)Env.getContextAsInt(this.ctx, this.m_curWindowNo, link));
            } else {
                query.addRestriction(link, "=", Env.getContext(this.ctx, this.m_curWindowNo, link));
            }
        }
        new AZoomAcross(this.aZoomAcross.getButton(), this.currentTab.getTableName(), this.currentTab.getAD_Window_ID(), query);
    }

    private void cmd_request() {
        int record_ID = this.currentTab.getRecord_ID();
        log.info("ID=" + record_ID);
        if (record_ID <= 0) {
            return;
        }
        int AD_Table_ID = this.currentTab.getAD_Table_ID();
        int C_BPartner_ID = 0;
        Object BPartner_ID = this.currentTab.getValue("C_BPartner_ID");
        if (BPartner_ID != null) {
            C_BPartner_ID = (Integer)BPartner_ID;
        }
        new ARequest(this.aRequest.getButton(), AD_Table_ID, record_ID, C_BPartner_ID);
    }

    private void cmd_archive() {
        int record_ID = this.currentTab.getRecord_ID();
        log.info("ID=" + record_ID);
        if (record_ID <= 0) {
            return;
        }
        int AD_Table_ID = this.currentTab.getAD_Table_ID();
        new AArchive(this.aArchive.getButton(), AD_Table_ID, record_ID);
    }

    private void cmd_print() {
        this.cmd_print(false);
    }

    private void cmd_print(boolean printPreview) {
        int AD_Process_ID = this.currentTab.getAD_Process_ID();
        log.info("ID=" + AD_Process_ID);
        if (AD_Process_ID == 0) {
            this.cmd_report();
            return;
        }
        this.cmd_save(false);
        int table_ID = this.currentTab.getAD_Table_ID();
        int record_ID = this.currentTab.getRecord_ID();
        ProcessInfo pi = new ProcessInfo(this.getTitle(), AD_Process_ID, table_ID, record_ID);
        pi.setAD_User_ID(Env.getAD_User_ID(this.ctx));
        pi.setAD_Client_ID(Env.getAD_Client_ID(this.ctx));
        pi.setPrintPreview(printPreview);
        ProcessCtl.process(this, this.m_curWindowNo, pi, null);
        this.statusBar.setStatusLine(pi.getSummary(), pi.isError());
    }

    private void cmd_find() {
        if (this.currentTab == null) {
            return;
        }
        this.cmd_save(false);
        new ASearch(this.aFind, Env.getFrame(this), this.m_curWindowNo, this.m_curGC, this.currentTab, this.m_onlyCurrentDays);
    }

    private void cmd_attachment() {
        int record_ID = this.currentTab.getRecord_ID();
        log.info("Record_ID=" + record_ID);
        if (record_ID == -1) {
            this.aAttachment.setEnabled(false);
            return;
        }
        new Attachment(Env.getFrame(this), this.m_curWindowNo, this.currentTab.getAD_AttachmentID(), this.currentTab.getAD_Table_ID(), record_ID, null);
        this.currentTab.loadAttachments();
        this.aAttachment.setPressed(this.currentTab.hasAttachment());
    }

    private void cmd_chat() {
        int record_ID = this.currentTab.getRecord_ID();
        log.info("Record_ID=" + record_ID);
        if (record_ID == -1) {
            this.aChat.setEnabled(false);
            return;
        }
        String infoName = null;
        String infoDisplay = null;
        for (int i = 0; i < this.currentTab.getFieldCount(); ++i) {
            GridField field = this.currentTab.getField(i);
            if (field.isKey()) {
                infoName = field.getHeader();
            }
            if ((field.getColumnName().equals("Name") || field.getColumnName().equals("DocumentNo")) && field.getValue() != null) {
                infoDisplay = field.getValue().toString();
            }
            if (infoName != null && infoDisplay != null) break;
        }
        String description = infoName + ": " + infoDisplay;
        new AChat(Env.getFrame(this), this.m_curWindowNo, this.currentTab.getCM_ChatID(), this.currentTab.getAD_Table_ID(), record_ID, description, null);
        this.currentTab.loadChats();
        this.aChat.setPressed(this.currentTab.hasChat());
    }

    private void cmd_lock() {
        log.info("Modifiers=" + this.m_lastModifiers);
        if (!this.m_isPersonalLock) {
            return;
        }
        int record_ID = this.currentTab.getRecord_ID();
        if (record_ID == -1) {
            return;
        }
        if ((this.m_lastModifiers & 2) != 0) {
            new RecordAccessDialog(Env.getFrame(this), this.currentTab.getAD_Table_ID(), record_ID);
        } else {
            this.currentTab.lock(Env.getCtx(), record_ID, this.aLock.getButton().isSelected());
            this.currentTab.loadAttachments();
        }
        this.aLock.setPressed(this.currentTab.isLocked());
    }

    private void cmd_history() {
        log.info("");
        if (this.m_mWorkbench.getMWindow(this.getWindowIndex()).isTransaction()) {
            if (this.currentTab.needSave(true, true) && !this.cmd_save(false)) {
                return;
            }
            Point pt = new Point(0, this.aHistory.getButton().getBounds().height);
            SwingUtilities.convertPointToScreen(pt, this.aHistory.getButton());
            VOnlyCurrentDays ocd = new VOnlyCurrentDays((Frame)Env.getFrame(this), pt);
            if (!ocd.isCancel()) {
                this.m_onlyCurrentDays = ocd.getCurrentDays();
                if (this.m_onlyCurrentDays == 1) {
                    this.m_onlyCurrentRows = true;
                    this.m_onlyCurrentDays = 0;
                } else {
                    this.m_onlyCurrentRows = false;
                }
                this.currentTab.setQuery(null);
                MRole role = MRole.getDefault();
                int maxRows = role.getMaxQueryRecords();
                log.config("OnlyCurrent=" + this.m_onlyCurrentRows + ", Days=" + this.m_onlyCurrentDays + ", MaxRows=" + maxRows);
                this.m_curGC.query(this.m_onlyCurrentRows, this.m_onlyCurrentDays, maxRows);
            } else if (this.isFirstTab()) {
                this.aHistory.setPressed(!this.currentTab.isOnlyCurrentRows());
            }
        }
    }

    private void cmd_help() {
        log.info("");
        Help hlp = new Help((Frame)Env.getFrame(this), this.getTitle(), this.m_mWorkbench.getMWindow(this.getWindowIndex()));
        hlp.setVisible(true);
    }

    private void cmd_end(boolean exit) {
        boolean exitSystem = false;
        if (!this.cmd_save(false)) {
            return;
        }
        if (exit && ADialog.ask(this.m_curWindowNo, this, "ExitApplication?")) {
            exitSystem = true;
        }
        Env.getFrame(this).dispose();
        if (exitSystem) {
            AEnv.exit(0);
        }
    }

    private void cmd_winSize() {
        Dimension size = this.getSize();
        if (!ADialog.ask(this.m_curWindowNo, this, "WinSizeSet", "x=" + size.width + " - y=" + size.height)) {
            this.setPreferredSize(null);
            SwingUtilities.getWindowAncestor(this).pack();
            size = new Dimension(0, 0);
        }
        MWindow win = new MWindow(this.ctx, this.currentTab.getAD_Window_ID(), null);
        win.setWindowSize(size);
        win.saveEx();
    }

    private void cmd_export() {
        new AExport(this);
    }

    protected void actionButton(VButton vButton) {
        log.info(vButton.toString());
        if (this.currentTab.hasChangedCurrentTabAndParents()) {
            String msg = CLogger.retrieveErrorString("Please ReQuery Window");
            ADialog.error(this.m_curWindowNo, this, null, msg);
            return;
        }
        boolean startWOasking = false;
        String col = vButton.getColumnName();
        if (col.equals("Record_ID")) {
            int AD_Table_ID = Env.getContextAsInt(this.ctx, this.m_curWindowNo, "AD_Table_ID");
            int Record_ID = Env.getContextAsInt(this.ctx, this.m_curWindowNo, "Record_ID");
            AEnv.zoom(AD_Table_ID, Record_ID);
            return;
        }
        if (this.currentTab.needSave(true, false) && !this.cmd_save(true)) {
            return;
        }
        for (GridTab includedTab : this.currentTab.getIncludedTabs()) {
            if (!includedTab.needSave(true, false) || includedTab.dataSave(true)) continue;
            return;
        }
        int table_ID = this.currentTab.getAD_Table_ID();
        int record_ID = this.currentTab.getRecord_ID();
        if (record_ID == -1 && this.currentTab.getKeyColumnName().equals("AD_Language")) {
            record_ID = Env.getContextAsInt(this.ctx, this.m_curWindowNo, "AD_Language_ID");
        }
        if (record_ID == -1 && (vButton.getProcess_ID() == 306 || vButton.getProcess_ID() == 307)) {
            Integer id = (Integer)this.currentTab.getValue("AD_ChangeLog_ID");
            record_ID = id;
        }
        if (record_ID == -1 && this.currentTab.getKeyColumnName().endsWith("_ID")) {
            ADialog.error(this.m_curWindowNo, this, "SaveErrorRowNotFound");
            return;
        }
        boolean isProcessMandatory = false;
        MProcess process = null;
        if (vButton.getProcess_ID() != 0) {
            process = MProcess.get(this.ctx, vButton.getProcess_ID());
        }
        if (col.equals("PaymentRule")) {
            VPayment vp = new VPayment(this.m_curWindowNo, this.currentTab, vButton);
            if (vp.isInitOK()) {
                vp.setVisible(true);
            }
            vp.dispose();
            if (vp.needSave()) {
                this.cmd_save(false);
                this.cmd_refresh();
            }
        } else if (col.equals("DocAction") || col.equals("StartProcess") && process != null && process.getAD_Workflow_ID() != 0) {
            isProcessMandatory = true;
            VDocAction vda = new VDocAction(this.m_curWindowNo, this.currentTab, vButton, record_ID);
            if (vda.getNumberOfOptions() == 0) {
                vda.dispose();
                log.info("DocAction - No Options");
                return;
            }
            vda.setVisible(true);
            if (!vda.isStartProcess()) {
                return;
            }
            startWOasking = true;
            vda.dispose();
        } else if (col.equals("CreateFrom")) {
            ICreateFrom cf;
            if (vButton.getProcess_ID() <= 0 && (cf = VCreateFromFactory.create(this.currentTab)) != null) {
                if (cf.isInitOK()) {
                    cf.showWindow();
                    cf.closeWindow();
                    this.currentTab.dataRefresh();
                } else {
                    cf.closeWindow();
                }
                return;
            }
        } else if (col.equals("Posted") && MRole.getDefault().isShowAcct()) {
            Object ps;
            String docStatus;
            String processed = Env.getContext(this.ctx, this.m_curWindowNo, "Processed");
            if (!(processed.equals("Y") || "CO".equals(docStatus = Env.getContext(this.ctx, this.m_curWindowNo, "DocStatus")) || "CL".equals(docStatus) || "RE".equals(docStatus) || "VO".equals(docStatus))) {
                ADialog.error(this.m_curWindowNo, this, "PostDocNotComplete");
                return;
            }
            int tableId = Env.getContextAsInt(this.ctx, this.m_curWindowNo, "AD_Table_ID", true);
            int recordId = Env.getContextAsInt(this.ctx, this.m_curWindowNo, "Record_ID", true);
            if (tableId == 0 || recordId == 0) {
                tableId = this.currentTab.getAD_Table_ID();
                recordId = this.currentTab.getRecord_ID();
            }
            if ((ps = this.currentTab.getValue("Posted")) != null && ps.equals("Y")) {
                new AcctViewer(Env.getContextAsInt(this.ctx, this.m_curWindowNo, "AD_Client_ID"), tableId, recordId);
            } else if (ADialog.ask(this.m_curWindowNo, this, "PostImmediate?")) {
                boolean force = ps != null && !ps.equals("N");
                String error = AEnv.postImmediate(this.m_curWindowNo, Env.getAD_Client_ID(this.ctx), tableId, recordId, force);
                if (error != null) {
                    ADialog.error(this.m_curWindowNo, this, "PostingError-N", error);
                }
                this.cmd_refresh();
            }
            return;
        }
        log.config("Process_ID=" + vButton.getProcess_ID() + ", Record_ID=" + record_ID);
        if (vButton.getProcess_ID() == 0) {
            if (isProcessMandatory) {
                ADialog.error(this.m_curWindowNo, this, null, Msg.parseTranslation(this.ctx, "@NotFound@ @AD_Process_ID@"));
            }
            return;
        }
        if (this.currentTab.needSave(true, false) && !this.cmd_save(true)) {
            return;
        }
        MRole role = MRole.getDefault(this.ctx, false);
        Boolean accessRW = role.checkProcessAccess(process.getAD_Process_ID());
        if (accessRW == null || !accessRW.booleanValue()) {
            ADialog.error(this.m_curWindowNo, this, null, Msg.parseTranslation(this.ctx, "@AccessCannotProcess@"));
            return;
        }
        int form_ID = process.getAD_Form_ID();
        if (form_ID != 0) {
            if (this.currentTab.needSave(true, false) && !this.cmd_save(true)) {
                return;
            }
            FormFrame ff = new FormFrame(this.getWindowNo());
            String title = vButton.getDescription();
            if (title == null || title.length() == 0) {
                title = vButton.getName();
            }
            ProcessInfo pi = new ProcessInfo(title, vButton.getProcess_ID(), table_ID, record_ID);
            pi.setAD_User_ID(Env.getAD_User_ID(this.ctx));
            pi.setAD_Client_ID(Env.getAD_Client_ID(this.ctx));
            ff.setProcessInfo(pi);
            ff.openForm(form_ID);
            ff.pack();
            AEnv.showCenterScreen(ff);
            this.currentTab.dataRefresh();
            return;
        }
        int browse_ID = process.getAD_Browse_ID();
        if (browse_ID != 0) {
            if (this.currentTab.needSave(true, false) && !this.cmd_save(true)) {
                return;
            }
            String title = vButton.getDescription();
            if (title == null || title.length() == 0) {
                title = vButton.getName();
            }
            ProcessInfo pi = new ProcessInfo(title, vButton.getProcess_ID(), table_ID, record_ID);
            pi.setAD_User_ID(Env.getAD_User_ID(this.ctx));
            pi.setAD_Client_ID(Env.getAD_Client_ID(this.ctx));
            FormFrame ff = new FormFrame(this.getWindowNo());
            ff.setProcessInfo(pi);
            new VBrowser(ff, true, this.getWindowNo(), "", ASPUtil.getInstance().getBrowse(browse_ID), "", true, "", Env.isSOTrx(Env.getCtx(), this.m_curWindowNo));
            ff.pack();
            AEnv.showCenterScreen(ff);
            this.currentTab.dataRefresh();
            return;
        }
        ProcessModalDialog dialog = new ProcessModalDialog(this.ctx, Env.getWindow(this.m_curWindowNo), Env.getHeader(this.ctx, this.m_curWindowNo), this, this.m_curWindowNo, vButton.getProcess_ID(), table_ID, record_ID, startWOasking);
        if (!startWOasking && !dialog.isAutoStart()) {
            dialog.validate();
            dialog.pack();
            AEnv.showCenterWindow(Env.getWindow(this.m_curWindowNo), dialog);
        }
    }

    @Override
    public void lockUI(ProcessInfo pi) {
        this.setBusy(true, false);
    }

    @Override
    public void unlockUI(ProcessInfo pi) {
        boolean notPrint = pi != null && pi.getAD_Process_ID() != this.currentTab.getAD_Process_ID() && !pi.isReportingProcess();
        this.setBusy(false, notPrint);
        if (notPrint) {
            this.currentTab.dataRefresh();
            if (pi.isTimeout()) {
                Env.setContext(this.ctx, this.m_curWindowNo, "Processed", "Y");
            }
            this.m_curGC.dynamicDisplay(0);
            this.setStatusLine(pi.getSummary(), pi.isError());
            if (pi.isError()) {
                ADialog.error(this.m_curWindowNo, this, null, pi.getSummary());
            } else {
                ProcessInfoUtil.setLogFromDB(pi);
                String logInfo = pi.getLogInfo();
                if (logInfo.length() > 0) {
                    ADialog.info(this.m_curWindowNo, this, Env.getHeader(this.ctx, this.m_curWindowNo), pi.getTitle(), logInfo);
                }
            }
        } else {
            this.setStatusLine(pi.getSummary(), pi.isError());
            if (pi.isError()) {
                ADialog.error(this.m_curWindowNo, this, null, pi.getSummary());
            }
        }
    }

    @Override
    public boolean isUILocked() {
        return this.m_isLocked;
    }

    @Override
    public void executeASync(ProcessInfo pi) {
        log.config("-");
    }

    public GridTab getCurrentTab() {
        return this.currentTab;
    }

    public int noOfTabs() {
        return this.m_curWinTab.getTabCount();
    }

    public int getSelectedTabIndex() {
        return this.m_curWinTab.getSelectedIndex();
    }

    public void setSelectedTabIndex(int index) {
        this.m_curWinTab.setSelectedIndex(index);
    }

    public String getSelectedTabName() {
        String title = this.m_curWinTab.getTitleAt(this.m_curWinTab.getSelectedIndex());
        title = title.substring(title.indexOf("<html>") + 6);
        title = title.substring(0, title.indexOf(60));
        return title;
    }

    @Override
    public String toString() {
        String s = "APanel[curWindowNo=" + this.m_curWindowNo;
        if (this.m_mWorkbench != null) {
            s = s + ",WB=" + this.m_mWorkbench.toString();
        }
        s = s + "]";
        return s;
    }

    private void initSwitchLineAction() {
        this.aSwitchLinesDownAction = new SwitchAction("switchLinesDown", KeyStroke.getKeyStroke(40, 1), this);
        this.aSwitchLinesUpAction = new SwitchAction("switchLinesUp", KeyStroke.getKeyStroke(38, 1), this);
        VTable table = this.m_curGC.getTable();
        table.getInputMap(1).put(KeyStroke.getKeyStroke(40, 1), "none");
        table.getInputMap(1).put(KeyStroke.getKeyStroke(38, 1), "none");
        table.getInputMap(0).put(KeyStroke.getKeyStroke(40, 1), "none");
        table.getInputMap(0).put(KeyStroke.getKeyStroke(38, 1), "none");
        this.getInputMap(2).put(KeyStroke.getKeyStroke(40, 1), this.aSwitchLinesDownAction.getName());
        this.getActionMap().put(this.aSwitchLinesDownAction.getName(), this.aSwitchLinesDownAction);
        this.getInputMap(2).put(KeyStroke.getKeyStroke(38, 1), this.aSwitchLinesUpAction.getName());
        this.getActionMap().put(this.aSwitchLinesUpAction.getName(), this.aSwitchLinesUpAction);
    }

    public boolean isNested() {
        return this.isNested;
    }

    class SwitchAction
    extends AbstractAction {
        private static final long serialVersionUID = 3837712049468116744L;
        private ActionListener al;
        private String name;

        SwitchAction(String name, KeyStroke accelerator, ActionListener al) {
            super(name);
            this.putValue("Name", name);
            this.putValue("ShortDescription", name);
            this.putValue("AcceleratorKey", accelerator);
            this.putValue("ActionCommandKey", name);
            this.al = al;
            this.name = name;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.al.actionPerformed(e);
        }

        public String getName() {
            return this.name;
        }
    }
}

