/*
 * Decompiled with CFR 0.152.
 */
package org.compiere.apps;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.compiere.apps.ADialog;
import org.compiere.apps.AEnv;
import org.compiere.apps.AMenu;
import org.compiere.apps.ATask;
import org.compiere.apps.AWindow;
import org.compiere.apps.ProcessDialog;
import org.compiere.apps.form.FormFrame;
import org.compiere.model.MMenu;
import org.compiere.model.MRecentItem;
import org.compiere.model.MTask;
import org.compiere.model.PO;
import org.compiere.swing.CFrame;
import org.compiere.util.CLogger;
import org.compiere.util.Env;
import org.compiere.util.Ini;
import org.compiere.util.Msg;
import org.compiere.wf.MWFNode;
import org.eevolution.form.VBrowser;

public class AMenuStartItem
extends Thread
implements ActionListener {
    private int id = 0;
    private boolean isMenu = false;
    private String name;
    private AMenu menu;
    private static CLogger log = CLogger.getCLogger(AMenuStartItem.class);
    private Runnable resetProgressBar = new Runnable(){

        @Override
        public void run() {
            AMenuStartItem.this.m_value = 0;
            if (AMenuStartItem.this.menu != null) {
                AMenuStartItem.this.menu.progressBar.setValue(0);
            }
        }
    };
    private Runnable m_tickPB = new Runnable(){

        @Override
        public void run() {
            if (AMenuStartItem.this.menu == null) {
                return;
            }
            int tick = 5;
            if (AMenuStartItem.this.menu.progressBar.getValue() < AMenuStartItem.this.menu.progressBar.getMaximum() - 5) {
                AMenuStartItem.this.menu.progressBar.setValue(AMenuStartItem.this.menu.progressBar.getValue() + 5);
            }
        }
    };
    private Runnable updateProgressBar = new Runnable(){

        @Override
        public void run() {
            if (AMenuStartItem.this.menu == null) {
                return;
            }
            AMenuStartItem.this.m_value += AMenuStartItem.this.m_increment;
            if (AMenuStartItem.this.menu.progressBar.getValue() > AMenuStartItem.this.m_value) {
                AMenuStartItem.this.menu.progressBar.setValue(AMenuStartItem.this.m_value);
            }
        }
    };
    int m_value = 0;
    int m_increment = 20;
    private Timer timer = new Timer(500, this);

    public AMenuStartItem(int id, boolean isMenu, String name, AMenu menu) {
        this.id = id;
        this.isMenu = isMenu;
        this.name = name;
        this.menu = menu;
        if (menu != null) {
            this.m_increment = (menu.progressBar.getMaximum() - menu.progressBar.getMinimum()) / 5;
        }
    }

    @Override
    public void run() {
        if (this.menu != null) {
            this.menu.setBusy(true);
        }
        SwingUtilities.invokeLater(this.resetProgressBar);
        this.timer.start();
        String errmsg = null;
        try {
            SwingUtilities.invokeLater(this.updateProgressBar);
            if (this.isMenu) {
                MMenu menu = MMenu.getFromId(Env.getCtx(), this.id);
                this.startOption(menu.getAction(), menu.getOptionId(), menu.isSOTrx());
                MRecentItem.addMenuOption(Env.getCtx(), menu.getAD_Menu_ID(), menu.getAD_Window_ID());
            } else {
                MWFNode workflowNode = MWFNode.get(Env.getCtx(), this.id);
                this.startOption(workflowNode.getAction(), workflowNode.getOptionId(), false);
            }
            SwingUtilities.invokeLater(this.updateProgressBar);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "ID=" + this.id, e);
            errmsg = Msg.parseTranslation(Env.getCtx(), e.getMessage());
        }
        if (errmsg != null) {
            ADialog.error(0, null, "Error", errmsg);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.timer.stop();
        SwingUtilities.invokeLater(this.resetProgressBar);
        if (this.menu != null) {
            this.menu.setBusy(false);
        }
    }

    private void startOption(String action, int optionId, boolean isSOTrx) {
        if (action.equals("W")) {
            this.startWindow(0, optionId);
        } else if (action.equals("P") || action.equals("R")) {
            this.startProcess(optionId, isSOTrx);
        } else if (action.equals("B")) {
            this.startWindow(optionId, 0);
        } else if (action.equals("F")) {
            if (this.menu != null) {
                this.menu.startWorkFlow(optionId);
            }
        } else if (action.equals("T")) {
            this.startTask(optionId);
        } else if (action.equals("X")) {
            this.startForm(optionId);
        } else if (action.equals("S")) {
            this.startSmartBrowse(optionId, isSOTrx);
        } else {
            log.log(Level.SEVERE, "No valid Action in ID=" + optionId);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SwingUtilities.invokeLater(this.m_tickPB);
    }

    private void startWindow(int AD_Workbench_ID, int AD_Window_ID) {
        AWindow frame = (AWindow)AEnv.showWindow(AD_Window_ID);
        if (frame != null) {
            this.menu.getWindowManager().add(frame);
            return;
        }
        if (Ini.isPropertyBool("SingleInstancePerWindow") && (frame = this.menu.getWindowManager().find(AD_Window_ID)) != null) {
            frame.toFront();
            return;
        }
        SwingUtilities.invokeLater(this.updateProgressBar);
        frame = new AWindow(this.menu.getGraphicsConfiguration());
        boolean OK = false;
        OK = AD_Workbench_ID != 0 ? frame.initWorkbench(AD_Workbench_ID) : frame.initWindow(AD_Window_ID, null);
        if (!OK) {
            return;
        }
        SwingUtilities.invokeLater(this.updateProgressBar);
        if (Ini.isPropertyBool("OpenWindowMaximized")) {
            AEnv.showMaximized(frame);
        }
        SwingUtilities.invokeLater(this.updateProgressBar);
        if (!Ini.isPropertyBool("OpenWindowMaximized")) {
            frame.validate();
            AEnv.showCenterScreen(frame);
        }
        this.menu.getWindowManager().add(frame);
        frame = null;
    }

    private void startProcess(int AD_Process_ID, boolean isSOTrx) {
        SwingUtilities.invokeLater(this.updateProgressBar);
        this.timer.stop();
        ProcessDialog pd = new ProcessDialog(this.menu.getGraphicsConfiguration(), AD_Process_ID, isSOTrx);
        if (!pd.init()) {
            return;
        }
        this.timer.start();
        this.menu.getWindowManager().add(pd);
        SwingUtilities.invokeLater(this.updateProgressBar);
        pd.getContentPane().invalidate();
        pd.getContentPane().validate();
        pd.pack();
        SwingUtilities.invokeLater(this.updateProgressBar);
        AEnv.showCenterScreen(pd);
    }

    private void startTask(int AD_Task_ID) {
        SwingUtilities.invokeLater(this.updateProgressBar);
        PO task = null;
        if (AD_Task_ID > 0) {
            task = new MTask(Env.getCtx(), AD_Task_ID, null);
        }
        if (task.get_ID() != AD_Task_ID) {
            task = null;
        }
        if (task == null) {
            return;
        }
        SwingUtilities.invokeLater(this.updateProgressBar);
        this.menu.getWindowManager().add(new ATask(this.name, (MTask)task));
    }

    private void startForm(int AD_Form_ID) {
        FormFrame ff = null;
        if (Ini.isPropertyBool("SingleInstancePerWindow") && (ff = this.menu.getWindowManager().findForm(AD_Form_ID)) != null) {
            ff.toFront();
            return;
        }
        ff = new FormFrame(0);
        SwingUtilities.invokeLater(this.updateProgressBar);
        boolean ok = ff.openForm(AD_Form_ID);
        if (!ok) {
            ff.dispose();
            return;
        }
        this.menu.getWindowManager().add(ff.getCFrame());
        SwingUtilities.invokeLater(this.updateProgressBar);
        SwingUtilities.invokeLater(this.updateProgressBar);
        if (Ini.isPropertyBool("OpenWindowMaximized")) {
            AEnv.showMaximized(ff.getCFrame());
        } else {
            AEnv.showCenterScreen(ff);
        }
    }

    private void startSmartBrowse(int AD_Browse_ID, Boolean isSOTrx) {
        CFrame ff = new CFrame();
        if (Ini.isPropertyBool("SingleInstancePerWindow") && (ff = this.menu.getWindowManager().findBrowse(AD_Browse_ID).getFrame()) != null) {
            ff.toFront();
            return;
        }
        SwingUtilities.invokeLater(this.updateProgressBar);
        ff = VBrowser.openBrowse(0, AD_Browse_ID, "", isSOTrx);
        ff.setVisible(true);
        ff.pack();
        this.menu.getWindowManager().add(ff);
        SwingUtilities.invokeLater(this.updateProgressBar);
        SwingUtilities.invokeLater(this.updateProgressBar);
        if (Ini.isPropertyBool("OpenWindowMaximized")) {
            AEnv.showMaximized(ff);
        } else {
            AEnv.showCenterScreen(ff);
        }
    }
}

