/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class WeakList<T>
extends AbstractList<T> {
    private final ReferenceQueue<T> queue = new ReferenceQueue();
    private final List<ListEntry> list = new ArrayList<ListEntry>();
    private final Object sync = new Object();

    public boolean add(T o, boolean weak) {
        this.expungeStaleEntries();
        return this.list.add(new ListEntry(o, weak));
    }

    @Override
    public boolean add(T o) {
        return this.add(o, true);
    }

    @Override
    public T get(int i) {
        this.expungeStaleEntries();
        ListEntry e = this.list.get(i);
        return e.get();
    }

    @Override
    public int size() {
        this.expungeStaleEntries();
        return this.list.size();
    }

    @Override
    public T remove(int index) {
        ListEntry e = this.list.remove(index);
        return e == null ? null : (T)e.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<T> hardList() {
        this.expungeStaleEntries();
        ArrayList<T> result = new ArrayList<T>();
        Object object = this.sync;
        synchronized (object) {
            for (int i = 0; i < this.size(); ++i) {
                T tmp = this.get(i);
                if (tmp == null) continue;
                result.add(tmp);
            }
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return this.hardList().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expungeStaleEntries() {
        Object object = this.sync;
        synchronized (object) {
            ListWeakReference r;
            while ((r = (ListWeakReference)this.queue.poll()) != null) {
                ListEntry le = r.getListEntry();
                int i = this.list.indexOf(le);
                if (i == -1) continue;
                this.list.remove(i);
            }
        }
    }

    private class ListEntry {
        final T value;
        final ListWeakReference weakValue;
        final boolean isWeak;

        public ListEntry(T value, boolean isWeak) {
            if (isWeak) {
                this.value = null;
                this.weakValue = new ListWeakReference(value, this);
                this.isWeak = true;
            } else {
                this.value = value;
                this.weakValue = null;
                this.isWeak = false;
            }
        }

        public boolean isAvailable() {
            if (this.isWeak) {
                return this.weakValue.get() != null;
            }
            return true;
        }

        public T get() {
            if (this.isWeak) {
                return this.weakValue.get();
            }
            return this.value;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public String toString() {
            if (this.isAvailable()) {
                return "<GARBAGED>";
            }
            return String.valueOf(this.get());
        }
    }

    private class ListWeakReference
    extends WeakReference<T> {
        private final ListEntry parent;

        public ListWeakReference(T value, ListEntry parent) {
            super(value, WeakList.this.queue);
            this.parent = parent;
        }

        public ListEntry getListEntry() {
            return this.parent;
        }
    }
}

