/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.process;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.compiere.process.SvrProcess;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;

public class ApplyMigrationScripts
extends SvrProcess {
    private static CLogger log = CLogger.getCLogger(ApplyMigrationScripts.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String doIt() throws Exception {
        log.info("Applying migrations scripts");
        String sql = "select ad_migrationscript_id, script, name from ad_migrationscript where isApply = 'Y' and status = 'IP' order by name, created";
        CPreparedStatement pstmt = DB.prepareStatement(sql, this.get_TrxName());
        ResultSet rs = pstmt.executeQuery();
        while (rs.next()) {
            byte[] scriptArray = rs.getBytes(2);
            int seqID = rs.getInt(1);
            boolean execOk = true;
            try {
                StringBuffer tmpSql = new StringBuffer();
                tmpSql = new StringBuffer(new String(scriptArray));
                if (tmpSql.length() <= 0) continue;
                log.info("Executing script " + rs.getString(3));
                execOk = this.executeScript(tmpSql.toString(), rs.getString(3));
            }
            catch (SQLException e) {
                execOk = false;
                e.printStackTrace();
                log.saveError("Error", "Script: " + rs.getString(3) + " - " + e.getMessage());
                log.severe(e.getMessage());
            }
            finally {
                sql = "UPDATE ad_migrationscript SET status = ? , isApply = 'N' WHERE ad_migrationscript_id = ? ";
                pstmt = DB.prepareStatement(sql, this.get_TrxName());
                if (execOk) {
                    pstmt.setString(1, "CO");
                    pstmt.setInt(2, seqID);
                } else {
                    pstmt.setString(1, "ER");
                    pstmt.setInt(2, seqID);
                }
                try {
                    pstmt.executeUpdate();
                    if (execOk) continue;
                    pstmt.close();
                    return null;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    log.saveError("Error", "Script: " + rs.getString(3) + " - " + e.getMessage());
                    log.severe(e.getMessage());
                }
            }
        }
        rs.close();
        pstmt.close();
        return null;
    }

    @Override
    protected void prepare() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean executeScript(String sql, String fileName) {
        BufferedReader reader = new BufferedReader(new StringReader(sql));
        StringBuffer sqlBuf = new StringBuffer();
        boolean statementReady = false;
        boolean execOk = true;
        boolean longComment = false;
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                block17: {
                    if ((line = line.trim()).startsWith("--") || line.length() == 0) continue;
                    if (line.endsWith(";") && !longComment) {
                        sqlBuf.append(' ');
                        sqlBuf.append(line.substring(0, line.length() - 1));
                        statementReady = true;
                    } else if (line.startsWith("/*")) {
                        longComment = true;
                    } else if (line.endsWith("*/")) {
                        longComment = false;
                    } else {
                        if (longComment) continue;
                        sqlBuf.append(' ');
                        sqlBuf.append(line);
                        statementReady = false;
                    }
                    if (!statementReady || sqlBuf.length() == 0) continue;
                    Connection conn = DB.getConnectionRW();
                    conn.setAutoCommit(false);
                    Statement stmt = null;
                    try {
                        stmt = conn.createStatement();
                        stmt.execute(sqlBuf.toString());
                        System.out.print(".");
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        execOk = false;
                        log.saveError("Error", "Script: " + fileName + " - " + e.getMessage() + ". The line that caused the error is the following ==> " + sqlBuf);
                        log.severe(e.getMessage());
                    }
                    finally {
                        stmt.close();
                        if (execOk) {
                            conn.commit();
                        } else {
                            conn.rollback();
                        }
                        conn.setAutoCommit(true);
                        conn.close();
                        if (execOk) break block17;
                        return false;
                    }
                }
                sqlBuf.setLength(0);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }
}

