/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos.search;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.sql.ResultSet;
import javax.swing.SwingUtilities;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.adempiere.pos.POSTextField;
import org.adempiere.pos.VPOS;
import org.adempiere.pos.grid.VPOSBPartner;
import org.adempiere.pos.search.POSQuery;
import org.compiere.minigrid.ColumnInfo;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.MBPartnerInfo;
import org.compiere.model.PO;
import org.compiere.swing.CLabel;
import org.compiere.util.CLogger;
import org.compiere.util.CPreparedStatement;
import org.compiere.util.DB;
import org.compiere.util.Env;
import org.compiere.util.Msg;

public class QueryBPartner
extends POSQuery {
    private static final long serialVersionUID = -7109518709654253628L;
    private POSTextField fieldValue;
    private POSTextField fieldTaxID;
    private POSTextField fieldName;
    private POSTextField fieldName2;
    private POSTextField fieldContact;
    private POSTextField fieldEmail;
    private POSTextField fieldPhone;
    private POSTextField fieldCity;
    private int partnerId;
    private String partnerName;
    private static CLogger log = CLogger.getCLogger(QueryBPartner.class);
    private static ColumnInfo[] s_layout = new ColumnInfo[]{new ColumnInfo(" ", "C_BPartner_ID", IDColumn.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Value"), "Value", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "TaxID"), "TaxID", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Name"), "Name", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Name2"), "Name2", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Email"), "Email", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Phone"), "Phone", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "Postal"), "Postal", String.class), new ColumnInfo(Msg.translate(Env.getCtx(), "City"), "City", String.class)};
    private static String sqlFrom = "RV_BPartner";
    private static String sqlWhere = "IsActive='Y'";

    public QueryBPartner(VPOS vPOS) {
        super(vPOS);
    }

    @Override
    protected void init() {
        this.setTitle(Msg.translate(Env.getCtx(), "C_BPartner_ID"));
        this.parameterPanel.setLayout((LayoutManager)new MigLayout("fill", "", "[50][50][]"));
        this.parameterPanel.setBorder(new TitledBorder(Msg.getMsg(this.ctx, "Query")));
        CLabel cLabel = new CLabel(Msg.translate(this.ctx, "Value"));
        this.parameterPanel.add((Component)cLabel, " growy");
        this.fieldValue = new POSTextField("", this.posPanel.getKeyboard());
        cLabel.setLabelFor(this.fieldValue);
        this.parameterPanel.add((Component)this.fieldValue, "h 30, w 200");
        this.fieldValue.addActionListener(this);
        CLabel cLabel2 = new CLabel(Msg.translate(this.ctx, "TaxID"));
        this.parameterPanel.add((Component)cLabel2, " growy");
        this.fieldTaxID = new POSTextField("", this.posPanel.getKeyboard());
        cLabel2.setLabelFor(this.fieldTaxID);
        this.parameterPanel.add((Component)this.fieldTaxID, "h 30, w 200");
        this.fieldTaxID.addActionListener(this);
        CLabel cLabel3 = new CLabel(Msg.translate(this.ctx, "Contact"));
        this.parameterPanel.add((Component)cLabel3, " growy");
        this.fieldContact = new POSTextField("", this.posPanel.getKeyboard());
        cLabel3.setLabelFor(this.fieldContact);
        this.parameterPanel.add((Component)this.fieldContact, "h 30, w 200");
        this.fieldContact.addActionListener(this);
        CLabel cLabel4 = new CLabel(Msg.translate(this.ctx, "Phone"));
        this.parameterPanel.add((Component)cLabel4, " growy");
        this.fieldPhone = new POSTextField("", this.posPanel.getKeyboard());
        cLabel4.setLabelFor(this.fieldPhone);
        this.parameterPanel.add((Component)this.fieldPhone, "h 30, w 200, wrap");
        this.fieldPhone.addActionListener(this);
        CLabel cLabel5 = new CLabel(Msg.translate(this.ctx, "Name"));
        this.parameterPanel.add((Component)cLabel5, " growy");
        this.fieldName = new POSTextField("", this.posPanel.getKeyboard());
        cLabel5.setLabelFor(this.fieldName);
        this.parameterPanel.add((Component)this.fieldName, "h 30, w 200");
        this.fieldName.addActionListener(this);
        CLabel cLabel6 = new CLabel(Msg.translate(this.ctx, "Name2"));
        this.parameterPanel.add((Component)cLabel6, " growy");
        this.fieldName2 = new POSTextField("", this.posPanel.getKeyboard());
        cLabel6.setLabelFor(this.fieldName2);
        this.parameterPanel.add((Component)this.fieldName2, "h 30, w 200");
        this.fieldName2.addActionListener(this);
        CLabel cLabel7 = new CLabel(Msg.translate(this.ctx, "Email"));
        this.parameterPanel.add((Component)cLabel7, " growy");
        this.fieldEmail = new POSTextField("", this.posPanel.getKeyboard());
        cLabel7.setLabelFor(this.fieldEmail);
        this.parameterPanel.add((Component)this.fieldEmail, "h 30, w 200");
        this.fieldEmail.addActionListener(this);
        CLabel cLabel8 = new CLabel(Msg.translate(this.ctx, "City"));
        this.parameterPanel.add((Component)cLabel8, " growy");
        this.fieldCity = new POSTextField("", this.posPanel.getKeyboard());
        cLabel8.setLabelFor(this.fieldCity);
        this.parameterPanel.add((Component)this.fieldCity, "h 30, w 200");
        this.fieldCity.addActionListener(this);
        this.posTable.prepareTable(s_layout, sqlFrom, sqlWhere, false, "RV_BPartner");
        this.posTable.growScrollbars();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryBPartner.this.fieldValue.requestFocus();
            }
        });
        this.addNewAction();
    }

    @Override
    protected void newAction() {
        super.newAction();
        VPOSBPartner vPOSBPartner = new VPOSBPartner(new Frame(), 0, this.posPanel);
        vPOSBPartner.setVisible(true);
        this.partnerId = vPOSBPartner.getC_BPartner_ID();
        if (this.partnerId > 0) {
            this.setOkAction();
        }
    }

    @Override
    public void editAction() {
        super.editAction();
        VPOSBPartner vPOSBPartner = new VPOSBPartner(new Frame(), 1, this.posPanel);
        this.select();
        vPOSBPartner.loadBPartner(this.partnerId);
        vPOSBPartner.setVisible(true);
        this.close();
    }

    private void setResultsFromArray(MBPartnerInfo[] mBPartnerInfoArray) {
        this.posTable.loadTable(mBPartnerInfoArray);
        int n = this.posTable.getRowCount();
        if (n > 0) {
            this.posTable.setRowSelectionInterval(0, 0);
            if (n == 1) {
                this.select();
            }
        }
    }

    @Override
    public void setResults(PO[] pOArray) {
        if (pOArray == null || !(pOArray instanceof MBPartnerInfo[])) {
            return;
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        this.setResultsFromArray((MBPartnerInfo[])pOArray);
        this.setCursor(Cursor.getDefaultCursor());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadData() {
        block7: {
            StringBuffer stringBuffer = new StringBuffer();
            CPreparedStatement cPreparedStatement = null;
            ResultSet resultSet = null;
            try {
                this.setCursor(Cursor.getPredefinedCursor(3));
                stringBuffer.append(" SELECT b.C_BPartner_ID, b.Value, b.TaxID , b.Name , b.Name2 , u.Email, u.Phone, l.Postal, lb.name AS City").append(" FROM C_BPartner AS b").append(" INNER JOIN AD_User u ON (u.C_BPartner_ID = b.C_BPartner_ID)").append(" INNER JOIN C_BPartner_Location lb ON (lb.C_BPartner_ID = b.C_BPartner_ID)").append(" INNER JOIN C_Location l ON (l.C_Location_ID = lb.C_Location_ID)").append(" WHERE b.C_BPartner_ID = ?");
                int n = 1;
                cPreparedStatement = DB.prepareStatement(stringBuffer.toString(), null);
                cPreparedStatement.setInt(n++, this.posPanel.getC_BPartner_ID());
                resultSet = cPreparedStatement.executeQuery();
                this.posTable.loadTable(resultSet);
                int n2 = this.posTable.getRowCount();
                if (n2 > 0) {
                    this.posTable.setRowSelectionInterval(0, 0);
                    if (n2 == 1) {
                        this.select();
                    }
                }
                DB.close(resultSet);
            }
            catch (Exception exception) {
                log.severe("QueryTicket.setResults: " + exception + " -> " + stringBuffer);
                break block7;
            }
            finally {
                DB.close(resultSet);
                DB.close(cPreparedStatement);
                this.setCursor(Cursor.getDefaultCursor());
            }
            DB.close(cPreparedStatement);
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    @Override
    protected void select() {
        Integer n;
        boolean bl;
        this.cleanValues();
        int n2 = this.posTable.getSelectedRow();
        boolean bl2 = bl = n2 != -1;
        if (bl && (n = this.posTable.getSelectedRowKey()) != null) {
            this.partnerId = n;
            this.partnerName = (String)this.posTable.getValueAt(n2, 2);
        }
        log.fine("C_BPartner_ID=" + this.partnerId);
    }

    @Override
    protected void close() {
        this.dispose();
    }

    @Override
    public void reset() {
        this.fieldValue.setText(null);
        this.fieldTaxID.setText(null);
        this.fieldName.setText(null);
        this.fieldName2.setText(null);
        this.fieldContact.setText(null);
        this.fieldEmail.setText(null);
        this.fieldPhone.setText(null);
        this.fieldCity.setText(null);
        this.setResults(new MBPartnerInfo[0]);
        this.cleanValues();
    }

    @Override
    public void refresh() {
        this.cleanValues();
        this.setResults(MBPartnerInfo.find(this.ctx, this.fieldValue.getText(), this.fieldTaxID.getText(), this.fieldName.getText(), this.fieldName2.getText(), this.fieldContact.getText(), this.fieldEmail.getText(), this.fieldPhone.getText(), this.fieldCity.getText()));
    }

    private void cleanValues() {
        this.partnerId = -1;
        this.partnerName = null;
    }

    @Override
    protected void cancel() {
        this.cleanValues();
        this.dispose();
    }

    @Override
    public int getRecord_ID() {
        return this.partnerId;
    }

    @Override
    public String getValue() {
        return this.partnerName;
    }
}

