/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import org.adempiere.pos.POSSubPanel;
import org.adempiere.pos.POSTable;
import org.adempiere.pos.VPOS;
import org.adempiere.pos.services.POSOrderLineTableHandle;
import org.adempiere.pos.services.POSPanelInterface;
import org.compiere.minigrid.IDColumn;
import org.compiere.model.PO;
import org.compiere.swing.CScrollPane;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class POSOrderLinePanel
extends POSSubPanel
implements ActionListener,
FocusListener,
ListSelectionListener,
TableModelListener,
POSPanelInterface,
KeyListener,
MouseListener {
    private static final long serialVersionUID = -4023538043556457231L;
    private static CLogger logger = CLogger.getCLogger(POSOrderLinePanel.class);
    private POSTable posTable;
    private POSOrderLineTableHandle orderLineTableHandle;

    public POSOrderLinePanel(VPOS vPOS) {
        super(vPOS);
    }

    public int getTableWidth() {
        return this.posTable.getColumnModel().getTotalColumnWidth();
    }

    @Override
    public void init() {
        this.setLayout(new BorderLayout());
        this.posTable = new POSTable();
        this.orderLineTableHandle = new POSOrderLineTableHandle(this.posTable);
        CScrollPane cScrollPane = new CScrollPane(this.posTable);
        cScrollPane.addKeyListener(this);
        this.orderLineTableHandle.prepareTable();
        this.posTable.getModel().addTableModelListener(this);
        this.posTable.addKeyListener(this);
        this.posTable.addMouseListener(this);
        this.posTable.setFillsViewportHeight(true);
        this.posTable.growScrollbars();
        this.setMaximumSize(new Dimension(50, 50));
        this.setPreferredSize(new Dimension(50, 50));
        this.add((Component)cScrollPane, "Center");
        this.addKeyListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null || string.length() == 0) {
            return;
        }
        logger.info("POSOrderLinePanel - actionPerformed: " + string);
        this.posPanel.refreshPanel();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        logger.info("POSOrderLinePanel - focusGained: " + focusEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (focusEvent.isTemporary()) {
            return;
        }
        logger.info("POSDocumentPanel - focusLost");
        this.posPanel.refreshPanel();
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        Object object;
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        int n = this.posTable.getSelectedRow();
        if (n != -1 && (object = this.posTable.getModel().getValueAt(n, 0)) != null) {
            Integer n2 = ((IDColumn)object).getRecord_ID();
            this.posPanel.setOrderLineId(n2);
        }
        this.posPanel.refreshPanel();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        boolean bl = tableModelEvent.getType() == 0;
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getColumn();
        if (!bl || n2 != 2 && n2 != 4) {
            return;
        }
        IDColumn iDColumn = (IDColumn)this.posTable.getValueAt(n, 0);
        if (iDColumn != null) {
            this.posPanel.setOrderLineId(iDColumn.getRecord_ID());
            BigDecimal bigDecimal = (BigDecimal)this.posTable.getValueAt(n, 2);
            BigDecimal bigDecimal2 = (BigDecimal)this.posTable.getValueAt(n, 4);
            BigDecimal bigDecimal3 = (BigDecimal)this.posTable.getValueAt(n, 5);
            this.posPanel.setQty(bigDecimal);
            this.posPanel.setPrice(bigDecimal2);
            this.posPanel.setDiscountPercentage(bigDecimal3);
            this.updateLine();
        }
    }

    public void updateLine() {
        int n = this.posTable.getSelectedRow();
        this.posTable.getModel().removeTableModelListener(this);
        if (this.posPanel.getQty() != null && this.posPanel.getQty().signum() < 0) {
            if (this.posPanel.getOrderLineId() > 0 && this.posPanel.isRequiredPIN() && this.posPanel.isUserPinValid()) {
                this.posPanel.deleteLine(this.posPanel.getOrderLineId());
            }
            if (n >= 0) {
                ((DefaultTableModel)this.posTable.getModel()).removeRow(n);
                this.posTable.getModel().addTableModelListener(this);
                this.posPanel.refreshPanel();
            }
            return;
        }
        BigDecimal[] bigDecimalArray = this.posPanel.updateLine(this.posPanel.getOrderLineId(), this.posPanel.getQty().add(this.posPanel.getQtyAdded()), this.posPanel.getPriceLimit(), this.posPanel.getPrice(), this.posPanel.getPriceList(), this.posPanel.getDiscountPercentage());
        if (bigDecimalArray != null && n >= 0) {
            this.posTable.setValueAt(bigDecimalArray[0], n, 6);
            this.posTable.setValueAt(bigDecimalArray[2], n, 8);
        }
        this.posTable.getModel().addTableModelListener(this);
        this.posTable.requestFocusInWindow();
    }

    @Override
    public void refreshPanel() {
        this.posTable.getModel().removeTableModelListener(this);
        this.orderLineTableHandle.setEditable(this.posPanel.isModifyPrice(), this.posPanel.isDrafted());
        if (!this.posPanel.hasOrder()) {
            this.posTable.loadTable(new PO[0]);
        }
        this.orderLineTableHandle.loadTable(this.posPanel.getC_Order_ID());
        for (int i = 0; i < this.posTable.getRowCount(); ++i) {
            IDColumn iDColumn = (IDColumn)this.posTable.getModel().getValueAt(i, 0);
            if (iDColumn != null && this.posPanel.getOrderLineId() > 0 && iDColumn.getRecord_ID().intValue() == this.posPanel.getOrderLineId()) {
                this.posTable.getSelectionModel().setSelectionInterval(i, i);
                this.showProductInfo(i);
                break;
            }
            if (i != this.posTable.getRowCount() - 1 || !this.posPanel.hasLines()) continue;
            this.posTable.getSelectionModel().setSelectionInterval(0, 0);
            this.showProductInfo(0);
        }
        this.posPanel.autoSize();
        this.posTable.getModel().addTableModelListener(this);
    }

    public void disableTable() {
        this.posTable.setEnabled(false);
        this.orderLineTableHandle.setEditable(false, false);
        this.posTable.removeKeyListener(this);
        this.posTable.removeMouseListener(this);
    }

    public void enableTable() {
        this.posTable.setEnabled(true);
        this.orderLineTableHandle.setEditable(this.posPanel.isModifyPrice(), this.posPanel.isDrafted());
        this.posTable.addKeyListener(this);
        this.posTable.addMouseListener(this);
    }

    @Override
    public String validatePayment() {
        return null;
    }

    @Override
    public void changeViewPanel() {
        int n = this.posTable.getSelectedRow();
        if (n != -1 && n < this.posTable.getRowCount()) {
            BigDecimal bigDecimal = (BigDecimal)this.posTable.getValueAt(n, 2);
            BigDecimal bigDecimal2 = (BigDecimal)this.posTable.getValueAt(n, 4);
            BigDecimal bigDecimal3 = (BigDecimal)this.posTable.getValueAt(n, 5);
            this.posPanel.setQty(bigDecimal);
            this.posPanel.setPrice(bigDecimal2);
            this.posPanel.setDiscountPercentage(bigDecimal3);
        } else {
            this.posPanel.setQty(Env.ZERO);
            this.posPanel.setPrice(Env.ZERO);
            this.posPanel.setPriceLimit(Env.ZERO);
            this.posPanel.setPriceList(Env.ZERO);
            this.posPanel.setDiscountPercentage(Env.ZERO);
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        int n = this.posTable.getSelectedRow();
        if (n < 0) {
            keyEvent.consume();
            return;
        }
        this.posTable.setRowChecked(n, true);
        switch (keyEvent.getKeyCode()) {
            case 18: {
                break;
            }
            case 79: {
                this.posTable.editCellAt(n, 2, keyEvent);
                break;
            }
            case 80: {
                this.posTable.editCellAt(n, 4, keyEvent);
                break;
            }
            case 38: {
                this.showProductInfo(n);
                break;
            }
            case 40: {
                this.showProductInfo(n);
                break;
            }
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        POSTable pOSTable = (POSTable)mouseEvent.getSource();
        int n = pOSTable.getSelectedRow();
        if (n != -1) {
            this.showProductInfo(n);
            this.posPanel.setAddQty(false);
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private void showProductInfo(int n) {
        Object object = this.posTable.getModel().getValueAt(n, 0);
        if (object != null) {
            Integer n2 = ((IDColumn)object).getRecord_ID();
            this.posPanel.setOrderLineId(n2);
            BigDecimal bigDecimal = (BigDecimal)this.posTable.getModel().getValueAt(n, 2);
            BigDecimal bigDecimal2 = (BigDecimal)this.posTable.getModel().getValueAt(n, 4);
            BigDecimal bigDecimal3 = (BigDecimal)this.posTable.getModel().getValueAt(n, 5);
            this.posPanel.setQty(bigDecimal);
            this.posPanel.setPrice(bigDecimal2);
            this.posPanel.setDiscountPercentage(bigDecimal3);
            this.posPanel.changeViewPanel();
            this.posPanel.refreshProductInfo(this.posPanel.getM_Product_ID(this.posPanel.getOrderLineId()));
        }
    }

    @Override
    public void moveUp() {
        int n = this.posTable.getRowCount();
        if (n == 0) {
            return;
        }
        int n2 = this.posTable.getSelectedRow();
        if (--n2 < 0) {
            n2 = n - 1;
        }
        this.posTable.getSelectionModel().setSelectionInterval(n2, n2);
        this.showProductInfo(n2);
    }

    @Override
    public void moveDown() {
        int n = this.posTable.getRowCount();
        if (n == 0) {
            return;
        }
        int n2 = this.posTable.getSelectedRow();
        if (n == ++n2) {
            n2 = 0;
        }
        this.posTable.getSelectionModel().setSelectionInterval(n2, n2);
        this.showProductInfo(n2);
    }

    public void moveTop() {
        if (this.posPanel.hasLines()) {
            this.posTable.getSelectionModel().setSelectionInterval(0, 0);
            this.showProductInfo(0);
        }
    }
}

