/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.Timer;
import org.adempiere.pos.POSTextField;
import org.adempiere.pos.services.CPOS;
import org.adempiere.pos.services.POSLookupProductInterface;
import org.adempiere.util.StringUtils;
import org.compiere.apps.ADialog;
import org.compiere.model.MProduct;
import org.compiere.util.Env;
import org.compiere.util.KeyNamePair;
import org.compiere.util.Msg;

public class POSLookupProduct
implements ActionListener,
KeyListener {
    private POSLookupProductInterface lookupProductInterface = null;
    private POSTextField fieldProductName = null;
    private long lastKeyboardEvent = 0L;
    private boolean searched = false;
    private boolean selectLock = false;
    private JComboBox<KeyNamePair> productLookupComboBox = null;
    private Integer priceListId = 0;
    private Integer warehouseId = 0;
    private Integer partnerId = 0;
    private String fill = StringUtils.repeat(" ", 400);
    private static Integer PRODUCT_VALUE_LENGTH = 14;
    private static Integer PRODUCT_NAME_LENGTH = 40;
    private static Integer QUANTITY_LENGTH = 15;
    private String separator = "|";
    private String productValueTitle = StringUtils.trunc(Msg.parseTranslation(Env.getCtx(), "@Value@") + this.fill, PRODUCT_VALUE_LENGTH);
    private String productTitle = StringUtils.trunc(Msg.parseTranslation(Env.getCtx(), "@M_Product_ID@") + this.fill, PRODUCT_NAME_LENGTH);
    private String availableTitle = StringUtils.trunc(Msg.parseTranslation(Env.getCtx(), "@QtyAvailable@") + this.fill, QUANTITY_LENGTH);
    private String priceStdTitle = StringUtils.trunc(Msg.parseTranslation(Env.getCtx(), "@PriceStd@") + this.fill, QUANTITY_LENGTH);
    private String priceListTile = StringUtils.trunc(Msg.parseTranslation(Env.getCtx(), "@PriceList@") + this.fill, QUANTITY_LENGTH);
    private String title = "";

    public POSLookupProduct(POSLookupProductInterface lookupProductInterface, POSTextField fieldProductName, long lastKeyboardEvent) {
        this.lookupProductInterface = lookupProductInterface;
        this.fieldProductName = fieldProductName;
        this.lastKeyboardEvent = lastKeyboardEvent;
    }

    public void setLastKeyboardEvent(long lastKeyboardEvent) {
        this.lastKeyboardEvent = lastKeyboardEvent;
    }

    public void setFillingComponent(JComboBox<KeyNamePair> productLookupComboBox) {
        this.productLookupComboBox = productLookupComboBox;
        productLookupComboBox.addActionListener(this);
        productLookupComboBox.addKeyListener(this);
        char[] charArray = new char[200];
        Arrays.fill(charArray, ' ');
        this.fill = new String(charArray);
        this.title = new StringBuffer().append(this.productValueTitle).append(this.separator).append(this.productTitle).append(this.separator).append(this.availableTitle).append(this.separator).append(this.priceStdTitle).append(this.separator).append(this.priceListTile).toString();
        productLookupComboBox.addItem(new KeyNamePair(0, this.title));
    }

    public void setPriceListId(int priceListId) {
        this.priceListId = priceListId;
    }

    public void setPartnerId(int partnerId) {
        this.partnerId = partnerId;
    }

    public void setWarehouseId(int warehouseId) {
        this.warehouseId = warehouseId;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.productLookupComboBox && actionEvent.getModifiers() == 16 && actionEvent.getSource() != this.lookupProductInterface.getProductTimer()) {
            this.captureProductFromCombo();
        }
        if (actionEvent.getSource() == this.lookupProductInterface.getProductTimer()) {
            long now = System.currentTimeMillis();
            if (now - this.lastKeyboardEvent > 500L && !this.searched && this.fieldProductName.getText() != null && this.fieldProductName.getText().length() > 2) {
                this.executeQuery();
            } else if (!(this.searched || this.fieldProductName.getText() != null && this.fieldProductName.getText().length() != 0)) {
                this.productLookupComboBox.hidePopup();
                this.productLookupComboBox.removeAllItems();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (keyEvent.getSource().equals(this.fieldProductName)) {
            if (keyEvent.getKeyCode() == 40) {
                if (this.productLookupComboBox != null) {
                    this.productLookupComboBox.requestFocus();
                }
            } else {
                if (9 == keyEvent.getKeyCode() || 10 == keyEvent.getKeyCode()) {
                    this.fieldProductName.setPlaceholder(this.fieldProductName.getText());
                    try {
                        this.lookupProductInterface.findProduct(9 == keyEvent.getKeyCode(), 0);
                    }
                    catch (Exception exception) {
                        ADialog.error(0, null, exception.getLocalizedMessage());
                    }
                    this.fieldProductName.setText("");
                    return;
                }
                this.searched = false;
                this.lastKeyboardEvent = System.currentTimeMillis();
                if (this.lookupProductInterface.getProductTimer() != null) {
                    ((Timer)this.lookupProductInterface.getProductTimer()).restart();
                }
            }
        } else if (keyEvent.getSource().equals(this.productLookupComboBox) && keyEvent.getKeyCode() == 10) {
            this.captureProductFromCombo();
            return;
        }
    }

    public void captureProductFromCombo() {
        KeyNamePair item = (KeyNamePair)this.productLookupComboBox.getSelectedItem();
        if (item != null && !this.selectLock) {
            String productValue = MProduct.get(Env.getCtx(), item.getKey()).getValue();
            this.fieldProductName.setPlaceholder(productValue);
            try {
                this.lookupProductInterface.findProduct(true, item.getKey());
            }
            catch (Exception exception) {
                ADialog.error(0, null, exception.getLocalizedMessage());
            }
            this.productLookupComboBox.removeAllItems();
            this.fieldProductName.setText("");
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    private void executeQuery() {
        this.searched = true;
        this.productLookupComboBox.removeAllItems();
        this.productLookupComboBox.addItem(new KeyNamePair(0, this.title));
        this.selectLock = true;
        for (Vector<Object> columns : CPOS.getQueryProduct(0, this.fieldProductName.getText(), this.warehouseId, this.priceListId, this.partnerId)) {
            Integer productId = (Integer)columns.elementAt(0);
            String productValue = (String)columns.elementAt(1);
            String productName = (String)columns.elementAt(2);
            String qtyAvailable = (String)columns.elementAt(3);
            String priceStd = (String)columns.elementAt(4);
            String priceList = (String)columns.elementAt(5);
            String line = StringUtils.trunc(productValue + this.fill, PRODUCT_VALUE_LENGTH) + this.separator + StringUtils.trunc(productName + this.fill, PRODUCT_NAME_LENGTH) + this.separator + StringUtils.trunc(qtyAvailable + this.fill, QUANTITY_LENGTH) + this.separator + StringUtils.trunc(priceStd + this.fill, QUANTITY_LENGTH) + this.separator + StringUtils.trunc(priceList + this.fill, QUANTITY_LENGTH);
            this.productLookupComboBox.addItem(new KeyNamePair(productId, line));
        }
        this.productLookupComboBox.showPopup();
        this.selectLock = false;
    }
}

