/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.pos;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.HashMap;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import net.miginfocom.swing.MigLayout;
import org.adempiere.plaf.AdempierePLAF;
import org.adempiere.pos.POSKeyListener;
import org.compiere.model.MImage;
import org.compiere.model.MPOSKey;
import org.compiere.model.MPOSKeyLayout;
import org.compiere.print.MPrintColor;
import org.compiere.print.MPrintFont;
import org.compiere.swing.CButton;
import org.compiere.swing.CPanel;
import org.compiere.swing.CScrollPane;
import org.compiere.util.CLogger;
import org.compiere.util.Env;

public class POSKeyPanel
extends CPanel
implements ActionListener {
    private static final long serialVersionUID = -1773720355288801510L;
    private CardLayout cardLayout = new CardLayout();
    private HashMap<Integer, HashMap<Integer, MPOSKey>> keyMaps = new HashMap();
    int currentLayout;
    private static CLogger log = CLogger.getCLogger(POSKeyPanel.class);
    private POSKeyListener caller;
    private final int IMAGE_SIZE = 100;

    public POSKeyPanel(int n, POSKeyListener pOSKeyListener) {
        if (n == 0) {
            return;
        }
        this.setLayout(this.cardLayout);
        this.add((Component)this.createCard(n), Integer.toString(n));
        this.currentLayout = n;
        this.cardLayout.show(this, Integer.toString(n));
        this.caller = pOSKeyListener;
    }

    private CPanel createCard(int n) {
        MPOSKey[] mPOSKeyArray;
        Serializable serializable;
        if (this.keyMaps.containsKey(n)) {
            return null;
        }
        CPanel cPanel = new CPanel();
        cPanel.setLayout((LayoutManager)new MigLayout("fill, ins 0"));
        MPOSKeyLayout mPOSKeyLayout = MPOSKeyLayout.get(Env.getCtx(), n);
        Color color = Color.lightGray;
        if (mPOSKeyLayout.getAD_PrintColor_ID() != 0) {
            serializable = MPrintColor.get(Env.getCtx(), mPOSKeyLayout.getAD_PrintColor_ID());
            color = ((MPrintColor)serializable).getColor();
        }
        serializable = AdempierePLAF.getFont_Field();
        if (mPOSKeyLayout.getAD_PrintFont_ID() != 0) {
            mPOSKeyArray = MPrintFont.get(mPOSKeyLayout.getAD_PrintFont_ID());
            serializable = mPOSKeyArray.getFont();
        }
        if (mPOSKeyLayout.get_ID() == 0) {
            return null;
        }
        mPOSKeyArray = mPOSKeyLayout.getKeys(false);
        HashMap<Integer, MPOSKey> hashMap = new HashMap<Integer, MPOSKey>(mPOSKeyArray.length);
        this.keyMaps.put(n, hashMap);
        int n2 = 3;
        int n3 = 3;
        int n4 = mPOSKeyArray.length;
        int n5 = mPOSKeyLayout.getColumns();
        if (n5 == 0) {
            n5 = n2;
        }
        int n6 = 0;
        log.fine("PosSubFunctionKeys.init - NoKeys=" + n4 + ", Cols=" + n5);
        CPanel cPanel2 = new CPanel((LayoutManager)new MigLayout("fill, wrap " + Math.max(n5, 3)));
        String string = "h 50, w 50, growx, growy, sg button,";
        MPOSKey[] mPOSKeyArray2 = mPOSKeyArray;
        int n7 = mPOSKeyArray2.length;
        for (int i = 0; i < n7; ++i) {
            Object object;
            Serializable serializable2;
            Serializable serializable3;
            MPOSKey mPOSKey = mPOSKeyArray2[i];
            if (mPOSKey.getSubKeyLayout_ID() > 0 && (serializable3 = this.createCard(mPOSKey.getSubKeyLayout_ID())) != null) {
                this.add((Component)serializable3, Integer.toString(mPOSKey.getSubKeyLayout_ID()));
            }
            hashMap.put(mPOSKey.getC_POSKey_ID(), mPOSKey);
            serializable3 = color;
            Serializable serializable4 = serializable;
            StringBuffer stringBuffer = new StringBuffer("<html><p>");
            if (mPOSKey.getAD_PrintColor_ID() != 0) {
                serializable2 = MPrintColor.get(Env.getCtx(), mPOSKey.getAD_PrintColor_ID());
                serializable3 = ((MPrintColor)serializable2).getColor();
            }
            if (mPOSKey.getAD_PrintFont_ID() != 0) {
                serializable2 = MPrintFont.get(mPOSKey.getAD_PrintFont_ID());
                serializable4 = ((MPrintFont)serializable2).getFont();
            }
            stringBuffer.append(mPOSKey.getName());
            stringBuffer.append("</p></html>");
            log.fine("#" + hashMap.size() + " - " + (Color)serializable3);
            serializable2 = new CButton(stringBuffer.toString());
            ((CButton)serializable2).setBackground((Color)serializable3);
            ((JComponent)serializable2).setFont((Font)serializable4);
            if (mPOSKey.getAD_Image_ID() != 0) {
                object = MImage.get(Env.getCtx(), mPOSKey.getAD_Image_ID());
                Image image = ((MImage)object).getImage();
                Image image2 = image.getScaledInstance(100, 100, 4);
                ((AbstractButton)serializable2).setIcon(new ImageIcon(image2));
                ((AbstractButton)serializable2).setVerticalTextPosition(3);
                ((AbstractButton)serializable2).setHorizontalTextPosition(0);
            }
            ((Component)serializable2).setFocusable(false);
            if (!mPOSKey.isActive()) {
                ((AbstractButton)serializable2).setEnabled(false);
            }
            ((CButton)serializable2).setActionCommand(String.valueOf(mPOSKey.getC_POSKey_ID()));
            ((AbstractButton)serializable2).addActionListener(this);
            object = string;
            int n8 = 1;
            if (mPOSKey.getSpanX() > 1) {
                object = (String)object + "spanx " + mPOSKey.getSpanX() + ",";
                n8 = mPOSKey.getSpanX();
            }
            if (mPOSKey.getSpanY() > 1) {
                object = (String)object + "spany " + mPOSKey.getSpanY() + ",";
                n8 *= mPOSKey.getSpanY();
            }
            n6 += n8;
            cPanel2.add((Component)serializable2, object);
        }
        int n9 = Math.max(n6 / n5, n3);
        if (n6 % n5 > 0) {
            ++n9;
        }
        for (n7 = n6; n7 < n9 * n5; ++n7) {
            CButton cButton = new CButton("");
            cButton.setFocusable(false);
            cButton.setReadWrite(false);
            cPanel2.add((Component)cButton, string);
        }
        CScrollPane cScrollPane = new CScrollPane(cPanel2);
        cPanel.add((Component)cScrollPane, "growx, growy");
        cScrollPane.getVerticalScrollBar().setPreferredSize(new Dimension(30, 0));
        cScrollPane.getHorizontalScrollBar().setPreferredSize(new Dimension(0, 30));
        return cPanel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null || string.length() == 0 || this.keyMaps == null) {
            return;
        }
        log.info("PosSubFunctionKeys - actionPerformed: " + string);
        HashMap<Integer, MPOSKey> hashMap = this.keyMaps.get(this.currentLayout);
        try {
            int n = Integer.parseInt(string);
            MPOSKey mPOSKey = hashMap.get(n);
            if (mPOSKey.getSubKeyLayout_ID() > 0) {
                this.currentLayout = mPOSKey.getSubKeyLayout_ID();
                this.cardLayout.show(this, Integer.toString(mPOSKey.getSubKeyLayout_ID()));
            } else {
                this.caller.keyReturned(mPOSKey);
            }
        }
        catch (Exception exception) {
            log.info("Error : " + exception);
        }
    }

    public void showPanel() {
        this.setVisible(true);
    }

    public void hidePanel() {
        this.setVisible(false);
    }
}

