/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.plaf;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLookAndFeel;
import javax.swing.plaf.metal.MetalTheme;
import org.adempiere.plaf.AdempierePLAF;
import org.compiere.swing.CPanel;

class PreviewPanel
extends CPanel {
    private static final long serialVersionUID = 6028614986952449622L;
    private boolean capture = true;
    private LookAndFeel laf = null;
    private MetalTheme theme = null;
    private BufferedImage image;

    PreviewPanel() {
    }

    @Override
    public void paint(Graphics g) {
        if (this.capture) {
            this.image = (BufferedImage)this.createImage(this.getWidth(), this.getHeight());
            super.paint(this.image.createGraphics());
            g.drawImage(this.image, 0, 0, null);
            this.capture = false;
            if (this.laf != null) {
                if (this.laf instanceof MetalLookAndFeel) {
                    AdempierePLAF.setCurrentMetalTheme((MetalLookAndFeel)this.laf, this.theme);
                }
                try {
                    UIManager.setLookAndFeel(this.laf);
                }
                catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                    // empty catch block
                }
                SwingUtilities.updateComponentTreeUI(this);
                this.laf = null;
                this.theme = null;
            }
        } else if (this.image != null) {
            g.drawImage(this.image, 0, 0, null);
        }
    }

    public void refresh(LookAndFeel currentLaf, MetalTheme currentTheme) {
        this.laf = currentLaf;
        this.theme = currentTheme;
        this.capture = true;
    }
}

