/*
 * Decompiled with CFR 0.152.
 */
package org.adempiere.model;

import org.adempiere.exceptions.AdempiereException;
import org.adempiere.model.PromotionRule;
import org.compiere.model.MClient;
import org.compiere.model.MOrder;
import org.compiere.model.MOrderLine;
import org.compiere.model.ModelValidationEngine;
import org.compiere.model.ModelValidator;
import org.compiere.model.PO;
import org.compiere.util.DB;

public class PromotionValidator
implements ModelValidator {
    private int m_AD_Client_ID;

    @Override
    public String docValidate(PO po, int timing) {
        if (po instanceof MOrder) {
            if (timing == 8) {
                MOrder order = (MOrder)po;
                try {
                    PromotionRule.applyPromotions(order);
                    order.getLines(true, null);
                    order.calculateTaxTotal();
                    order.saveEx();
                    this.increasePromotionCounter(order);
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        throw (RuntimeException)e;
                    }
                    throw new AdempiereException(e.getLocalizedMessage(), e);
                }
            } else if (timing == 10) {
                MOrder order = (MOrder)po;
                this.decreasePromotionCounter(order);
            }
        }
        return null;
    }

    private void increasePromotionCounter(MOrder order) {
        MOrderLine[] lines = order.getLines(false, null);
        String promotionCode = (String)order.get_Value("PromotionCode");
        for (MOrderLine ol : lines) {
            int M_PromotionPreCondition_ID;
            Integer promotionID;
            if (ol.getC_Charge_ID() <= 0 || (promotionID = (Integer)ol.get_Value("M_Promotion_ID")) == null || promotionID <= 0 || (M_PromotionPreCondition_ID = this.findPromotionPreConditionId(order, promotionCode, promotionID)) <= 0) continue;
            String update = "UPDATE M_PromotionPreCondition SET PromotionCounter = PromotionCounter + 1 WHERE M_PromotionPreCondition_ID = ?";
            DB.executeUpdate(update, M_PromotionPreCondition_ID, order.get_TrxName());
        }
    }

    private void decreasePromotionCounter(MOrder order) {
        MOrderLine[] lines = order.getLines(false, null);
        String promotionCode = (String)order.get_Value("PromotionCode");
        for (MOrderLine ol : lines) {
            int M_PromotionPreCondition_ID;
            Integer promotionID;
            if (ol.getC_Charge_ID() <= 0 || (promotionID = (Integer)ol.get_Value("M_Promotion_ID")) == null || promotionID <= 0 || (M_PromotionPreCondition_ID = this.findPromotionPreConditionId(order, promotionCode, promotionID)) <= 0) continue;
            String update = "UPDATE M_PromotionPreCondition SET PromotionCounter = PromotionCounter - 1 WHERE M_PromotionPreCondition_ID = ?";
            DB.executeUpdate(update, M_PromotionPreCondition_ID, order.get_TrxName());
        }
    }

    private int findPromotionPreConditionId(MOrder order, String promotionCode, Integer promotionID) {
        String bpFilter = "M_PromotionPreCondition.C_BPartner_ID = ? OR M_PromotionPreCondition.C_BP_Group_ID = ? OR (M_PromotionPreCondition.C_BPartner_ID IS NULL AND M_PromotionPreCondition.C_BP_Group_ID IS NULL)";
        String priceListFilter = "M_PromotionPreCondition.M_PriceList_ID IS NULL OR M_PromotionPreCondition.M_PriceList_ID = ?";
        String warehouseFilter = "M_PromotionPreCondition.M_Warehouse_ID IS NULL OR M_PromotionPreCondition.M_Warehouse_ID = ?";
        String dateFilter = "M_PromotionPreCondition.StartDate <= ? AND (M_PromotionPreCondition.EndDate >= ? OR M_PromotionPreCondition.EndDate IS NULL)";
        StringBuffer select = new StringBuffer();
        select.append(" SELECT M_PromotionPreCondition.M_PromotionPreCondition_ID FROM M_PromotionPreCondition ").append(" WHERE").append(" (" + bpFilter + ")").append(" AND (").append(priceListFilter).append(")").append(" AND (").append(warehouseFilter).append(")").append(" AND (").append(dateFilter).append(")").append(" AND (M_PromotionPreCondition.M_Promotion_ID = ?)").append(" AND (M_PromotionPreCondition.IsActive = 'Y')");
        if (promotionCode != null && promotionCode.trim().length() > 0) {
            select.append(" AND (M_PromotionPreCondition.PromotionCode = ?)");
        } else {
            select.append(" AND (M_PromotionPreCondition.PromotionCode IS NULL)");
        }
        select.append(" ORDER BY M_PromotionPreCondition.C_BPartner_ID Desc, M_PromotionPreCondition.C_BP_Group_ID Desc, M_PromotionPreCondition.M_PriceList_ID Desc, M_PromotionPreCondition.M_Warehouse_ID Desc, M_PromotionPreCondition.StartDate Desc");
        int M_PromotionPreCondition_ID = 0;
        int C_BP_Group_ID = 0;
        try {
            C_BP_Group_ID = order.getC_BPartner().getC_BP_Group_ID();
        }
        catch (Exception exception) {
            // empty catch block
        }
        M_PromotionPreCondition_ID = promotionCode != null && promotionCode.trim().length() > 0 ? DB.getSQLValue(order.get_TrxName(), select.toString(), order.getC_BPartner_ID(), C_BP_Group_ID, order.getM_PriceList_ID(), order.getM_Warehouse_ID(), order.getDateOrdered(), order.getDateOrdered(), promotionID, promotionCode) : DB.getSQLValue(order.get_TrxName(), select.toString(), order.getC_BPartner_ID(), C_BP_Group_ID, order.getM_PriceList_ID(), order.getM_Warehouse_ID(), order.getDateOrdered(), order.getDateOrdered(), promotionID);
        return M_PromotionPreCondition_ID;
    }

    @Override
    public int getAD_Client_ID() {
        return this.m_AD_Client_ID;
    }

    @Override
    public void initialize(ModelValidationEngine engine, MClient client) {
        if (client != null) {
            this.m_AD_Client_ID = client.getAD_Client_ID();
        }
        engine.addDocValidate("C_Order", this);
        engine.addModelChange("C_OrderLine", this);
    }

    @Override
    public String login(int AD_Org_ID, int AD_Role_ID, int AD_User_ID) {
        return null;
    }

    @Override
    public String modelChange(PO po, int type) throws Exception {
        if (po instanceof MOrderLine && type == 6) {
            int M_PromotionPreCondition_ID;
            Integer promotionID;
            MOrderLine ol = (MOrderLine)po;
            MOrder order = ol.getParent();
            String promotionCode = (String)order.get_Value("PromotionCode");
            if (ol.getC_Charge_ID() > 0 && (promotionID = (Integer)ol.get_Value("M_Promotion_ID")) != null && promotionID > 0 && (M_PromotionPreCondition_ID = this.findPromotionPreConditionId(order, promotionCode, promotionID)) > 0) {
                String update = "UPDATE M_PromotionPreCondition SET PromotionCounter = PromotionCounter - 1 WHERE M_PromotionPreCondition_ID = ?";
                DB.executeUpdate(update, M_PromotionPreCondition_ID, order.get_TrxName());
            }
        }
        return null;
    }
}

